/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.cashtocard;

import i18n.B;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.FinanceOperation;
import ru.softlogic.cards.v2.connector.model.OperationTransferResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cards.v2.module.InputFormListener;
import ru.softlogic.cards.v2.module.OperationData;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.card.BaseCardInputModule;
import ru.softlogic.module.card.CardConfirmHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.CardTransferPaymentModule;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;

public class CardTransferInputModule
extends BaseCardInputModule {
    private CommonScreen lastScreen;
    private LocalGuiListener localGuiListener;
    private Sum sumIncome;
    private Sum sumOutcome;

    public CardTransferInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startModule(Environment environment, ApplicationContext context) {
        this.invokeOperation = false;
        Session.getInstance().getPack().setService(environment.getMenuItem().getService());
        environment.setPaymentModule(ModuleFactory.createPaymentModule(context, environment.getMenuItem(), new CardTransferPaymentModule(context)));
        this.localGuiListener = new LocalGuiListener(context, environment, this.log);
        this.cm = this.getCardModule(environment, this.localGuiListener);
        if (this.cm != null) {
            CardConfirmHelper.showConfirm(environment, context, (ScreenListener)new LocalConfirmScreenListener(), this.log);
        } else {
            context.showDialog((DialogInterface)this.createNoCardModuleDialog());
        }
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.context.showScreen(new ContentScreenAdapter(this.lastScreen));
    }

    @Override
    public synchronized void cancel(Intent intent) {
        CardModuleStore.getInstance().setCashRequireListener(null);
        super.cancel(intent);
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void _onClosed() {
            CardTransferInputModule.this.baseCancel(null);
        }

        @Override
        public void onCashRequire(boolean isEmitent, AccountInfo ai, CashRequireListener cl) {
            CardTransferInputModule.this.invokeOperation = false;
            CardTransferInputModule.this.context.showWait(null);
            CardTransferInputModule.this.log.info((Object)("CardTransfer.require: isEmitent = " + isEmitent + "; ai = " + ai + "; cl = " + cl));
            CardModuleStore.getInstance().setCashRequireListener(cl);
            if (AppDefaults.getInstance().getBooleanProperty("Module.cashtocard.comission.show", false)) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.commission", (Locale)CardTransferInputModule.this.locale), 10, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new LocalCommissionDialogListener(cl, isEmitent));
                CardTransferInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                this.showSumInputScreen(cl, isEmitent);
            }
        }

        private void showSumInputScreen(final CashRequireListener cl, final boolean isEmitent) {
            this.onInputForm("transferAmount", new HashMap<String, String>(), new InputFormListener(){

                public void onData(Map<String, String> map) {
                    String strAmount = map.get("AMOUNT");
                    try {
                        double amount = Double.parseDouble(strAmount);
                        Sum operSum = new Sum((int)amount * 100);
                        CardTransferInputModule.this.prePayment(CardTransferInputModule.this.environment, CardTransferInputModule.this.inputData, operSum, null, null);
                        cl.onResult(LocalGuiListener.this.beginBankOperation(operSum, isEmitent));
                    }
                    catch (Exception ex) {
                        CardTransferInputModule.this.log.error((Object)ex, (Throwable)ex);
                        CardTransferInputModule.this.baseCancel(null);
                    }
                }

                public void onCancel() {
                    cl.onCancel();
                }

                public void onBack() {
                }
            });
        }

        private FinanceOperation beginBankOperation(Sum sum, boolean isEmitent) {
            CardTransferInputModule.this.log.info((Object)("Start card operation, sum outcome=" + sum));
            CardTransferInputModule.this.sumOutcome = sum;
            Pack pack = Session.getInstance().getPack();
            CardTransferInputModule.this.sumIncome = CommissionCalculator.calculate((Sum)sum, (Commission)pack.getCommission(), (Commission)pack.getService().getCommission(), (Date)CardTransferInputModule.this.environment.getDateOfStartPayment(), (String)(isEmitent ? "BANKCARD" : "BANKCARD_OTHER"), (boolean)CardTransferInputModule.this.environment.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            CardTransferInputModule.this.log.info((Object)("Sum income: " + CardTransferInputModule.this.sumIncome));
            FinanceOperation fo = new FinanceOperation(StoreHelper.convertDep(PackUtility.getData(Session.getInstance().getPack())), (long)CardTransferInputModule.this.sumIncome.getBasicSum(), (long)CardTransferInputModule.this.sumIncome.sub(CardTransferInputModule.this.sumOutcome).getBasicSum(), null, this.getProperty("mcc"), this.getProperty("merchant-id") == null ? this.getProperty("vendor") : this.getProperty("merchant-id"));
            CardTransferInputModule.this.invokeOperation = true;
            CardTransferInputModule.this.log.info((Object)"Done");
            return fo;
        }

        private String getProperty(String key) {
            return (String)Session.getInstance().getPack().getService().getProperties().get(key);
        }

        private class LocalCommissionDialogListener
        implements DialogListener {
            private final CashRequireListener cl;
            private final boolean isEmitent;

            private LocalCommissionDialogListener(CashRequireListener cl, boolean isEmitent) {
                this.cl = cl;
                this.isEmitent = isEmitent;
            }

            public void dialogClosed(UserCase userCase) {
                LocalGuiListener.this.showSumInputScreen(this.cl, this.isEmitent);
            }
        }
    }

    private class LocalTransferResultListener
    implements CardModuleResultListener<OperationTransferResult> {
        private LocalTransferResultListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            DialogScreen dialog;
            CardTransferInputModule.this.invokeOperation = false;
            CardTransferInputModule.this.log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            if (cardInfo != null && cardInfo.getPanHash() != null) {
                CardTransferInputModule.this.setCardPanHash(cardInfo.getPanHash().getSha1());
                CardTransferInputModule.this.environment.getInitData().put("CARD_INFO", cardInfo);
            }
            UserAction.getInstance().update();
            CardTransferInputModule.this.context.showWait(null);
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                CardTransferInputModule.this.log.info((Object)"Wrong pin, show dialog");
                dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.pin-wrong", (Locale)CardTransferInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        CardTransferInputModule.this.log.info((Object)"Wrong pin dialog closed. Start card operation");
                        CardTransferInputModule.this.invokeOperation = true;
                        CardModuleStore.getInstance().getDepositProxy().setListener(new LocalTransferResultListener());
                        CardTransferInputModule.this.cm.deposit((CardModuleResultListener)CardModuleStore.getInstance().getDepositProxy());
                        CardTransferInputModule.this.log.info((Object)"Done");
                    }
                });
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                CardTransferInputModule.this.log.info((Object)"Operation canceled by user, show dialog");
                dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.card.transfer.error1", (Locale)CardTransferInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardTransferInputModule.this));
            } else {
                String text = message == null || message.isEmpty() ? B.get((String)"Provider.card.transfer.error2", (Locale)CardTransferInputModule.this.locale) : MessageFormat.format(B.get((String)"Provider.card.transfer.error3", (Locale)CardTransferInputModule.this.locale), B.get((String)message, (Locale)CardTransferInputModule.this.locale, (String)message));
                dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, text, 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardTransferInputModule.this));
            }
            CardTransferInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        public void onResult(OperationTransferResult t, CardInfo ci) {
            CardTransferInputModule.this.setCardPanHash(ci.getPanHash().getSha1());
            if (CardTransferInputModule.this.environment.getInitData() == null) {
                CardTransferInputModule.this.environment.setInitData(new HashMap<String, Object>());
            }
            CardTransferInputModule.this.environment.getInitData().put("TRANSFER_RESUALT", t);
            CardTransferInputModule.this.environment.getInitData().put("CARD_INFO", ci);
            CardTransferInputModule.this.environment.getInitData().put("SUM_INCOME", CardTransferInputModule.this.sumIncome);
            CardTransferInputModule.this.environment.getInitData().put("SUM_OUTCOME", CardTransferInputModule.this.sumOutcome);
            this.toPreparePayments(CardTransferInputModule.this.inputData);
        }

        public void onCardData(CardData cd) {
        }

        private void toPreparePayments(HashMap<String, Object> serverData) {
            SumScreenDescription ssd = new SumScreenDescription();
            ssd.setType("sum");
            if (serverData != null) {
                CardTransferInputModule.this.inputData.putAll(serverData);
            }
            CardTransferInputModule.this._startPayment(CardTransferInputModule.this.environment, ssd, CardTransferInputModule.this.inputData);
        }
    }

    private class LocalConfirmScreenListener
    extends ScreenAdapter {
        private LocalConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CardTransferInputModule.this.cancelListener = cancelListener;
            CardTransferInputModule.this.log.info((Object)("Action on confirm input screen: " + action));
            if (ActionType.isNext((String)action)) {
                CardTransferInputModule.this.log.info((Object)"Start card operation");
                CardTransferInputModule.this.invokeOperation = true;
                LocalTransferResultListener transferResultListener = new LocalTransferResultListener();
                CardModuleStore.getInstance().getDepositProxy().setListener(transferResultListener);
                CardTransferInputModule.this.cm.transfer(this.convert(CardTransferInputModule.this.inputData), (CardModuleResultListener)transferResultListener);
                CardTransferInputModule.this.log.info((Object)"Done");
            } else {
                CardTransferInputModule.this.cancel(null);
            }
        }

        private OperationData convert(Map<String, Object> data) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Object entry : data.values()) {
                if (!(entry instanceof InputElement)) continue;
                InputElement ie = (InputElement)entry;
                result.put(ie.getKey(), ie.getValue());
            }
            return new OperationData(result);
        }
    }
}

