/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.cardbalance;

import i18n.B;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.AmountType;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationStatementResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.BankModule;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.module.card.BaseCardInputModule;
import ru.softlogic.module.card.CardConfirmHelper;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.utils.ExitDialogListener;

public class CardReportInputModule
extends BaseCardInputModule {
    private final StatementOperationListener accountsOperationListener = new StatementOperationListener();
    private BankModule bm;

    public CardReportInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startModule(Environment environment, ApplicationContext context) {
        this.cm = this.getCardModule(environment, new LocalGuiListener(context, environment, this.log));
        BankModule bankModule = this.bm = this.cm == null ? null : this.cm.getBankModule();
        if (this.cm != null && this.bm != null) {
            CardConfirmHelper.showConfirm(environment, context, (ScreenListener)new LocalConfirmScreenListener(), this.log);
        } else {
            context.showDialog((DialogInterface)this.createNoCardModuleDialog());
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void _onClosed() {
            CardReportInputModule.this.baseCancel(null);
        }
    }

    private class StatementOperationListener
    implements CardModuleResultListener<OperationStatementResult> {
        private StatementOperationListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            CardReportInputModule.this.invokeOperation = false;
            CardReportInputModule.this.log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            UserAction.getInstance().update();
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                CardReportInputModule.this.log.info((Object)"Wrong pin, show dialog");
                CardReportInputModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.pin-wrong", (Locale)CardReportInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        CardReportInputModule.this.log.info((Object)"Wrong pin dialog closed. Start card operation");
                        CardReportInputModule.this.invokeOperation = true;
                        CardReportInputModule.this.cm.statement((CardModuleResultListener)CardReportInputModule.this.accountsOperationListener);
                        CardReportInputModule.this.log.info((Object)"Done");
                    }
                });
                CardReportInputModule.this.context.showDialog((DialogInterface)dialog);
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                CardReportInputModule.this.log.info((Object)"Operation canceled by user, show dialog");
                CardReportInputModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.statement.error1", (Locale)CardReportInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardReportInputModule.this));
                CardReportInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                CardReportInputModule.this.context.showWait(null);
                if (message == null || message.isEmpty()) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.statement.error2", (Locale)CardReportInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardReportInputModule.this));
                    CardReportInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.card.statement.error3", (Locale)CardReportInputModule.this.locale), B.get((String)message, (Locale)CardReportInputModule.this.locale, (String)message)), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardReportInputModule.this));
                    CardReportInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onResult(OperationStatementResult t, CardInfo ci) {
            CardReportInputModule.this.invokeOperation = false;
            UserAction.getInstance().update();
            CardReportInputModule.this.log.info((Object)">>>onSuccess");
            CardReportInputModule.this.log.info((Object)("OperationStatementResult: " + t));
            CardReportInputModule.this.log.info((Object)"Printing card balance");
            Amount balance = null;
            if (t.getAdditionalAmounts() != null) {
                for (Amount a : t.getAdditionalAmounts()) {
                    if (a.getAmountType() != AmountType.CurrentAccountAvailableBalance) continue;
                    balance = a;
                    break;
                }
            }
            CustomData cd = new CustomData();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("operations", t.getOperations());
            data.put("balance", balance);
            data.put("pan", "" + ci.getPan());
            data.put("auth", "" + t.getAuthIdentResponse());
            data.put("merchant", "" + t.getMerchant());
            data.put("terminal", "" + t.getTerminal());
            data.put("rrn", "" + t.getRrn());
            data.put("stan", "" + t.getStan());
            data.put("sf", SumFormatter.class);
            AccountInfo ai = ci.getAccountInfo();
            if (ai != null) {
                data.put("account", ai.getNumber());
            }
            data.put("df", new SimpleDateFormat("dd.MM.yy HH:mm"));
            data.put("now", new Date());
            cd.setCustomData(data);
            cd.setTemplate("card_statement.tpl");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.statement.complete", (Locale)CardReportInputModule.this.locale), 5, DC.cases((int)8, (Locale)CardReportInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitDialogListener(CardReportInputModule.this));
            CardReportInputModule.this.context.showWait(null);
            CardReportInputModule.this.context.showDialog((DialogInterface)dialog);
            CardReportInputModule.this.context.getPrinterQueue().printCustomDocument(cd);
        }

        public void onCardData(CardData cd) {
        }
    }

    private class LocalConfirmScreenListener
    extends ScreenAdapter {
        private LocalConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CardReportInputModule.this.cancelListener = cancelListener;
            CardReportInputModule.this.log.info((Object)("Action on confirm input screen: " + action));
            if (ActionType.isNext((String)action)) {
                CardReportInputModule.this.log.info((Object)"Start card operation");
                CardReportInputModule.this.invokeOperation = true;
                CardReportInputModule.this.cm.statement((CardModuleResultListener)CardReportInputModule.this.accountsOperationListener);
                CardReportInputModule.this.log.info((Object)"Done");
            } else {
                CardReportInputModule.this.cancel(null);
            }
        }
    }
}

