/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.cardbalance;

import i18n.B;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.AmountType;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.connector.model.OperationBalanceResult;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.BankModule;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModuleResultListener;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.module.card.BaseCardInputModule;
import ru.softlogic.module.card.CardConfirmHelper;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.utils.ExitDialogListener;

public class CardBalanceInputModule
extends BaseCardInputModule {
    private final AccountOperationListener accountsOperationListener = new AccountOperationListener();
    private BankModule bm;

    public CardBalanceInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _startModule(Environment environment, ApplicationContext context) throws DescriptionException, ModuleInitException {
        this.log.info((Object)"Start module: BaseCardInputModule");
        this.cm = this.getCardModule(environment, new LocalGuiListener(context, environment, this.log));
        BankModule bankModule = this.bm = this.cm == null ? null : this.cm.getBankModule();
        if (this.cm != null && this.bm != null) {
            CardConfirmHelper.showConfirm(environment, context, (ScreenListener)new LocalConfirmScreenListener(), this.log);
        } else {
            context.showDialog((DialogInterface)this.createNoCardModuleDialog());
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        public LocalGuiListener(ApplicationContext context, Environment environment, Logger log) {
            super(context, environment, log);
        }

        @Override
        public void _onClosed() {
            CardBalanceInputModule.this.baseCancel(null);
        }
    }

    private class AccountOperationListener
    implements CardModuleResultListener<OperationBalanceResult> {
        private AccountOperationListener() {
        }

        public void onError(CardModuleError cme, String message, CardInfo cardInfo) {
            CardBalanceInputModule.this.invokeOperation = false;
            CardBalanceInputModule.this.log.info((Object)(">>>onError " + cme + ", " + message + " CardInfo: " + cardInfo));
            UserAction.getInstance().update();
            if (cme == CardModuleError.ERROR_WRONG_PIN) {
                CardBalanceInputModule.this.log.info((Object)"Wrong pin, show dialog");
                CardBalanceInputModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.pin-wrong", (Locale)CardBalanceInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        CardBalanceInputModule.this.log.info((Object)"Wrong pin dialog closed. Start card operation");
                        CardBalanceInputModule.this.invokeOperation = true;
                        CardBalanceInputModule.this.cm.balance((CardModuleResultListener)CardBalanceInputModule.this.accountsOperationListener);
                        CardBalanceInputModule.this.log.info((Object)"Done");
                    }
                });
                CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
            } else if (cme == CardModuleError.ERROR_USER_CANCEL) {
                CardBalanceInputModule.this.log.info((Object)"Operation canceled by user, show dialog");
                CardBalanceInputModule.this.context.showWait(null);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.balance.error1", (Locale)CardBalanceInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardBalanceInputModule.this));
                CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                CardBalanceInputModule.this.context.showWait(null);
                if (message == null || message.isEmpty()) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.balance.error2", (Locale)CardBalanceInputModule.this.locale), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardBalanceInputModule.this));
                    CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Provider.card.balance.error3", (Locale)CardBalanceInputModule.this.locale), B.get((String)message, (Locale)CardBalanceInputModule.this.locale, (String)message)), 20, DC.cases((int)8), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(CardBalanceInputModule.this));
                    CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onResult(OperationBalanceResult t, CardInfo ci) {
            CardBalanceInputModule.this.invokeOperation = false;
            UserAction.getInstance().update();
            CardBalanceInputModule.this.log.info((Object)">>>onSuccess");
            CardBalanceInputModule.this.log.info((Object)("OperationBalanceResult: " + t));
            CardBalanceInputModule.this.log.info((Object)"Show question dialog");
            DisplayedUserCase[] du = new DisplayedUserCase[]{new DisplayedUserCase(UserCase.Cancel, B.get((String)"Provider.card.balance.print", (Locale)CardBalanceInputModule.this.locale)), new DisplayedUserCase(UserCase.Ok, B.get((String)"Provider.card.balance.screen", (Locale)CardBalanceInputModule.this.locale))};
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.card.balance.question", (Locale)CardBalanceInputModule.this.locale), 20, du, UserCase.Ok);
            dialog.addListener((DialogListener)new LocalBalanceListener(t, ci));
            CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        public void onCardData(CardData cd) {
        }
    }

    private class LocalBalanceListener
    implements DialogListener {
        private final OperationBalanceResult balance;
        private final CardInfo ci;

        public LocalBalanceListener(OperationBalanceResult balance, CardInfo ci) {
            this.balance = balance;
            this.ci = ci;
        }

        public void dialogClosed(UserCase userCase) {
            CardBalanceInputModule.this.log.info((Object)("User selected " + userCase));
            int own = (int)this.balance.getBalance();
            int lim = 0;
            if (this.balance.getAdditionalAmounts() != null) {
                for (Amount a : this.balance.getAdditionalAmounts()) {
                    if (a.getAmountType() != AmountType.ExceedLimit) continue;
                    lim = (int)a.getValue();
                }
            }
            int total = own + lim;
            if (userCase == UserCase.Cancel) {
                CardBalanceInputModule.this.log.info((Object)"Printing card balance");
                CustomData cd = new CustomData();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("balance", "" + SumFormatter.format((int)own));
                data.put("overdraft", "" + SumFormatter.format((int)lim));
                data.put("total", "" + SumFormatter.format((int)total));
                data.put("currency", "" + this.balance.getCurrency().getDigitCode());
                data.put("pan", this.ci.getPan());
                data.put("auth", "" + this.balance.getAuthIdentResponse());
                data.put("merchant", "" + this.balance.getMerchant());
                data.put("terminal", "" + this.balance.getTerminal());
                data.put("rrn", "" + this.balance.getRrn());
                data.put("stan", "" + this.balance.getStan());
                AccountInfo ai = this.ci.getAccountInfo();
                if (ai != null) {
                    data.put("account", ai.getNumber());
                }
                cd.setData(data);
                HashMap<String, Cloneable> cData = new HashMap<String, Cloneable>();
                cData.put("df", new SimpleDateFormat("dd.MM.yy HH:mm"));
                cData.put("now", new Date());
                cd.setCustomData(cData);
                cd.setTemplate("card_balance.tpl");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.balance.complete", (Locale)CardBalanceInputModule.this.locale), 5, DC.cases((int)8, (Locale)CardBalanceInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardBalanceInputModule.this));
                CardBalanceInputModule.this.context.showWait(null);
                CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
                CardBalanceInputModule.this.context.getPrinterQueue().printCustomDocument(cd);
            } else {
                CardBalanceInputModule.this.log.info((Object)"Show dialog with card balance");
                String curr = B.get((String)("Provider.card.balance.currency.code." + this.balance.getCurrency().getDigitCode()), (Locale)CardBalanceInputModule.this.locale);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Provider.card.balance.text", (Locale)CardBalanceInputModule.this.locale), SumFormatter.format((int)own), SumFormatter.format((int)lim), SumFormatter.format((int)total), curr), 20, DC.cases((int)8, (Locale)CardBalanceInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(CardBalanceInputModule.this));
                CardBalanceInputModule.this.context.showWait(null);
                CardBalanceInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }
    }

    private class LocalConfirmScreenListener
    extends ScreenAdapter {
        private LocalConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CardBalanceInputModule.this.cancelListener = cancelListener;
            CardBalanceInputModule.this.log.info((Object)("Action on confirm input screen: " + action));
            if (ActionType.isNext((String)action)) {
                CardBalanceInputModule.this.log.info((Object)"Start card operation");
                CardBalanceInputModule.this.invokeOperation = true;
                CardBalanceInputModule.this.cm.balance((CardModuleResultListener)CardBalanceInputModule.this.accountsOperationListener);
                CardBalanceInputModule.this.log.info((Object)"Done");
            } else {
                CardBalanceInputModule.this.cancel(null);
            }
        }
    }
}

