/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced;

import i18n.B;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.VSTemplateProcessor;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hdw.dev.crd.CRMsg;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardStateListener;
import ru.softlogic.hdwbridge.sc.SmartCardProcessor;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.MethodType;
import ru.softlogic.input.model.advanced.OpenUrlTarget;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.Printer;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleRequestListener;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperation;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserHandler;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderHandler;
import ru.softlogic.input.model.advanced.actions.hdw.SmartCardHandler;
import ru.softlogic.input.model.advanced.actions.hdw.WebcamHandler;
import ru.softlogic.input.model.advanced.actions.request.CardRequestListener;
import ru.softlogic.input.model.advanced.actions.request.ServerConnector;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Paths;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.advanced.AdvCommissionCalculatorImpl;
import ru.softlogic.module.input.advanced.CardModuleService;
import ru.softlogic.module.input.advanced.CardProcessorStore;
import ru.softlogic.module.input.advanced.CardReaderService;
import ru.softlogic.module.input.advanced.ConnectorAdapter;
import ru.softlogic.module.input.advanced.Helper;
import ru.softlogic.module.input.advanced.PrinterAdapter;
import ru.softlogic.module.input.advanced.TaskAdapter;
import ru.softlogic.module.input.advanced.attribute.EnvAttributeProcessor;
import ru.softlogic.module.input.advanced.hdw.CardReaderHandlerImpl;
import ru.softlogic.module.input.advanced.hdw.SmartCardHandlerImpl;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.ScenarioStore;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.PathUtils;

public class AdvancedInputModule
extends BaseInputModule
implements CardStateListener {
    private MenuItem menuItem;
    private Locale locale;
    private Scenario scenario;
    private Map<String, Object> data;
    private TerminalEnvironment te;
    private String initBarcodeString;
    private String currentId;
    private ActionMap currentMap;
    private ActionMap prevMap;
    private Environment environment;
    private CommonScreen currentScreen;
    private ScreenDescription currentScreenDesription;
    private ComplexScreenListener screenListener;
    private ScenarioStore scenarioStore;
    private SumScreenDescription sumDescription;
    private VSTemplateProcessor processor;
    private CardReaderService crs;
    private CardModuleService cardModuleService;
    private SmartCardHandlerImpl sch;
    private CardReaderHandlerImpl crh;

    public AdvancedInputModule(ApplicationContext context) {
        super(context);
        this.screenListener = new LocalScreenListener(context);
        this.te = new TerminalEnvironment();
        this.scenarioStore = new ScenarioStore(Paths.getScenarioPath(), Paths.getEncodePath());
        try {
            this.processor = new VSTemplateProcessor(PathUtils.getAppHome());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.locale = environment.getLocale();
        this.menuItem = environment.getMenuItem();
        this.sumDescription = null;
        ru.softlogic.input.model.advanced.messages.B.setLocale((Locale)environment.getLocale());
        this.screenListener.setEnvironment(environment);
        try {
            this.screenListener.setPersonalNumbers(ReferenceManager.getInstance().getPersonalNumbers());
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        this.data = new HashMap<String, Object>();
        long begin = System.currentTimeMillis();
        try {
            CardReader cr;
            this.log.info((Object)"Load scenario");
            this.scenario = this.scenarioStore.getScenario(this.menuItem.getService().getCode(), environment.getLocale());
            this.log.info((Object)"Success");
            this.log.info((Object)("<<<<<" + this.scenario.getPrefillItem()));
            ModuleHelper.prefillStore(this.scenario.getPrefillItem(), environment, this.data);
            this.data.put("#chnum-name", this.scenario.getChangeNumber());
            this.data.put("#printer-type", this.context.getPrinterQueue().getPrinterType().toString());
            this.log.info((Object)(">>>>>" + this.data));
            environment.setChangeNumber(this.scenario.getChangeNumber());
            long end = System.currentTimeMillis();
            if (end - begin > 300L) {
                Service service = environment.getMenuItem().getService();
                ProblemNotifier.getDefaultNotifier().onProblem("Parsing form is too slow. Timeout=" + (end - begin) + " ms, service=" + service.getName() + "," + service.getId());
            } else if (end - begin > 5L) {
                this.log.debug((Object)("Parsing timeout: " + (end - begin)));
            }
            for (String key : this.scenario.getScreens().keySet()) {
                if (!(((AdvancedScreenDescription)this.scenario.getScreens().get(key)).getDescription() instanceof SumScreenDescription)) continue;
                this.sumDescription = (SumScreenDescription)((AdvancedScreenDescription)this.scenario.getScreens().get(key)).getDescription();
                break;
            }
            if (this.sumDescription == null) {
                this.sumDescription = new SumScreenDescription();
                this.sumDescription.setType("sum");
            }
            this.log.debug((Object)("Scenario: " + this.scenario));
            String cardHandler = this.scenario.getCardHandler();
            CardProcessorStore cardProcStore = CardProcessorStore.getInstance();
            if (cardHandler != null) {
                SmartCardProcessor scp = (SmartCardProcessor)Class.forName("ru.softlogic.smartcard." + cardHandler.toLowerCase() + ".CardProcessor").newInstance();
                cardProcStore.setProcessor(scp);
            }
            if ((cr = cardProcStore.getCardReader()) != null) {
                this.sch = new SmartCardHandlerImpl(cr);
                this.crh = new CardReaderHandlerImpl(cr, this);
            }
            boolean isProcess = false;
            Map<String, Object> initData = environment.getInitData();
            if (initData != null && !initData.isEmpty()) {
                Object cardAttr;
                Object barcodeAttr = initData.get("barcode");
                if (barcodeAttr instanceof String) {
                    this.initBarcodeString = (String)barcodeAttr;
                }
                if ((cardAttr = initData.get("card")) instanceof String) {
                    String card = (String)cardAttr;
                    this.data.put("card", new InputElement("card", "\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b", card));
                }
                ModuleHelper.fillStore(initData, this.data);
                isProcess = true;
            }
            String beginProcess = this.scenario.getBeginProcess();
            String beginTemplate = this.scenario.getBeginTemplate();
            if (Session.getInstance().getPaymentTemplateState().isSkipInput() && beginTemplate != null && !beginTemplate.isEmpty()) {
                this.showScreen(beginTemplate);
            } else if (isProcess && beginProcess != null && !beginProcess.isEmpty()) {
                this.showScreen(beginProcess);
            } else {
                this.showScreen(this.scenario.getBegin());
            }
            this.prevMap = null;
        }
        catch (ParseException ex) {
            throw new DescriptionException(ex);
        }
        catch (Throwable ex) {
            throw new ModuleInitException(ex);
        }
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        try {
            this.showScreen(this.currentId);
        }
        catch (InitException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
        }
    }

    @Override
    public synchronized void cancel(Intent intent) {
        try {
            if (this.cardModuleService != null) {
                CardModuleService tcms = this.cardModuleService;
                tcms.cancel();
                this.cardModuleService = null;
            }
            if (this.crs != null) {
                CardReaderService tcrs = this.crs;
                tcrs.cancel();
                this.crs = null;
            }
            super.cancel(intent);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            ModuleHelper.invoke(this.cancelListener);
        }
    }

    public void setCancelListener(Runnable cancelListener) {
        this.cancelListener = cancelListener;
    }

    @Override
    public Map<String, Object> getDataContext() {
        return this.data;
    }

    @Override
    protected void mergeData(Map<String, Object> local) {
        if (local != null) {
            this.data.putAll(local);
        }
    }

    @Override
    protected void showCurrentScreen() {
        if (this.currentScreen != null) {
            try {
                this.currentScreen.init(Helper.processButtons(this.currentScreenDesription, this.currentMap), InitModuleHelper.buildScreenInit(this.environment, this.data));
                this.currentScreen.setListener((ScreenListener)this.screenListener);
                this.context.showScreen(new ContentScreenAdapterKbr(this.currentScreen));
            }
            catch (InitException ex) {
                ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
            }
        } else {
            this.log.error((Object)"Current screen not set");
        }
    }

    @Override
    protected void showNextScreen() {
        this.screenListener.onAction("Next", this.data, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void showScreen(String screenId) throws InitException {
        this.log.info((Object)("Go to screen: " + screenId));
        if ("exit".equals(screenId)) {
            this.cancel(null);
        } else if ("previous".equals(screenId) || "previos".equals(screenId)) {
            this.back();
        } else if ("pay".equals(screenId)) {
            PaymentParams paymentParams;
            TransactionSum ts;
            this.currentScreen = null;
            Object obj = this.data.get("#sum");
            Pack pack = Session.getInstance().getPack();
            Sum operationSum = pack.getOperationSum();
            if (obj != null) {
                ts = (TransactionSum)obj;
                operationSum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
            }
            if ((obj = this.data.get("#sum-min")) instanceof TransactionSum) {
                ts = (TransactionSum)obj;
                pack.setMinSum(new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits())));
            }
            if ((obj = this.data.get("#sum-max")) instanceof TransactionSum) {
                ts = (TransactionSum)obj;
                pack.setMaxSum(new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits())));
            }
            if ((obj = this.data.get("#fee-sum")) instanceof ru.softlogic.input.model.FeeSum) {
                ru.softlogic.input.model.FeeSum fs = (ru.softlogic.input.model.FeeSum)obj;
                this.log.info((Object)("Set provider fee: " + fs));
                pack.setProviderFee(new FeeSum(fs.getFee(), fs.getFeeName(), fs.getFeePercent()));
            }
            if ((paymentParams = this.scenario.getPaymentParams()) == null || paymentParams.getKey() == null || paymentParams.getKey().trim().isEmpty()) {
                pack.setAllowReturn(paymentParams == null ? false : paymentParams.isAllowReturn());
                pack.setPrintByOne(paymentParams == null ? false : paymentParams.isSingleCheck());
                InitModuleHelper.processData(this.data);
                this._startPayment(this.environment, this.sumDescription, this.data, operationSum, null, null);
            } else {
                Object cart = this.data.get(paymentParams.getKey());
                if (cart == null) {
                    throw new InitException("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441 \u0438\u043c\u0435\u043d\u0435\u043c " + paymentParams.getKey() + "\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430");
                }
                pack.setSumDistributionType(paymentParams.getDistributionType());
                InitModuleHelper.processData(this.data);
                this.startPayment(this.environment, this.sumDescription, this.data, operationSum, null, null, cart);
            }
        } else {
            this.currentId = screenId;
            AdvancedScreenDescription screen = this.scenario.getScreenById(screenId);
            if (screen == null) {
                throw new InitException("Screen with id='" + screenId + "' not found");
            }
            ScreenDescription description = screen.getDescription();
            if ("void".equals(description.getType())) {
                this.currentMap = screen.getActionMap();
                this.screenListener.onAction("Next", this.data, new LocalVoidScreenCancelListener(this.cancelListener, this.currentMap));
            } else {
                this.currentMap = screen.getActionMap();
                this.currentScreen = CommonScreenStore.getScreen((String)description.getType(), (String)description.getDecor());
                if (this.currentScreen != null) {
                    this.currentScreenDesription = description;
                    this.barcodeScanner = this.currentScreenDesription.getBarcodeScanner();
                    ScreenDescription sd = this.barcodeScanner != null && this.barcodeScanner.isDisableButtonNext() ? Helper.processButtonsDisableNext(description, this.currentMap) : Helper.processButtons(description, this.currentMap);
                    sd = Helper.processScreenTitle(sd, this.data);
                    this.currentScreen.init(sd, InitModuleHelper.buildScreenInit(this.environment, this.data));
                    this.currentScreen.setListener((ScreenListener)this.screenListener);
                    this.context.showScreen(new ContentScreenAdapterKbr(this.currentScreen));
                    ru.softlogic.input.model.field.barcode.BarcodeScanner bscaner = description.getBarcodeScanner();
                    if (this.initBarcodeString != null && bscaner != null) {
                        try {
                            BarcodeData parse = bscaner.getParser().parse(this.initBarcodeString);
                            Map convert = ContextHelper.convert((List)parse.getElements());
                            this.data.putAll(convert);
                            this.initBarcodeString = null;
                        }
                        catch (BarcodeException ex) {
                            this.log.warn((Object)ex, (Throwable)ex);
                        }
                    }
                    if (description.getSound() != null) {
                        MediaPlayer.getInstance().play(description.getSound());
                    }
                } else {
                    throw new InitException("Unknown screen type: " + description.getType());
                }
            }
        }
    }

    private void startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data, Sum operationSum, Service srv, Commission comm, Object pCart) throws InitException {
        if (pCart instanceof List) {
            Commission comission;
            Short stid;
            List cart = (List)pCart;
            LinkedList<Payment> payments = new LinkedList<Payment>();
            Service envService = environment.getMenuItem().getService();
            Service s = srv == null ? envService : srv;
            int sid = (srv == null ? envService : srv).getId();
            Commission personal = ProviderHelper.getPersonalCommission(data, sid, stid = (srv == null ? envService : srv).getServiceTypeId());
            if (personal != null) {
                this.log.info((Object)("Set personal commission: " + personal));
                comission = personal;
            } else {
                comission = comm != null ? comm : environment.getMenuItem().getCommission();
            }
            Session.getInstance().getPack().setService(s);
            Session.getInstance().getPack().setCommission(comission);
            Session.getInstance().getPack().setPrintByOne(this.scenario.getPaymentParams().isSingleCheck());
            Session.getInstance().getPack().setAllowReturn(this.scenario.getPaymentParams().isAllowReturn());
            for (Data dt : cart) {
                Map elems = StoreHelper.convert((List)dt.getElements());
                if (!"1".equals(StoreHelper.getElement2((String)"selected", (Map)elems).getValue())) continue;
                InputElement ie = StoreHelper.getElement2((String)"summ", (Map)elems);
                InputElement ie2 = StoreHelper.getElement2((String)"service-count", (Map)elems);
                int count = 1;
                if (ie2 != null && !ie2.getValue().isEmpty()) {
                    try {
                        count = Integer.parseInt(ie2.getValue());
                    }
                    catch (NumberFormatException ex) {
                        throw new InitException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0443\u0441\u043b\u0443\u0433\u0438", (Throwable)ex);
                    }
                }
                if (ie.getValue().isEmpty()) continue;
                try {
                    Sum sum = new Sum(Double.parseDouble(ie.getValue().replace(',', '.')));
                    if (sum.isEmpty()) continue;
                    Payment p = new Payment();
                    p.setOperationSum(sum.mul(count));
                    HashMap<String, Object> data1 = new HashMap<String, Object>();
                    PaymentParams paymentParams = this.scenario.getPaymentParams();
                    if (paymentParams != null && paymentParams.isFirstParamsContext()) {
                        data1.putAll(data);
                        data1.putAll(elems);
                    } else {
                        data1.putAll(elems);
                        data1.putAll(data);
                    }
                    p.setData(StoreHelper.clearMulti(data1));
                    payments.add(p);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    throw new InitException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0443\u043c\u043c\u044b", (Throwable)ex);
                }
            }
            if (payments.isEmpty()) {
                throw new InitException("\u0423\u0441\u043b\u0443\u0433\u0438 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b");
            }
            Session.getInstance().getPack().setPayments(payments);
            Session.getInstance().getPack().setOperationSum(operationSum);
            CommonSumScreen css = (CommonSumScreen)CommonScreenStore.getSumScreen((SumScreenDescription)ssd, (MenuItem)environment.getMenuItem(), (boolean)true);
            try {
                ScreenInit si = InitModuleHelper.buildScreenInit(environment, data, srv == null ? environment.getMenuItem().getService() : srv, comission);
                if (CashDeviceManager.getInstance() != null) {
                    si.getData().put("coin-enable", String.valueOf(CashDeviceManager.getInstance().getDefaultCoinValidator() != null && CashDeviceManager.getInstance().getDefaultCoinValidator().isEnabled()));
                }
                si.setPayments(Session.getInstance().getPack().getPayments());
                css.init((ScreenDescription)ssd, si);
                this.log.info((Object)"Start payment");
                environment.getPaymentModule().startPayment(environment, css);
            }
            catch (InitException ex) {
                ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
            }
        } else {
            throw new InitException("" + pCart + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f nested data");
        }
    }

    public void onCardState(int cardState) {
        this.log.info((Object)("Card state is change: " + CRMsg.getCardState((int)cardState)));
        if (cardState == 2) {
            if (this.currentScreen != null) {
                this.log.info((Object)"Notify screen");
                this.currentScreen.onEvent(new Event(0));
            } else {
                this.log.info((Object)"Screen is null, skip");
            }
        }
    }

    private void showError(Exception ex) {
        this.log.error((Object)ex, (Throwable)ex);
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.advanced.process.error", (Locale)this.locale), 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener((DialogListener)new ExitDialogListener(this));
        this.context.showDialog((DialogInterface)dialog);
    }

    private class LocalVoidScreenCancelListener
    implements Runnable {
        Runnable prevCancel;

        public LocalVoidScreenCancelListener(Runnable prevCancel, ActionMap prevMap) {
            this.prevCancel = prevCancel;
            AdvancedInputModule.this.prevMap = prevMap;
        }

        @Override
        public void run() {
            if (AdvancedInputModule.this.prevMap != null) {
                AdvancedInputModule.this.currentMap = AdvancedInputModule.this.prevMap;
            }
            ModuleHelper.invoke(this.prevCancel);
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> localData, Runnable cancelListener) {
            AdvancedInputModule.this.log.info((Object)("Action: " + action));
            AdvancedInputModule.this.cancelListener = cancelListener;
            try {
                if (DialogType.ERRORDIALOG.toString().equals(action)) {
                    String error = (String)(localData.get("#error.message") != null ? localData.get("#error.message") : null);
                    DialogScreen ds = ComponentFactory.getInstance().createDialog(DialogType.ERRORDIALOG, error, 3, null, UserCase.Ok);
                    AdvancedInputModule.this.context.showDialog((DialogInterface)ds);
                } else {
                    Action act = AdvancedInputModule.this.currentMap.getActionByType(action);
                    if (act == null) {
                        act = AdvancedInputModule.this.currentMap.getActionByType(action.toLowerCase());
                    }
                    ActionContext context = new ActionContext((ru.softlogic.input.model.advanced.Environment)AdvancedInputModule.this.te, cancelListener, act.getSequence(), ContextHelper.mergeData((Map)AdvancedInputModule.this.data, localData), (short)AdvancedInputModule.this.menuItem.getService().getId());
                    context.execute();
                }
            }
            catch (Exception ex) {
                AdvancedInputModule.this.log.error((Object)ex, (Throwable)ex);
                ru.softlogic.srv.api.event.Event event = new ru.softlogic.srv.api.event.Event(EventType.SoftwareFault, "Advanced: " + ex.getMessage());
                AdvancedInputModule.this.context.getServerConnector().sendEvent(event);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.advanced.process.error", (Locale)AdvancedInputModule.this.locale), 10, DC.cases((int)1), UserCase.Ok);
                dialog.addListener((DialogListener)new ExitDialogListener(AdvancedInputModule.this));
                AdvancedInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        public void onRedirect(int serviceId) {
            AdvancedInputModule.this._redirect(serviceId);
        }

        @Override
        public void onLocale(Locale locale) {
            super.onLocale(locale);
            ru.softlogic.input.model.advanced.messages.B.setLocale((Locale)locale);
        }
    }

    private class TerminalEnvironment
    implements ru.softlogic.input.model.advanced.Environment {
        private TerminalEnvironment() {
        }

        public void showDialog(DialogAction dialog) {
            AdvancedInputModule.this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043a\u0430\u0437 \u0434\u0438\u0430\u043b\u043e\u0433\u0430: " + dialog));
            DialogScreen ds = ComponentFactory.getInstance().createDialog(dialog);
            AdvancedInputModule.this.context.showDialog((DialogInterface)ds);
        }

        public void showScreen(String nextScreen, Map<String, Object> localData) {
            AdvancedInputModule.this.log.info((Object)("Needs to show screen: " + nextScreen));
            AdvancedInputModule.this.data.putAll(localData);
            LinkedHashMap result = new LinkedHashMap();
            for (String key : AdvancedInputModule.this.data.keySet()) {
                if (AdvancedInputModule.this.data.get(key) == null) continue;
                result.put(key, AdvancedInputModule.this.data.get(key));
            }
            AdvancedInputModule.this.data = result;
            try {
                AdvancedInputModule.this.showScreen(nextScreen);
            }
            catch (InitException ex) {
                this.showError((Exception)((Object)ex));
            }
        }

        public void showError(Exception ex) {
            AdvancedInputModule.this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", (Throwable)ex);
            String servId = "";
            if (AdvancedInputModule.this.environment.getMenuItem() != null && AdvancedInputModule.this.environment.getMenuItem().getService() != null) {
                servId = "(service=" + AdvancedInputModule.this.environment.getMenuItem().getService().getId() + ") ";
            }
            ClientInterface serverConnector = AdvancedInputModule.this.context.getServerConnector();
            serverConnector.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.SoftwareFault, "Advanced " + servId + ": " + ex.getMessage()));
            BarcodeScanner.getScanner().removeListener(AdvancedInputModule.this.barcodeListener);
            AdvancedInputModule.this.showError(ex);
        }

        public void execute(AsyncTask task) {
            AdvancedInputModule.this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438: " + task));
            AdvancedInputModule.this.context.getTaskExecutor().execute(new TaskAdapter(task, AdvancedInputModule.this.locale));
        }

        public ServerConnector getConnector() {
            return new ConnectorAdapter(AdvancedInputModule.this.context.getServerConnector());
        }

        public AdvancedHardwareApi getHardwareApi() {
            return new AdvancedHardwareApi(){

                public SmartCardHandler getSmartCardHandler() {
                    return AdvancedInputModule.this.sch;
                }

                public CardReaderHandler getCardReaderHandler() {
                    return AdvancedInputModule.this.crh;
                }

                public CardDispenserHandler getCardDispenserHandler() {
                    return null;
                }

                public Printer getPrinter() {
                    return new PrinterAdapter(AdvancedInputModule.this.context.getPrinterQueue());
                }

                public WebcamHandler getWebcamHandler() {
                    return null;
                }
            };
        }

        public void openService(short serviceId, Map<String, Object> params) {
            AdvancedInputModule.this._redirect(serviceId, params);
        }

        public String getOffer(String fileName) {
            if (fileName == null) {
                fileName = "offer";
            }
            Locale loc = AdvancedInputModule.this.environment.getLocale();
            String res = AdvancedInputModule.this.processor.process(fileName + (loc != null ? "_" + loc.getLanguage() : "") + ".html");
            if (res != null) {
                return res;
            }
            return AdvancedInputModule.this.processor.process(fileName + ".html");
        }

        public Map<String, String> getPointParams() {
            HashMap<String, String> res = new HashMap<String, String>();
            String params = AdvancedInputModule.this.environment.getPoint().getParams();
            if (params != null) {
                params = params.replace("<br/>", "\n");
                Properties pr = new Properties();
                try {
                    pr.load(new StringReader(params));
                    for (String name : pr.stringPropertyNames()) {
                        res.put(name, pr.getProperty(name));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return res;
        }

        public synchronized void getCardTrack(int track, final CardRequestListener listener) {
            try {
                if (AdvancedInputModule.this.crs == null) {
                    AdvancedInputModule.this.crs = new CardReaderService((ApplicationContext)AdvancedInputModule.this.context, AdvancedInputModule.this);
                }
                AdvancedInputModule.this.crs.run(AdvancedInputModule.this.environment, track, listener);
            }
            catch (Throwable e) {
                AdvancedInputModule.this.log.error((Object)e, e);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.advanced.crs.error", (Locale)AdvancedInputModule.this.locale), 10, DC.cases((int)1), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        listener.onResult(null);
                    }
                });
                AdvancedInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        public void executeCardModuleTask(CardOperation co, boolean needReject, final CardModuleRequestListener listener) {
            try {
                if (AdvancedInputModule.this.cardModuleService == null) {
                    AdvancedInputModule.this.cardModuleService = new CardModuleService((ApplicationContext)AdvancedInputModule.this.context, AdvancedInputModule.this.environment, AdvancedInputModule.this);
                }
                AdvancedInputModule.this.cardModuleService.setNeedRejectCard(needReject);
                AdvancedInputModule.this.cardModuleService.setListener(listener);
                AdvancedInputModule.this.cardModuleService.run();
            }
            catch (Exception e) {
                AdvancedInputModule.this.log.error((Object)e, (Throwable)e);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.advanced.crs.error", (Locale)AdvancedInputModule.this.locale), 10, DC.cases((int)1), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        listener.onError(e);
                    }
                });
                AdvancedInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        public void play(String file) {
            MediaPlayer.getInstance().play(file);
        }

        public Short getOperator(String number) {
            Integer id = FederalNumberValidator.getInstance().getProvider(number);
            return id == null ? null : Short.valueOf(id.shortValue());
        }

        public void handleError(Exception ex) {
            AdvancedInputModule.this.log.error((Object)ex, (Throwable)ex);
        }

        public InputElement getValue(String value) {
            return EnvAttributeProcessor.getValue(value, AdvancedInputModule.this.locale, AdvancedInputModule.this.menuItem.getService());
        }

        public AdvancedCommissionCalculator getCommissionCalculator() {
            return new AdvCommissionCalculatorImpl(AdvancedInputModule.this.environment);
        }

        public void openUrl(String string, OpenUrlTarget out, MethodType mt, String string1, Map<String, String> map) {
        }
    }
}

