/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.cash.Keeper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.operation.TableItem;
import ru.softlogic.service.comission.SumResult;

public class UnloaderPrintHelper {
    private static final String DELIMITER = "#";
    private static SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss  dd.MM.yy");

    public static String printHeader(Locale locale) {
        return B.get((String)"Admin.unload.payments.csv.idOperation", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.checkNumber", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.serviceType", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.service", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.commission", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.date", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.titles", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.form", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.views", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.keeper", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.change", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.sumResult.out", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.sumResult.outProv", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.sumResult.commission", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.sumResult.change", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.pinCode", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.pinCodeNominal", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.tableItems", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.point", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.dealer", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.paymentSystem", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.bank", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.copy", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.locale", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.paymentTool", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.cardNumber", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.client", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.terminal", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.systemTransaction", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.retrRefNumber", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.cashlessData.authIdentResponse", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.flags", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.unknownProcessResult", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.lastProcess", (Locale)locale) + '\n';
    }

    public static String printOperations(Operation[] ops, int size, Locale locale) {
        String result = "";
        for (int i = 0; i < size; ++i) {
            result = ops[i] instanceof GroupOperation ? result + UnloaderPrintHelper.prepareGroupOperation((GroupOperation)ops[i], locale) : result + UnloaderPrintHelper.prepareOperation(ops[i]);
        }
        return result;
    }

    private static String prepareOperation(Operation o) {
        return o.getIdOperation() + DELIMITER + o.getCheckNumber() + DELIMITER + "\"" + (o.getServiceType() != null ? o.getServiceType().getName() : "-") + "\"" + DELIMITER + "\"" + (o.getService() != null ? o.getService().getName() : "-") + "\"" + DELIMITER + "\"" + (o.getCommission() != null ? o.getCommission().getName() : "-") + "\"" + DELIMITER + (o.getDate() != null ? sdf.format(o.getDate()) : "-") + DELIMITER + UnloaderPrintHelper.printPaymentData(o.getTitles(), o.getForm(), o.getViews()) + DELIMITER + UnloaderPrintHelper.printKeeperSum(o.getKeeper()) + DELIMITER + UnloaderPrintHelper.printKeeperSum(o.getChange()) + DELIMITER + UnloaderPrintHelper.printSumResult(o.getSumResult()) + DELIMITER + "\"" + (o.getPinCode() != null ? o.getPinCode() : "-") + "\"" + DELIMITER + "\"" + (o.getPinCodeNominal() != null ? o.getPinCodeNominal().toString() : "-") + "\"" + DELIMITER + UnloaderPrintHelper.printTable(o.getTableItems()) + DELIMITER + (o.getPoint() != null ? Integer.valueOf(o.getPoint().getId()) : "-") + DELIMITER + (o.getDealer() != null ? o.getDealer().getName() : "-") + DELIMITER + (o.getPaymentSystem() != null ? o.getPaymentSystem().getName() : "-") + DELIMITER + (o.getBank() != null ? o.getBank().getName() : "-") + DELIMITER + String.valueOf(o.isCopy()) + DELIMITER + (o.getLocale() != null ? o.getLocale().toString() : "-") + DELIMITER + PackUtility.getPaymentTool(o.getPaymentTool()) + DELIMITER + UnloaderPrintHelper.printCashlessData(o.getCashlessData()) + DELIMITER + UnloaderPrintHelper.printFlags(o.getFlags()) + DELIMITER + String.valueOf(o.isUnknownProcessResult()) + DELIMITER + (o.getLastProcess() != 0L ? sdf.format(o.getLastProcess()) : "-") + '\n';
    }

    private static String prepareGroupOperation(GroupOperation go, Locale locale) {
        String result = go.getIdOperation() + DELIMITER + go.getCheckNumber() + DELIMITER + "\"" + (go.getServiceType() != null ? go.getServiceType().getName() : "-") + "\"" + DELIMITER + "\"" + (go.getService() != null ? go.getService().getName() : "-") + "\"" + DELIMITER + "\"" + (go.getCommission() != null ? go.getCommission().getName() : "-") + "\"" + DELIMITER + (go.getDate() != null ? sdf.format(go.getDate()) : "-") + DELIMITER + UnloaderPrintHelper.printGroupPaymentData(go.getTitles(), go.getForm(), go.getViews()) + DELIMITER + UnloaderPrintHelper.printKeeperSum(go.getKeeper()) + DELIMITER + UnloaderPrintHelper.printKeeperSum(go.getChange()) + DELIMITER + UnloaderPrintHelper.printSumResult(go.getSumResult()) + DELIMITER + "\"" + (go.getPinCode() != null ? go.getPinCode() : "-") + "\"" + DELIMITER + "\"" + (go.getPinCodeNominal() != null ? go.getPinCodeNominal().toString() : "-") + "\"" + DELIMITER + UnloaderPrintHelper.printTable(go.getTableItems()) + DELIMITER + (go.getPoint() != null ? Integer.valueOf(go.getPoint().getId()) : "-") + DELIMITER + (go.getDealer() != null ? go.getDealer().getName() : "-") + DELIMITER + (go.getPaymentSystem() != null ? go.getPaymentSystem().getName() : "-") + DELIMITER + (go.getBank() != null ? go.getBank().getName() : "-") + DELIMITER + String.valueOf(go.isCopy()) + DELIMITER + (go.getLocale() != null ? go.getLocale().toString() : "-") + DELIMITER + PackUtility.getPaymentTool(go.getPaymentTool()) + DELIMITER + UnloaderPrintHelper.printCashlessData(go.getCashlessData()) + DELIMITER + UnloaderPrintHelper.printFlags(go.getFlags()) + DELIMITER + String.valueOf(go.isUnknownProcessResult()) + DELIMITER + (go.getLastProcess() != 0L ? sdf.format(go.getLastProcess()) : "-") + '\n';
        result = result + UnloaderPrintHelper.printGroupHeader(locale);
        for (ChildOperation co : go.getChildOperations()) {
            result = result + "#\"" + (co.getTitles() == null || co.getForm().get("name") == null ? "-" : (String)co.getForm().get("name")) + "\"" + DELIMITER + "\"" + (co.getSumOutcome() != null ? co.getSumOutcome().toString() : "-") + "\"" + DELIMITER + "\"" + (co.getCommission() != null ? co.getCommission().toString() : "-") + "\"" + '\n';
        }
        return result;
    }

    private static String printGroupHeader(Locale locale) {
        return DELIMITER + B.get((String)"Admin.unload.payments.csv.group.service", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.group.sumOutcome", (Locale)locale) + DELIMITER + B.get((String)"Admin.unload.payments.csv.group.sumCommission", (Locale)locale) + '\n';
    }

    private static String printGroupPaymentData(Map<String, String> titles, Map<String, String> form, Map<String, String> views) {
        if (titles == null || form == null || views == null) {
            return "-#-#-";
        }
        String t = "\"";
        String f = "\"";
        String v = "\"";
        for (String key : titles.keySet()) {
            if ("name".equals(key)) continue;
            t = t + "\n" + (titles.get(key) != null ? titles.get(key) : "-");
            f = f + "\n" + (form.get(key) != null ? form.get(key) : "-");
            v = v + "\n" + (views.get(key) != null ? views.get(key) : "-");
        }
        t = t.replaceFirst("\\\n", "") + "\"";
        f = f.replaceFirst("\\\n", "") + "\"";
        v = v.replaceFirst("\\\n", "") + "\"";
        return t + DELIMITER + f + DELIMITER + v;
    }

    private static String printPaymentData(Map<String, String> titles, Map<String, String> form, Map<String, String> views) {
        if (titles == null || form == null || views == null) {
            return "-#-#-";
        }
        String t = "\"";
        String f = "\"";
        String v = "\"";
        for (String key : titles.keySet()) {
            t = t + "\n" + (titles.get(key) != null ? titles.get(key) : "-");
            f = f + "\n" + (form.get(key) != null ? form.get(key) : "-");
            v = v + "\n" + (views.get(key) != null ? views.get(key) : "-");
        }
        t = t.replaceFirst("\\\n", "") + "\"";
        f = f.replaceFirst("\\\n", "") + "\"";
        v = v.replaceFirst("\\\n", "") + "\"";
        return t + DELIMITER + f + DELIMITER + v;
    }

    private static String printKeeperSum(Keeper k) {
        if (k == null || k.getSum() == null) {
            return "-";
        }
        return "\"" + k.getSum().toString() + "\"";
    }

    private static String printSumResult(SumResult sr) {
        if (sr == null) {
            return "-#-#-#-";
        }
        String res = "";
        res = sr.getOut() != null ? res + "\"" + sr.getOut().toString() + "\"" + DELIMITER : res + "-#";
        res = sr.getOutProv() != null ? res + "\"" + sr.getOutProv().toString() + "\"" + DELIMITER : res + "-#";
        res = sr.getCommission() != null ? res + "\"" + sr.getCommission().toString() + "\"" + DELIMITER : res + "-#";
        res = sr.getChange() != null ? res + "\"" + sr.getChange().toString() + "\"" : res + DELIMITER;
        return res;
    }

    private static String printTable(TableItem[] tis) {
        if (tis == null) {
            return "-";
        }
        String res = "\"";
        for (TableItem ti : tis) {
            res = res + "\n" + ti.getTitle() + ": " + ti.getValue();
        }
        res = res.replaceFirst("\\\n", "") + "\"";
        return res;
    }

    private static String printCashlessData(CashlessData cd) {
        if (cd == null) {
            return "-#-#-#-#-#-";
        }
        String res = "";
        res = cd.getCardNumber() != null ? res + "\"" + cd.getCardNumber() + "\"" + DELIMITER : res + "-#";
        res = cd.getClient() != null ? res + "\"" + cd.getClient() + "\"" + DELIMITER : res + "-#";
        res = cd.getTerminal() != null ? res + "\"" + cd.getTerminal() + "\"" + DELIMITER : res + "-#";
        res = cd.getSystemTransaction() != null ? res + "\"" + cd.getSystemTransaction() + "\"" + DELIMITER : res + "-#";
        res = cd.getRetrRefNumber() != null ? res + "\"" + cd.getRetrRefNumber() + "\"" + DELIMITER : res + "-#";
        res = cd.getAuthIdentResponse() != null ? res + "\"" + cd.getAuthIdentResponse() + "\"" : res + DELIMITER;
        return res;
    }

    private static String printFlags(int flags) {
        String res = "";
        if ((flags & 1) > 0) {
            res = res + "\nDOC_NOT_PRINTED";
        }
        if ((flags & 2) > 0) {
            res = res + "\nDOC_COPY";
        }
        if ((flags & 0x10) > 0) {
            res = res + "\nONLINE_PAYMENT";
        }
        if ((flags & 0x20) > 0) {
            res = res + "\nFISCAL_PAYMENT";
        }
        if ((flags & 0x40) > 0) {
            res = res + "\nFRAUD_BLOCKING";
        }
        if ((flags & 0x80) > 0) {
            res = res + "\nSMS_AGREE";
        }
        if ((flags & 0x100) > 0) {
            res = res + "\nSAFE_SERVICE";
        }
        if ((flags & 0x200) > 0) {
            res = res + "\nSEND_SMS_CHECK";
        }
        if ((res = res.replaceFirst("\\\n", "")).equals("")) {
            return "No flags set";
        }
        return "\"" + res + "\"";
    }
}

