/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import ru.softlogic.module.input.admin.PaymentsCollectionRecord;

public class PaymentsCollectionModel
extends AbstractTableModel {
    private PaymentsCollectionRecord[] records;
    private String[] columns;
    private SimpleDateFormat sdf;

    public PaymentsCollectionModel(PaymentsCollectionRecord[] records, String number, String type, String id, String date, String sum) {
        this.records = records;
        this.columns = new String[5];
        this.columns[0] = number;
        this.columns[1] = type;
        this.columns[2] = id;
        this.columns[3] = date;
        this.columns[4] = sum;
        this.sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public void updateRecords(PaymentsCollectionRecord[] records) {
        this.records = records;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.records == null ? 0 : this.records.length;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PaymentsCollectionRecord rec = this.records[rowIndex];
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        if (columnIndex == 1) {
            return rec.getType() == null ? "" : rec.getType();
        }
        if (columnIndex == 2) {
            return rec.getId() == null ? "" : rec.getId();
        }
        if (columnIndex == 3) {
            return rec.getDate() == null ? "-" : this.sdf.format(rec.getDate());
        }
        if (columnIndex == 4) {
            return rec.getSum() == null ? "-" : rec.getSum();
        }
        return null;
    }
}

