/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;

public class CashBoxModel
implements TableModel {
    private CashUnit[] units;
    private Keeper keeper;
    private String[] titles;

    public CashBoxModel(CashUnit[] units, Keeper keeper, String[] titles) {
        this.units = units;
        this.keeper = keeper;
        this.titles = titles;
    }

    @Override
    public int getRowCount() {
        return this.units.length + 1;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.titles[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.units.length) {
            if (columnIndex == 0) {
                return this.units[rowIndex].getNominal().toString();
            }
            if (columnIndex == 1) {
                return this.keeper.getCashUnits().get(this.units[rowIndex]) == null ? 0 : (Integer)this.keeper.getCashUnits().get(this.units[rowIndex]);
            }
            int count = this.keeper.getCashUnits().get(this.units[rowIndex]) == null ? 0 : (Integer)this.keeper.getCashUnits().get(this.units[rowIndex]);
            return this.units[rowIndex].getNominal().mul(count);
        }
        if (columnIndex == 0) {
            return this.titles[3];
        }
        if (columnIndex == 1) {
            int count = 0;
            for (CashUnit cu : this.keeper.getCashUnits().keySet()) {
                count += ((Integer)this.keeper.getCashUnits().get(cu)).intValue();
            }
            return Integer.toString(count);
        }
        if (columnIndex == 2) {
            return this.keeper.getCashSum();
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

