/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.module.Paths;
import ru.softlogic.parser.uni.Parser;
import ru.softlogic.system.util.PathUtils;

public class PreinitHelper {
    private static Map<String, SoftReference<Form>> forms = new HashMap<String, SoftReference<Form>>();
    private static Logger log = Logger.getLogger((String)"pay");

    public static Map<String, InputElement> getItems(int code, Locale locale) {
        Form form = PreinitHelper.getForm(code, locale);
        if (form != null && form.getScreenSequence() != null && form.getScreenSequence().getFields() != null) {
            LinkedHashMap<String, InputElement> map = new LinkedHashMap<String, InputElement>();
            for (InputElement ie : form.getScreenSequence().getFields()) {
                map.put(ie.getKey(), ie);
            }
            return map;
        }
        return null;
    }

    public static Map<String, String> getItemsData(int code, Locale locale) {
        Form form = PreinitHelper.getForm(code, locale);
        if (form != null && form.getScreenSequence() != null && form.getScreenSequence().getFields() != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (InputElement ie : form.getScreenSequence().getFields()) {
                map.put(ie.getKey(), ie.getValue());
            }
            return map;
        }
        return null;
    }

    private static Form getForm(int code, Locale locale) {
        Form form;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((form = PreinitHelper.getForm(code, "preinit", "_" + locale.getLanguage())) != null) {
            return form;
        }
        form = PreinitHelper.getForm(code, "preinit", "");
        return form;
    }

    private static Form getForm(int code, String path, String suffix) {
        String id = "" + code + path + suffix;
        log.info((Object)("Search: " + id));
        if (forms.containsKey(id)) {
            SoftReference<Form> srf = forms.get(id);
            if (srf != null) {
                Form f = srf.get();
                if (f == null) {
                    log.info((Object)("SoftReference go out: " + path + suffix));
                    f = PreinitHelper.readFormRes(code, path, suffix);
                    forms.put(id, new SoftReference<Form>(f));
                }
                return f;
            }
        } else {
            Form f = PreinitHelper.readFormRes(code, path, suffix);
            if (f != null) {
                forms.put(id, new SoftReference<Form>(f));
                return f;
            }
            forms.put(id, null);
        }
        return null;
    }

    private static Form readFormRes(int code, String path, String postfix) {
        try {
            return Parser.getForm((File)new File(PathUtils.getAppHome() + "/resources/utility/" + path + postfix + ".xml"), (short)((short)code), (File)Paths.getAutoCompletePath());
        }
        catch (Exception ex) {
            Logger.getLogger((String)"pay").info((Object)ex.getMessage());
            return null;
        }
    }
}

