/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import java.lang.reflect.Constructor;
import java.util.EnumMap;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.module.input.EmptyInputModule;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.admin.AdminInputModule;
import ru.softlogic.module.input.advanced.AdvancedInputModule;
import ru.softlogic.module.input.cardbalance.CardBalanceInputModule;
import ru.softlogic.module.input.cardbalance.CardReportInputModule;
import ru.softlogic.module.input.cashtocard.CardTransferInputModule;
import ru.softlogic.module.input.cashtocard.CashToCardInputModule;
import ru.softlogic.module.input.cashtonocard.CashToNoCardInputModule;
import ru.softlogic.module.input.chcopy.CheckCopyInputModule;
import ru.softlogic.module.input.dynamic.DynamicFormInputModule;
import ru.softlogic.module.input.ecards.ECardsInputModule;
import ru.softlogic.module.input.exit.ExitInputModule;
import ru.softlogic.module.input.hopper.CoinHopperInputModule;
import ru.softlogic.module.input.mobile.MobileInputModule;
import ru.softlogic.module.input.ntscoffee.NtsCoffeeBonusInputModule;
import ru.softlogic.module.input.ntscoffee.NtsCoffeeInputModule;
import ru.softlogic.module.input.ntssnack.NtsSnackInputModule;
import ru.softlogic.module.input.paystat.AdvPayStatusInputModule;
import ru.softlogic.module.input.paystat.PayStatusInputModule;
import ru.softlogic.module.input.promo.PromoInputModule;
import ru.softlogic.module.input.repayment.LastPaymentRepeatModule;
import ru.softlogic.module.input.runner.RunnerModule;
import ru.softlogic.module.input.site.LocalSiteInputModule;
import ru.softlogic.module.input.universal.UniversalInputModule;
import ru.softlogic.module.search.SearchProviderInputModule;
import ru.softlogic.provider.ProviderType;

public class InputModuleFactory {
    private static final Map<ProviderType, InputModule> modules = new EnumMap<ProviderType, InputModule>(ProviderType.class);
    private static ApplicationContext context;

    public static void init(ApplicationContext context) {
        InputModuleFactory.context = context;
    }

    public static InputModule getModule(ProviderType type) {
        if (context == null) {
            throw new NullPointerException("Factory not init");
        }
        if (type == null) {
            return null;
        }
        InputModule im = modules.get(type);
        if (im != null) {
            return im;
        }
        switch (type) {
            case UniversalProvider: {
                im = new UniversalInputModule(context);
                break;
            }
            case AdminProvider: {
                im = new AdminInputModule(context);
                break;
            }
            case Mobile: {
                im = new MobileInputModule(context);
                break;
            }
            case AdvancedProvider: {
                im = new AdvancedInputModule(context);
                break;
            }
            case ChCopyProvider: {
                im = new CheckCopyInputModule(context);
                break;
            }
            case PaymentStatusProvider: {
                im = new PayStatusInputModule(context);
                break;
            }
            case AdvPaymentStatusProvider: {
                im = new AdvPayStatusInputModule(context);
                break;
            }
            case PromoProvider: {
                im = new PromoInputModule(context);
                break;
            }
            case SearchService: {
                im = new SearchProviderInputModule(context);
                break;
            }
            case SiteProvider: {
                im = new LocalSiteInputModule(context);
                break;
            }
            case CoinHopperProvider: {
                im = new CoinHopperInputModule(context);
                break;
            }
            case ExitInputModule: {
                im = new ExitInputModule(context);
                break;
            }
            case RunExternal: {
                im = new RunnerModule(context);
                break;
            }
            case CardBalance: {
                im = new CardBalanceInputModule(context);
                break;
            }
            case CardReport: {
                im = new CardReportInputModule(context);
                break;
            }
            case CashToCard: {
                im = new CashToCardInputModule(context);
                break;
            }
            case CardTransferProvider: {
                im = new CardTransferInputModule(context);
                break;
            }
            case CashToNoCard: {
                im = new CashToNoCardInputModule(context);
                break;
            }
            case Keeper: {
                try {
                    Constructor<?> constructor = Class.forName("ru.softlogic.module.input.keeper.KeeperInputModule").getConstructor(ApplicationContext.class);
                    im = (InputModule)constructor.newInstance(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    im = null;
                }
                break;
            }
            case ECardsProvider: {
                im = new ECardsInputModule(context);
                break;
            }
            case NtsCoffeeProvider: {
                im = new NtsCoffeeInputModule(context);
                break;
            }
            case NtsCoffeeBonusProvider: {
                im = new NtsCoffeeBonusInputModule(context);
                break;
            }
            case NtsSnackProvider: {
                im = new NtsSnackInputModule(context);
                break;
            }
            case EmptyInputModule: {
                im = new EmptyInputModule(context);
                break;
            }
            case LastPaymentRepeatProvider: {
                im = new LastPaymentRepeatModule(context);
                break;
            }
            case DynamicForm: {
                im = new DynamicFormInputModule(context);
            }
        }
        if (im != null) {
            modules.put(type, im);
        }
        return im;
    }
}

