/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import i18n.B;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Payment;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.request.ConnectorException;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.module.input.FiscalRequestListener;

public class FiscalRequestTask
implements AsyncTask {
    private final int serviceId;
    private final ApplicationContext ctx;
    private final FiscalRequestListener listener;
    private final Map<String, Object> data;
    private final List<Payment> payments;
    private final Locale locale;
    private final Logger log = Logger.getLogger((String)"pay");

    public FiscalRequestTask(int serviceId, ApplicationContext ctx, FiscalRequestListener listener, Map<String, Object> data, List<Payment> payments, Locale locale) {
        this.serviceId = serviceId;
        this.ctx = ctx;
        this.listener = listener;
        this.data = data;
        this.payments = payments;
        this.locale = locale;
    }

    public Object execute() {
        RequestData rd = new RequestData();
        rd.setIdService((short)this.serviceId);
        rd.setFunction("fiscal#get-transaction");
        HashMap<String, InputElement> map = new HashMap<String, InputElement>();
        if (this.data != null) {
            for (String key : this.data.keySet()) {
                if (!(this.data.get(key) instanceof InputElement)) continue;
                InputElement ie = (InputElement)this.data.get(key);
                map.put(ie.getKey(), ie);
            }
        } else if (this.payments != null) {
            Map dt = this.payments.get(0).getData();
            for (String key : dt.keySet()) {
                if (!(dt.get(key) instanceof InputElement)) continue;
                InputElement ie = (InputElement)dt.get(key);
                map.put(ie.getKey(), ie);
            }
        }
        rd.setParamsIe(map);
        try {
            this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u0437\u0430\u043f\u0440\u043e\u0441 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438: " + rd));
            return this.ctx.getServerConnector().request(rd);
        }
        catch (ConnectorException ex) {
            return ex;
        }
    }

    public void onResult(Object result) {
        this.log.info((Object)("result=" + result));
        if (result instanceof Exception) {
            DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.fiscal.request.exception", (Locale)this.locale), 15, DC.cases((int)1, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
            dlg.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    FiscalRequestTask.this.listener.onRestore();
                }
            });
            this.ctx.showDialog((DialogInterface)dlg);
        } else {
            Response resp = (Response)result;
            if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
                if (resp.getData() != null) {
                    LinkedHashMap<String, Object> resData = new LinkedHashMap<String, Object>();
                    Data dt = (Data)resp.getData();
                    if (dt.getElements() != null) {
                        for (InputElement el : dt.getElements()) {
                            resData.put(el.getKey(), el);
                        }
                    }
                    this.listener.onResult(resData);
                }
            } else {
                DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.fiscal.request.error", (Locale)this.locale), 15, DC.cases((int)1, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
                dlg.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        FiscalRequestTask.this.listener.onRestore();
                    }
                });
                this.ctx.showDialog((DialogInterface)dlg);
            }
        }
    }

    public String toString() {
        return "FiscalRequestTask{}";
    }
}

