/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.entry;

import i18n.B;
import java.awt.EventQueue;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.AppEnvironmentAdapter;
import ru.softlogic.app.AppEnvironmentListener;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.application.CashAccMenuListener;
import ru.softlogic.application.CashDispMenuListener;
import ru.softlogic.application.DelayMenuListener;
import ru.softlogic.application.EmptyUserActionsListener;
import ru.softlogic.application.PrinterMenuListener;
import ru.softlogic.application.WarningMenuListener;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.ContentScreen;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.content.menu.MenuParams;
import ru.softlogic.gui.screen.content.menu.MenuScreen;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboard;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.completive.CompletiveModule;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.entry.BaseEntryModule;
import ru.softlogic.module.entry.ChangeCancelManager;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.module.payout.PayoutModule;
import ru.softlogic.module.present.PresentModule;
import ru.softlogic.module.print.PrintModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.module.reinit.BaseReinitModule;
import ru.softlogic.module.reinit.ReinitModule;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public class MenuEntryModule
extends BaseEntryModule {
    private static final Logger log = Logger.getLogger((String)"gui");
    private final ApplicationContext context;
    private final PaymentModule paymentModule;
    private final ProcessingModule processingModule;
    private final PrintModule printModule;
    private final PayoutModule payoutModule;
    private final EndingModule endingModule;
    private final PresentModule presentModule;
    private final CompletiveModule completiveModule;
    private final MenuScreen menuScreen;
    private final StartPaymentListener startPaymentListener;
    private final PrinterMenuListener printerMenuListener;
    private final DelayMenuListener delayMenuListener;
    private final WarningMenuListener warningMenuListener;
    private final CashDispMenuListener cashDispMenuListener;
    private final CashAccMenuListener accMenuListener;
    private final ReinitModule reinitModule;
    private final EmptyUserActionsListener emptyUserActionsListener;
    private Locale defaultLocale;

    public MenuEntryModule(ApplicationContext context, PaymentModule paymentModule, PayoutModule payoutModule, ProcessingModule processingModule, PrintModule printModule, EndingModule endingModule, PresentModule presentModule, CompletiveModule completiveModule) {
        this.context = context;
        this.paymentModule = paymentModule;
        this.payoutModule = payoutModule;
        this.processingModule = processingModule;
        this.printModule = printModule;
        this.endingModule = endingModule;
        this.presentModule = presentModule;
        this.completiveModule = completiveModule;
        this.reinitModule = new BaseReinitModule(context);
        AppEnvironment.getInstance().addListener((AppEnvironmentListener)new LocalAppEnvListener());
        this.menuScreen = ComponentFactory.getInstance().createMenu();
        this.startPaymentListener = new StartPaymentListener();
        this.warningMenuListener = new WarningMenuListener(context, this.startPaymentListener);
        this.printerMenuListener = new PrinterMenuListener(context, this.warningMenuListener);
        this.delayMenuListener = new DelayMenuListener(context, this.printerMenuListener);
        this.cashDispMenuListener = new CashDispMenuListener(context, this.delayMenuListener);
        this.accMenuListener = new CashAccMenuListener(context, this.cashDispMenuListener);
        this.menuScreen.setListener((MenuListener)this.accMenuListener);
        this.emptyUserActionsListener = new EmptyUserActionsListener(context.getServerConnector());
    }

    @Override
    public void restore() {
        ModuleHelper.releaseDevices();
        ExtKeyboard.getInstance().disable();
        this.menuScreen.restore();
        this.context.showScreen((ContentScreen)this.menuScreen);
        this.context.setModule(this);
    }

    @Override
    public void start(final ServiceType st, final MenuItem mi, final Intent intent) {
        ModuleHelper.releaseDevices();
        ExtKeyboard.getInstance().disable();
        this.defaultLocale = ModuleHelper.getDefaultLocale();
        MediaPlayer.getInstance().setLocale(this.defaultLocale);
        MediaPlayer.getInstance().play("hello.mp3");
        if (EventQueue.isDispatchThread()) {
            this.showMenu(st, mi, intent);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuEntryModule.this.showMenu(st, mi, intent);
                }
            });
        }
    }

    private void showMenu(ServiceType st, MenuItem mi, Intent intent) {
        try {
            ReferenceManager refm = ReferenceManager.getInstance();
            Keeper ck = Session.getInstance().getCurrentKeeper();
            Sum change = ck == null ? null : ck.getSum();
            MenuParams mp = new MenuParams();
            mp.setMenu(refm.getMenu());
            mp.setStates(refm.getMenuItemStates());
            mp.setDealer(refm.getDealer());
            mp.setPoint(refm.getPoint());
            mp.setPointOptions(refm.getPointOptions());
            mp.setLocale(this.defaultLocale);
            mp.setChange(change);
            mp.setChangeTimeout(ChangeCancelManager.getTimeout());
            mp.setStartGroup(st);
            mp.setIntentType(intent != null ? Integer.valueOf(intent.getType()) : null);
            this.menuScreen.setMenu(mp);
            this.menuScreen.toRootLayer();
            this.context.showScreen((ContentScreen)this.menuScreen);
        }
        catch (Exception ex) {
            log.error((Object)"Can't get menu", (Throwable)ex);
            ModuleHelper.showModuleErrorDialog(this.context, 30, B.get((String)"Module.entry.create.menu"), null);
            log.error((Object)ex, (Throwable)ex);
        }
        this.context.setModule(this);
        if (mi != null) {
            this.startPaymentListener.onUserAction(mi, null);
        } else {
            this.toPostEntryStart();
        }
    }

    private void toPostEntryStart() {
        try {
            MenuItemState[] states = ReferenceManager.getInstance().getMenuItemStates();
            if (states != null) {
                for (MenuItemState mis : states) {
                    if (!ButtonStatus.DefaultService.equals((Object)mis.getButtonStatus())) continue;
                    Keeper keeper = Session.getInstance().getCurrentKeeper();
                    if (keeper != null && keeper.getSum() != null && !keeper.getSum().isEmpty()) {
                        log.info((Object)"Can't open default service: Keeper is not empty");
                        continue;
                    }
                    MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(mis.getServiceId(), false);
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    if (visitor.getMenuItem() == null) continue;
                    log.info((Object)("Open default service: " + visitor.getMenuItem().getService().getName()));
                    this.startPaymentListener.onUserAction(visitor.getMenuItem(), null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EmptyUserActionsListener getEmptyUserActionsListener() {
        return this.emptyUserActionsListener;
    }

    private class LocalAppEnvListener
    extends AppEnvironmentAdapter {
        private LocalAppEnvListener() {
        }

        public void open(ProviderType type, Map<String, Object> data) {
            log.info((Object)("Open provider: " + type));
            PaymentHelper.run(type, MenuEntryModule.this.context, MenuEntryModule.this.defaultLocale, (Restorable)MenuEntryModule.this, MenuEntryModule.this.paymentModule, MenuEntryModule.this.payoutModule, MenuEntryModule.this.processingModule, MenuEntryModule.this.printModule, MenuEntryModule.this.endingModule, MenuEntryModule.this.reinitModule, MenuEntryModule.this.presentModule, MenuEntryModule.this.completiveModule, (StateFacade.getState().getWarningMask() & 1) > 0, data, null);
        }

        public void open(ProviderType type) {
            this.open(type, null);
        }

        public void open(MenuItem menuItem) {
            log.info((Object)("Open menuItem: " + menuItem));
            MenuEntryModule.this.delayMenuListener.onUserAction(menuItem, null);
        }

        public void open(MenuItem menuItem, Map<String, Object> data) {
            log.info((Object)("Open menuItem: " + menuItem + " " + data));
            MenuEntryModule.this.delayMenuListener.onUserAction(menuItem, data);
        }

        public void open(Integer label) {
            if (label != null) {
                Sum change;
                Keeper ck = Session.getInstance().getCurrentKeeper();
                Sum sum = change = ck == null ? null : ck.getSum();
                if (change == null || change.isEmpty()) {
                    GroupByLabelVisitor visitor = new GroupByLabelVisitor(label.intValue());
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    if (visitor.getServiceType() != null) {
                        try {
                            MenuEntryModule.this.menuScreen.toServiceType(visitor.getServiceType());
                            MenuEntryModule.this.context.showScreen((ContentScreen)MenuEntryModule.this.menuScreen);
                        }
                        catch (Exception ex) {
                            ModuleHelper.showModuleErrorDialog(MenuEntryModule.this.context, 30, B.get((String)"Module.entry.create.menu"), null);
                            log.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
        }

        public void open(ServiceType serviceType) {
            try {
                MenuEntryModule.this.menuScreen.toServiceType(serviceType);
                MenuEntryModule.this.context.showScreen((ContentScreen)MenuEntryModule.this.menuScreen);
            }
            catch (Exception ex) {
                ModuleHelper.showModuleErrorDialog(MenuEntryModule.this.context, 30, B.get((String)"Module.entry.create.menu"), null);
                log.error((Object)ex, (Throwable)ex);
            }
        }

        public void setLocale(Locale locale) {
            log.info((Object)("Set locale: " + locale));
        }

        public void onUserAction(String action) {
            MenuEntryModule.this.delayMenuListener.onUserAction(action);
        }
    }

    private class StartPaymentListener
    implements MenuListener {
        private StartPaymentListener() {
        }

        public void onUserAction(MenuItem menuItem, Map<String, Object> data) {
            PaymentHelper.run(menuItem, MenuEntryModule.this.context, MenuEntryModule.this.defaultLocale, (Restorable)MenuEntryModule.this, MenuEntryModule.this.paymentModule, MenuEntryModule.this.payoutModule, MenuEntryModule.this.processingModule, MenuEntryModule.this.printModule, MenuEntryModule.this.endingModule, MenuEntryModule.this.reinitModule, MenuEntryModule.this.presentModule, MenuEntryModule.this.completiveModule, (StateFacade.getState().getWarningMask() & 1) > 0, data, null);
        }

        public void onLangSelection(String lang) {
            log.info((Object)("Set lang: " + lang));
            String[] split = lang.split("_");
            MenuEntryModule.this.defaultLocale = new Locale(split[0], split.length > 1 ? split[1] : MenuEntryModule.this.defaultLocale.getCountry());
            MediaPlayer.getInstance().setLocale(MenuEntryModule.this.defaultLocale);
        }

        public void onRedirect(int serviceId) {
        }

        public void onProvider(ProviderType type) {
            log.info((Object)("Open provider: " + type));
            PaymentHelper.run(type, MenuEntryModule.this.context, MenuEntryModule.this.defaultLocale, (Restorable)MenuEntryModule.this, MenuEntryModule.this.paymentModule, MenuEntryModule.this.payoutModule, MenuEntryModule.this.processingModule, MenuEntryModule.this.printModule, MenuEntryModule.this.endingModule, MenuEntryModule.this.reinitModule, MenuEntryModule.this.presentModule, MenuEntryModule.this.completiveModule, (StateFacade.getState().getWarningMask() & 1) > 0, null, null);
        }

        public void onUserAction(String action) {
            if ("complaint".equals(action)) {
                Integer id = AppDefaults.getInstance().getIntegerValue("Service.complaint.id");
                if (id == null) {
                    log.error((Object)"ID of complaint service not set");
                } else {
                    MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(id.intValue());
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    if (visitor.getMenuItem() != null) {
                        this.onUserAction(visitor.getMenuItem(), null);
                    } else {
                        log.error((Object)("Can't find service with CODE = " + id));
                    }
                }
            } else if ("menu-screen-exit".equals(action)) {
                MenuEntryModule.this.emptyUserActionsListener.incScreenOpen();
            }
        }
    }
}

