/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.card;

import org.apache.log4j.Logger;
import ru.softlogic.cards.v2.connector.model.TerminalAddressInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleManager;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cards.v2.module.UserInterfaceEventListener;
import ru.softlogic.cards.v2.processor.PanFilter;
import ru.softlogic.cards.v2.processor.PanFilterSimple;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.card.OutCancelListener;
import ru.softlogic.module.card.proxy.BankDepositListenerProxy;
import ru.softlogic.module.card.proxy.CardModuleEventsProxy;
import ru.softlogic.module.card.proxy.DepositListenerProxy;
import ru.softlogic.reference.point.BINList;
import ru.softlogic.reference.point.Point;
import ru.softlogic.system.util.Translit;

public class CardModuleStore {
    private static final CardModuleStore instance = new CardModuleStore();
    private CardModuleManager manager;
    private CardModule cm;
    private boolean cardReaderOnly;
    private final CardModuleEventsProxy eventsProxy = new CardModuleEventsProxy();
    protected DepositListenerProxy depositProxy = new DepositListenerProxy();
    protected BankDepositListenerProxy bankDepositProxy = new BankDepositListenerProxy();
    private CashRequireListener cashRequireListener;
    private CashRequireListener bankCashRequireListener;
    private OutCancelListener outCancelListener;
    private String lastTerminalId;
    private boolean openFromInputModule;
    private static final Logger log = Logger.getLogger((String)"pay");

    public static CardModuleStore getInstance() {
        return instance;
    }

    public boolean isCardReaderOnly() {
        return this.cardReaderOnly;
    }

    public void setCardReaderOnly(boolean cardReaderOnly) {
        this.cardReaderOnly = cardReaderOnly;
    }

    public CardModuleEventsProxy getEventsProxy() {
        return this.eventsProxy;
    }

    public DepositListenerProxy getDepositProxy() {
        return this.depositProxy;
    }

    public BankDepositListenerProxy getBankDepositProxy() {
        return this.bankDepositProxy;
    }

    public void setManager(CardModuleManager manager) {
        this.manager = manager;
    }

    public boolean isInit() {
        return this.manager != null;
    }

    public CardModule openSession(UserInterfaceEventListener usel) {
        if (this.manager == null) {
            return null;
        }
        this.eventsProxy.setListener(usel);
        this.cm = this.manager.openSession((UserInterfaceEventListener)this.eventsProxy);
        this.openFromInputModule = false;
        return this.cm;
    }

    public CardModule openSessionFromInputModule(UserInterfaceEventListener usel) {
        CardModule session = this.openSession(usel);
        if (session != null) {
            this.openFromInputModule = true;
        }
        return session;
    }

    public boolean isOpenFromInputModule() {
        return this.openFromInputModule;
    }

    public boolean isReady() {
        return this.manager != null && this.manager.getCardModuleManagerState() == CardModuleManager.CardModuleManagerState.Ready;
    }

    public boolean isNeedReverse() {
        return this.manager != null && this.manager.getCardModuleManagerState() == CardModuleManager.CardModuleManagerState.NeedReverse;
    }

    public void updatePanFilter(BINList binList) {
        log.info((Object)("Update PAN-filter: " + binList));
        PanFilterSimple panFilter = new PanFilterSimple(binList.getValid(), binList.getInvalid(), binList.getCapture(), binList.getIin());
        this.manager.setPanFilter((PanFilter)panFilter);
    }

    public boolean reverse() {
        if (this.manager != null) {
            log.debug((Object)"Run revert last");
            return this.manager.reverseLast();
        }
        log.debug((Object)"Need revert last, but manager is null");
        return true;
    }

    public CardModule getCurrentSession() {
        return this.cm;
    }

    public void closeSession(boolean cl) {
        this.cm.closeSession(cl);
        this.cm = null;
    }

    public void closeSessionSafe(boolean cl) {
        try {
            this.closeSession(cl);
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
    }

    public void setReference(Point p) {
        if (p != null && this.manager != null) {
            String pointName = p.getName() == null ? "" : Translit.translit((String)p.getName()).toUpperCase();
            String region = p.getArea() == null ? "" : Translit.translit((String)p.getArea()).toUpperCase();
            String city = p.getCity() == null ? "" : Translit.translit((String)p.getCity()).toUpperCase();
            String address = p.getAddress() == null ? "" : Translit.translit((String)p.getAddress());
            this.manager.setTerminalAddressInfo(new TerminalAddressInfo(p.getIndex(), region, city, address, pointName));
            String cmPoint = (String)p.getAttributes().get("card-module-point");
            if (cmPoint != null && cmPoint.equals(this.lastTerminalId)) {
                this.lastTerminalId = cmPoint;
                this.manager.setTerminalId(this.lastTerminalId);
            }
        }
    }

    public CashRequireListener getCashRequireListener() {
        return this.cashRequireListener;
    }

    public void setCashRequireListener(CashRequireListener cashRequireListener) {
        this.cashRequireListener = cashRequireListener;
    }

    public CashRequireListener getBankCashRequireListener() {
        return this.bankCashRequireListener;
    }

    public void setBankCashRequireListener(CashRequireListener bankCashRequireListener) {
        this.bankCashRequireListener = bankCashRequireListener;
    }

    public void setUserEventInterfaceListener(UserInterfaceEventListener usel) {
        this.eventsProxy.setListener(usel);
    }

    public void setOutCancelListener(OutCancelListener outCancelListener) {
        this.outCancelListener = outCancelListener;
    }

    public void clearCashRequireListener() {
        if (this.cashRequireListener != null) {
            this.cashRequireListener.onCancel();
        }
        this.cashRequireListener = null;
    }

    public void clearBankCashRequireListener() {
        if (this.bankCashRequireListener != null) {
            this.bankCashRequireListener.onCancel();
        }
        this.bankCashRequireListener = null;
    }

    public void invokeOutCancelListener(Intent intent) {
        if (this.outCancelListener != null) {
            this.outCancelListener.cancel(intent);
        }
        this.outCancelListener = null;
    }
}

