/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.card;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.application.CardEmergencyEventListener;
import ru.softlogic.application.DeviceInfoHandlingSender;
import ru.softlogic.cards.v2.model.CardModuleOptions;
import ru.softlogic.cards.v2.model.PanFilterOptions;
import ru.softlogic.cards.v2.module.CardApplication;
import ru.softlogic.cards.v2.module.CardModuleManager;
import ru.softlogic.cards.v2.module.EmergencyEventListener;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.BINList;

public class CardModuleConfigurator {
    protected File workDir;
    protected Logger log;
    protected List<Thread> threads;
    protected CardModuleManager manager;
    protected boolean cardReaderOnly;

    public CardModuleConfigurator(File workDir, Logger log) {
        this.workDir = workDir;
        this.log = log;
    }

    public CardModuleManager getManager() {
        return this.manager;
    }

    public boolean isCardReaderOnly() {
        return this.cardReaderOnly;
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public void start(DeviceInfoHandlingSender readerInfoListener, DeviceInfoHandlingSender eppInfoListener, CardEmergencyEventListener emergencyEventListener) throws Exception {
        this.threads = new LinkedList<Thread>();
        this.log.info((Object)"**************************************************************************");
        if (!this.workDir.isDirectory()) {
            this.log.error((Object)"Work directory is not found");
            throw new Exception("Work directory is not found");
        }
        File configFile = new File(this.workDir, "/conf.xml");
        this.log.info((Object)("Read configuration: " + configFile.getAbsolutePath()));
        PanFilterOptions panFilter = null;
        BINList binList = ReferenceManager.getInstance().getBinList();
        if (binList != null) {
            panFilter = new PanFilterOptions(binList.getIin(), binList.getValid(), binList.getInvalid(), binList.getCapture());
        }
        CardApplication app = new CardApplication(this.workDir.getAbsolutePath(), (EmergencyEventListener)emergencyEventListener, new CardModuleOptions(panFilter));
        this.log.info((Object)"Complete");
        this.log.info((Object)"");
        if (app.getCardReader() != null) {
            app.getCardReader().addDeviceInfoListener((DeviceInfoListener)readerInfoListener);
            app.getCardReader().addDeviceProblemListener((DeviceProblemListener)readerInfoListener);
            app.getCardReader().addStateListener((DeviceStateListener)readerInfoListener);
        }
        if (app.getEpp() != null) {
            app.getEpp().addDeviceInfoListener((DeviceInfoListener)eppInfoListener);
            app.getEpp().addDeviceProblemListener((DeviceProblemListener)eppInfoListener);
            app.getEpp().addStateListener((DeviceStateListener)eppInfoListener);
        }
        this.manager = app.getManager();
        this.cardReaderOnly = app.isCardReaderOnly();
        if (this.manager == null) {
            throw new NullPointerException("CardManager");
        }
        this.threads.addAll(app.getThreads());
    }
}

