/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.card;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.parser.adv.Parser;
import ru.softlogic.system.util.PathUtils;

public class CardFormHelper {
    private static Map<String, SoftReference<Scenario>> forms = new HashMap<String, SoftReference<Scenario>>();
    private static Logger log = Logger.getLogger((String)"pay");

    public static Scenario getScenario(Locale locale) throws Exception {
        Scenario form;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((form = CardFormHelper.getScenario("card", locale, "_" + locale.getLanguage())) != null) {
            return form;
        }
        form = CardFormHelper.getScenario("card", locale, "");
        if (form != null) {
            return form;
        }
        throw new Exception("Can't parce form");
    }

    private static Scenario getScenario(String path, Locale locale, String suffix) {
        String id = "" + path + suffix;
        log.info((Object)("Search: " + id));
        if (forms.containsKey(id)) {
            SoftReference<Scenario> srf = forms.get(id);
            if (srf != null) {
                Scenario f = srf.get();
                if (f == null) {
                    log.info((Object)("SoftReference go out: " + path + suffix));
                    f = CardFormHelper.readScenarioRes(path, suffix);
                    forms.put(id, new SoftReference<Scenario>(f));
                }
                return f;
            }
        } else {
            Scenario f = CardFormHelper.readScenarioRes(path, suffix);
            if (f != null) {
                forms.put(id, new SoftReference<Scenario>(f));
                return f;
            }
            forms.put(id, null);
        }
        return null;
    }

    private static Scenario readScenarioRes(String path, String postfix) {
        try {
            return Parser.parse((File)new File(PathUtils.getAppHome() + "/resources/utility/scenario/" + path + postfix + ".xml"));
        }
        catch (Exception ex) {
            log.error((Object)("Error on parsing: " + ex.getMessage()));
            return null;
        }
    }
}

