/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.input.Environment;
import ru.softlogic.service.comission.SumResult;

public class PackUtility {
    private static Logger log = Logger.getLogger((String)"pay");

    public static Sum getOperationSum(Pack pack) {
        Sum res = new Sum();
        for (Payment payment : pack.getPayments()) {
            if (payment.getOperationSum() == null) continue;
            res = res.add(payment.getOperationSum());
        }
        return res.isEmpty() ? null : res;
    }

    public static String getPaybackType(Pack pack) {
        try {
            return ResourceBundle.getBundle("ru.softlogic.module.messages").getString("payback." + pack.getPaybackType());
        }
        catch (Exception ex) {
            return "type " + pack.getPaybackType();
        }
    }

    public static String getPaymentType(Pack pack) {
        try {
            return ResourceBundle.getBundle("ru.softlogic.module.messages").getString("payment." + pack.getPaymentType());
        }
        catch (Exception ex) {
            return "type " + pack.getPaymentType();
        }
    }

    public static String getPaymentTool(int pt) {
        if (pt == 0) {
            return "CASH";
        }
        if (pt == 1) {
            return "CBC";
        }
        if (pt == 2) {
            return "BANKCARD";
        }
        if (pt == 3) {
            return "BANKCARD_OTHER";
        }
        if (pt == 4) {
            return "KEEPER";
        }
        return "-";
    }

    public static void printPack(String title, Pack pack) {
        log.info((Object)">--------------------------------------------------------------------------");
        log.info((Object)("----- " + title));
        log.info((Object)("Pack date: " + pack.getDate() + (pack.isTimeout() ? ", by timeout" : "")));
        log.info((Object)("Payment type: " + PackUtility.getPaymentType(pack)));
        log.info((Object)("Payback type: " + PackUtility.getPaybackType(pack)));
        log.info((Object)("Payment tool: " + PackUtility.getPaymentTool(pack.getPaymentTool())));
        log.info((Object)("Service     : " + (pack.getService() == null ? "-" : pack.getService().getName() + ", " + pack.getService().getId())));
        log.info((Object)("Commission  : " + (pack.getCommission() == null ? "-" : pack.getCommission())));
        log.info((Object)("Provider fee: " + (pack.getProviderFee() == null ? "-" : pack.getProviderFee())));
        log.info((Object)("Sum result  : " + pack.getSumResult()));
        for (Payment p : pack.getPayments()) {
            PackUtility.printPayment(p);
        }
        if (pack.getKeeper() != null) {
            log.info((Object)("Payment keeper   : " + pack.getKeeper().getSum() + ", " + pack.getKeeper()));
        } else {
            log.info((Object)"Payment keeper   : -");
        }
        if (pack.getChange() != null) {
            log.info((Object)("Change keeper   : " + pack.getChange().getSum() + ", " + pack.getChange()));
        } else {
            log.info((Object)"Change keeper   : -");
        }
        log.info((Object)("Change   : " + (pack.getSumResult() == null ? "null" : pack.getSumResult().getChange())));
        log.info((Object)("Cash back card: " + pack.getCbc()));
        if (pack.getPaymentTool() == 2) {
            log.info((Object)("Cashless data: " + pack.getCashlessData()));
        }
        log.info((Object)"<----------------------------");
    }

    public static void printPayment(Payment payment) {
        if (payment == null) {
            return;
        }
        log.info((Object)("Payment: id=" + payment.getId() + ", doc=" + payment.getDoc() + ", date=" + payment.getDate()));
        log.info((Object)("    Operation sum  : " + (payment.getOperationSum() == null ? "-" : payment.getOperationSum())));
        log.info((Object)("    Amount         : " + payment.getSumOut()));
        log.info((Object)"    Data:");
        if (payment.getData() != null) {
            for (Object o : payment.getData().values()) {
                if (o instanceof InputElement) {
                    InputElement ie = (InputElement)o;
                    if (ie.hasFlag(2048)) {
                        log.info((Object)("        " + ie.getKey() + ":" + ie.getKeyTitle() + " = " + ie.getMaskedValue()));
                        continue;
                    }
                    log.info((Object)("        " + ie.getKey() + ":" + ie.getKeyTitle() + " = " + ie.getValue() + ":" + ie.getValueTitle()));
                    continue;
                }
                log.info((Object)("        " + o));
            }
        }
        log.info((Object)"*");
    }

    public static void distributeSum(Pack pack, SumResult resultSum) {
        Sum sum = resultSum.getOut();
        if ("uniform".equals(pack.getSumDistributionType())) {
            Sum lSum = new Sum(sum.getBasicSum() / pack.getPayments().size());
            for (Payment p : pack.getPayments()) {
                p.setSumOut(lSum);
                sum = sum.sub(lSum);
            }
            if (!sum.isEmpty()) {
                ((Payment)pack.getPayments().get(0)).setSumOut(((Payment)pack.getPayments().get(0)).getSumOut().add(sum));
            }
        } else {
            for (Payment p : pack.getPayments()) {
                if (p.getOperationSum() == null || p.getOperationSum().isEmpty()) continue;
                if (sum.isEmpty()) break;
                if (sum.compareTo(p.getOperationSum()) > 0) {
                    p.setSumOut(p.getOperationSum());
                    sum = sum.sub(p.getSumOut());
                    continue;
                }
                p.setSumOut(sum);
                sum = new Sum();
            }
            if (resultSum.getChange() == null) {
                resultSum.setChange(new Sum());
            }
            if (!sum.isEmpty()) {
                if ("default".equals(pack.getSumDistributionType())) {
                    resultSum.setChange(resultSum.getChange().add(sum));
                } else {
                    ((Payment)pack.getPayments().get(0)).setSumOut(((Payment)pack.getPayments().get(0)).getSumOut().add(sum));
                }
            }
            LinkedList<Payment> newPayments = new LinkedList<Payment>();
            for (Payment p : pack.getPayments()) {
                if (p.getSumOut() == null || p.getSumOut().isEmpty()) continue;
                newPayments.add(p);
            }
            pack.setPayments(newPayments);
        }
    }

    public static void cancelPackage(Pack pack) {
        for (Payment p : pack.getPayments()) {
            p.setSumOut(new Sum());
        }
    }

    public static String getMainNumber(Pack pack) {
        Payment p = (Payment)pack.getPayments().get(0);
        if (p.getData() != null) {
            for (Object o : p.getData().values()) {
                InputElement ie;
                if (!(o instanceof InputElement) || !"id1".equals((ie = (InputElement)o).getKey())) continue;
                return ie.getValue();
            }
        }
        return "---";
    }

    public static Map<String, Object> getData(Pack pack) {
        if (pack == null || pack.getPayments() == null || pack.getPayments().isEmpty() || ((Payment)pack.getPayments().get(0)).getData() == null) {
            return new HashMap<String, Object>();
        }
        return ((Payment)pack.getPayments().get(0)).getData();
    }

    public static List<Sum> getPackSums(Pack pack) {
        if (pack == null || pack.getPayments() == null || pack.getPayments().size() < 2) {
            return null;
        }
        LinkedList<Sum> sums = new LinkedList<Sum>();
        for (Payment p : pack.getPayments()) {
            if (p.getOperationSum() == null || p.getOperationSum().isEmpty()) continue;
            sums.add(p.getOperationSum());
        }
        if (sums.isEmpty()) {
            return null;
        }
        return sums;
    }

    public static List<Sum> getPackDivSums(Pack pack) {
        int op;
        if (pack == null || pack.getPayments() == null) {
            return null;
        }
        LinkedList<Sum> sums = new LinkedList<Sum>();
        Sum divideSum = pack.getService().getDivideSum();
        Sum opr = pack.getOperationSum();
        int div = divideSum.getBasicSum();
        for (op = opr.getBasicSum(); op > div; op -= div) {
            sums.add(new Sum(div));
        }
        sums.add(new Sum(op));
        if (sums.isEmpty()) {
            return null;
        }
        return sums;
    }

    public static Map<String, String> getCardOperationParams(Environment env) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service-id", "" + Session.getInstance().getPack().getService().getId());
        return params;
    }
}

