/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleMessage;
import ru.softlogic.module.ModuleTypeListener;

public class ModuleStore {
    private Module module;
    private final Set<ModuleTypeListener> listeners = new HashSet<ModuleTypeListener>();
    private final Logger log = Logger.getLogger((String)"gui");

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.log.info((Object)("Open module: " + ModuleMessage.getModuleType(module.getType())));
        this.module = module;
        for (ModuleTypeListener listener : this.listeners) {
            this.log.info((Object)("Notify: " + listener.getClass().getSimpleName()));
            listener.onChange(module.getType());
        }
    }

    public void addListener(ModuleTypeListener listener) {
        if (listener != null) {
            this.log.info((Object)("ModuleStor@addListener: " + listener.getClass().getSimpleName()));
            this.listeners.add(listener);
        }
    }
}

