/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module;

import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.module.StaticTimeoutManager;
import ru.softlogic.module.TimeoutManager;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;

public class DynamicTimeoutManager
extends TimeoutManager {
    private final StaticTimeoutManager stm = new StaticTimeoutManager();

    @Override
    public int getTimeout(int moduleType) {
        PointOptions po = null;
        try {
            po = ReferenceManager.getInstance().getPointOptions();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        if (po != null) {
            boolean useServerTimeout;
            if (moduleType == 1) {
                if (po.getGuiMenuTimeout() > 20 && po.getGuiMenuTimeout() < 180) {
                    return po.getGuiMenuTimeout();
                }
            } else if (moduleType == 3 && (useServerTimeout = AppDefaults.getInstance().getBooleanProperty("Module.payment.useServerTimeout", false)) && po.getGuiProcessTimeout() >= 30 && po.getGuiProcessTimeout() <= 1300) {
                return po.getGuiProcessTimeout();
            }
        }
        return this.stm.getTimeout(moduleType);
    }
}

