/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash.acceptor.cbc;

import java.io.File;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.api.cbc.CashBackCardInterface;
import ru.softlogic.srv.connector.ConnectorException;

public class HtmlCbcModule
extends ManagedCashAcceptor {
    private CashBackCardInterface server;
    private boolean enable;

    public HtmlCbcModule(CashBackCardInterface server) {
        if (server == null) {
            throw new IllegalArgumentException("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
        }
        this.server = server;
    }

    public final synchronized void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        this.enable = true;
    }

    public final synchronized void disable() {
        this.enable = false;
    }

    public final synchronized ActivationResult activate(String pin, Sum sum) {
        ActivationResult result = null;
        if (this.enable && this.cashStorage != null) {
            try {
                Sum allowed = this.cashStorage.getAllowedSum();
                Logger.getLogger((String)"pay").info((Object)("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u0433\u0430\u0448\u0435\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438: " + pin + ", \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + allowed));
                result = this.server.acivateCashBackCard(pin, sum, allowed, SequenceManager.getValueQuietly((String)"cbcard"));
            }
            catch (ConnectorException ex) {
                result = new ActivationResult(ActivationResultType.ErrNetwork, 0, null);
            }
        } else {
            result = new ActivationResult(ActivationResultType.ErrPermit, 0, null);
        }
        Logger.getLogger((String)"pay").info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0433\u0430\u0448\u0435\u043d\u0438\u044f: " + result));
        if (result != null && result.getError() == ActivationResultType.Ok && this.cashStorage != null) {
            CashBackCard cbc = CashFactory.getDefaultInstance().getCashBackCard();
            cbc.setNominal(result.getRest());
            cbc.setRef(result.getIdOperation());
            this.cashStorage.addCbc(cbc);
        }
        return result;
    }

    public String toString() {
        return "cashbackcard module";
    }

    public void setMaxSum(Sum sum) {
    }

    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
    }
}

