/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.oth.FileInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.system.util.HashUtils;
import ru.softlogic.system.util.PathUtils;

class WindowsSystem {
    WindowsSystem() {
    }

    public static SystemInfo getPcInfo() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        SystemInfo info = new SystemInfo();
        info.setOsName(bean.getName());
        info.setOsVersion(bean.getVersion());
        File file = new File(PathUtils.getAppHome());
        info.setHddSize((int)(file.getTotalSpace() / 1024L / 1024L / 1024L));
        File cnf = PathUtils.getFilePath((String)"configuration.xml");
        info.setCnfCrc(HashUtils.calculateCRC32Checksum((File)cnf));
        info.setCnfModificationDate(new Date(cnf.lastModified()));
        try {
            LinkedList<FileInfo> files = new LinkedList<FileInfo>();
            for (File f : PathUtils.getFiles()) {
                files.add(new FileInfo(f.getAbsolutePath().replace(PathUtils.getAppHome() + File.separator, ""), f.length(), f.lastModified(), HashUtils.calculateCRC32Checksum((File)f)));
            }
            info.setFiles(files.toArray(new FileInfo[files.size()]));
        }
        catch (Exception e) {
            Logger.getLogger((String)"app").error((Object)(e.getMessage() + " AppHome='" + PathUtils.getAppHome() + "' " + PathUtils.getFiles()));
        }
        return info;
    }
}

