/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import java.util.ArrayList;
import java.util.List;
import ru.softlogic.application.collection.MoneyCollectionObserver;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;

public class MoneyCollectionProxy
implements ValidatorStatusListener {
    private ValidatorStatus currentStatus;
    private final MoneyCollectionObserver observer;
    private final List<ValidatorStatus> stats = new ArrayList<ValidatorStatus>();
    private boolean locked;

    public MoneyCollectionProxy(MoneyCollectionObserver observer) {
        this.observer = observer;
    }

    public synchronized void update(ValidatorStatus status) {
        this.currentStatus = status;
        if (this.locked) {
            this.stats.add(status);
        } else {
            this.observer.update(status);
        }
    }

    public synchronized boolean canEncash() {
        return this.currentStatus != ValidatorStatus.StackOut;
    }

    public synchronized void lock() {
        this.locked = true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (!this.stats.isEmpty()) {
            for (ValidatorStatus status : this.stats) {
                this.update(status);
            }
            this.stats.clear();
        }
    }
}

