/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.html.connector.model.Connector;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.io.utils.BU;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.system.util.CheckCollectorPwdHelper;

public class MoneyCollectionObserver4Connector
implements ValidatorStatusListener {
    private MoneyCollectionHandler cashHandler;
    private MoneyCollectionHandler coinHandler;
    private ApplicationContext context;
    private Logger log;
    private boolean busy;
    private Connector connector;

    public MoneyCollectionObserver4Connector(MoneyCollectionHandler cashHandler, MoneyCollectionHandler coinHandler) {
        if (cashHandler == null || coinHandler == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 MoneyCollectionHandler");
        }
        this.cashHandler = cashHandler;
        this.coinHandler = coinHandler;
        this.log = Logger.getLogger((String)"maintenance");
    }

    public void update(ValidatorStatus status) {
        if (status == ValidatorStatus.StackOut) {
            this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u0441\u043d\u044f\u0442\u0438\u0435 \u043a\u0430\u0441\u0441\u0435\u0442\u044b");
            if (!this.busy) {
                this.busy = true;
                UserAction.getInstance().update();
                int strategy = 0;
                try {
                    PointOptions po = ReferenceManager.getInstance().getPointOptions();
                    if (po != null) {
                        strategy = po.getCollectionStrategy2();
                    }
                }
                catch (ReferenceException po) {
                    // empty catch block
                }
                this.log.info((Object)("Strategy: " + BU.toHex((int)strategy)));
                this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0430\u0440\u043e\u043b\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430");
                int Password = 0;
                if (CheckCollectorPwdHelper.checkCollectorPwdSet()) {
                    this.log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430 \u0437\u0430\u0434\u0430\u043d");
                    Password = 1;
                }
                this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                int Cash = 0;
                if ((strategy & 1) > 0) {
                    this.log.info((Object)"\u041e\u043f\u0446\u0438\u044f \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                    if ((strategy & 2) > 0) {
                        this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                        Cash = 2;
                    } else {
                        Cash = 1;
                    }
                }
                this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                int Coin = 0;
                if (CashDeviceManager.getInstance().getDefaultCoinValidator() != null && (strategy & 4) > 0) {
                    this.log.info((Object)"\u041e\u043f\u0446\u0438\u044f \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                    if ((strategy & 8) > 0) {
                        this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                        Coin = 2;
                    } else {
                        Coin = 1;
                    }
                }
                this.log.info((Object)("\u0428\u0430\u0433 \u043f\u0435\u0447\u0430\u0442\u0438 z-\u043e\u0442\u0447\u0435\u0442\u0430. \u0422\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + this.context.getPrinterQueue().getPrinterType()));
                int Report = 0;
                if ((strategy & 0x10) > 0 && this.context.getPrinterQueue().getPrinterType() == PrinterType.Kkm) {
                    this.log.info((Object)"\u041e\u043f\u0446\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438 z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                    if ((strategy & 0x20) > 0) {
                        this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                        Report = 2;
                    } else {
                        Report = 1;
                    }
                }
                this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
                int Menu2 = 0;
                if ((strategy & 0x40) > 0) {
                    this.log.info((Object)"\u041e\u043f\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                    if ((strategy & 0x80) > 0) {
                        this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                        Menu2 = 2;
                    } else {
                        Menu2 = 1;
                    }
                }
                this.connector.onStackOut(Password, Cash, Coin, Report, Menu2);
                this.busy = false;
            } else {
                this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f stack \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f ");
            }
        }
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }
}

