/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.application.collection.MoneyCollectionInitiator;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.sequence.Sequence;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.system.util.CalibrationHelper;

public class MoneyCollectionHandler {
    private final String MONEY_COLLECTION_ID_KEY = "MoneyCollection.sequence.id";
    private CashBox box;
    private Logger log;
    private ApplicationContext context;
    private ServerUser user;
    private boolean busy;
    private CashBox flowDownBox;

    public MoneyCollectionHandler(CashBox box) {
        if (box == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 CashBox");
        }
        this.box = box;
        this.log = Logger.getLogger((String)"maintenance");
    }

    public MoneyCollectionHandler(CashBox box, CashBox flowDownBox) {
        this(box);
        this.flowDownBox = flowDownBox;
    }

    public CashBox getBox() {
        return this.box;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public synchronized void onMoneyCollection() {
        if (!this.busy) {
            this.busy = true;
            this.onMoneyCollection(MoneyCollectionInitiator.CashInHardware, null, null);
        } else {
            this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f");
        }
    }

    public synchronized void onMoneyCollection(MoneyCollectionInitiator initiator, ServerUser user) {
        if (!this.busy) {
            this.busy = true;
            this.onMoneyCollection(initiator, user, null);
        } else {
            this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f");
        }
    }

    public synchronized void onMoneyCollection(ServerUser user) {
        this.onMoneyCollection(user, null);
    }

    public synchronized void onMoneyCollection(final ServerUser user, final CashUnit cu) {
        if (!this.busy) {
            UserAction.getInstance().update();
            this.busy = true;
            int strategy = 0;
            boolean checkColibration = false;
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po != null) {
                    strategy = po.getCollectionStrategy2();
                    checkColibration = po.isCheckTouchScreen();
                }
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
            if (checkColibration) {
                this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438");
                CalibrationHelper.checkCalibrate(this.context, strategy, user, new Runnable(){

                    @Override
                    public void run() {
                        MoneyCollectionHandler.this.onMoneyCollection(MoneyCollectionInitiator.CashInPerson, user, cu);
                    }
                });
            } else {
                this.onMoneyCollection(MoneyCollectionInitiator.CashInPerson, user, cu);
            }
        } else {
            this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f");
        }
    }

    public synchronized void onFlowDownMoneyCollection(ServerUser user) {
        if (this.flowDownBox == null) {
            return;
        }
        if (!this.busy) {
            UserAction.getInstance().update();
            this.busy = true;
            this.user = user;
            this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044e c\u043b\u0438\u0442\u044b\u0445 \u043c\u043e\u043d\u0435\u0442, \u0438\u043d\u0438\u0446\u0438\u0430\u0442\u043e\u0440: " + (Object)((Object)MoneyCollectionInitiator.CashInPerson)));
            this.log.info((Object)("\u0418\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u0443\u0435\u043c " + this.flowDownBox + " " + this.flowDownBox.getKeeper()));
            this.context.getServerConnector().sendEvent(new Event(EventType.MoneyCollection, "" + (Object)((Object)MoneyCollectionInitiator.CashInPerson) + "," + this.flowDownBox.getDeviceClass()));
            Keeper keeper = this.flowDownBox.collect();
            if (keeper != null) {
                int id = 0;
                try {
                    Sequence seq = SequenceManager.getInstance().getSequence("collection-id");
                    id = seq.next();
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: ", (Throwable)ex);
                }
                MoneyCollection mc = new MoneyCollection(id, keeper, this.flowDownBox.getDeviceClass(), keeper.getCreated(), user);
                this.context.getPrinterQueue().print(mc);
                if (this.context.getFraudQueue() != null) {
                    this.context.getFraudQueue().putMoneyCollection(mc);
                } else {
                    this.context.getServerConnector().sendMoneyCollection(mc);
                }
            }
            this.setFree();
            this.log.info((Object)"\u041f\u0440\u043e\u0438\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
        } else {
            this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f");
        }
    }

    private synchronized void onMoneyCollection(MoneyCollectionInitiator initiator, ServerUser user, CashUnit cu) {
        UserAction.getInstance().update();
        this.user = user;
        this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044e, \u0438\u043d\u0438\u0446\u0438\u0430\u0442\u043e\u0440: " + (Object)((Object)initiator)));
        this.collect(initiator, cu);
        this.setFree();
        this.log.info((Object)"\u041f\u0440\u043e\u0438\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
    }

    private void collect(MoneyCollectionInitiator initiator, CashUnit cu) {
        this.log.info((Object)("\u0418\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u0443\u0435\u043c " + this.box));
        this.context.getServerConnector().sendEvent(new Event(EventType.MoneyCollection, "" + (Object)((Object)initiator) + "," + this.box.getDeviceClass()));
        Keeper keeper = this.box.collect(cu);
        if (keeper != null) {
            Sequence seq;
            try {
                if (initiator != MoneyCollectionInitiator.CashInHardware && initiator != MoneyCollectionInitiator.CashInPerson) {
                    ServiceZReportStorage.getInstance().setCurrentMCSum(null, keeper);
                } else {
                    ServiceZReportStorage.getInstance().setCurrentMCSum(keeper, null);
                }
                ServiceZReportStorage.getInstance().clearAllSnapshots();
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage());
                this.log.error((Object)("onMoneyCollection:" + Arrays.toString(ex.getStackTrace())));
            }
            int id = 0;
            String sqName = AppDefaults.getInstance().getProperty("MoneyCollection.sequence.id", null);
            if ("fiscalkz".equals(sqName)) {
                try {
                    seq = SequenceManager.getInstance().getSequence("fiscalkz-operation-id");
                    id = seq.current() + 1;
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: ", (Throwable)ex);
                }
            } else {
                try {
                    seq = SequenceManager.getInstance().getSequence("collection-id");
                    id = seq.next();
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: ", (Throwable)ex);
                }
            }
            MoneyCollection mc = new MoneyCollection(id, keeper, this.box.getDeviceClass(), keeper.getCreated(), this.user);
            this.context.getPrinterQueue().print(mc);
            if (this.context.getFraudQueue() != null) {
                this.context.getFraudQueue().putMoneyCollection(mc);
            } else {
                this.context.getServerConnector().sendMoneyCollection(mc);
            }
        }
    }

    private void setFree() {
        this.busy = false;
    }
}

