/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import ru.softlogic.application.collection.MoneyCollectionInitiator;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.reference.point.ServerUser;

public class CollectionRequest {
    private DeviceClass deviceClass;
    private MoneyCollectionInitiator initiator;
    private ServerUser user;

    public CollectionRequest(DeviceClass deviceClass) {
        this(deviceClass, MoneyCollectionInitiator.CashInHardware, null);
    }

    public CollectionRequest(DeviceClass deviceClass, MoneyCollectionInitiator initiator, ServerUser user) {
        if (deviceClass == null) {
            throw new NullPointerException("DeviceClass must be specify");
        }
        if (initiator == null) {
            throw new NullPointerException("MoneyCollectionInitiator must be specify");
        }
        this.deviceClass = deviceClass;
        this.initiator = initiator;
        this.user = user;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public MoneyCollectionInitiator getInitiator() {
        return this.initiator;
    }

    public ServerUser getUser() {
        return this.user;
    }

    public String toString() {
        return "CollectionRequest{deviceClass=" + this.deviceClass + ", initiator=" + (Object)((Object)this.initiator) + ", user=" + this.user + '}';
    }
}

