/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.cash.Keeper;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.system.util.TimeUtil;

public class ZReportServiceObserver
implements Runnable {
    private Logger log;
    private MoneyCollectionHandler cashCollectionHandler;
    private MoneyCollectionHandler coinCollectionHandler;
    private static final long DAY = 86400000L;

    public ZReportServiceObserver(MoneyCollectionHandler cashCollectionHandler, MoneyCollectionHandler coinCollectionHandler) {
        try {
            if (cashCollectionHandler == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 cashCollectionHandler");
            }
            if (coinCollectionHandler == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 coinCollectionHandler");
            }
            this.cashCollectionHandler = cashCollectionHandler;
            this.coinCollectionHandler = coinCollectionHandler;
            this.log = Logger.getLogger((String)"print");
            this.log.setAdditivity(false);
            this.log.info((Object)"ZReportServiceObserver: success init");
        }
        catch (IllegalArgumentException ex) {
            this.log.error((Object)Arrays.toString(ex.getStackTrace()), (Throwable)ex);
        }
    }

    @Override
    public void run() {
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            while ((rm == null || rm != null && rm.getPoint() == null) && !Thread.currentThread().isInterrupted()) {
                this.log.info((Object)"ZReportServiceObserver: \u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0442\u043e\u0447\u043a\u0438 \u0435\u0449\u0451 \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b, \u0441\u043f\u0438\u043c 10\u0441\u0435\u043a\u0443\u043d\u0434, \u0438 \u043f\u043e\u0434\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0441\u043d\u043e\u0432\u0430");
                rm = ReferenceManager.getInstance();
                Thread.sleep(10000L);
            }
            while (!Thread.currentThread().isInterrupted()) {
                long interval;
                rm = ReferenceManager.getInstance();
                this.log.info((Object)"ZReportServiceObserver: \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0442\u043e\u0447\u043a\u0438, \u0438\u0449\u0435\u043c \u0432\u0440\u0435\u043c\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043d\u044d\u043f\u0448\u043e\u0442\u0430 z-\u043e\u0442\u0447\u0451\u0442\u0430 \u0438\u043b\u0438 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0446\u0438\u043a\u043b\u0430");
                ServiceZReportStorage szrs = ServiceZReportStorage.getInstance();
                if (rm != null && rm.getPoint() != null && rm.getPoint().getAttributes() != null) {
                    String zreportServiceSnapshotTime;
                    String zreportServiceTimeInterval = (String)rm.getPoint().getAttributes().get("zreport-service-interval");
                    if (zreportServiceTimeInterval != null && !zreportServiceTimeInterval.isEmpty() && Long.parseLong(zreportServiceTimeInterval) > 0L) {
                        this.log.info((Object)("ZReportServiceObserver: \u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432\u0437\u044f\u0442\u044b\u0439 \u0438\u0437 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0442\u043e\u0447\u043a\u0438: " + zreportServiceTimeInterval));
                        szrs.setTimeInterval(Long.parseLong(zreportServiceTimeInterval));
                    }
                    if ((zreportServiceSnapshotTime = (String)rm.getPoint().getAttributes().get("zreport-service-time-snap")) != null && !zreportServiceSnapshotTime.isEmpty()) {
                        this.log.info((Object)("ZReportServiceObserver: \u0412\u0440\u0435\u043c\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043d\u0430\u043f\u0448\u043e\u0442\u0430(\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u0434\u043d\u044f) \u0432\u0437\u044f\u0442\u044b\u0439 \u0438\u0437 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0442\u043e\u0447\u043a\u0438: " + zreportServiceSnapshotTime));
                        szrs.setTimeSnapshot(Integer.parseInt(zreportServiceSnapshotTime));
                    }
                    szrs.flushZReport();
                }
                if (szrs.getTimeInterval() > 0L) {
                    interval = szrs.getTimeInterval();
                } else {
                    Calendar c = Calendar.getInstance();
                    c.setTime(new Date());
                    long now = c.getTimeInMillis();
                    if (szrs.getTimeSnapshot() > 0 && szrs.getTimeSnapshot() < 24) {
                        c.set(11, szrs.getTimeSnapshot());
                    } else {
                        this.log.info((Object)"ZReportServiceObserver: \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043d\u044d\u043f\u0448\u043e\u0442\u0430 z-\u043e\u0442\u0447\u0451\u0442\u0430 - \u043f\u043e\u043b\u043d\u043e\u0447\u044c \u0438 \u043e\u0434\u043d\u0430 \u043c\u0438\u043d\u0443\u0442\u0430");
                        c.add(5, 1);
                        c.set(11, 0);
                    }
                    c.set(12, 1);
                    c.set(13, 0);
                    c.set(14, 0);
                    long nInterval = c.getTimeInMillis() - now;
                    if (nInterval < 0L) {
                        if ((nInterval = 86400000L + nInterval) > 0L) {
                            interval = nInterval;
                        } else {
                            this.log.info((Object)"ZReportServiceObserver:\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u0417\u0430\u0441\u044b\u043f\u0430\u0435\u043c \u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0441\u0443\u0442\u043e\u043a");
                            interval = TimeUtil.untilMidnight();
                        }
                    } else {
                        interval = nInterval;
                    }
                }
                this.log.info((Object)("ZReportServiceObserver: \u0417\u0430\u0441\u044b\u043f\u0430\u0435\u043c \u043d\u0430 " + interval));
                Thread.sleep(interval);
                this.saveMoneyCollectionInfo();
            }
        }
        catch (Exception ex) {
            Thread.currentThread().interrupt();
            this.log.error((Object)Arrays.toString(ex.getStackTrace()), (Throwable)ex);
        }
    }

    public void saveMoneyCollectionInfo() {
        try {
            ServiceZReportStorage reportStorage = ServiceZReportStorage.getInstance();
            if (reportStorage != null) {
                if (reportStorage.getCurrentSnapshot().getAllCurrentCount() > 0) {
                    this.log.info((Object)"ZReportServiceObserver: \u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 z-\u043e\u0442\u0447\u0451\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438");
                    Keeper cashKeeper = null;
                    if (this.cashCollectionHandler != null && this.cashCollectionHandler.getBox() != null && this.cashCollectionHandler.getBox().getKeeper() != null) {
                        cashKeeper = this.cashCollectionHandler.getBox().getKeeper();
                    }
                    Keeper coinKeeper = null;
                    if (this.coinCollectionHandler != null && this.coinCollectionHandler.getBox() != null && this.coinCollectionHandler.getBox().getKeeper() != null) {
                        coinKeeper = this.coinCollectionHandler.getBox().getKeeper();
                    }
                    reportStorage.setCurrentMCSum(cashKeeper, coinKeeper);
                    reportStorage.saveCurrentSnapshot();
                } else {
                    this.log.info((Object)"ZReportServiceObserver: \u0421\u043c\u0435\u043d\u0430 \u043d\u0435 \u0431\u044b\u043b\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0435 \u0431\u044b\u043b\u043e \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)Arrays.toString(ex.getStackTrace()), (Throwable)ex);
        }
    }
}

