/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.EventQueue;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;

public class WarningMenuListener
implements MenuListener {
    private ApplicationContext context;
    private MenuListener listener;
    private MenuItem mi;
    private Logger log;
    private Locale locale;
    private Map<String, Object> initData;

    public WarningMenuListener(ApplicationContext context, MenuListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435");
        }
        if (listener == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043b\u0438\u0441\u0442\u0435\u043d\u0435\u0440\u0435");
        }
        this.context = context;
        this.listener = listener;
        this.init(null);
        this.log = Logger.getLogger((String)"pay");
    }

    public void init(Locale locale) {
        this.locale = locale;
    }

    public void onUserAction(MenuItem menuItem, Map<String, Object> data) {
        this.mi = menuItem;
        this.initData = data;
        if (this.mi != null && this.mi.getService() != null && this.mi.getService().getWarning() != null && !this.mi.getService().getWarning().trim().isEmpty()) {
            this.log.info((Object)("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: " + this.mi.getService().getWarning()));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, WarningMenuListener.this.mi.getService().getWarning().trim(), 10, DC.cases((int)12, (Locale)WarningMenuListener.this.locale, (Object[])new Object[0]), "ok".equalsIgnoreCase(SystemProp.getServiceWarningDefaultCase()) ? UserCase.Ok : UserCase.Cancel);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            WarningMenuListener.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                            if (userCase == UserCase.Ok) {
                                WarningMenuListener.this.toNextListener();
                            } else {
                                WarningMenuListener.this.context.toMainMenu();
                            }
                        }
                    });
                    WarningMenuListener.this.context.showDialog((DialogInterface)dialog);
                }
            });
        } else {
            this.toNextListener();
        }
    }

    void toNextListener() {
        this.listener.onUserAction(this.mi, this.initData);
    }

    public void onLangSelection(String lang) {
        this.listener.onLangSelection(lang);
    }

    public void onRedirect(int serviceId) {
        this.listener.onRedirect(serviceId);
    }

    public void onProvider(ProviderType type) {
        this.listener.onProvider(type);
    }

    public void onUserAction(String action) {
        this.listener.onUserAction(action);
    }
}

