/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.app.DeviceSummaryInit;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.CurrentModuleTypeStore;
import ru.softlogic.date.DateStore;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.modem.ModemApi;
import ru.softlogic.hardware.device.modem.ModemException;
import ru.softlogic.hardware.device.modem.Registration;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.hardware.device.modem.resources.ModemHelper;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.modem.Operator;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.ThreadUtil;

public class UssdChecker
implements Runnable {
    private final int FUTURE_TIMEOUT = 172800000;
    private ClientInterface clientInterface;
    private String ussdRequest;
    private SerialPort port;
    private Logger log;
    private ConnectionManager manager;
    private DeviceInfo lastDeviceInfo;
    private DateStore dateStore;
    private boolean checkBalance;
    private long lastUserActive;
    public static final long USER_INACTIVE_TIMEOUT = 300000L;

    public UssdChecker(ClientInterface clientInterface, DateStore dateStore, String ussdRequest, SerialPort port, boolean checkBalance) {
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ModemInterface");
        }
        if (dateStore == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DateStore");
        }
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.clientInterface = clientInterface;
        this.dateStore = dateStore;
        this.ussdRequest = ussdRequest;
        this.port = port;
        this.checkBalance = checkBalance;
        this.lastUserActive = System.currentTimeMillis();
        this.manager = ManagerFactory.getInstance().getManager();
        this.log = Logger.getLogger((String)"modem");
        this.log.setAdditivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        boolean ussdErrorSend = false;
        long requestTimeout = this.getRequestTimeout();
        Date last = this.dateStore.getDate();
        this.log.info((Object)("Last request time: " + last));
        this.log.info((Object)("Check balance each: " + requestTimeout / 1000L / 60L / 60L + " hour(s)"));
        Date now = new Date();
        if (last != null && last.getTime() + requestTimeout > now.getTime() && last.getTime() < now.getTime() + 172800000L) {
            this.log.info((Object)("Next balance check in: " + (last.getTime() + requestTimeout - now.getTime()) / 1000L / 60L + " min"));
            ThreadUtil.sleep((long)(last.getTime() + requestTimeout - now.getTime()));
        }
        while (!Thread.currentThread().isInterrupted()) {
            GenericModemApi modemApi = null;
            try {
                if (!this.canUSSDCheck()) {
                    Thread.sleep(10000L);
                    continue;
                }
                ConnectionManager connectionManager = this.manager;
                synchronized (connectionManager) {
                    for (int i = 0; i < 3; ++i) {
                        this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0431\u0430\u043b\u0430\u043d\u0441 \u043c\u043e\u0434\u0435\u043c\u0430, \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116 " + i));
                        try {
                            this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                            OperationResult or = this.manager.disconnectAll();
                            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: " + or));
                            modemApi = new GenericModemApi(this.port);
                            modemApi.open();
                            new ModemIniter(modemApi).process();
                            this.log.info((Object)"Get modem info");
                            String vendor = modemApi.getVendor();
                            this.log.info((Object)("Vendor=" + vendor));
                            String model = modemApi.getModel();
                            this.log.info((Object)("Model=" + model));
                            String firmare = modemApi.getFirmware();
                            this.log.info((Object)("Firmvare=" + firmare));
                            DeviceInfo current = new DeviceInfo(DeviceType.GenericModem);
                            current.setVendor(vendor);
                            current.setModel(model);
                            current.setFirmware(firmare);
                            current.setPort(this.port.getName());
                            if (this.lastDeviceInfo == null || !this.lastDeviceInfo.equals((Object)current)) {
                                this.log.info((Object)"Send device info to server");
                                this.lastDeviceInfo = current;
                                this.clientInterface.send(current);
                            }
                            modemApi.setRegistrationMode(2);
                            Registration reg = modemApi.getRegistration();
                            this.log.info((Object)("Registration info: " + reg));
                            if (reg.getState() == 1 || reg.getState() == 5) {
                                this.log.info((Object)"\u041c\u043e\u0434\u0435\u043c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                                int operId = modemApi.getOperatorId();
                                this.log.info((Object)("operator-id=" + operId));
                                String operName = modemApi.getOperatorName();
                                this.log.info((Object)("operator-name=" + operName));
                                if (this.ussdRequest == null || this.ussdRequest.isEmpty()) {
                                    this.ussdRequest = ModemHelper.getUssdRequest((int)operId, (String)operName);
                                }
                                int signalLevel = modemApi.getSignalLevel();
                                this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u0438\u0433\u043d\u0430\u043b\u0430: " + signalLevel));
                                Integer balanceSum = null;
                                String phone = null;
                                if (this.checkBalance) {
                                    String pUssd;
                                    if (this.ussdRequest == null) {
                                        this.log.info((Object)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c USSD \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + operId));
                                        if (!ussdErrorSend) {
                                            this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440");
                                            ussdErrorSend = true;
                                            this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "ussd error: " + operId));
                                        }
                                    } else if (this.ussdRequest.isEmpty()) {
                                        this.log.info((Object)("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + operId));
                                    } else {
                                        if (ModemHelper.isUssdModifyNeeded((String)vendor)) {
                                            this.ussdRequest = this.ussdRequest.replaceFirst("\\*", "#");
                                            this.log.info((Object)("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043c\u043e\u0434\u0435\u043c " + vendor + ". \u0417\u0430\u043c\u0435\u043d\u044f\u044e * \u043d\u0430 # \u0432 USSD \u0437\u0430\u043f\u0440\u043e\u0441\u0435."));
                                        }
                                        this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441: " + this.ussdRequest));
                                        balanceSum = this.getBalance((ModemApi)modemApi, this.ussdRequest, vendor);
                                        if (balanceSum == null) {
                                            this.log.info((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441, \u043f\u0440\u043e\u0431\u0443\u044e \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u0430\u0440\u0438\u0430\u043d\u0442: \"" + this.ussdRequest + "\""));
                                            balanceSum = this.getBalance((ModemApi)modemApi, "\"" + this.ussdRequest + "\"", vendor);
                                        }
                                        if (balanceSum == null) {
                                            this.log.info((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441, \u043f\u0440\u043e\u0431\u0443\u044e \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u0430\u0440\u0438\u0430\u043d\u0442: " + this.ussdRequest + ";"));
                                            balanceSum = this.getBalance((ModemApi)modemApi, this.ussdRequest + ";", vendor);
                                        }
                                        if (balanceSum == null) {
                                            this.log.info((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441, \u043f\u0440\u043e\u0431\u0443\u044e \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u0430\u0440\u0438\u0430\u043d\u0442: \"" + this.ussdRequest + ";\""));
                                            balanceSum = this.getBalance((ModemApi)modemApi, "\"" + this.ussdRequest + ";\"", vendor);
                                        }
                                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: " + balanceSum));
                                    }
                                    if ((pUssd = ModemHelper.getUssdPhoneRequest((int)operId, (String)operName)) != null) {
                                        try {
                                            phone = modemApi.executeUssd(pUssd, "^.*(\\+?\\d{0,3}[9]{1}[0-9]{9,11}).*$", "^.*(\\+?\\d{0,3}[9]{1}[0-9]{9,11}).*$", ModemHelper.isPDURequire((String)vendor), 5000);
                                            this.log.info((Object)("Phone number res: " + phone));
                                        }
                                        catch (ModemException ex) {
                                            this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430", (Throwable)ex);
                                        }
                                    }
                                    if (phone != null && !phone.matches("^(\\+?\\d{0,3}[9]{1}[0-9]{9,11})$")) {
                                        phone = null;
                                    }
                                }
                                long imei = 0L;
                                long imsi = 0L;
                                try {
                                    imei = modemApi.getImei();
                                    imsi = modemApi.getImsi();
                                }
                                catch (ModemException ex) {
                                    this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c IMEI \u0438 IMSI", (Throwable)ex);
                                }
                                String iccid = "";
                                try {
                                    iccid = modemApi.getIccid();
                                }
                                catch (ModemException ex) {
                                    this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c ICCID", (Throwable)ex);
                                }
                                ModemState ms = new ModemState(balanceSum, signalLevel, new Operator(operId, operName), reg.getLac(), reg.getCid(), phone);
                                ms.setImei(imei);
                                ms.setImsi(imsi);
                                ms.setIccid(iccid);
                                this.clientInterface.sendModemState(ms);
                                DeviceSummaryInit.setModemState(ms);
                                break;
                            }
                            this.log.error((Object)"\u041c\u043e\u0434\u0435\u043c \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                            break;
                        }
                        catch (Exception ex) {
                            this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \u0441 \u043c\u043e\u0434\u0435\u043c\u043e\u043c", (Throwable)ex);
                        }
                        finally {
                            if (modemApi != null) {
                                modemApi.close();
                            }
                        }
                        Thread.sleep(new Random().nextInt(5000));
                    }
                }
                try {
                    this.dateStore.updtae();
                }
                catch (IOException ex) {
                    this.log.error((Object)"Erron on sava last check time", (Throwable)ex);
                }
                requestTimeout = this.getRequestTimeout();
                this.log.info((Object)("Sleep: " + requestTimeout / 1000L / 60L + " minutes"));
                ThreadUtil.sleep((long)requestTimeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Stop thread");
    }

    private long getRequestTimeout() {
        int balanceTimeout = 4;
        try {
            balanceTimeout = ReferenceManager.getInstance().getPointOptions().getBalanceTimeout();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        if (balanceTimeout < 6) {
            balanceTimeout = 6;
        }
        if (balanceTimeout > 168) {
            balanceTimeout = 168;
        }
        return (long)(balanceTimeout * 60 * 60) * 1000L;
    }

    private Integer getBalance(ModemApi modemApi, String ussd, String vendor) {
        Pattern balancePattern = Pattern.compile("\\-?[0-9]+");
        Integer result = null;
        try {
            this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0431\u0430\u043b\u0430\u043d\u0441, ussd=" + ussd));
            String balance = ussd.toLowerCase().startsWith("atd") ? modemApi.executeAtd(ussd, ModemHelper.isPDURequire((String)vendor)) : modemApi.executeUssd(ussd, ModemHelper.isPDURequire((String)vendor));
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0431\u0430\u043b\u0430\u043d\u0441 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430: " + balance));
            balance = balance.toLowerCase();
            Object[] mins = AppDefaults.getInstance().getMinusPrefixes();
            this.log.info((Object)("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043c\u0438\u043d\u0443\u0441\u043e\u0432\u044b\u0435 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u044b: " + Arrays.toString(mins)));
            if (mins != null && mins.length > 0) {
                for (Object minus : mins) {
                    if (!balance.contains((CharSequence)minus)) continue;
                    this.log.info((Object)("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0437\u0430\u043c\u0435\u043d\u044b: " + (String)minus));
                    balance = balance.replace((CharSequence)minus, "-");
                    break;
                }
            }
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: " + balance));
            Matcher balanceMatcher = balancePattern.matcher(balance);
            if (balanceMatcher.find()) {
                result = Integer.parseInt(balanceMatcher.group());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441", (Throwable)ex);
        }
        return result;
    }

    private boolean isUserActive() {
        return Session.getInstance().getPack() != null && Session.getInstance().getPack().getKeeper() != null && Session.getInstance().getPack().getKeeper().getSum() != null && !Session.getInstance().getPack().getKeeper().getSum().isEmpty() || 1 != CurrentModuleTypeStore.getCurrentModuleType() && 0 != CurrentModuleTypeStore.getCurrentModuleType();
    }

    private boolean canUSSDCheck() {
        long currTime = System.currentTimeMillis();
        if (this.isUserActive()) {
            this.lastUserActive = currTime;
        }
        return currTime - this.lastUserActive > 300000L;
    }
}

