/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.system.util.EventNotifier;

public class UncaughtExceptionListener
implements Thread.UncaughtExceptionHandler {
    private Logger log = Logger.getLogger((String)"start");

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.log.error((Object)("Uncaught exception in thread " + t.getName() + ": "));
        this.log.error((Object)e, e);
        EventNotifier.notifyErrorOnce(t.getName() + "->" + e.toString().replaceAll("\\p{C}", "?"));
        if (e instanceof StackOverflowError) {
            SafeReboot.getInstance().restart(0);
        } else if (e instanceof OutOfMemoryError) {
            SafeReboot.getInstance().restart(0);
        } else if (e instanceof IllegalStateException) {
            SafeReboot.getInstance().restart(0);
        } else if ("ImagePreLoader".equals(t.getName())) {
            // empty if block
        }
    }
}

