/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;

public class SimplePayoutManager
implements PayoutManager {
    private Logger log = Logger.getLogger((String)"pay");

    public boolean canGive(Map<CashUnit, Integer> set, int sumPayout, int sumIncome) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        short count = 0;
        int setSum = 0;
        for (CashUnit cu : set.keySet()) {
            int cnt = set.get(cu);
            count += cnt;
            setSum += cu.getNominal().mul(cnt).getBasicSum();
        }
        this.log.info((Object)("Coin count: " + count + ", set sum=" + setSum + ", payout sum=" + sumPayout + ", input sum=" + sumIncome));
        try {
            short limit = ReferenceManager.getInstance().getPointOptions().getChangeCoinLimit();
            this.log.info((Object)("Coin limit: " + limit));
            if (limit > 0 && limit < count) {
                this.log.info((Object)"Limit failed");
                return false;
            }
            Integer restLimit = ReferenceManager.getInstance().getPointOptions().getChangeRestLimit();
            this.log.info((Object)("Rest limit: " + restLimit));
            if (restLimit != null && sumPayout - setSum > restLimit) {
                this.log.info((Object)"Rest limit failed");
                return false;
            }
            Integer restPercent = ReferenceManager.getInstance().getPointOptions().getChangeRestPercent();
            this.log.info((Object)("Rest percent: " + restPercent));
            if (restPercent != null && restPercent > 0 && (double)sumPayout * 100.0 / (double)sumIncome > (double)restPercent.intValue()) {
                this.log.info((Object)"Rest percent failed");
                return false;
            }
            return true;
        }
        catch (ReferenceException ex) {
            return true;
        }
    }
}

