/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.state.DisplayStateListener;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PowerSchedule;
import ru.softlogic.system.util.TimeUtil;
import ru.softlogic.system.util.display.DisplayManagerApi;

public class Rebooter
implements Runnable {
    private static final long EQ_TIME = 10000L;
    private static final long CHECK_TIMEOUT = 120000L;
    private static final String ACTION_REBOOT = "ACTION_REBOOT";
    private static final String ACTION_POWEROFF = "ACTION_POWEROFF";
    private static final String ACTION_SCREENOFF = "ACTION_SCREENOFF";
    private static final String ACTION_SCREENON = "ACTION_SCREENON";
    private static final String ACTION_RESTART_SOFTWARE = "ACTION_RESTART_SOFTWARE";
    private DisplayStateListener displayStateListener;
    private List<PowerSchedule> lastPowerSchedules;
    private long lastAction;
    private SortedSet<RebooterTask> tasks = new TreeSet<RebooterTask>();
    private Logger log;

    public Rebooter(DisplayStateListener displayStateListener) {
        this.displayStateListener = displayStateListener;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    Rebooter.this.lastAction = System.currentTimeMillis();
                    Rebooter.this.displayStateListener.onDisplayState(true);
                }
            }
        }, 16L);
        this.log = Logger.getLogger((String)"maintenance");
    }

    @Override
    public void run() {
        this.log.info((Object)"Start rebooter");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(120000L);
                this.processTasks();
                this.findTasks();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop rebooter");
    }

    private void processTasks() {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            RebooterTask rt = (RebooterTask)it.next();
            long left = rt.startTime + rt.timeout - System.currentTimeMillis();
            long d = Math.abs(left);
            if (d <= 120000L && !rt.executed) {
                this.log.info((Object)("\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e " + rt));
                if (ACTION_POWEROFF.equals(rt.type)) {
                    SafeReboot.getInstance().poweroff();
                    Thread.currentThread().interrupt();
                } else if (ACTION_REBOOT.equals(rt.type)) {
                    SafeReboot.getInstance().reboot();
                    Thread.currentThread().interrupt();
                } else if (ACTION_SCREENOFF.equals(rt.type)) {
                    this.displayOff();
                } else if (ACTION_SCREENON.equals(rt.type)) {
                    this.displayOn();
                } else if (ACTION_RESTART_SOFTWARE.equals(rt.type)) {
                    SafeReboot.getInstance().restart(0);
                    Thread.currentThread().interrupt();
                }
                rt.executed = true;
                continue;
            }
            if (d <= 120000L || left >= 0L) continue;
            if (rt.endTime == null) {
                this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 " + rt + " \u043f\u0440\u043e\u0448\u043b\u043e - \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438"));
                it.remove();
                continue;
            }
            if (!ACTION_SCREENOFF.equals(rt.type)) continue;
            if (System.currentTimeMillis() > rt.endTime) {
                this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f " + rt + " \u043f\u0440\u043e\u0448\u043b\u043e - \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438"));
                this.displayOn();
                it.remove();
                continue;
            }
            if (Math.abs(System.currentTimeMillis() - this.lastAction) <= rt.timeout || rt.updated >= this.lastAction) continue;
            this.log.info((Object)"\u041e\u0442\u043a\u043b\u044e\u0447\u0430\u044e \u043c\u043e\u043d\u0438\u0442\u043e\u0440");
            this.displayOff();
            rt.updated = System.currentTimeMillis();
            rt.executed = true;
        }
    }

    private void findTasks() {
        this.processReboot();
        this.processRestart();
        this.processSchedule();
    }

    private void processReboot() {
        int day = new GregorianCalendar().get(6);
        int schedule = AppDefaults.getInstance().getIntegerValue("schedule.reboot", 4);
        if (schedule < 0 || schedule > 30) {
            schedule = 4;
        }
        if (schedule != 0 && day % schedule == 0) {
            RebooterTask rt = new RebooterTask(ACTION_REBOOT, System.currentTimeMillis() + TimeUtil.until((int)2), 0L, null);
            if (Math.abs(rt.startTime - System.currentTimeMillis()) < 120000L) {
                return;
            }
            if (!this.tasks.contains(rt)) {
                this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + this.tasks));
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + rt));
                this.tasks.add(rt);
            }
        }
    }

    private void processRestart() {
        int day = new GregorianCalendar().get(6);
        int schedule = AppDefaults.getInstance().getIntegerValue("schedule.restart", 0);
        if (schedule < 0 || schedule > 30) {
            schedule = 0;
        }
        if (schedule != 0 && day % schedule == 0) {
            RebooterTask rt = new RebooterTask(ACTION_RESTART_SOFTWARE, System.currentTimeMillis() + TimeUtil.until((int)2), 0L, null);
            if (Math.abs(rt.startTime - System.currentTimeMillis()) < 120000L) {
                return;
            }
            if (!this.tasks.contains(rt)) {
                this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + this.tasks));
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + rt));
                this.tasks.add(rt);
            }
        }
    }

    private void processSchedule() {
        try {
            Point p = ReferenceManager.getInstance().getPoint();
            if (p != null) {
                List sh = p.getPowerSchedules();
                if (this.lastPowerSchedules != null && this.lastPowerSchedules != sh) {
                    Iterator it = this.tasks.iterator();
                    while (it.hasNext()) {
                        RebooterTask rt = (RebooterTask)it.next();
                        if (!ACTION_SCREENON.equals(rt.type) && !ACTION_SCREENOFF.equals(rt.type) && !ACTION_POWEROFF.equals(rt.type) || rt.executed) continue;
                        it.remove();
                    }
                }
                this.lastPowerSchedules = sh;
                if (sh != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    int day = cal.get(7);
                    if (day == 1) {
                        day = 8;
                    }
                    day -= 2;
                    cal.set(13, 0);
                    for (PowerSchedule ps : sh) {
                        if ((1 << day & ps.getDays()) <= 0) continue;
                        cal.set(11, ps.getHour());
                        cal.set(12, ps.getMinute());
                        long time = cal.getTimeInMillis() - System.currentTimeMillis();
                        if (time < 0L && ps.getHourDisplayOn() == null) continue;
                        String type = ACTION_POWEROFF;
                        if (ps.getType() == 2) {
                            type = ACTION_SCREENOFF;
                        } else if (ps.getType() == 3) {
                            type = ACTION_SCREENON;
                        }
                        RebooterTask rt = new RebooterTask(type, cal.getTimeInMillis(), ps.getDisplayOffTimeout() == null ? 0L : (long)(ps.getDisplayOffTimeout() * 60 * 1000), null);
                        if (ps.getHourDisplayOn() != null) {
                            if (ps.getHour() > ps.getHourDisplayOn()) {
                                ((Calendar)cal).add(6, 1);
                            }
                            cal.set(11, ps.getHourDisplayOn());
                            if (ps.getMinuteDisplayOn() != null) {
                                cal.set(12, ps.getMinuteDisplayOn());
                            }
                            rt.endTime = cal.getTimeInMillis();
                            if (System.currentTimeMillis() > rt.endTime) continue;
                        }
                        if (this.tasks.contains(rt)) continue;
                        this.log.info((Object)("Time " + time));
                        this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + System.currentTimeMillis() + " " + this.tasks));
                        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + rt + " \u0434\u043b\u044f " + ps));
                        this.tasks.add(rt);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    private void displayOff() {
        DisplayManagerApi.getInstance().displayOff();
        this.displayStateListener.onDisplayState(false);
    }

    private void displayOn() {
        DisplayManagerApi.getInstance().displayOn();
        this.displayStateListener.onDisplayState(true);
    }

    private class RebooterTask
    implements Comparable<RebooterTask> {
        private long startTime;
        private long timeout;
        private long updated;
        private Long endTime;
        private String type;
        private boolean executed;

        public RebooterTask() {
        }

        public RebooterTask(String type, long startTime, long timeout, Long endTime) {
            this.type = type;
            this.startTime = startTime;
            this.timeout = timeout;
            this.endTime = endTime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RebooterTask)) {
                return false;
            }
            RebooterTask t = (RebooterTask)obj;
            if (this.type != null && t.type == null || this.type == null && t.type != null) {
                return false;
            }
            if (this.type == null) {
                return false;
            }
            if (!this.type.equals(t.type)) {
                return false;
            }
            return Math.abs(this.startTime - t.startTime) < 10000L && Math.abs(this.timeout - t.timeout) < 10000L;
        }

        @Override
        public int compareTo(RebooterTask o) {
            if (o == null) {
                return 1;
            }
            long res = this.startTime - o.startTime;
            if (this.equals(o)) {
                return 0;
            }
            return res > 0L ? 1 : -1;
        }

        public String toString() {
            return "RebooterTask{type=" + this.type + ", startTime=" + this.startTime + ", timeout=" + this.timeout + ", endTime=" + this.endTime + '}';
        }
    }
}

