/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.ConfigurationSN;
import ru.softlogic.app.configuration.SerialNumbersStore;
import ru.softlogic.application.QueueAgentListener;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.command.CommandStore;
import ru.softlogic.encashment.EncashmentStore;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.statistics.Statistics;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.admin.UnloadSync;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.point.BINList;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.refs.References;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.EncashmentResult;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.network.RefVersionObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.system.util.os.OsApi;

public class QueueAgent
implements Runnable,
RemoteStatusObserver,
RefVersionObserver {
    private final int refsTimeOut = 3;
    private final int defaultRefsMaxTimeOut = 20;
    private final int refsMaxTimeOutNight = 60;
    private final int sleepOnFail = 1;
    private int refsMaxTimeOut;
    private Queue queue;
    private CommandStore commandStore;
    private ServerInterface serverInterface;
    private Logger log;
    private long lastRefsRequest;
    private long lastConnect;
    private int remoteStatus;
    private long remoteRefVersion = 0L;
    private boolean syncTime;
    private int maxPackageSize = 3;
    private int timeout = 10;
    private UnloadSync unloadSync;
    private Set<QueueAgentListener> agentListeners;

    public QueueAgent(Queue queue, CommandStore commandStore, ServerInterface serverInterface) {
        if (queue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Queue");
        }
        if (commandStore == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 CommandStore");
        }
        if (serverInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ServerInterface");
        }
        this.queue = queue;
        this.commandStore = commandStore;
        this.serverInterface = serverInterface;
        serverInterface.addRemoteStatusObserver((RemoteStatusObserver)this);
        serverInterface.addRefVersionObserver((RefVersionObserver)this);
        this.log = Logger.getLogger((String)"net");
        this.log.setAdditivity(false);
        this.unloadSync = UnloadSync.getInstance();
        this.lastConnect = System.currentTimeMillis();
        this.agentListeners = new LinkedHashSet<QueueAgentListener>();
    }

    public void update(int remoteStatus) {
        this.remoteStatus = remoteStatus;
        this.lastConnect = System.currentTimeMillis();
        this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + remoteStatus + ", \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u0430"));
        this.queue.setRemoteLock((remoteStatus & 1) != 0);
    }

    public void update(long version) {
        this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u044f: " + version));
        this.remoteRefVersion = version;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        boolean needPing = false;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ReferenceManager rm = ReferenceManager.getInstance();
                if (rm.getPointOptions() != null) {
                    this.timeout = ReferenceManager.getInstance().getPointOptions().getQueueScanTimeout();
                    this.maxPackageSize = ReferenceManager.getInstance().getPointOptions().getMaxPackageSize();
                    this.refsMaxTimeOut = ReferenceManager.getInstance().getPointOptions().getConnectTimeout();
                }
            }
            catch (ReferenceException rm) {
                // empty catch block
            }
            try {
                Operation[] operations = this.queue.getOperations();
                GroupOperation[] groupOperations = this.queue.getGroupOperations();
                MoneyCollection[] moneyCollections = this.queue.getMoneyCollections();
                for (QueueAgentListener qal : this.agentListeners) {
                    qal.onPaymentsInfo(operations, groupOperations, moneyCollections);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                this.sync();
                if (needPing) {
                    this.log.info((Object)"\u041f\u0438\u043d\u0433\u0443\u044e \u0441\u0435\u0440\u0432\u0435\u0440");
                    try {
                        this.serverInterface.ping();
                    }
                    catch (ConnectorException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043f\u0438\u043d\u0433\u0430", (Throwable)ex);
                    }
                }
                if ((this.remoteStatus & 1) != 0) {
                    if ((this.remoteStatus & 8) == 0) {
                        Thread.sleep(420000L);
                        try {
                            this.serverInterface.ping();
                        }
                        catch (ConnectorException ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043f\u0438\u043d\u0433\u0430", (Throwable)ex);
                        }
                    } else {
                        this.getRefs();
                        this.sendPackets();
                    }
                } else {
                    this.getRefs();
                    this.sendPackets();
                }
                Thread.sleep((long)(this.timeout <= 0 ? 10 : this.timeout) * 1000L);
                needPing = false;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable ex) {
                needPing = true;
                this.log.error((Object)ex, ex);
                ThreadUtil.sleep((long)30000L);
            }
        }
        this.queue.close();
        this.log.info((Object)"Stop thread");
    }

    public void addAgentListener(QueueAgentListener listener) {
        if (listener != null) {
            this.agentListeners.add(listener);
        }
    }

    private void getRefs() {
        if (this.lastRefsRequest == 0L || System.currentTimeMillis() - this.lastRefsRequest > 180000L) {
            ReferenceManager refMan = null;
            try {
                refMan = ReferenceManager.getInstance();
            }
            catch (ReferenceException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            if (refMan != null) {
                boolean flag = false;
                if (refMan.getVersion() != this.remoteRefVersion && this.remoteRefVersion > 0L || refMan.getVersion() == 0L) {
                    this.log.info((Object)("\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435: local=" + refMan.getVersion() + " remote=" + this.remoteRefVersion));
                    flag = true;
                } else if (System.currentTimeMillis() - this.lastConnect > (long)(this.calcTimeout(refMan.getPointOptions().isUseNightMode()) * 60 * 1000)) {
                    this.log.info((Object)("\u041d\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u043b\u0438\u0441\u044c \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u0431\u043e\u043b\u0435\u0435 " + this.calcTimeout(refMan.getPointOptions().isUseNightMode()) + " \u043c\u0438\u043d\u0443\u0442"));
                    flag = true;
                }
                if (!flag) {
                    return;
                }
                References references = null;
                try {
                    references = this.serverInterface.getReferences();
                }
                catch (ConnectorException ex) {
                    this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0441\u043e\u0431\u044b\u0442\u0438\u0435: " + ex.getMessage()));
                    if ("Sign error".equals(ex.getMessage())) {
                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0441\u043e\u0431\u044b\u0442\u0438\u0435");
                        this.queue.putEvent(new Event(EventType.SoftwareFault, "references sign error"));
                    }
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432", (Throwable)ex);
                    this.sleepOnFail();
                }
                if (references != null) {
                    BINList binList;
                    if (references.getDealer() != null) {
                        refMan.setDealer(references.getDealer());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0434\u0438\u043b\u0435\u0440\u0435: " + references.getDealer()));
                    }
                    if (references.getMenuItemStates() != null) {
                        refMan.setMenuItemStates(references.getMenuItemStates());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043d\u043e\u0432\u044b\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043a\u043d\u043e\u043f\u043e\u043a \u043c\u0435\u043d\u044e");
                    }
                    if (references.getMenu() != null) {
                        refMan.setMenu(references.getMenu());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u043d\u043e\u0432\u043e\u0435 \u043c\u0435\u043d\u044e: " + references.getMenu()));
                    }
                    if (references.getPoint() != null) {
                        refMan.setPoint(references.getPoint());
                        if (references.getPoint().getTimeZone() != null && AppDefaults.getInstance().getBooleanProperty("timezone.update.enable", false)) {
                            try {
                                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0447\u0430\u0441\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u044f\u0441\u0430: " + OsApi.getInstance().setTimeZone(TimeZone.getTimeZone(references.getPoint().getTimeZone()).getRawOffset() / 3600000)));
                                TimeZone.setDefault(TimeZone.getTimeZone(ReferenceManager.getInstance().getPoint().getTimeZone()));
                            }
                            catch (Throwable e) {
                                this.log.error((Object)e, e);
                            }
                        }
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043d\u043e\u0432\u043e\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0442\u043e\u0447\u043a\u0435: " + references.getPoint()));
                    }
                    if (references.getPointOptions() != null) {
                        refMan.setPointOptions(references.getPointOptions());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043d\u043e\u0432\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u043e\u0447\u043a\u0438");
                    }
                    if (references.getServiceOptions() != null) {
                        refMan.setServiceOptions(references.getServiceOptions());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043e\u043f\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0435\u0434\u0437\u0430\u043a\u0443\u043f\u043a\u0435 \u043a\u0430\u0440\u0442");
                    }
                    if (references.getPersonalNumbers() != null) {
                        refMan.setPersonalNumbers(references.getPersonalNumbers());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430");
                    }
                    if (references.getBanners() != null) {
                        refMan.setBanners(references.getBanners());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0440\u0435\u043a\u043b\u0430\u043c\u043d\u044b\u0435 \u0431\u0430\u043d\u043d\u0435\u0440\u044b: " + Arrays.toString(references.getBanners())));
                    }
                    if (references.getMovies() != null) {
                        refMan.setMovies(references.getMovies());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0440\u0435\u043a\u043b\u0430\u043c\u043d\u044b\u0435 \u0440\u043e\u043b\u0438\u043a\u0438: " + Arrays.toString(references.getMovies())));
                    }
                    if (references.getCheckAdvs() != null) {
                        refMan.setCheckAdvs(references.getCheckAdvs());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0440\u0435\u043a\u043b\u0430\u043c\u0430 \u043d\u0430 \u0447\u0435\u043a\u0430\u0445: " + Arrays.toString(references.getCheckAdvs())));
                    }
                    if (references.getAuth() != null) {
                        refMan.setAuth(references.getAuth());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    if (references.getUpdateOptions() != null) {
                        refMan.setUpdateOptions(references.getUpdateOptions());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439");
                    }
                    if (references.getCommands() != null) {
                        this.commandStore.add(references.getCommands());
                    }
                    if (references.getPaymentSystem() != null) {
                        refMan.setPaymentSystem(references.getPaymentSystem());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435");
                    }
                    if (references.getBank() != null) {
                        refMan.setBank(references.getBank());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0435\u043c\u0443 \u0431\u0430\u043d\u043a\u0443");
                    }
                    if (references.getServerAddresses() != null) {
                        refMan.setServerAddresses(references.getServerAddresses());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0430\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    if (references.getServerUsers() != null) {
                        refMan.setServerUsers(references.getServerUsers());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u0443 \u0432 \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
                    }
                    if (references.getPromos() != null) {
                        refMan.setPromos(references.getPromos());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u043f\u0440\u043e\u043c\u043e \u0430\u043a\u0446\u0438\u044f\u043c");
                    }
                    if (references.getBonuses() != null) {
                        refMan.setBonuses(references.getBonuses());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0431\u043e\u043d\u0443\u0441\u0430\u043c");
                    }
                    if (references.getCurrencyRates() != null) {
                        refMan.setCurrencyRates(references.getCurrencyRates());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u043a\u0443\u0440\u0441\u0430\u043c \u0432\u0430\u043b\u044e\u0442: " + Arrays.asList(references.getCurrencyRates())));
                    }
                    if (references.getProviderCurrencyRates() != null) {
                        refMan.setProviderCurrencyRates(references.getProviderCurrencyRates());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u043a\u0443\u0440\u0441\u0430\u043c \u0432\u0430\u043b\u044e\u0442 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u043e\u0432: " + Arrays.asList(references.getProviderCurrencyRates())));
                    }
                    if (references.getChanged() != null) {
                        refMan.updateChangedMenuItems(references.getChanged());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u043c \u043f\u0443\u043d\u043a\u0442\u0430\u043c \u043c\u0435\u043d\u044e: " + Arrays.asList(references.getChanged())));
                    }
                    if (references.getWeather() != null) {
                        refMan.setWeather(references.getWeather());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u0433\u043e\u0434\u0435: " + Arrays.asList(references.getWeather())));
                    }
                    if ((binList = references.getBinList()) != null) {
                        refMan.setBinList(binList);
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d PAN-\u0444\u0438\u043b\u044c\u0442\u0440: " + Arrays.asList(binList)));
                        try {
                            CardModuleStore.getInstance().updatePanFilter(binList);
                        }
                        catch (Throwable e) {
                            this.log.info((Object)"BankCard module is not available");
                        }
                    }
                    if (references.getFraudControlRules() != null) {
                        refMan.setFraudControlRules(references.getFraudControlRules());
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0438\u044f \u043c\u043e\u0448\u0435\u043d\u043d\u0438\u0447\u0435\u0441\u0442\u0432\u0430: " + Arrays.asList(references.getFraudControlRules())));
                    }
                    if (references.getEncashments() != null) {
                        EncashmentStore.getInstance().add(references.getEncashments());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438. \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435.");
                        this.queue.putEvent(new Event(EventType.RemoteCollection));
                    }
                    this.log.info((Object)("\u041d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432: " + references.getVersion()));
                    refMan.setVersion(references.getVersion());
                }
            }
            this.lastRefsRequest = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPackets() {
        UnloadSync unloadSync = this.unloadSync;
        synchronized (unloadSync) {
            if (this.unloadSync.getUnloader() != null) {
                this.log.info((Object)"\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
                try {
                    LinkedList<Operation> ops = new LinkedList<Operation>();
                    Operation[] operations = this.queue.getAllOperations();
                    if (operations != null) {
                        ops.addAll(Arrays.asList(operations));
                        this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u043d\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + ops.size()));
                        Operation[] remOp = this.unloadSync.getUnloader().onUnload(ops.toArray(new Operation[ops.size()]));
                        this.log.info((Object)("\u0412\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + remOp.length + ", \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438"));
                        this.unloadSync.setResult(remOp.length);
                        ops.clear();
                        LinkedList<Operation> gops = new LinkedList<Operation>();
                        for (Operation o : remOp) {
                            if (o instanceof Operation && !(o instanceof GroupOperation)) {
                                ops.add(o);
                                continue;
                            }
                            gops.add(o);
                        }
                        this.queue.deleteOperations(ops.toArray(new Operation[ops.size()]));
                        this.queue.deleteGroupOperations(gops.toArray(new GroupOperation[gops.size()]));
                    } else {
                        this.log.info((Object)"\u041d\u0435\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438");
                        this.unloadSync.setResult(null);
                        this.unloadSync.setUnloader(null);
                    }
                }
                catch (IOException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    this.unloadSync.setResult(ex);
                }
                finally {
                    this.unloadSync.setUnloader(null);
                }
            }
        }
        try {
            Object[] objectArray;
            Object[] updateStates;
            CbcStatus[] csrs;
            NetworkStatistics[] nses;
            JammInfo[] jammInfos;
            EncashmentResult[] encashmentResults;
            CommandResult[] commandResults;
            NetworkDevice[] devices;
            ModemState state;
            SaleConfirm[] confirms;
            AdvStatistic[] advStats;
            Statistics[] stats;
            MoneyCollection[] moneyCollections;
            GroupOperation[] groupOperations;
            Operation[] operations;
            BoxAmount[] boxAmounts;
            BoxStatus[] boxStatuses;
            BoxInfo[] boxInfos;
            DeviceStatus[] statuses;
            DeviceInfo[] infos;
            ZReportInfo[] zReportInfos;
            Event[] events;
            EnvRiskFactors erf;
            SystemInfo si = this.queue.getSystemInfo();
            if (si != null) {
                this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e SystemInfo");
                if (this.serverInterface.sendSystemInfo(new SystemInfo[]{si})) {
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e. \u0423\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.setSystemInfo(null);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438");
                }
            }
            if ((erf = this.queue.getEnvRiskFactors()) != null) {
                this.log.info((Object)"Send EnvRiskFactors");
                if (this.serverInterface.sendEnvRiskFactors(erf)) {
                    this.log.info((Object)"Success");
                    this.queue.setEnvRiskFactors(null);
                } else {
                    this.log.error((Object)"Error");
                }
            }
            if ((events = this.queue.getEvents()) != null && events.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + events.length));
                if (this.serverInterface.sendEvents(events)) {
                    this.log.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteEvents(events);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
                }
                events = null;
            }
            if ((zReportInfos = this.queue.getZReportInfos()) != null && zReportInfos.length > 0) {
                try {
                    this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + zReportInfos.length));
                    if (this.serverInterface.sendZReportInfos(zReportInfos)) {
                        this.log.info((Object)"z-\u043e\u0442\u0447\u0435\u0442\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                        this.queue.deleteZReportInfo(zReportInfos);
                    } else {
                        this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432");
                    }
                    zReportInfos = null;
                }
                catch (Exception ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
            }
            if ((infos = this.queue.getDeviceInfo()) != null && infos.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445: " + infos.length));
                this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0441\u0435\u0440\u0438\u0439\u043d\u0438\u043a\u0438 \u0443 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432. \u0415\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u0435 \u043f\u0440\u0438 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0432\u0440\u0443\u0447\u043d\u0443\u044e, \u043f\u0440\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c");
                this.checkDeviceSerialNumber(infos);
                if (this.serverInterface.sendDeviceInfo(infos)) {
                    this.log.info((Object)"\u0418\u043d\u0444\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteDeviceInfos(infos);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430\u0445");
                }
            }
            if ((statuses = this.queue.getDeviceStatuses()) != null && statuses.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + statuses.length));
                if (this.serverInterface.sendStatuses(statuses)) {
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteDeviceStatuses(statuses);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
                }
            }
            if ((boxInfos = this.queue.getDispenserBoxInfos()) != null && boxInfos.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0431\u043e\u043a\u0441\u0430\u0445 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + boxInfos.length));
                if (this.serverInterface.sendBoxInfos(boxInfos)) {
                    this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u043e\u043a\u0441\u0430\u0445 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteDispenserBoxInfos(boxInfos);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0431\u043e\u043a\u0441\u0430\u0445");
                }
            }
            if ((boxStatuses = this.queue.getDispenserBoxStatuses()) != null && boxStatuses.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0431\u043e\u043a\u0441\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + boxStatuses.length));
                if (this.serverInterface.sendBoxStatuses(boxStatuses)) {
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441\u044b \u0431\u043e\u043a\u0441\u043e\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteDispenserBoxStatuses(boxStatuses);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0431\u043e\u043a\u0441\u043e\u0432");
                }
            }
            if ((boxAmounts = this.queue.getDispenserBoxAmounts()) != null && boxAmounts.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0437\u0430\u043f\u043e\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043a\u0441\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + boxAmounts.length));
                if (this.serverInterface.sendBoxAmounts(boxAmounts)) {
                    this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043a\u0441\u043e\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteDispenserBoxAmounts(boxAmounts);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043a\u0441\u043e\u0432");
                }
            }
            if ((operations = this.queue.getOperations()) != null && operations.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + operations.length + " \u0444\u0438\u043b\u044c\u0442\u0440\u0443\u044e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
                LinkedList<Operation> fl = new LinkedList<Operation>();
                long now = System.currentTimeMillis();
                for (Operation op : operations) {
                    if (op.getLastProcess() != 0L && now - op.getLastProcess() <= 420000L && op.getLastProcess() <= now) continue;
                    fl.add(op);
                }
                if (fl.size() > 0) {
                    operations = fl.toArray(new Operation[fl.size()]);
                    if (this.maxPackageSize > 0 && operations.length > this.maxPackageSize) {
                        this.log.info((Object)("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + this.maxPackageSize));
                        operations = Arrays.copyOf(operations, this.maxPackageSize);
                    }
                    Object[] states = this.serverInterface.processWithResult(operations);
                    this.log.info((Object)("Result: " + Arrays.toString(states)));
                    LinkedList<Operation> remOp = new LinkedList<Operation>();
                    now = System.currentTimeMillis();
                    for (int i = 0; i < states.length; ++i) {
                        Object os = states[i];
                        Operation op = operations[i];
                        this.log.info((Object)("Op: " + op + "->" + os));
                        if (os.getCheck() == op.getCheckNumber() && os.getIdOperation() == op.getIdOperation()) {
                            if (os.getError() == 0) {
                                this.log.info((Object)"Success state, remove");
                                remOp.add(op);
                                continue;
                            }
                            if (os.getError() == 6) {
                                this.log.info((Object)"Error in cash units, remove");
                                remOp.add(op);
                                continue;
                            }
                            this.log.info((Object)"Other error, operation will send later");
                            op.setLastProcess(now);
                            continue;
                        }
                        this.log.error((Object)"Wrong result metrics");
                    }
                    if (remOp.size() > 0) {
                        this.log.info((Object)("Delete " + remOp.size() + " operations"));
                        this.queue.deleteOperations(remOp.toArray(new Operation[remOp.size()]));
                    } else {
                        this.log.info((Object)"Nothing to delete");
                    }
                }
            }
            if ((groupOperations = this.queue.getGroupOperations()) != null && groupOperations.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + groupOperations.length));
                if (this.serverInterface.processGroup(groupOperations)) {
                    this.log.info((Object)"\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteGroupOperations(groupOperations);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439");
                }
            }
            if ((moneyCollections = this.queue.getMoneyCollections()) != null && moneyCollections.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + moneyCollections.length));
                if (this.serverInterface.sendMoneyCollection(moneyCollections)) {
                    this.log.info((Object)"\u0418\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteMoneyCollections(moneyCollections);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439");
                }
            }
            if ((stats = this.queue.getStatistics()) != null && stats.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + stats.length));
                if (this.serverInterface.sendStatistics(stats)) {
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteStatistics(stats);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
                }
            }
            if ((advStats = this.queue.getAdvStatistics()) != null && advStats.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + advStats.length));
                if (this.serverInterface.sendAdvStatistics(advStats)) {
                    this.log.info((Object)"Adv \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteAdvStatistics(advStats);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
                }
            }
            if ((confirms = this.queue.getSaleConfirms()) != null && confirms.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0439 \u043f\u0440\u043e\u0434\u0430\u0436: " + confirms.length));
                if (this.serverInterface.registerSales(confirms)) {
                    this.log.info((Object)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                    this.queue.deleteSaleConfirms(confirms);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0439 \u043f\u0440\u043e\u0434\u0430\u0436");
                }
            }
            if ((state = this.queue.getModemState()) != null) {
                this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043c\u043e\u0434\u0435\u043c\u0443: " + state));
                if (this.serverInterface.sendModemState(state)) {
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441 \u043c\u043e\u0434\u0435\u043c\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d");
                    this.queue.deleteModemState(state);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043c\u043e\u0434\u0435\u043c\u0430");
                }
            }
            if ((devices = this.queue.getNetworkDevices()) != null && devices.length > 0) {
                this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0441\u0435\u0442\u0435\u0432\u044b\u043c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430\u043c");
                if (this.serverInterface.sendNetworkDevices(devices)) {
                    this.log.info((Object)"\u0421\u0435\u0442\u0435\u0432\u044b\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b");
                    this.queue.deleteNetworkDevices(devices);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432");
                }
            }
            if ((commandResults = this.queue.getCommandResults()) != null && commandResults.length > 0) {
                this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434");
                if (this.serverInterface.commandConfirm(commandResults)) {
                    this.log.info((Object)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b");
                    this.queue.deleteCommandResults(commandResults);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u0438\u0439 \u043a\u043e\u043c\u0430\u043d\u0434");
                }
            }
            if ((encashmentResults = this.queue.getEncashmentResults()) != null && encashmentResults.length != 0) {
                this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438");
                for (EncashmentResult res : encashmentResults) {
                    if (this.serverInterface.sendEncashmentResult(res)) {
                        this.log.info((Object)"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b");
                        this.queue.deleteEncashmentResult(res);
                        continue;
                    }
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438");
                }
            }
            if (this.queue.getDiskSpace() != null) {
                this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u043d\u0430 \u0434\u0438\u0441\u043a\u0435 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440: " + this.queue.getDiskSpace() + " Mb"));
                if (this.serverInterface.sendSpace(this.queue.getDiskSpace().intValue())) {
                    this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d");
                    this.queue.setDiskSpace(null);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432. \u043c\u0435\u0441\u0442\u0430");
                }
            }
            if ((jammInfos = this.queue.getJamms()) != null && jammInfos.length > 0) {
                this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0437\u0430\u0436\u0435\u0432\u044b\u0432\u0430\u043d\u0438\u0438");
                if (this.serverInterface.sendJamm(jammInfos)) {
                    this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b");
                    this.queue.deleteJamm(jammInfos);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0436\u0435\u0432\u044b\u0432\u0430\u043d\u0438\u0439");
                }
            }
            if ((nses = this.queue.getNetworkStatistics()) != null && nses.length > 0) {
                this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439");
                if (this.serverInterface.sendNetworkStatistics(nses)) {
                    this.log.info((Object)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430");
                    this.queue.deleteNetworkStatistics(nses);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
                }
            }
            if ((csrs = this.queue.getCbcStates()) != null && csrs.length > 0) {
                LinkedList<CbcStatus> list = new LinkedList<CbcStatus>();
                for (CbcStatus cbcStatus : csrs) {
                    if (cbcStatus.getSendTimeout() != null && cbcStatus.getSendTimeout() >= System.currentTimeMillis()) continue;
                    list.add(cbcStatus);
                }
                csrs = list.toArray(new CbcStatus[list.size()]);
                if (csrs.length > 0) {
                    this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0433\u0430\u0448\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438");
                    if (this.serverInterface.sendActivateStatus(csrs)) {
                        this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                        this.queue.deleteCbcStates(csrs);
                    } else {
                        this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0439 \u043a\u0430\u0440\u0442 \u0441\u0434\u0430\u0447");
                    }
                }
            }
            if ((updateStates = this.queue.getUpdateStates()) != null && updateStates.length > 0) {
                this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + Arrays.toString(updateStates)));
                for (Object object : updateStates) {
                    if (this.serverInterface.sendUpdateState((UpdateState)object)) {
                        this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                        this.queue.deleteUpdateStatus((UpdateState)object);
                        continue;
                    }
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
                }
            }
            if ((objectArray = this.queue.getDemands()) != null && objectArray.length > 0) {
                this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0437\u0430\u043f\u0440\u043e\u0441\u044b: " + Arrays.toString(objectArray)));
                if (this.serverInterface.demand((Demand[])objectArray)) {
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    this.queue.deleteDemand((Demand[])objectArray);
                } else {
                    this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
                }
            }
        }
        catch (ConnectorException ex) {
            this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0442\u0441\u044b\u043b\u043a\u0435 \u043f\u0430\u043a\u0435\u0442\u043e\u0432", (Throwable)ex);
            this.sleepOnFail();
        }
    }

    private void checkDeviceSerialNumber(DeviceInfo[] infos) {
        SerialNumbersStore store = ConfigurationSN.getInstance().getStore();
        if (store.getNumbers() != null) {
            String serialManual = "";
            for (int i = 0; i < infos.length; ++i) {
                short deviceClass = infos[i].getDeviceClass();
                String serial = infos[i].getSerial();
                if (deviceClass == DeviceClass.CashAcceptor.getCode() && (serial == null || serial.isEmpty())) {
                    serialManual = store.getSerial(SerialNumbersStore.Type.VALIDATOR);
                    if (serialManual == null || serialManual.isEmpty()) continue;
                    infos[i].setSerial(serialManual);
                    continue;
                }
                if (deviceClass == DeviceClass.Modem.getCode() && (serial == null || serial.isEmpty())) {
                    serialManual = store.getSerial(SerialNumbersStore.Type.MODEM);
                    if (serialManual == null || serialManual.isEmpty()) continue;
                    infos[i].setSerial(serialManual);
                    continue;
                }
                if (deviceClass != DeviceClass.PosPrinter.getCode() && deviceClass != DeviceClass.IppPrinter.getCode() && deviceClass != DeviceClass.FiscalPrinter.getCode() || serial != null && !serial.isEmpty() || (serialManual = store.getSerial(SerialNumbersStore.Type.PRINTER)) == null || serialManual.isEmpty()) continue;
                infos[i].setSerial(serialManual);
            }
        }
    }

    private void sleepOnFail() {
        this.log.error((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c. \u0421\u043f\u0438\u043c 1 \u043c\u0438\u043d\u0443\u0442\u044b");
        ThreadUtil.sleep((long)60000L);
    }

    private int calcTimeout(boolean useNightMode) {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        if (hour >= 7 && hour <= 22 || !useNightMode) {
            return this.refsMaxTimeOut > 0 && this.refsMaxTimeOut < 25 ? this.refsMaxTimeOut : 20;
        }
        return 60;
    }

    private void sync() {
        if (!this.syncTime) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u044f");
            try {
                Date date = this.serverInterface.ping();
                this.syncTime = true;
                if (date != null) {
                    Date now = new Date();
                    this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + date + ", \u0432\u0440\u0435\u043c\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0430: " + now));
                    if (Math.abs(now.getTime() - date.getTime()) > 300000L) {
                        this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 5 \u043c\u0438\u043d\u0443\u0442. \u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u044e");
                        int res = OsApi.getInstance().setLocalTime(date);
                        if (res == 0) {
                            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e, \u043d\u043e\u0432\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + new Date()));
                            if (Math.abs(now.getTime() - date.getTime()) > 1800000L) {
                                Date now2 = new Date();
                                if (Math.abs(now2.getTime() - now.getTime()) > 10000L) {
                                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u0441\u0438\u043b\u044c\u043d\u043e \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u041f\u041e");
                                    SafeReboot.getInstance().restart(0);
                                } else {
                                    this.log.error((Object)"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0447\u0430\u0441\u043e\u0432\u044b\u043c\u0438 \u043f\u043e\u044f\u0441\u0430\u043c\u0438. \u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0434\u0435\u043b\u0430\u044e");
                                }
                            }
                        } else {
                            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u041d\u0415 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e, \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f: " + new Date() + ", \u043e\u0448\u0438\u0431\u043a\u0430=" + res));
                        }
                    }
                } else {
                    this.log.info((Object)"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443");
                }
            }
            catch (ConnectorException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438", (Throwable)ex);
                this.sleepOnFail();
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438", ex);
            }
        }
    }
}

