/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;

public class PrinterStatusObserver
implements ru.softlogic.hardware.device.print.status.PrinterStatusObserver {
    private ClientInterface server;
    private boolean usePaperNearEndSensor;
    private PrinterStatus lastStatus;
    private Logger log;

    public PrinterStatusObserver(ClientInterface server, boolean usePaperNearEndSensor) {
        if (server == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
        }
        this.server = server;
        this.usePaperNearEndSensor = usePaperNearEndSensor;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void update(DeviceClass deviceClass, PrinterStatus status) {
        if (!this.usePaperNearEndSensor) {
            status.setPaperNearEnd(false);
        }
        if (!status.equals((Object)this.lastStatus)) {
            int deviceStatus = 0;
            int flags = 0;
            if (!status.isOnline()) {
                deviceStatus = -2;
            } else if (status.isPaperEnd()) {
                deviceStatus = 1;
            } else if (status.isError()) {
                deviceStatus = -6;
            }
            if (status.isPaperNearEnd()) {
                flags = 1;
            }
            this.server.sendStatus(new DeviceStatus(Short.valueOf(deviceClass.getCode()), deviceStatus, flags));
            this.lastStatus = status;
            this.log.info((Object)(">>\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + status));
        }
    }

    public void errorEvent(String comment) {
        this.server.sendEvent(new Event(EventType.KkmEvent, comment));
    }
}

