/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.network.NetObserver;

public class NetworkStatisticHandler
implements NetObserver,
Runnable {
    private NetworkStatistics stat;
    private ClientInterface server;
    private Logger log;
    private String dir;

    public NetworkStatisticHandler(ClientInterface server) {
        if (server == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.server = server;
        this.log = Logger.getLogger((String)"app");
        this.dir = PathUtils.getAppHome() + File.separator + "data" + File.separator + "network" + File.separator;
        this.readData();
    }

    public synchronized void update(boolean netError) {
        this.stat.setNetworkTotal(this.stat.getNetworkTotal() + 1);
        if (netError) {
            this.stat.setNetworkError(this.stat.getNetworkError() + 1);
        }
        this.updateData();
    }

    private synchronized NetworkStatistics resetStatistics() {
        NetworkStatistics res = this.stat;
        res.setTo(new Date());
        this.stat = new NetworkStatistics();
        this.stat.setFrom(new Date());
        this.updateData();
        return res;
    }

    private void updateData() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.dir + "stat.obj"));
            oos.writeObject(this.stat);
        }
        catch (Exception exception) {
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readData() {
        try {
            FileUtil.checkDir((String)this.dir);
        }
        catch (FileUtilException fileUtilException) {
            // empty catch block
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.dir + "stat.obj"));
            Object obj = ois.readObject();
            if (obj instanceof NetworkStatistics) {
                this.stat = (NetworkStatistics)obj;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.stat == null) {
            this.stat = new NetworkStatistics();
            this.stat.setFrom(new Date());
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"*** Start NetworStatistics thread *************************");
        this.log.info((Object)this.stat);
        while (!Thread.currentThread().isInterrupted()) {
            long interval = this.getSleepInterval(this.stat.getFrom());
            this.log.info((Object)("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0437\u0430\u043f\u0443\u0441\u043a \u0447\u0435\u0440\u0435\u0437 " + interval / 1000L + " c\u0435\u043a\u0443\u043d\u0434"));
            try {
                if (interval > 0L) {
                    Thread.sleep(interval);
                }
                NetworkStatistics ns = this.resetStatistics();
                this.log.info((Object)("send: " + ns));
                this.server.sendNetworStatistics(ns);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"*** Stop NetworStatistics thread **************************");
    }

    private long getSleepInterval(Date date) {
        Date now = new Date();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        ((Calendar)c).add(5, 1);
        Date next = c.getTime();
        return next.getTime() - now.getTime();
    }
}

