/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.Ping;

public class NetworkObserver
implements NetObserver,
Runnable {
    private final int countLimit = 3;
    private final long timeLimit = 360000L;
    private final long rebootTimeLimit = 2700000L;
    private final long reconnectTimeLimit = 900000L;
    private WatchDog watchDog;
    private int count;
    private Logger log;
    private long lastDate;
    private long lastOnlineDate;
    private ConnectionManager manager;
    private WatchDogThread wdt;
    private boolean rebootOnNetError;

    public NetworkObserver(boolean rebootOnNetError) {
        this.rebootOnNetError = rebootOnNetError;
        this.log = Logger.getLogger((String)"watchdog");
        this.log.setAdditivity(false);
        this.lastDate = System.currentTimeMillis() - 600000L;
        this.lastOnlineDate = System.currentTimeMillis();
        this.manager = ManagerFactory.getInstance().getManager();
        this.wdt = new WatchDogThread();
        Thread th = new Thread((Runnable)this.wdt, "NetworkObserverWatchDog");
        th.setDaemon(true);
        th.start();
    }

    public void setWatchDog(WatchDog watchDog) {
        this.watchDog = watchDog;
    }

    public void update(boolean netError) {
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: \u043e\u0448\u0438\u0431\u043a\u0430=" + netError + " \u0441\u0447\u0435\u0442\u0447\u0438\u043a: " + this.count));
        if (netError) {
            ++this.count;
        } else {
            this.count = 0;
            this.lastDate = this.lastOnlineDate = System.currentTimeMillis();
        }
    }

    @Override
    public void run() {
        if (this.watchDog != null) {
            this.log.info((Object)"\u041f\u0440\u0438\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440.");
            if (this.rebootOnNetError) {
                this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0438\u044f \u0441\u0432\u044f\u0437\u0438. \u041f\u0440\u043e\u0431\u0443\u044e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u043e\u0434\u0435\u043c");
                try {
                    this.watchDog.resetModem();
                    this.log.info((Object)"\u041c\u043e\u0434\u0435\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
                }
                catch (IOException ex) {
                    this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430", (Throwable)ex);
                }
            } else {
                this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043c\u043e\u0434\u0435\u043c\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
        }
        int lastCount = 0;
        while (!Thread.currentThread().isInterrupted()) {
            long now = System.currentTimeMillis();
            if (this.count >= 3 && now - this.lastDate >= 360000L) {
                this.log.error((Object)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u0439 \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u043e \u043f\u0440\u0435\u0434\u0435\u043b\u0430");
                long rebootTime = 2700000L;
                try {
                    if (ReferenceManager.getInstance().getPointOptions() != null && ReferenceManager.getInstance().getPointOptions().getRebootTimeout() > 0) {
                        rebootTime = (long)(ReferenceManager.getInstance().getPointOptions().getRebootTimeout() * 60) * 1000L;
                    }
                }
                catch (ReferenceException referenceException) {
                    // empty catch block
                }
                if (!Ping.isNetworkAlive()) {
                    this.log.error((Object)"\u0421\u0435\u0442\u044c \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                    if (now - this.lastOnlineDate >= (this.watchDog != null ? rebootTime : rebootTime / 2L)) {
                        this.reboot();
                    } else {
                        this.stopPpp();
                        if (this.watchDog != null) {
                            this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u0435\u043c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u043e\u0434\u0435\u043c\u0430");
                            try {
                                this.watchDog.resetModem();
                                this.log.info((Object)"\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u043d\u0430");
                            }
                            catch (IOException ex) {
                                this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0441\u044b\u043b\u043a\u0435 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b", (Throwable)ex);
                            }
                        } else {
                            this.log.error((Object)"\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430 \u043d\u0435\u0442. \u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u043e\u0434\u0435\u043c");
                        }
                    }
                } else if (rebootTime > 0L && now - this.lastOnlineDate > rebootTime) {
                    this.log.info((Object)"\u0421\u0435\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u041e\u0434\u043d\u0430\u043a\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439 \u043d\u0435 \u0431\u044b\u043b\u043e \u0431\u043e\u043b\u0435\u0435 45 \u043c\u0438\u043d\u0443\u0442. \u041f\u0440\u043e\u0431\u0443\u044e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
                    this.reboot();
                } else if (now - this.lastOnlineDate > 900000L) {
                    this.log.info((Object)"\u0421\u0435\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u041e\u0434\u043d\u0430\u043a\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439 \u043d\u0435 \u0431\u044b\u043b\u043e \u0431\u043e\u043b\u0435\u0435 15 \u043c\u0438\u043d\u0443\u0442. \u041f\u0440\u043e\u0431\u0443\u044e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    this.stopPpp();
                } else {
                    this.log.info((Object)"\u0421\u0435\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u041d\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0432 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430");
                }
                this.count = 0;
                this.lastDate = now;
            } else if (lastCount != this.count) {
                this.log.debug((Object)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u044f \u043c/\u0434 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430\u043c\u0438 \u043d\u0435 \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u043e \u043b\u0438\u043c\u0438\u0442\u0430");
                lastCount = this.count;
            }
            this.wdt.update();
            ThreadUtil.sleep((long)10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPpp() {
        this.log.info((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
        ConnectionManager connectionManager = this.manager;
        synchronized (connectionManager) {
            Logger.getLogger((String)"ppp").info((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
            OperationResult or = this.manager.disconnectAll();
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430: " + or));
        }
    }

    private void reboot() {
        this.log.info((Object)"\u0421\u0432\u044f\u0437\u0438 \u043d\u0435\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e. \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
        try {
            DaemonUtil.createExitFlag((String)"_flag_neterror");
            SafeReboot.getInstance().reboot();
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", (Throwable)ex);
        }
    }

    private class WatchDogThread
    implements Runnable {
        private long lastNotify = System.currentTimeMillis();
        private int counter = 0;

        private WatchDogThread() {
        }

        public void update() {
            this.lastNotify = System.currentTimeMillis();
        }

        @Override
        public void run() {
            NetworkObserver.this.log.info((Object)"NetworkObserverThread start");
            ThreadUtil.sleep((long)240000L);
            while (!Thread.currentThread().isInterrupted()) {
                ThreadUtil.sleep((long)60000L);
                if (System.currentTimeMillis() - this.lastNotify <= 600000L) continue;
                ++this.counter;
                if (this.counter != 3) continue;
                NetworkObserver.this.log.info((Object)"\u041f\u043e\u0442\u043e\u043a \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d. \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u044e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
                SafeReboot.getInstance().reboot();
                break;
            }
            NetworkObserver.this.log.info((Object)"NetworkObserverThread stop");
        }
    }
}

