/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.EventQueue;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.keyboard.KeyboardListener;
import ru.softlogic.hdw.dev.keyboard.ControlKey;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboardKeyListener;

public class ExtKeyboardAdapter
implements ExtKeyboardKeyListener {
    private KeyboardListener listener;

    public ExtKeyboardAdapter(KeyboardListener listener) {
        this.listener = listener;
    }

    public void pressKey(final char key) {
        UserAction.getInstance().update();
        if (this.listener != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtKeyboardAdapter.this.listener.onKeyPress(key);
                }
            });
        }
    }

    public void pressKey(final ControlKey controlKey) {
        UserAction.getInstance().update();
        if (this.listener != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ControlKey.Dot.equals((Object)controlKey)) {
                        ExtKeyboardAdapter.this.listener.onKeyPress('.');
                    } else if (ControlKey.Key00.equals((Object)controlKey)) {
                        ExtKeyboardAdapter.this.listener.onKeyPress('0');
                        ExtKeyboardAdapter.this.listener.onKeyPress('0');
                    } else if (ControlKey.Enter.equals((Object)controlKey)) {
                        ExtKeyboardAdapter.this.listener.onEnter();
                    } else if (ControlKey.Cancel.equals((Object)controlKey)) {
                        ExtKeyboardAdapter.this.listener.onCancel();
                    } else if (ControlKey.Correction.equals((Object)controlKey)) {
                        ExtKeyboardAdapter.this.listener.onClearLast();
                    }
                }
            });
        }
    }
}

