/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.AppUtils;

public class ErrorDumpProcessor
implements Runnable {
    private ClientInterface clientInterface;

    public ErrorDumpProcessor(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new NullPointerException("clientInterface");
        }
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        List<File> res = AppUtils.getDumps();
        Logger log = Logger.getLogger((String)"app");
        for (File f : res) {
            log.info((Object)("Found java dump: " + f.getAbsolutePath()));
        }
        if (res.size() > 1) {
            this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "error dump count=" + (res.size() - 1)));
            for (int i = 0; i < res.size() - 1; ++i) {
                res.get(i).delete();
            }
        }
    }
}

