/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class EmptyUserActionsListener
implements ModuleTypeListener {
    private int maxSOC;
    private int maxPMOC;
    private int screenOpenedCount;
    private int paymentModuleOpenedCount;
    private int lastModule;
    private ClientInterface sc;
    private Logger log;

    public EmptyUserActionsListener(ClientInterface sc) {
        this.sc = sc;
        this.maxSOC = AppDefaults.getInstance().getIntegerValue("menu.screen.open.empty.max", 0);
        this.maxPMOC = AppDefaults.getInstance().getIntegerValue("module.payment.open.empty.max", 0);
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public void onChange(int moduleType) {
        if (this.lastModule != moduleType) {
            if (moduleType == 5) {
                this.reset();
            } else if (moduleType == 3) {
                this.screenOpenedCount = 0;
                ++this.paymentModuleOpenedCount;
                if (this.maxPMOC > 0 && this.paymentModuleOpenedCount > this.maxPMOC) {
                    this.log.info((Object)"\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435");
                    this.sc.sendEvent(new Event(EventType.Warning, "No payment " + this.paymentModuleOpenedCount + " discovery payment module"));
                    this.paymentModuleOpenedCount = 0;
                }
            }
            this.lastModule = moduleType;
        }
    }

    public void reset() {
        this.screenOpenedCount = 0;
        this.paymentModuleOpenedCount = 0;
    }

    public void incScreenOpen() {
        ++this.screenOpenedCount;
        if (this.maxSOC > 0 && this.screenOpenedCount > this.maxSOC) {
            this.log.info((Object)"\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u044d\u043a\u0440\u0430\u043d\u043e\u0432 \u043c\u0435\u043d\u044e. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435");
            this.sc.sendEvent(new Event(EventType.Warning, "No payment " + this.screenOpenedCount + " discovery menu screens"));
            this.screenOpenedCount = 0;
        }
    }
}

