/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;

public class DeviceInfoHandlingSender
implements DeviceInfoListener,
DeviceStateListener,
DeviceProblemListener {
    private ClientInterface client;
    private DeviceInfo last;
    private DeviceState lastState;
    private Logger log;

    public DeviceInfoHandlingSender(ClientInterface client) {
        if (client == null) {
            throw new NullPointerException("Client interface is needed");
        }
        this.client = client;
        this.log = Logger.getLogger((String)"app");
    }

    public void onDeviceInfo(DeviceInfo info) {
        if (!(info == null || this.last != null && this.last.equals((Object)info))) {
            ru.softlogic.hardware.device.DeviceInfo di = new ru.softlogic.hardware.device.DeviceInfo(info.getDeviceClass(), info.getDeviceType());
            di.setFirmware(info.getFirmware());
            di.setFirmware1(info.getFirmware1());
            di.setFirmware2(info.getFirmware2());
            di.setInfo(info.getInfo());
            di.setModel(info.getModel());
            di.setPort(info.getPort());
            di.setProto(info.getProto());
            di.setSerial(info.getSerial());
            di.setVendor(info.getVendor());
            this.client.send(di);
            this.last = info;
        }
    }

    public void onState(DeviceState ds) {
        if (!(ds == null || this.lastState != null && this.lastState.equals((Object)ds))) {
            DeviceStatus ds1 = new DeviceStatus(Short.valueOf(ds.getDeviceClass()), ds.getState(), ds.getFlags());
            this.client.sendStatus(ds1);
            this.lastState = ds;
        }
    }

    public void onProblem(DeviceId di, String string) {
        this.log.error((Object)("" + di + " " + string));
        this.client.sendEvent(new Event(EventType.Warning, "" + di.toString() + " " + string));
    }
}

