/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.CardReaderConfiguration;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.app.configuration.ConfigurationException;
import ru.softlogic.app.configuration.DeviceConfiguration;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.command.ArchBuilder;
import ru.softlogic.command.CommandStore;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui.utils.menu.GroupByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.modem.Registration;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.hardware.device.modem.resources.ModemHelper;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.ReportRequest;
import ru.softlogic.hardware.scanner.DeviceTypeFilter;
import ru.softlogic.hardware.scanner.Scanner;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.email.Auth;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.command.CommandResultType;
import ru.softlogic.srv.api.command.CommandType;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.AppUtils;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.ResourceUtil;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.system.util.os.OsException;

public class CommandLauncher
implements Runnable,
ModuleTypeListener {
    private CommandStore commandStore;
    private ClientInterface clientInterface;
    private PrinterQueue printerQueue;
    private Logger log;
    private ProcessExecutor executor;
    private int curentModule;
    private SerialPort modemPort;

    public CommandLauncher(CommandStore commandStore, ClientInterface clientInterface, PrinterQueue printerQueue, ProcessExecutor executor, SerialPort modemPort) {
        if (commandStore == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 CommandStore");
        }
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        if (printerQueue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PrinterQueue");
        }
        this.commandStore = commandStore;
        this.clientInterface = clientInterface;
        this.printerQueue = printerQueue;
        this.executor = executor;
        this.modemPort = modemPort;
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
    }

    @Override
    public void run() {
        this.log.info((Object)"Start Thread");
        ThreadUtil.sleep((long)AppDefaults.getInstance().getIntegerValue("app.cmdlauncher.timeout", 180000).intValue());
        this.log.info((Object)"Start process commands");
        while (!Thread.currentThread().isInterrupted()) {
            for (Command cmd : this.commandStore.get()) {
                this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e: " + cmd));
                if (cmd.getType() == null || cmd.getExecuteTill() == null) {
                    this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
                    this.updateCommand(cmd, CommandResultType.BadParams, null);
                    continue;
                }
                if (cmd.getExecuteTill().compareTo(new Date()) < 0) {
                    this.log.info((Object)"\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b");
                    this.updateCommand(cmd, CommandResultType.Timeout, null);
                    continue;
                }
                switch (cmd.getType()) {
                    case Reboot: {
                        this.reboot(cmd);
                        break;
                    }
                    case ExecuteCmd: {
                        this.executeCmd(cmd);
                        break;
                    }
                    case CheckDisk: {
                        this.checkDisk(cmd);
                        break;
                    }
                    case SendLog: {
                        this.sendLogs(cmd, false, "pay.log", "coin.log", "cashin.log");
                        break;
                    }
                    case SendAllLog: {
                        this.sendLogs(cmd, true, "pay.log", "cashin.log", "coin.log", "add/adv.log", "add/adv-player.log", "add/app.log", "add/barcode.log", "add/client.log", "add/cdm.log", "add/coffee.log", "add/cvd.log", "add/gui.log", "add/cards.log", "add/cashin-observer.log", "add/network.log", "add/modem.log", "add/update.log", "add/watchdog.log", "add/print.log", "add/start.log", "add/locker.log", "add/maintenance.log", "add/ppp.log", "add/payout.log", "add/present.log", "add/proximity.log", "add/scanner.log", "add/sound.log", "add/tmm.log", "add/ups.log", "add/transactions.log", "card/pinpad.log", "card/server.log", "card/emvcore.log", "card/equip.log", "card/cards.log", "card/cardmodule.log", "card/cardreader.log");
                        break;
                    }
                    case SendScreenShot: {
                        this.sendScreenShot(cmd);
                        break;
                    }
                    case SendScreenShots: {
                        this.sendScreenShots(cmd);
                        break;
                    }
                    case SendScreenShotService: {
                        this.sendScreenShotService(cmd);
                        break;
                    }
                    case ClearUpdate: {
                        this.clearUpdate(cmd);
                        break;
                    }
                    case SendHardwareInfo: {
                        this.sendHardareInfo(cmd);
                        break;
                    }
                    case PowerOff: {
                        this.updateCommand(cmd, CommandResultType.Ok, "");
                        SafeReboot.getInstance().poweroff();
                        break;
                    }
                    case JavaLog: {
                        this.sendJavaLog(cmd);
                        break;
                    }
                    case Processes: {
                        this.sendPrecessInfo(cmd);
                        break;
                    }
                    case UpdateFirmware: {
                        this.updateFirmware(cmd);
                        break;
                    }
                    case ExecuteUSSD: {
                        this.executeUSSD(cmd);
                        break;
                    }
                    case ChangePS: {
                        this.changePrintSystem(cmd);
                        break;
                    }
                    case SendEcardData: {
                        this.sendEcardData(cmd);
                        break;
                    }
                    case SendNetStat: {
                        this.sendNetStatData(cmd);
                        break;
                    }
                    case PrintZReportsMem: {
                        this.printZReportsMem(cmd);
                        break;
                    }
                    default: {
                        this.updateCommand(cmd, CommandResultType.BadParams, "unknown command");
                    }
                }
                if (cmd.getType() != CommandType.SendLog && cmd.getType() != CommandType.SendAllLog && cmd.getType() != CommandType.ExecuteCmd) continue;
            }
            ThreadUtil.sleep((long)20000L);
        }
        this.log.info((Object)"Stop Thread");
    }

    private void clearUpdate(Command cmd) {
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439");
        try {
            FileUtils.deleteDirectory((File)new File(PathUtils.getAppHome() + "/update"));
            this.updateCommand(cmd, CommandResultType.Ok, null);
            if (cmd.isReboot()) {
                this.reboot(null);
            }
        }
        catch (Exception ex) {
            this.updateCommand(cmd, CommandResultType.Error, "" + ex.getClass() + ":" + this.trim(ex.getMessage()));
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f", (Throwable)ex);
        }
    }

    private void sendHardareInfo(Command cmd) {
        this.log.info((Object)"Requires sending hardware information");
        Auth auth = null;
        Point point = null;
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
        }
        String email = cmd.getParam1();
        if (email == null || email.isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        File f = new File(PathUtils.getAppHome(), "/resources/dmi/fullinfo");
        if (!f.exists() || !f.isFile()) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.Error, "File not exist");
            return;
        }
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("System info, point " + point.getId(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(f);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("sysinfo.txt");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "size=" + f.length() / 1024L + " Kb");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + f.length() / 1024L + " Kb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendScreenShot(Command cmd) {
        Point point;
        Auth auth;
        this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430");
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
            this.commandStore.remove(cmd);
            return;
        }
        String email = cmd.getParam1();
        if (email == null || email.isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        this.commandStore.remove(cmd);
        this.log.info((Object)"\u041f\u044b\u0442\u0430\u0435\u043c\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430");
        try {
            long t = System.currentTimeMillis();
            if (this.curentModule != 1) {
                this.updateCommand(cmd, CommandResultType.Ok, "\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u044d\u043a\u0440\u0430\u043d");
            }
            while (this.curentModule != 1) {
                if (System.currentTimeMillis() - t > 300000L) {
                    throw new Exception("Did not wait for the main screen");
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            this.updateCommand(cmd, CommandResultType.BadParams, e.getMessage());
            return;
        }
        BufferedImage screenShot = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screens = ge.getScreenDevices();
            if (screens == null || screens[0] == null) {
                throw new Exception("Screen not found");
            }
            Robot robotForScreen = new Robot(screens[0]);
            Rectangle screenBounds = screens[0].getDefaultConfiguration().getBounds();
            screenBounds.x = 0;
            screenBounds.y = 0;
            screenShot = robotForScreen.createScreenCapture(screenBounds);
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043d\u044f\u0442\u0438\u044f \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
            return;
        }
        if (screenShot == null) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435\u0442 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            this.updateCommand(cmd, CommandResultType.BadParams, "\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435\u0442 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            return;
        }
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("\u0421\u043a\u0440\u0438\u043d\u0448\u043e\u0442 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430  [" + new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()) + "], \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ",comment=" + cmd.getComment(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart screenFile = new MimeBodyPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageOutputStream ios = null;
            try {
                ios = ImageIO.createImageOutputStream(os);
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(0.85f);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(screenShot, null, null), iwp);
                writer.dispose();
            }
            finally {
                IOUtils.closeQuietly((Closeable)ios);
            }
            ByteArrayDataSource ds = new ByteArrayDataSource(os.toByteArray(), "image/jpeg");
            screenFile.setDataHandler(new DataHandler((DataSource)ds));
            screenFile.setFileName("screen.jpeg");
            multipart.addBodyPart((BodyPart)screenFile);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendScreenShots(Command cmd) {
        this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u0432");
        Auth auth = null;
        Point point = null;
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
        }
        String email = cmd.getParam1();
        if (email == null || email.isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        LinkedList<BufferedImage> screenShots = new LinkedList<BufferedImage>();
        try {
            GraphicsDevice[] screens;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
                Robot robotForScreen = new Robot(screen);
                Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
                screenBounds.x = 0;
                screenBounds.y = 0;
                BufferedImage buf = robotForScreen.createScreenCapture(screenBounds);
                if (buf == null) continue;
                screenShots.add(buf);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043d\u044f\u0442\u0438\u044f \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
            return;
        }
        if (screenShots.isEmpty()) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435\u0442 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            this.updateCommand(cmd, CommandResultType.BadParams, "Error. No screenshots to send");
            return;
        }
        int count = 0;
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("\u0421\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u044b [" + new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()) + "], \u0442\u043e\u0447\u043a\u0430: " + point.getId() + "/" + point.getName() + ",comment=" + cmd.getComment(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            for (BufferedImage screen : screenShots) {
                MimeBodyPart screenFile = new MimeBodyPart();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageOutputStream ios = null;
                try {
                    ios = ImageIO.createImageOutputStream(os);
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                    ImageWriter writer = iter.next();
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(0.85f);
                    writer.setOutput(ios);
                    writer.write(null, new IIOImage(screen, null, null), iwp);
                    writer.dispose();
                }
                finally {
                    IOUtils.closeQuietly((Closeable)ios);
                }
                ByteArrayDataSource ds = new ByteArrayDataSource(os.toByteArray(), "image/jpeg");
                screenFile.setDataHandler(new DataHandler((DataSource)ds));
                screenFile.setFileName("screen" + count++ + ".png");
                multipart.addBodyPart((BodyPart)screenFile);
            }
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "count:" + count);
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : " count:" + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendScreenShotService(Command cmd) {
        Point point;
        Auth auth;
        this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430 \u043f\u0430\u043f\u043a\u0438 \u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u043c");
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
            this.commandStore.remove(cmd);
            return;
        }
        String email = cmd.getParam1();
        String serviceId = cmd.getParam2();
        if (email == null || email.isEmpty() || serviceId == null || serviceId.trim().isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        this.commandStore.remove(cmd);
        this.log.info((Object)("\u0418\u0449\u0435\u043c \u043f\u0430\u043f\u043a\u0443, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d \u0441\u0435\u0440\u0432\u0438\u0441 id=" + serviceId));
        GroupByServiceIdVisitor gbsiv = new GroupByServiceIdVisitor(Integer.parseInt(serviceId));
        MenuUtils.processMenu((MenuVisitor)gbsiv);
        ServiceType st = gbsiv.getServiceType();
        if (st == null) {
            this.log.error((Object)("\u0421\u0435\u0440\u0432\u0438\u0441\u0430 \u0441 id= " + serviceId + " \u043d\u0435\u0442 \u0432 \u043c\u0435\u043d\u044e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430"));
            this.updateCommand(cmd, CommandResultType.BadParams, "Service with id= " + serviceId + " not found in point menu");
            return;
        }
        this.log.info((Object)("\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043f\u0430\u043f\u043a\u0435: " + st));
        this.log.info((Object)"\u041f\u044b\u0442\u0430\u0435\u043c\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442");
        try {
            Keeper k;
            long t = System.currentTimeMillis();
            if (this.curentModule != 1) {
                this.updateCommand(cmd, CommandResultType.Ok, "\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u043d\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0435");
            }
            while (this.curentModule != 1 || (k = ru.softlogic.app.session.Session.getInstance().getCurrentKeeper()) != null && k.getSum() != null && !k.getSum().isEmpty()) {
                if (System.currentTimeMillis() - t > 600000L) {
                    throw new Exception("Did not wait for inactivity at the terminal");
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            this.updateCommand(cmd, CommandResultType.BadParams, e.getMessage());
            return;
        }
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u043f\u0430\u043f\u043a\u0443");
        UserAction.getInstance().update();
        AppEnvironment.getInstance().open(st);
        this.log.info((Object)"\u0416\u0434\u0435\u043c 2 \u0441\u0435\u043a, \u043f\u043e\u043a\u0430 \u043e\u0442\u043a\u0440\u043e\u0435\u0442\u0441\u044f \u043d\u0443\u0436\u043d\u0430\u044f \u043f\u0430\u043f\u043a\u0430");
        ThreadUtil.sleep((long)2000L);
        this.log.info((Object)"\u0414\u0435\u043b\u0430\u0435\u043c \u0441\u043d\u0438\u043c\u043e\u043a \u044d\u043a\u0440\u0430\u043d\u0430");
        BufferedImage screenShot = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screens = ge.getScreenDevices();
            if (screens == null || screens[0] == null) {
                throw new Exception("Screen not found");
            }
            Robot robotForScreen = new Robot(screens[0]);
            Rectangle screenBounds = screens[0].getDefaultConfiguration().getBounds();
            screenBounds.x = 0;
            screenBounds.y = 0;
            screenShot = robotForScreen.createScreenCapture(screenBounds);
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043d\u044f\u0442\u0438\u044f \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
            return;
        }
        if (screenShot == null) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430. \u041d\u0435\u0442 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            this.updateCommand(cmd, CommandResultType.BadParams, "Error. No screenshot to send");
            return;
        }
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("\u0421\u043a\u0440\u0438\u043d\u0448\u043e\u0442 \u043f\u0430\u043f\u043a\u0438 \u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u043c [" + new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()) + "], \u0442\u043e\u0447\u043a\u0430: " + point.getId() + "/" + point.getName() + ",comment=" + cmd.getComment(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart screenFile = new MimeBodyPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageOutputStream ios = null;
            try {
                ios = ImageIO.createImageOutputStream(os);
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = iter.next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(0.85f);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(screenShot, null, null), iwp);
                writer.dispose();
            }
            finally {
                IOUtils.closeQuietly((Closeable)ios);
            }
            ByteArrayDataSource ds = new ByteArrayDataSource(os.toByteArray(), "image/jpeg");
            screenFile.setDataHandler(new DataHandler((DataSource)ds));
            screenFile.setFileName("screen.jpeg");
            multipart.addBodyPart((BodyPart)screenFile);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430 \u043f\u0430\u043f\u043a\u0438 \u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u043c", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogs(Command cmd, boolean addConfiguration, String ... files) {
        this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u043b\u043e\u0433\u043e\u0432: " + Arrays.toString(files)));
        Auth auth = null;
        Point point = null;
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
        }
        String dateFrom = cmd.getParam1();
        String email = cmd.getParam2();
        String dateTo = cmd.getParam3();
        if (dateTo == null) {
            dateTo = dateFrom;
        }
        if (dateFrom == null || dateFrom.isEmpty() || email == null || email.isEmpty() || dateTo == null || dateTo.isEmpty()) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0441\u043b\u0430\u0442\u044c \u043b\u043e\u0433\u0438 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 [" + dateFrom + "," + dateTo + "] \u043d\u0430 \u0430\u0434\u0440\u0435\u0441 " + email));
        if (auth == null) {
            this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u043e\u0441\u044b\u043b\u043a\u0430 \u043b\u043e\u0433\u0430, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, "The authorization parameters on the mail server are not specified");
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = sdf.parse(dateFrom);
            d2 = sdf.parse(dateTo);
            this.log.info((Object)("\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0434\u0430\u0442\u044b: [" + d1 + "," + d2 + "]"));
        }
        catch (ParseException ex) {
            this.log.info((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u0442\u044b", (Throwable)ex);
        }
        if (d1.after(d2)) {
            Date d = d1;
            d1 = d2;
            d2 = d;
        }
        this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u0430\u0440\u0445\u0438\u0432");
        File arc = null;
        ArchBuilder archBuilder = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d1);
        try {
            archBuilder = new ArchBuilder();
            archBuilder.setLabel("\u0416\u0443\u0440\u043d\u0430\u043b\u044b \u0437\u0430 [" + dateFrom + "," + dateTo + "], \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ", comment=" + cmd.getComment() + ", localtime=" + new Date());
            while (cal.getTime().compareTo(d2) <= 0) {
                Date dl = cal.getTime();
                String dls = sdf.format(dl);
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043b\u043e\u0433\u0438 \u0437\u0430 " + dls));
                String suffix = "." + dls;
                if (sdf.format(new Date()).equals(dls)) {
                    suffix = "";
                }
                for (String file : files) {
                    this.addEntry(archBuilder, file.replace("add/", "").replace(".log", "") + suffix + ".txt", File.separator + "log" + File.separator + file + suffix);
                }
                ((Calendar)cal).add(5, 1);
            }
            if (addConfiguration) {
                this.addEntry(archBuilder, "configuration.xml", "/configuration.xml");
            }
            arc = archBuilder.finish();
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430", (Throwable)ex);
            archBuilder.finish();
        }
        if (arc == null) {
            this.log.info((Object)"\u0410\u0440\u0445\u0438\u0432 \u043f\u0443\u0441\u0442\u043e\u0439. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e");
            this.updateCommand(cmd, CommandResultType.Error, "no data");
            return;
        }
        this.log.info((Object)("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + arc + ", \u0440\u0430\u0437\u043c\u0435\u0440=" + arc.length() / 1024L + " Kb"));
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("\u0416\u0443\u0440\u043d\u0430\u043b\u044b \u0437\u0430 [" + sdf.format(d1) + "," + sdf.format(d2) + "], \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ",comment=" + cmd.getComment(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(arc);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("logs_" + point.getId() + ".zip");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "size=" + arc.length() / 1024L + " Kb");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + arc.length() / 1024L + " Kb");
        }
        finally {
            if (archBuilder != null) {
                archBuilder.finish();
            }
        }
    }

    private void checkDisk(Command cmd) {
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0434\u0438\u0441\u043a\u0430");
        try {
            String disk = PathUtils.getAppDrive();
            this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0434\u0438\u0441\u043a: " + disk));
            OsApi.getInstance().scheduleDiskCheck();
            this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445");
            this.updateCommand(cmd, CommandResultType.Ok, null);
        }
        catch (OsException ex) {
            this.updateCommand(cmd, CommandResultType.Error, ex.getMessage());
            this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430", (Throwable)ex);
        }
        if (cmd.isReboot()) {
            this.reboot(null);
        }
    }

    private void reboot(Command cmd) {
        if (cmd != null) {
            this.updateCommand(cmd, CommandResultType.Ok, null);
        }
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
        SafeReboot.getInstance().reboot();
    }

    private void executeCmd(Command cmd) {
        String cmdLine = cmd.getParam1();
        if (cmdLine == null) {
            this.log.error((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443: " + cmdLine));
        if (cmdLine.startsWith("netstat")) {
            this.sendNetStatData(cmd);
        } else if (cmdLine.startsWith("search-modem")) {
            this.searchModem(cmd);
        } else if (cmdLine.startsWith("search-cardreader")) {
            this.searchCardReader(cmd);
        } else if (cmdLine.startsWith("search-watchdog")) {
            this.searchWatchDog(cmd);
        } else if (cmdLine.startsWith("set-software-watchdog")) {
            this.setSoftwareWatchDog(cmd);
        } else if ("exit".equals(cmdLine)) {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u0443 java \u043c\u0430\u0448\u0438\u043d\u044b");
            this.updateCommand(cmd, CommandResultType.Ok, null);
            SafeReboot.getInstance().restart(0);
        } else {
            try {
                this.updateCommand(cmd, CommandResultType.Ok, null);
                this.executor.executeProcess(cmdLine, 120);
            }
            catch (Exception ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (Throwable)ex);
            }
        }
        if (cmd.isReboot()) {
            this.reboot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchModem(Command cmd) {
        ConnectionManager manager;
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u043e\u0438\u0441\u043a \u043c\u043e\u0434\u0435\u043c\u0430");
        ConnectionManager connectionManager = manager = ManagerFactory.getInstance().getManager();
        synchronized (connectionManager) {
            this.log.info((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0441\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
            OperationResult or = manager.disconnectAll();
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + or));
            ThreadUtil.sleep((long)2000L);
            Object[] ports = PortScanner.scanSerial();
            this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u043e\u0432: " + Arrays.toString(ports)));
            LinkedList<String> ports2 = new LinkedList<String>();
            DeviceConfiguration<SerialPort> dc = Configuration.getInstance().getCashAcceptorConfiguration();
            if (dc != null) {
                ports2.add(dc.getPort().getName());
            }
            if ((dc = Configuration.getInstance().getCoinAcceptorConfiguration()) != null) {
                ports2.add(dc.getPort().getName());
            }
            if ((dc = Configuration.getInstance().getFiscalPrinterConfiguration()) != null) {
                ports2.add(dc.getPort().getName());
            }
            for (Object port : ports) {
                this.log.info((Object)("\u0418\u0449\u0443 \u043c\u043e\u0434\u0435\u043c \u043d\u0430 \u043f\u043e\u0440\u0442\u0435: " + (String)port));
                if (ports2.contains(port)) {
                    this.log.info((Object)"\u041f\u043e\u0440\u0442 \u0437\u0430\u043d\u044f\u0442, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u044e");
                    continue;
                }
                try {
                    SerialPort sp = new SerialPort((String)port);
                    GenericModemApi api = new GenericModemApi(sp);
                    api.look(true);
                    this.log.info((Object)"\u041d\u0430\u0448\u043b\u0438 \u043c\u043e\u0434\u0435\u043c");
                    if (cmd.getParam1().endsWith("-set")) {
                        this.log.info((Object)"\u041f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043c\u043e\u0434\u0435\u043c \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                        Configuration.getInstance().setModemConfiguration(new DeviceConfiguration<SerialPort>(DeviceType.GenericModem, sp));
                        Configuration.getInstance().setUssdCheck(true);
                        Configuration.getInstance().setUssdAutoRequest(true);
                        if (Configuration.getInstance().getWatchDogConfiguration() == null) {
                            this.log.info((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440, \u043f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439");
                            Configuration.getInstance().setWatchDogConfiguration(new DeviceConfiguration<SerialPort>(DeviceType.Software, sp));
                            Configuration.getInstance().setSoftwareWatchDogUse(true);
                        }
                        try {
                            Configuration.getInstance().updateConfiguration();
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                    }
                    this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": " + (String)port);
                    return;
                }
                catch (NoSuchDeviceException ex) {
                    this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0448\u043b\u0438 \u043c\u043e\u0434\u0435\u043c");
                }
            }
        }
        this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": -");
    }

    private void setSoftwareWatchDog(Command cmd) {
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u043f\u0438\u0441\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440");
        if (Configuration.getInstance().getModemConfiguration() != null) {
            this.log.info((Object)("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043c\u043e\u0434\u0435\u043c\u0430: " + Configuration.getInstance().getModemConfiguration()));
            this.log.info((Object)"\u041f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439 \u0441\u0442\u043e\u0440\u043e\u0436");
            Configuration.getInstance().setWatchDogConfiguration(new DeviceConfiguration<SerialPort>(DeviceType.Software, Configuration.getInstance().getModemConfiguration().getPort()));
            Configuration.getInstance().setSoftwareWatchDogUse(true);
            try {
                Configuration.getInstance().updateConfiguration();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": " + Configuration.getInstance().getModemConfiguration().getPort().getName() + "->" + DeviceType.Software);
        } else {
            this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": -");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWatchDog(Command cmd) {
        ConnectionManager manager;
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u043e\u0438\u0441\u043a \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430");
        ConnectionManager connectionManager = manager = ManagerFactory.getInstance().getManager();
        synchronized (connectionManager) {
            this.log.info((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0441\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
            OperationResult or = manager.disconnectAll();
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + or));
            Object[] ports = PortScanner.scanSerial();
            this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u043e\u0432: " + Arrays.toString(ports)));
            LinkedList<String> ports2 = new LinkedList<String>();
            DeviceConfiguration<SerialPort> dc = Configuration.getInstance().getCashAcceptorConfiguration();
            if (dc != null) {
                ports2.add(dc.getPort().getName());
            }
            if ((dc = Configuration.getInstance().getCoinAcceptorConfiguration()) != null) {
                ports2.add(dc.getPort().getName());
            }
            if ((dc = Configuration.getInstance().getFiscalPrinterConfiguration()) != null) {
                ports2.add(dc.getPort().getName());
            }
            LinkedList<DeviceClass> dClasses = new LinkedList<DeviceClass>();
            dClasses.add(DeviceClass.WatchDog);
            LinkedList<SerialPort> activePorts = new LinkedList<SerialPort>();
            for (Object port : ports) {
                if (ports2.contains(port)) continue;
                activePorts.add(new SerialPort((String)port));
            }
            Scanner sc = new Scanner((DeviceTypeFilter)AppDefaults.getInstance());
            Map res = sc.scanSerialPorts(dClasses, null, activePorts, ResourceUtil.getPortsBlacklist((Logger)this.log));
            this.log.info((Object)("\u0421\u043a\u0430\u043d\u043d\u0435\u0440 \u043d\u0430\u0448\u0435\u043b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430: " + res));
            if (res != null && !res.isEmpty()) {
                BasePort bp = (BasePort)res.keySet().iterator().next();
                DeviceType dt = (DeviceType)res.get(bp);
                if (bp instanceof SerialPort && cmd.getParam1().endsWith("-set")) {
                    this.log.info((Object)"\u041f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u0441\u0442\u043e\u0440\u043e\u0436");
                    Configuration.getInstance().setWatchDogConfiguration(new DeviceConfiguration<SerialPort>(dt, (SerialPort)bp));
                    Configuration.getInstance().setSoftwareWatchDogUse(false);
                    try {
                        Configuration.getInstance().updateConfiguration();
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": " + bp.getName() + "->" + dt);
            } else {
                this.log.info((Object)"\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u044b\u0445 \u0442\u0430\u0439\u043c\u0435\u0440\u043e\u0432 \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e");
                if (Configuration.getInstance().getModemConfiguration() != null) {
                    if (cmd.getParam1().endsWith("-set")) {
                        this.log.info((Object)"\u041f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439 \u0441\u0442\u043e\u0440\u043e\u0436");
                        Configuration.getInstance().setWatchDogConfiguration(new DeviceConfiguration<SerialPort>(DeviceType.Software, Configuration.getInstance().getModemConfiguration().getPort()));
                        Configuration.getInstance().setSoftwareWatchDogUse(true);
                        try {
                            Configuration.getInstance().updateConfiguration();
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                    }
                    this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": " + Configuration.getInstance().getModemConfiguration().getPort().getName() + "->" + DeviceType.Software);
                } else {
                    this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": -");
                }
            }
        }
    }

    private void updateCommand(Command cmd, CommandResultType resultType, String comment) {
        if (resultType != null) {
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b " + resultType));
            this.clientInterface.send(new CommandResult(cmd.getId(), resultType, comment));
        }
        this.commandStore.remove(cmd);
    }

    private void addEntry(ArchBuilder ab, String name, String path) throws IOException {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c: \u0438\u043c\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f=" + name + ", \u043f\u0443\u0442\u044c=" + path));
        this.log.info((Object)("\u0418\u0449\u0443 \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0444\u0430\u0439\u043b: " + PathUtils.getAppHome() + path));
        if (new File(PathUtils.getAppHome() + path).exists()) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + PathUtils.getAppHome() + path));
            ab.addEntry(name, PathUtils.getAppHome() + path);
        } else if (new File(PathUtils.getAppHome() + path + ".zip").exists()) {
            this.log.info((Object)"\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442, \u043f\u0440\u043e\u0431\u0443\u044e \u0438\u0441\u043a\u0430\u0442\u044c \u0430\u0440\u0445\u0438\u0432");
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + PathUtils.getAppHome() + path + ".zip"));
            ab.addEntry(name + ".zip", PathUtils.getAppHome() + path + ".zip");
        } else {
            this.log.info((Object)"\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
    }

    private void addEntry(ArchBuilder ab, String name, File file) throws IOException {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c: \u0438\u043c\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f=" + name + ", \u043f\u0443\u0442\u044c=" + file.getAbsolutePath()));
        if (file.exists()) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e: " + file.getAbsolutePath()));
            ab.addEntry(name, file.getAbsolutePath());
        } else {
            this.log.info((Object)"\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
    }

    private String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim().replace("\n", "").replace("\r", "");
    }

    private void sendJavaLog(Command cmd) {
        this.log.info((Object)"Requires sending hardware information");
        Auth auth = null;
        Point point = null;
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
        }
        String email = cmd.getParam1();
        if (email == null || email.isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        List<File> files = AppUtils.getDumps();
        if (files.isEmpty()) {
            this.updateCommand(cmd, CommandResultType.Error, "File not exist");
            return;
        }
        File f = files.get(files.size() - 1);
        this.log.info((Object)("Dump file: " + f.getAbsolutePath()));
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("Java dump, point " + point.getId(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(f);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("hs_err_pid.log");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "size=" + f.length() / 1024L + " Kb");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + f.length() / 1024L + " Kb");
        }
    }

    private void sendPrecessInfo(Command cmd) {
        this.log.info((Object)"Requires send process list");
        Auth auth = null;
        Point point = null;
        try {
            auth = ReferenceManager.getInstance().getAuth();
            point = ReferenceManager.getInstance().getPoint();
        }
        catch (ReferenceException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
        }
        String email = cmd.getParam1();
        if (email == null || email.isEmpty() || auth == null || point == null) {
            this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        File f = new File(PathUtils.getAppHome() + "/bin/processlist");
        if (f.exists()) {
            f.delete();
        }
        try {
            OsApi.getInstance().generatePrecessList();
        }
        catch (OsException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        f = new File(PathUtils.getAppHome() + "/bin/processlist");
        if (!f.exists()) {
            this.updateCommand(cmd, CommandResultType.Error, "File not exist");
            return;
        }
        this.log.info((Object)("ProcessList file: " + f.getAbsolutePath()));
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("Process List, point " + point.getId(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(f);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("processes.csv");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "size=" + f.length() / 1024L + " Kb");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + f.length() / 1024L + " Kb");
        }
    }

    private void updateFirmware(Command cmd) {
        this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
        this.commandStore.remove(cmd);
        this.updateCommand(cmd, CommandResultType.Ok, "");
        CashManager.getDefaultInstance().updateFirmware(new File(PathUtils.getFirmwaresPath()), new UpdateFirmwareListener(){

            public void onResut(String message) {
                CommandLauncher.this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430: " + message));
                CommandLauncher.this.clientInterface.sendEvent(new Event(EventType.Update, message));
            }

            public void onError(String message) {
                CommandLauncher.this.log.info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0445\u043e\u0434\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430: " + message));
                CommandLauncher.this.clientInterface.sendEvent(new Event(EventType.UpdateFault, message));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUSSD(Command cmd) {
        if (cmd.getParam1() == null || cmd.getParam1().isEmpty()) {
            this.updateCommand(cmd, CommandResultType.BadParams, "USSD \u043f\u0443\u0441\u0442\u043e\u0439");
            return;
        }
        if (this.modemPort == null) {
            this.updateCommand(cmd, CommandResultType.BadParams, "\u041c\u043e\u0434\u0435\u043c \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            return;
        }
        ConnectionManager manager = ManagerFactory.getInstance().getManager();
        GenericModemApi modemApi = null;
        ConnectionManager connectionManager = manager;
        synchronized (connectionManager) {
            for (int i = 0; i < 3; ++i) {
                this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e USSD " + cmd.getParam1() + ", \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116 " + i));
                try {
                    this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                    OperationResult or = manager.disconnectAll();
                    this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: " + or));
                    modemApi = new GenericModemApi(this.modemPort);
                    modemApi.open();
                    new ModemIniter(modemApi).process();
                    modemApi.setRegistrationMode(2);
                    Registration reg = modemApi.getRegistration();
                    this.log.info((Object)("Registration info: " + reg));
                    if (reg.getState() == 1 || reg.getState() == 5) {
                        this.log.info((Object)"\u041c\u043e\u0434\u0435\u043c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                        int operId = modemApi.getOperatorId();
                        this.log.info((Object)("operator-id=" + operId));
                        boolean pduRequire = ModemHelper.isPDURequire((String)modemApi.getVendor());
                        String res = modemApi.executeUssd(cmd.getParam1(), cmd.getParam2(), cmd.getParam3(), pduRequire, 5000);
                        this.updateCommand(cmd, CommandResultType.Ok, res);
                        return;
                    }
                    this.log.error((Object)"\u041c\u043e\u0434\u0435\u043c \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                    break;
                }
                catch (Exception ex) {
                    this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \u0441 \u043c\u043e\u0434\u0435\u043c\u043e\u043c", (Throwable)ex);
                }
                finally {
                    if (modemApi != null) {
                        modemApi.close();
                    }
                }
                try {
                    Thread.sleep((long)new Random().nextInt(5000) * 1L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.updateCommand(cmd, CommandResultType.Error, "Request failed");
        }
    }

    private void changePrintSystem(Command cmd) {
        String cmdLine = cmd.getParam1();
        if (cmdLine == null) {
            this.log.error((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
            this.updateCommand(cmd, CommandResultType.BadParams, null);
            return;
        }
        String handler = "Standart";
        if ("1".equals(cmdLine)) {
            handler = "FiscalServer";
        } else if ("2".equals(cmdLine)) {
            handler = "FiscalServerKZ";
        }
        try {
            Configuration.getInstance().setPrintHandler(handler);
            Configuration.getInstance().updateConfiguration();
            this.updateCommand(cmd, CommandResultType.Ok, "PrintSystem changed");
        }
        catch (ConfigurationException ex) {
            this.updateCommand(cmd, CommandResultType.Error, ex.getMessage());
            return;
        }
        if (cmd.isReboot()) {
            this.reboot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendEcardData(Command cmd) {
        boolean success;
        File arc;
        File[] files;
        String errMessage;
        String email;
        Point point;
        Auth auth;
        block42: {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 Ecard");
            if (Configuration.getInstance().getMppkPath() == null) {
                this.log.error((Object)"\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 Ecard");
                this.updateCommand(cmd, CommandResultType.Error, "The path to the Ecard data folder is not specified in the configuration file");
                return;
            }
            String uploadPath = Configuration.getInstance().getMppkPath() + File.separator + "PathToUploadData";
            File uploadFolder = new File(uploadPath);
            if (!uploadFolder.exists()) {
                this.log.error((Object)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u0430\u043f\u043a\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0438, \u0438\u0441\u043a\u043e\u043c\u044b\u0439 \u043f\u0443\u0442\u044c: " + uploadPath));
                this.updateCommand(cmd, CommandResultType.Error, "A folder with data for sending was not found");
                return;
            }
            this.log.info((Object)("\u041f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438: " + uploadPath));
            auth = null;
            point = null;
            try {
                auth = ReferenceManager.getInstance().getAuth();
                point = ReferenceManager.getInstance().getPoint();
            }
            catch (ReferenceException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
            }
            email = cmd.getParam1();
            if (email == null || email.isEmpty()) {
                this.log.error((Object)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430");
                this.updateCommand(cmd, CommandResultType.BadParams, null);
                return;
            }
            if (auth == null) {
                this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u043e\u0441\u044b\u043b\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 Ecard, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                this.updateCommand(cmd, CommandResultType.BadParams, "The authorization parameters on the mail server are not specified");
                return;
            }
            this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u0430\u0440\u0445\u0438\u0432");
            errMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hh-mm");
            files = null;
            arc = new File(uploadPath + File.separator + sdf.format(new Date()) + ".zip");
            success = true;
            try {
                files = uploadFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return false;
                        }
                        return file.getAbsolutePath().endsWith(".enc");
                    }
                });
                arc.createNewFile();
                if (files != null && files.length > 0) {
                    byte[] buf = new byte[1000];
                    ZipOutputStream zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(arc));
                        zos.setLevel(9);
                        String label = "\u0414\u0430\u043d\u043d\u044b\u0435 Ecard, \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ", comment=" + cmd.getComment() + ", localtime=" + new Date();
                        ZipEntry ze = new ZipEntry("label.txt");
                        zos.putNextEntry(ze);
                        zos.write(label.getBytes(), 0, label.getBytes().length);
                        zos.closeEntry();
                        for (File f : files) {
                            int read;
                            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0444\u0430\u0439\u043b: " + f.getAbsolutePath() + ", \u0438\u043c\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + f.getName()));
                            ze = new ZipEntry(f.getName());
                            BufferedInputStream is = null;
                            zos.putNextEntry(ze);
                            is = new BufferedInputStream(new FileInputStream(f));
                            while ((read = ((InputStream)is).read(buf)) >= 0) {
                                zos.write(buf, 0, read);
                            }
                            try {
                                IOUtils.closeQuietly((InputStream)is);
                                zos.closeEntry();
                                continue;
                            }
                            catch (IOException ex) {
                                success = false;
                                break block42;
                            }
                            catch (IOException ex) {
                                try {
                                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: ", (Throwable)ex);
                                    success = false;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        IOUtils.closeQuietly(is);
                                        zos.closeEntry();
                                    }
                                    catch (IOException ex2) {
                                        success = false;
                                        break block42;
                                    }
                                    throw throwable;
                                }
                                try {
                                    IOUtils.closeQuietly((InputStream)is);
                                    zos.closeEntry();
                                }
                                catch (IOException ex3) {
                                    success = false;
                                }
                                break block42;
                            }
                        }
                        break block42;
                    }
                    catch (IOException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: ", (Throwable)ex);
                        success = false;
                        break block42;
                    }
                    finally {
                        if (zos != null) {
                            try {
                                zos.close();
                            }
                            catch (IOException ex) {
                                success = false;
                            }
                        }
                    }
                }
                this.log.error((Object)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
                errMessage = "No data for sending";
                success = false;
            }
            catch (Throwable ex) {
                this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430", ex);
                success = false;
            }
        }
        if (!success) {
            this.log.info((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430, \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e");
            this.updateCommand(cmd, CommandResultType.Error, errMessage);
            arc.delete();
            return;
        }
        this.log.info((Object)"\u0410\u0440\u0445\u0438\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
        boolean sended = false;
        this.log.info((Object)("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + arc + ", \u0440\u0430\u0437\u043c\u0435\u0440=" + arc.length() / 1024L + " Kb"));
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
        Object last = null;
        try {
            Properties props = this.getMailProperties(auth);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
            MimeMessage message = new MimeMessage(session);
            String mailFrom = props.getProperty("mail.from");
            message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email.trim()));
            message.setSubject("\u0414\u0430\u043d\u043d\u044b\u0435 Ecard, \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ", comment=" + cmd.getComment(), "utf-8");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(arc);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("ecard_data_" + (point != null ? Integer.valueOf(point.getId()) : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ".zip");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                try {
                    Transport.send((Message)message);
                    this.updateCommand(cmd, CommandResultType.Ok, "size=" + arc.length() / 1024L + " Kb");
                    this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                    sended = true;
                    break;
                }
                catch (MessagingException ex) {
                    last = ex;
                    this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                    ThreadUtil.sleep((long)20000L);
                    if (i != 4) continue;
                    throw new Exception("Failed to send mail");
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 Ecard", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + arc.length() / 1024L + " Kb");
            sended = false;
        }
        if (sended) {
            this.log.info((Object)"\u0423\u0434\u0430\u043b\u044f\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 (\u043e\u0441\u0442\u0430\u0435\u0442\u0441\u044f \u0430\u0440\u0445\u0438\u0432)");
            for (File f : files) {
                f.delete();
            }
        } else {
            this.log.info((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435, \u0443\u0434\u0430\u043b\u044f\u044e \u0430\u0440\u0445\u0438\u0432");
            arc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendNetStatData(Command cmd) {
        block33: {
            block34: {
                Object last;
                ArchBuilder archBuilder;
                File arc;
                if (OsDetector.current() != 1) break block34;
                File dir = new File("/var/lib/vnstat");
                File tmpDir = null;
                try {
                    tmpDir = File.createTempFile("netstat", "tmp");
                    tmpDir.delete();
                    tmpDir.mkdir();
                }
                catch (IOException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
                this.log.info((Object)("tmp dir " + tmpDir.getAbsolutePath()));
                for (File f : dir.listFiles()) {
                    if (!f.isFile() || f.getName().equals("lo")) continue;
                    BufferedReader br = null;
                    Object pw = null;
                    try {
                        String str;
                        Process proc = Runtime.getRuntime().exec(new String[]{"vnstat", "-i", f.getName(), "-d"});
                        proc.waitFor();
                        pw = new PrintWriter(new File(tmpDir, f.getName() + ".txt"));
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((str = br.readLine()) != null) {
                            ((PrintWriter)pw).println(str);
                        }
                        IOUtils.closeQuietly((Writer)pw);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly(pw);
                        IOUtils.closeQuietly(br);
                    }
                    IOUtils.closeQuietly((Reader)br);
                }
                Auth auth = null;
                Point point = null;
                try {
                    auth = ReferenceManager.getInstance().getAuth();
                    point = ReferenceManager.getInstance().getPoint();
                }
                catch (ReferenceException ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
                }
                if (tmpDir.listFiles() == null || tmpDir.listFiles().length == 0) {
                    this.updateCommand(cmd, CommandResultType.Error, "No files to send");
                } else {
                    block31: {
                        arc = null;
                        archBuilder = null;
                        String title = "\u0421\u0435\u0442\u0435\u0432\u0430\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430, \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ", localtime=" + new Date();
                        try {
                            archBuilder = new ArchBuilder();
                            archBuilder.setLabel(title);
                            for (File f : tmpDir.listFiles()) {
                                this.addEntry(archBuilder, f.getName(), f);
                            }
                            arc = archBuilder.finish();
                        }
                        catch (IOException ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430", (Throwable)ex);
                            archBuilder.finish();
                        }
                        if (arc == null) {
                            this.log.info((Object)"\u0410\u0440\u0445\u0438\u0432 \u043f\u0443\u0441\u0442\u043e\u0439. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e");
                            this.updateCommand(cmd, CommandResultType.Error, "no data");
                            return;
                        }
                        this.log.info((Object)("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + arc + ", \u0440\u0430\u0437\u043c\u0435\u0440=" + arc.length() / 1024L + " Kb"));
                        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
                        last = null;
                        Properties props = this.getMailProperties(auth);
                        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
                        MimeMessage message = new MimeMessage(session);
                        String mailFrom = props.getProperty("mail.from");
                        message.setFrom((Address)new InternetAddress(mailFrom != null ? mailFrom : auth.getUser()));
                        String[] split = cmd.getParam1().split(" ");
                        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(split.length > 1 ? split[1] : split[0]));
                        message.setSubject(title, "utf-8");
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        FileDataSource source = new FileDataSource(arc);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                        messageBodyPart.setFileName("netstat_" + point.getId() + ".zip");
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                        message.setContent((Multipart)multipart);
                        for (int i = 0; i < 5; ++i) {
                            this.log.info((Object)("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0447\u0442\u044b \u2116 " + i));
                            try {
                                Transport.send((Message)message);
                                this.updateCommand(cmd, CommandResultType.Ok, "size=" + arc.length() / 1024L + " Kb");
                                this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
                                break;
                            }
                            catch (MessagingException ex) {
                                last = ex;
                                this.log.error((Object)"\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0442\u0441\u044b\u043b\u043a\u0438", (Throwable)ex);
                                ThreadUtil.sleep((long)20000L);
                                if (i != 4) continue;
                                throw new Exception("Failed to send mail");
                            }
                        }
                        if (archBuilder == null) break block31;
                        archBuilder.finish();
                    }
                    try {
                        Process proc = Runtime.getRuntime().exec(new String[]{"rm", "-r", tmpDir.getAbsolutePath()});
                        proc.waitFor();
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex);
                    }
                }
                break block33;
                catch (Exception ex) {
                    block32: {
                        try {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", (Throwable)ex);
                            this.updateCommand(cmd, CommandResultType.Error, (last != null ? last.getClass() + ":" + this.trim(last.getMessage()) + "," : "") + " size=" + arc.length() / 1024L + " Kb");
                            if (archBuilder == null) break block32;
                        }
                        catch (Throwable throwable) {
                            if (archBuilder != null) {
                                archBuilder.finish();
                            }
                            try {
                                Process proc = Runtime.getRuntime().exec(new String[]{"rm", "-r", tmpDir.getAbsolutePath()});
                                proc.waitFor();
                            }
                            catch (Exception ex2) {
                                this.log.error((Object)ex2);
                            }
                            throw throwable;
                        }
                        archBuilder.finish();
                    }
                    try {
                        Process proc = Runtime.getRuntime().exec(new String[]{"rm", "-r", tmpDir.getAbsolutePath()});
                        proc.waitFor();
                    }
                    catch (Exception ex3) {
                        this.log.error((Object)ex3);
                    }
                    break block33;
                }
            }
            this.updateCommand(cmd, CommandResultType.Error, "Windows is not supported");
        }
    }

    private void printZReportsMem(Command cmd) {
        try {
            ReportResult report = this.printerQueue.reportAndWait(new ReportRequest(KkmOperation.FormReportZMem));
            this.updateCommand(cmd, report.isError() ? CommandResultType.Error : CommandResultType.Ok, report.getMessage());
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.Error, ex.getMessage());
        }
        if (cmd.isReboot()) {
            this.reboot(null);
        }
    }

    @Override
    public void onChange(int moduleType) {
        this.curentModule = moduleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties getMailProperties(Auth auth) throws Exception {
        FileInputStream fis;
        Properties props;
        block5: {
            props = new Properties();
            fis = null;
            try {
                if (auth == null || auth.getEmailSettings() == null || auth.getEmailSettings().trim().isEmpty()) {
                    fis = new FileInputStream(PathUtils.getAppHome() + "/resources/mail-server.properties");
                    props.load(fis);
                    break block5;
                }
                props.load(new StringReader(auth.getEmailSettings()));
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(fis);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return props;
    }

    private void searchCardReader(Command cmd) {
        this.log.info((Object)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u043e\u0438\u0441\u043a \u043a\u0430\u0440\u0442-\u0440\u0438\u0434\u0435\u0440\u0430");
        Object[] ports = PortScanner.scanSerial();
        this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u043e\u0432: " + Arrays.toString(ports)));
        LinkedList<String> ports2 = new LinkedList<String>();
        DeviceConfiguration<SerialPort> dc = Configuration.getInstance().getCashAcceptorConfiguration();
        if (dc != null) {
            ports2.add(dc.getPort().getName());
        }
        if ((dc = Configuration.getInstance().getCoinAcceptorConfiguration()) != null) {
            ports2.add(dc.getPort().getName());
        }
        if ((dc = Configuration.getInstance().getFiscalPrinterConfiguration()) != null) {
            ports2.add(dc.getPort().getName());
        }
        for (Object port : ports) {
            this.log.info((Object)("\u0418\u0449\u0443 \u043a\u0430\u0440\u0442-\u0440\u0438\u0434\u0435\u0440 \u043d\u0430 \u043f\u043e\u0440\u0442\u0435: " + (String)port));
            if (ports2.contains(port)) {
                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u0437\u0430\u043d\u044f\u0442, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u044e");
                continue;
            }
            try {
                SerialPort sp = new SerialPort((String)port);
                SerialDeviceApi api = ApiFactory.createDeviceApi((DeviceType)DeviceType.Sankyo, (SerialPort)sp);
                api.look(true);
                this.log.info((Object)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
                if (cmd.getParam1().endsWith("-set")) {
                    this.log.info((Object)"\u041f\u0440\u043e\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                    Configuration.getInstance().setCardReaderConfiguration(new CardReaderConfiguration<SerialPort>("sankyo3k5", sp));
                    try {
                        Configuration.getInstance().updateConfiguration();
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": " + (String)port);
                return;
            }
            catch (NoSuchDeviceException ex) {
                this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0448\u043b\u0438 \u043a\u0430\u0440\u0442\u0440\u0438\u0434\u0435\u0440");
            }
        }
        this.updateCommand(cmd, CommandResultType.Ok, cmd.getParam1() + ": -");
    }

    private class MailAuthenticator
    extends Authenticator {
        private Auth auth;

        public MailAuthenticator(Auth auth) {
            this.auth = auth;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.auth.getUser(), this.auth.getPassword());
        }
    }
}

