/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.hardware.device.cashin.CashObserver;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.HopperException;

public class CoinMover
implements CashObserver {
    private Hopper hopper;
    private Logger log;

    public CoinMover(Hopper hopper) {
        if (hopper == null) {
            throw new NullPointerException("Hopper");
        }
        this.hopper = hopper;
        this.log = Logger.getLogger((String)"coin");
    }

    public void notify(CashUnit cu) {
        this.log.info((Object)("Move " + cu + " to hopper"));
        try {
            this.hopper.add((MoneyUnit)cu, 1);
            this.log.info((Object)"Moved successfully");
        }
        catch (HopperException ex) {
            ProblemNotifier.getDefaultNotifier().onProblem("Hopper: " + cu + ", " + ex.getMessage());
            this.log.error((Object)"Hopper error", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.info((Object)"IO error", (Throwable)ex);
        }
    }
}

