/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.app.FrameStore;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui.useraction.UserAction;

public class ClickChecker
implements Runnable {
    private long lastAction = System.currentTimeMillis();
    private Logger log = Logger.getLogger((String)"gui");

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        Rectangle r = FrameStore.getFrame().getBounds();
        this.log.info((Object)("Frame bounds: " + r));
        this.log.info((Object)"Add global listener to mouse events");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    ClickChecker.this.lastAction = System.currentTimeMillis();
                }
            }
        }, 16L);
        try {
            this.log.info((Object)"Sleep 5 minutes");
            Thread.sleep(300000L);
            this.log.info((Object)"Try to create robot");
            Robot robot = new Robot();
            Random rnd = new Random();
            this.log.info((Object)"Run thread");
            while (!Thread.currentThread().isInterrupted()) {
                long to = (System.currentTimeMillis() - this.lastAction) / 1000L;
                if (to > 180L) {
                    this.log.info((Object)"Do click");
                    for (int i = 0; i < 5; ++i) {
                        robot.mouseMove(r.x + rnd.nextInt(r.width), r.y + rnd.nextInt(r.height));
                        Thread.sleep(200L);
                    }
                    robot.mouseMove(r.x, r.y);
                    robot.mousePress(16);
                }
                to = (System.currentTimeMillis() - this.lastAction) / 1000L;
                this.log.info((Object)("Click timeout: " + to + "s"));
                if (to > 900L) {
                    ProblemNotifier.getDefaultNotifier().onProblem("No clicks. Last user action: " + UserAction.getInstance().getTimeout() + "s, last mouse action: " + to + "s");
                }
                Thread.sleep(180000L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (AWTException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }
}

