/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.cashin.CashObserver;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.statistic.CashAcceptorStatus;

public class CashAcceptorStatusObserver
extends ManagedCashAcceptor
implements Runnable {
    private static final int ERROR_TIMEOUT = 180000;
    private static final int MAX_ERRORS = 10;
    private static final int MAX_TRIES = 3;
    public static final int FLAG_OK = 1;
    public static final int FLAG_POSSIBLE_JAMM = 1;
    private ClientInterface server;
    private Validator validator;
    private ValidatorStatus localStatus;
    private int localFlags;
    private ValidatorStatus serverStatus;
    private int serverFlags;
    private long lastChange;
    private int errCount;
    private int failTries;
    private StatusObserverImpl observer;
    private RejectObserver rejectObserver;
    private Logger log;

    public CashAcceptorStatusObserver(ClientInterface server, Validator validator) {
        if (server == null) {
            throw new IllegalArgumentException("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        if (validator == null) {
            throw new IllegalArgumentException("\u041a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439");
        }
        this.server = server;
        this.validator = validator;
        this.localStatus = ValidatorStatus.Ok;
        try {
            CashAcceptorStatus status = ReferenceManager.getInstance().getCashAcceptorStatus();
            if (status != null) {
                this.localStatus = ValidatorStatus.getByCode((int)status.getStatus());
                if (this.localStatus == null) {
                    this.localStatus = ValidatorStatus.Ok;
                }
                this.localFlags = status.getFlags();
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        this.lastChange = System.currentTimeMillis();
        this.observer = new StatusObserverImpl();
        this.validator.addStatusObserver((ValidatorStatusListener)this.observer);
        this.rejectObserver = new RejectObserver();
        this.validator.addCashObserver((CashObserver)this.rejectObserver);
        this.validator.addStatisticObserver((StatisticListener)this.rejectObserver);
        this.log = Logger.getLogger((String)"cashin-observer");
        this.log.setAdditivity(false);
    }

    @Override
    public void run() {
        this.log.debug((Object)("\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043b\u0435\u0436\u0435\u043d\u0438\u0435 \u0437\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c " + this.validator));
        while (!Thread.currentThread().isInterrupted()) {
            long now = System.currentTimeMillis();
            ValidatorStatus ls = this.localStatus;
            int flags = this.localFlags;
            if (!(ls == this.serverStatus && flags == this.serverFlags || ls != ValidatorStatus.Ok && flags == this.serverFlags && now - this.lastChange < 180000L)) {
                this.log.debug((Object)("\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 " + this.validator + " \u0442\u0435\u043a\u0443\u0449\u0438\u0439: " + ls + " fl=" + this.localFlags + " \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439: " + this.serverStatus + " fl=" + this.serverFlags));
                this.log.debug((Object)"\u041e\u0442\u0441\u044b\u043b\u0430\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440");
                boolean result = false;
                DeviceStatus ds = new DeviceStatus(Short.valueOf(this.validator.getInfo().getDeviceClass()), ls.getCode(), flags);
                this.server.sendStatus(ds);
                this.lastChange = now;
                this.serverStatus = ls;
                this.serverFlags = flags;
                try {
                    ReferenceManager.getInstance().setCashAcceptorStatus(new CashAcceptorStatus(this.serverStatus.getCode(), this.serverFlags));
                }
                catch (ReferenceException referenceException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.debug((Object)("\u041e\u0441\u0442\u0430\u043d\u043e\u0432 " + this.validator));
    }

    public void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        ++this.failTries;
    }

    public void disable() {
    }

    public void setMaxSum(Sum sum) {
    }

    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
    }

    public String toString() {
        return "CashAcceptorObserver";
    }

    public class RejectObserver
    implements StatisticListener,
    CashObserver {
        public void notify(Event event) {
            if (event != Event.Insert) {
                CashAcceptorStatusObserver.this.errCount++;
            }
            if (CashAcceptorStatusObserver.this.errCount >= 10 && CashAcceptorStatusObserver.this.failTries >= 3 && (CashAcceptorStatusObserver.this.localFlags & 1) == 0) {
                CashAcceptorStatusObserver.this.log.info((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043e\u0442\u043a\u0430\u0437\u043e\u0432. \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f");
                CashAcceptorStatusObserver.this.localFlags = CashAcceptorStatusObserver.this.localFlags | 1;
                CashAcceptorStatusObserver.this.lastChange = System.currentTimeMillis();
            }
        }

        public void notify(CashUnit cu) {
            CashAcceptorStatusObserver.this.errCount = 0;
            CashAcceptorStatusObserver.this.failTries = 0;
            CashAcceptorStatusObserver.this.localFlags = CashAcceptorStatusObserver.this.localFlags & 0xFFFFFFFE;
            if (CashAcceptorStatusObserver.this.localStatus != ValidatorStatus.Ok) {
                CashAcceptorStatusObserver.this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ValidatorStatus.Ok));
                CashAcceptorStatusObserver.this.localStatus = ValidatorStatus.Ok;
                CashAcceptorStatusObserver.this.lastChange = System.currentTimeMillis();
            }
        }
    }

    private class StatusObserverImpl
    implements ValidatorStatusListener {
        private StatusObserverImpl() {
        }

        public void update(ValidatorStatus newStatus) {
            if (CashAcceptorStatusObserver.this.localStatus != newStatus) {
                CashAcceptorStatusObserver.this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + newStatus));
                if (newStatus == ValidatorStatus.Init) {
                    CashAcceptorStatusObserver.this.errCount = 0;
                    CashAcceptorStatusObserver.this.localStatus = ValidatorStatus.Ok;
                } else {
                    CashAcceptorStatusObserver.this.localStatus = newStatus;
                }
                CashAcceptorStatusObserver.this.lastChange = System.currentTimeMillis();
            }
        }
    }
}

