/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticStore;
import ru.softlogic.srv.connector.ClientInterface;

public class CashAcceptorStatisticThread
implements Runnable {
    private static final long TIMEOUT = 86400000L;
    private StatisticStore store;
    private ClientInterface clientInterface;
    private Logger log;

    public CashAcceptorStatisticThread(StatisticStore store, ClientInterface clientInterface) {
        if (store == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 StatisticStore");
        }
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.store = store;
        this.clientInterface = clientInterface;
        this.log = Logger.getLogger((String)"app");
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        while (!Thread.currentThread().isInterrupted()) {
            long current = new Date().getTime() - this.store.getFrom().getTime();
            if (current > 86400000L) {
                this.log.info((Object)"\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0434\u043b\u044f \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
                this.clientInterface.sendStatistics(this.store.resetStatistics());
            }
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Stop thread");
    }
}

