/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.timer;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.apache.log4j.Logger;
import ru.softlogic.cash.acceptor.DriverControl;

public class GuiControl
implements KeyListener {
    private final DriverControl control;
    private final Logger log = Logger.getLogger((String)"cashin");

    public GuiControl(DriverControl control) {
        this.control = control;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.log.info((Object)("Press: " + KeyEvent.getKeyText(e.getKeyCode())));
        switch (e.getKeyCode()) {
            case 112: {
                this.processKey(e, 1);
                break;
            }
            case 113: {
                this.processKey(e, 2);
                break;
            }
            case 114: {
                this.processKey(e, 3);
                break;
            }
            case 115: {
                this.processKey(e, 4);
                break;
            }
            case 120: {
                this.log.info((Object)"Notify stack out");
                this.control.onStackOut();
                break;
            }
            case 121: {
                this.log.info((Object)"Notify jamm");
                this.control.onJamm();
                break;
            }
            case 123: {
                this.log.info((Object)"Notify recover");
                this.control.onRecover();
                break;
            }
        }
    }

    private void processKey(KeyEvent t, int noteId) {
        this.log.info((Object)("Notify note " + noteId));
        if (t.isAltDown()) {
            this.log.info((Object)"Alt is pressed, skip");
        } else if (t.isControlDown()) {
            this.control.onFroudNote(noteId);
        } else if (t.isShiftDown()) {
            this.control.onNote(noteId);
        } else {
            this.control.onProtectedNote(noteId);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

