/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.state;

import org.apache.log4j.Logger;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.AddStateListener;
import ru.softlogic.app.state.DisplayStateListener;
import ru.softlogic.app.state.NetErrorStatistic;
import ru.softlogic.app.state.StateFacadeEngine;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.cash.manager.observer.FraudListener;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.device.print.status.PrinterStatusObserver;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.ups.UPSListener;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.DeviceLockingAction;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.srv.queue.QueueStatus;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;

public class BaseFacadeEngine
implements StateFacadeEngine {
    private Queue queue;
    private CashBox cashinBox;
    private CashBox coinBox;
    private ClientInterface ci;
    private PrinterStatus printerStatus;
    private DeviceClass printerClass;
    private ValidatorStatus validatorStatus;
    private long validatorUpdated;
    private Boolean isDisplayOn;
    private boolean locked;
    private CashAccListener cashAccListener;
    private NetworkListener networkListener;
    private PrinterListener printerListener;
    private LocalDisplayState displayStateLIstener;
    private LocalFraudListener fraudListener;
    private boolean fraudlock;
    private int fraudlocktime;
    private long fraudlocklasttime;
    private NetErrorStatistic networkErrors;
    private boolean networkErrorLogged;
    private LocalUPSListener upsListener;
    private boolean onBattery;
    private TerminalState lastState;
    private DeviceStateListener cdmStateListener;
    private int cdmState;
    private AddStateListener addStateListener;
    private int addState;
    private Logger log = Logger.getLogger((String)"locker");

    public BaseFacadeEngine(Queue queue, CashBox cashinBox, CashBox coinBox, ClientInterface ci) {
        if (queue == null) {
            throw new NullPointerException("Queue");
        }
        if (cashinBox == null) {
            throw new NullPointerException("Cashin box");
        }
        if (coinBox == null) {
            throw new NullPointerException("Coin box");
        }
        if (ci == null) {
            throw new NullPointerException("ClientInterface");
        }
        this.queue = queue;
        this.cashinBox = cashinBox;
        this.coinBox = coinBox;
        this.ci = ci;
        this.cashAccListener = new CashAccListener();
        this.networkListener = new NetworkListener();
        this.printerListener = new PrinterListener();
        this.fraudListener = new LocalFraudListener();
        this.upsListener = new LocalUPSListener();
        this.cdmStateListener = new LocalCDMStateListener();
        this.displayStateLIstener = new LocalDisplayState();
        this.addStateListener = new LocalAddStateListener();
        this.networkErrors = new NetErrorStatistic();
        try {
            this.locked = ReferenceManager.getInstance().isLocked();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ValidatorStatusListener getCashAcceptorListener() {
        return this.cashAccListener;
    }

    public RemoteStatusObserver getNetworkObserver() {
        return this.networkListener;
    }

    public NetObserver getNetworkErrorObserver() {
        return this.networkListener;
    }

    public PrinterStatusObserver getPrinterListener() {
        return this.printerListener;
    }

    public LocalFraudListener getFraudListener() {
        return this.fraudListener;
    }

    public LocalUPSListener getUpsListener() {
        return this.upsListener;
    }

    public LocalDisplayState getDisplayStateLIstener() {
        return this.displayStateLIstener;
    }

    public AddStateListener getAddStateListener() {
        return this.addStateListener;
    }

    @Override
    public TerminalState getState() {
        QueueStatus qs = this.queue.getStatus();
        ReferenceManager rm = null;
        PointOptions po = null;
        Point point = null;
        try {
            rm = ReferenceManager.getInstance();
            po = rm.getPointOptions();
            point = rm.getPoint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean workWithBrokenFiscal = false;
        int netErrorTimeOption = 0;
        int netErrorCountOption = 0;
        DeviceLockingAction[] lockingActions = null;
        if (po != null) {
            workWithBrokenFiscal = po.isWorkWithBrokenFiscal();
            netErrorTimeOption = po.getNotConnectedMinute();
            netErrorCountOption = po.getNotConnectedTry();
            lockingActions = po.getLockingActions();
        }
        int errorCode = 0;
        int warningMask = 0;
        boolean isCashoutErrorLock = false;
        Integer inLimit = null;
        if (point != null) {
            isCashoutErrorLock = point.isCashoutErrorLock();
            inLimit = point.getIncassLimit();
        }
        Long netErrorTime = this.networkErrors.getNetworkErrorTime();
        if (this.onBattery) {
            this.log.error((Object)"Terminal is running on battery");
            errorCode = 8;
        } else if (rm == null) {
            this.log.error((Object)"Can't get reference manager");
            errorCode = 10;
        } else if (this.locked) {
            this.log.error((Object)"Terminal locked on server");
            errorCode = 4;
        } else if (po != null && (qs.getSize() > po.getQueueSize() || qs.getTimeout() > (long)po.getQueueTimeout())) {
            this.log.error((Object)"Too many stored payments");
            errorCode = 2;
        } else if (qs.isDiskError() || this.cashinBox.isDiskError() || this.coinBox.isDiskError()) {
            this.log.error((Object)("Disk error: q=" + qs.isDiskError() + ",cash=" + this.cashinBox.isDiskError() + ",coin=" + this.coinBox.isDiskError()));
            errorCode = 3;
        } else if (rm.getDealer() == null || rm.getPoint() == null || rm.getPointOptions() == null || rm.getMenu() == null || rm.getMenu().getTypes() == null) {
            errorCode = 6;
        } else if (this.fraudlock) {
            if (System.currentTimeMillis() - this.fraudlocklasttime < (long)(this.fraudlocktime * 1000)) {
                errorCode = 1;
            } else {
                this.fraudlock = false;
            }
        } else if (netErrorTimeOption > 0 && netErrorTime != null && (System.currentTimeMillis() - netErrorTime) / 60000L >= (long)netErrorTimeOption) {
            if (!this.networkErrorLogged) {
                this.log.error((Object)("Lock by NetworkErrorTime. " + (System.currentTimeMillis() - netErrorTime) / 1000L + " sec. left"));
                this.networkErrorLogged = true;
            }
            errorCode = 2;
        } else if (netErrorCountOption > 0 && this.networkErrors.getNetworkErrorCount() >= (long)netErrorCountOption) {
            if (this.networkErrorLogged) {
                this.log.error((Object)("Lock by NetworkErrorCount. Error counts: " + this.networkErrors.getNetworkErrorCount()));
                this.networkErrorLogged = true;
            }
            errorCode = 2;
        } else if (this.validatorStatus != null && this.validatorStatus != ValidatorStatus.Ok && this.validatorStatus != ValidatorStatus.Init) {
            DeviceLockingAction dla;
            boolean canCard = false;
            try {
                if (CardModuleStore.getInstance().isInit() && CardModuleStore.getInstance().isReady() && !CardModuleStore.getInstance().isCardReaderOnly()) {
                    canCard = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.validatorStatus.isError()) {
                boolean cAccError = true;
                if (this.validatorStatus == ValidatorStatus.StackOut) {
                    boolean bl = cAccError = System.currentTimeMillis() - this.validatorUpdated > 210000L;
                }
                if (this.validatorStatus == ValidatorStatus.JammInHead || this.validatorStatus == ValidatorStatus.JammInStack) {
                    warningMask |= 0x10;
                } else if (this.validatorStatus == ValidatorStatus.Servicing) {
                    errorCode = 13;
                } else if (cAccError && CashDeviceManager.getInstance().getDefaultCoinValidator() != null) {
                    warningMask |= 2;
                } else if (cAccError) {
                    errorCode = 1;
                }
            }
            if (errorCode != 0) {
                dla = this.getDLA(lockingActions, DeviceClass.CashAcceptor.getCode(), (short)1);
                if (dla != null) {
                    if (dla.getAction() == 0) {
                        errorCode = 0;
                    } else if (dla.getAction() == 1) {
                        errorCode = 0;
                        warningMask |= 2;
                    }
                } else if (canCard) {
                    errorCode = 0;
                    warningMask |= 0x20;
                }
            } else if (warningMask != 0) {
                if (canCard) {
                    warningMask |= 0x20;
                }
                if ((dla = this.getDLA(lockingActions, DeviceClass.CashAcceptor.getCode(), (short)0)) != null) {
                    if (dla.getAction() == 0) {
                        warningMask &= 0xFFFFFFEF;
                        warningMask &= 0xFFFFFFFD;
                        warningMask &= 0xFFFFFFDF;
                    } else if (dla.getAction() == 2) {
                        errorCode = 1;
                        warningMask &= 0xFFFFFFDF;
                    }
                }
            }
        } else if (this.cdmState != 0) {
            warningMask |= 8;
            if (isCashoutErrorLock) {
                errorCode = 11;
            }
        } else if (inLimit != null && this.cashinBox.getKeeper().getSum().add(this.coinBox.getKeeper().getSum()).getBasicSum() >= inLimit) {
            errorCode = 12;
        }
        if (errorCode == 0 && this.printerStatus != null && !this.printerStatus.isWork()) {
            DeviceLockingAction dla = this.getDLA(lockingActions, this.printerClass.getCode(), (short)1);
            if (dla != null) {
                if (dla.getAction() == 2) {
                    errorCode = 5;
                } else if (dla.getAction() == 1) {
                    warningMask |= 1;
                }
            } else if (this.printerClass == DeviceClass.FiscalPrinter && !workWithBrokenFiscal) {
                errorCode = 5;
            } else {
                warningMask |= 1;
            }
        }
        if (errorCode == 0 && this.addState != 0) {
            errorCode = this.addState;
        }
        TerminalState state = new TerminalState(errorCode, warningMask);
        if (this.lastState == null || !this.lastState.equals((Object)state)) {
            Payment p;
            Object obj;
            Pack pack;
            this.lastState = state;
            this.log.info((Object)("Current terminal state: " + state));
            if (state.getErrorCode() == 1 && (state.getWarningMask() & 0x10) > 0 && (pack = Session.getInstance().getPack()) != null && pack.getPayments() != null && !pack.getPayments().isEmpty() && (obj = (p = (Payment)pack.getPayments().get(0)).getData().get("id1")) instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                String msg = "srv-id: " + (pack.getService() == null ? "-" : Integer.valueOf(pack.getService().getId()));
                msg = ie.hasFlag(2048) ? msg + " id1=" + ie.getMaskedValue() : msg + " id1=" + ie.getValue();
                this.ci.sendEvent(new Event(EventType.Jamm, msg));
            }
        }
        return state;
    }

    public DeviceStateListener getCDMStateListener() {
        return this.cdmStateListener;
    }

    private DeviceLockingAction getDLA(DeviceLockingAction[] dlas, short deviceClass, short deviceState) {
        if (dlas == null) {
            return null;
        }
        for (DeviceLockingAction dla : dlas) {
            if (dla == null || dla.getDeviceClass() != deviceClass || dla.getState() != deviceState) continue;
            return dla;
        }
        return null;
    }

    private class LocalAddStateListener
    implements AddStateListener {
        private LocalAddStateListener() {
        }

        @Override
        public void onAddState(int newState) {
            BaseFacadeEngine.this.addState = newState;
        }
    }

    private class LocalDisplayState
    implements DisplayStateListener {
        private LocalDisplayState() {
        }

        @Override
        public void onDisplayState(boolean isOn) {
            if (BaseFacadeEngine.this.isDisplayOn == null || BaseFacadeEngine.this.isDisplayOn != isOn) {
                BaseFacadeEngine.this.isDisplayOn = isOn;
                BaseFacadeEngine.this.ci.sendStatus(new DeviceStatus(Short.valueOf(DeviceClass.Display.getCode()), isOn ? 0 : 2));
            }
        }
    }

    private class LocalCDMStateListener
    implements DeviceStateListener {
        private LocalCDMStateListener() {
        }

        public void onState(DeviceState ds) {
            BaseFacadeEngine.this.cdmState = ds.getState();
        }
    }

    private class LocalUPSListener
    implements UPSListener {
        private LocalUPSListener() {
        }

        @Override
        public void onBatteryMode() {
            BaseFacadeEngine.this.onBattery = true;
        }

        @Override
        public void onLineMode() {
            BaseFacadeEngine.this.onBattery = false;
        }
    }

    private class LocalFraudListener
    implements FraudListener {
        private LocalFraudListener() {
        }

        public void fraudDetected(Integer fraudTimeout) {
            BaseFacadeEngine.this.log.info((Object)("Fraud detected. Lock terminal by " + fraudTimeout + " seconds"));
            BaseFacadeEngine.this.fraudlock = true;
            BaseFacadeEngine.this.fraudlocktime = fraudTimeout == null ? 0 : fraudTimeout;
            BaseFacadeEngine.this.fraudlocklasttime = System.currentTimeMillis();
        }
    }

    private class PrinterListener
    implements PrinterStatusObserver {
        private PrinterListener() {
        }

        public void update(DeviceClass deviceClass, PrinterStatus status) {
            BaseFacadeEngine.this.log.debug((Object)("New printer state: " + deviceClass + "->" + status));
            BaseFacadeEngine.this.printerStatus = status;
            BaseFacadeEngine.this.printerClass = deviceClass;
        }

        public void errorEvent(String comment) {
        }
    }

    private class NetworkListener
    implements RemoteStatusObserver,
    NetObserver {
        private NetworkListener() {
        }

        public void update(int remoteStatus) {
            BaseFacadeEngine.this.log.debug((Object)("Get network state: " + remoteStatus));
            BaseFacadeEngine.this.locked = (remoteStatus & 1) != 0;
            try {
                ReferenceManager.getInstance().updateLockedStatus(BaseFacadeEngine.this.locked);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void update(boolean netError) {
            if (netError) {
                BaseFacadeEngine.this.networkErrors.setNetworkErrorCount(BaseFacadeEngine.this.networkErrors.getNetworkErrorCount() + 1L);
                if (BaseFacadeEngine.this.networkErrors.getNetworkErrorTime() == null) {
                    BaseFacadeEngine.this.networkErrors.setNetworkErrorTime(System.currentTimeMillis());
                }
            } else {
                BaseFacadeEngine.this.networkErrors.setNetworkErrorTime(null);
                BaseFacadeEngine.this.networkErrors.setNetworkErrorCount(0L);
                BaseFacadeEngine.this.networkErrorLogged = false;
            }
        }
    }

    private class CashAccListener
    implements ValidatorStatusListener {
        private CashAccListener() {
        }

        public void update(ValidatorStatus status) {
            BaseFacadeEngine.this.log.info((Object)("New validator state: " + status));
            BaseFacadeEngine.this.validatorUpdated = System.currentTimeMillis();
            BaseFacadeEngine.this.validatorStatus = status;
        }
    }
}

