/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.utils;

import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import ru.softlogic.hardware.device.modem.Registration;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;

public class UssdChecker4Connector
implements Callable<JSONObject> {
    private SerialPort port;
    private Logger log;
    private ConnectionManager manager;

    public UssdChecker4Connector(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.manager = ManagerFactory.getInstance().getManager();
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONObject call() throws Exception {
        GenericModemApi modemApi = null;
        Exception last = null;
        ConnectionManager connectionManager = this.manager;
        synchronized (connectionManager) {
            int i = 0;
            while (i < 5) {
                this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u0438\u0433\u043d\u0430\u043b\u0430 \u043c\u043e\u0434\u0435\u043c\u0430, \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116 " + i));
                try {
                    this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                    OperationResult or = this.manager.disconnectAll();
                    this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: " + or));
                    modemApi = new GenericModemApi(this.port);
                    modemApi.open();
                    new ModemIniter(modemApi).process();
                    this.log.info((Object)"Get modem info");
                    String vendor = modemApi.getVendor();
                    this.log.info((Object)("Vendor=" + vendor));
                    String model = modemApi.getModel();
                    this.log.info((Object)("Model=" + model));
                    String firmare = modemApi.getFirmware();
                    this.log.info((Object)("Firmvare=" + firmare));
                    modemApi.setRegistrationMode(2);
                    Registration reg = modemApi.getRegistration();
                    this.log.info((Object)("Registration info: " + reg));
                    if (reg.getState() == 1 || reg.getState() == 5) {
                        this.log.info((Object)"\u041c\u043e\u0434\u0435\u043c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                        int signalLevel = modemApi.getSignalLevel();
                        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u0438\u0433\u043d\u0430\u043b\u0430: " + signalLevel));
                        JSONObject resp = new JSONObject();
                        resp.put("level", 100 - signalLevel);
                        resp.put("vendor", (Object)vendor);
                        resp.put("model", (Object)model);
                        resp.put("firmare", (Object)firmare);
                        JSONObject jSONObject = resp;
                        return jSONObject;
                    }
                    this.log.error((Object)"\u041c\u043e\u0434\u0435\u043c \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u0441\u0435\u0442\u0438");
                    last = new Exception("The modem is not registered in the network");
                    throw last;
                }
                catch (Exception ex) {
                    last = ex;
                    this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \u0441 \u043c\u043e\u0434\u0435\u043c\u043e\u043c", (Throwable)ex);
                }
                finally {
                    if (modemApi != null) {
                        modemApi.close();
                    }
                }
                try {
                    Thread.sleep(new Random().nextInt(500));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                ++i;
            }
            throw last;
        }
    }
}

