/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html.connector.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.app.html.connector.model.Connector;
import ru.softlogic.app.html.connector.model.ConnectorState;
import ru.softlogic.app.html.connector.model.GuiNotifier;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class ConnectorStateController {
    private ConnectorState previos;
    private Map<ConnectorState, Set<ConnectorState>> jumpTable;
    private Calendar statetime;
    public static final int TimeOut = 90;
    private Logger log;
    private GuiNotifier notifier;
    private Connector connector;
    private ClientInterface clientInterface;

    public ConnectorStateController(GuiNotifier notifier, Connector connector, ClientInterface clientInterface, Logger log) {
        this.clientInterface = clientInterface;
        this.notifier = notifier;
        this.connector = connector;
        this.log = log;
        this.previos = ConnectorState.none;
        this.statetime = new GregorianCalendar();
        this.jumpTable = new HashMap<ConnectorState, Set<ConnectorState>>();
        HashSet<ConnectorState> buf = new HashSet<ConnectorState>();
        buf.add(ConnectorState.load);
        this.jumpTable.put(ConnectorState.none, buf);
        buf = new HashSet();
        buf.add(ConnectorState.begin);
        this.jumpTable.put(ConnectorState.load, buf);
        buf = new HashSet();
        buf.add(ConnectorState.payment);
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.demand);
        this.jumpTable.put(ConnectorState.begin, buf);
        buf = new HashSet();
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.finish);
        buf.add(ConnectorState.cbcactivate);
        buf.add(ConnectorState.reinit);
        this.jumpTable.put(ConnectorState.payment, buf);
        buf = new HashSet();
        buf.add(ConnectorState.load);
        buf.add(ConnectorState.reinit);
        buf.add(ConnectorState.cancel);
        this.jumpTable.put(ConnectorState.finish, buf);
        buf = new HashSet();
        buf.add(ConnectorState.load);
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.reinit);
        this.jumpTable.put(ConnectorState.cancel, buf);
        buf = new HashSet();
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.finish);
        buf.add(ConnectorState.cbcactivate);
        buf.add(ConnectorState.reinit);
        this.jumpTable.put(ConnectorState.cbcactivate, buf);
        buf = new HashSet();
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.payment);
        buf.add(ConnectorState.reinit);
        this.jumpTable.put(ConnectorState.reinit, buf);
        buf = new HashSet();
        buf.add(ConnectorState.none);
        buf.add(ConnectorState.load);
        buf.add(ConnectorState.begin);
        buf.add(ConnectorState.payment);
        buf.add(ConnectorState.cancel);
        buf.add(ConnectorState.finish);
        buf.add(ConnectorState.cbcactivate);
        buf.add(ConnectorState.demand);
        buf.add(ConnectorState.reinit);
        this.jumpTable.put(ConnectorState.ping, buf);
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if ((ConnectorStateController.this.previos == ConnectorState.begin || ConnectorStateController.this.previos == ConnectorState.payment || ConnectorStateController.this.previos == ConnectorState.cbcactivate) && (new GregorianCalendar().getTimeInMillis() - ConnectorStateController.this.statetime.getTimeInMillis()) / 1000L >= 90L) {
                    ConnectorStateController.this.log.error((Object)"\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0441\u0435\u0441\u0441\u0438\u0439. \u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u0438\u0441\u0442\u0435\u043a\u043b\u043e");
                    ConnectorStateController.this.notifier.onError(13107, "Session Controller. Life time expired");
                    ConnectorStateController.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "Session observer: session time is up"));
                    int result = ConnectorStateController.this.connector.onCancel(0);
                    if (result != 0) {
                        ConnectorStateController.this.connector.onCancel(1);
                    }
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public ConnectorState getPrevios() {
        return this.previos;
    }

    public void go2NewState(ConnectorState newState) throws WrongMethodInvocation {
        if (newState == ConnectorState.ping) {
            this.statetime = new GregorianCalendar();
            return;
        }
        if (!this.jumpTable.get((Object)this.previos).contains((Object)newState)) {
            throw new WrongMethodInvocation("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435  " + (Object)((Object)newState) + "  \u0438\u0437 " + (Object)((Object)this.previos));
        }
        this.log.info((Object)("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u043e \u0438\u0437 " + (Object)((Object)this.previos) + " \u0432 " + (Object)((Object)newState)));
        this.previos = newState;
        this.statetime = new GregorianCalendar();
    }

    public void rollback(ConnectorState newState) {
        this.log.info((Object)("\u041e\u0442\u043a\u0430\u0442\u044b\u0432\u0430\u044e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u0432 " + (Object)((Object)newState)));
        this.previos = newState;
    }

    public class WrongMethodInvocation
    extends Exception {
        public WrongMethodInvocation(String message) {
            super(message);
        }
    }
}

