/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html;

import i18n.B;
import it.sauronsoftware.cron4j.Scheduler;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.AppEnvironmentListener;
import ru.softlogic.app.Application;
import ru.softlogic.app.ApplicationException;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.app.configuration.ConfigurationException;
import ru.softlogic.app.configuration.ConfigurationSN;
import ru.softlogic.app.configuration.DeviceConfiguration;
import ru.softlogic.app.configuration.PresentConfiguration;
import ru.softlogic.app.configuration.SerialNumbersStore;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.diagnostic.SimpleProblemNotifier;
import ru.softlogic.app.html.HtmlConnectorApplicationContext;
import ru.softlogic.app.html.connector.utils.UssdChecker4Connector;
import ru.softlogic.app.messages.AppB;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.AppStateWatcherImpl;
import ru.softlogic.app.state.BaseFacadeEngine;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.timer.TimerThread;
import ru.softlogic.application.AppDiskErrorListener;
import ru.softlogic.application.AppHopperStateListener;
import ru.softlogic.application.BDPNUpdater;
import ru.softlogic.application.BannerUpdater;
import ru.softlogic.application.CardEmergencyEventListener;
import ru.softlogic.application.CashAcceptorIdentificationListener;
import ru.softlogic.application.CashAcceptorStatisticObserver;
import ru.softlogic.application.CashAcceptorStatisticThread;
import ru.softlogic.application.CashAcceptorStatusObserver;
import ru.softlogic.application.CoinAcceptorStatusObserver;
import ru.softlogic.application.CommandLauncher;
import ru.softlogic.application.DeviceInfoHandlingSender;
import ru.softlogic.application.DeviceInfoSender;
import ru.softlogic.application.DispenserStatusListener;
import ru.softlogic.application.ECardSender;
import ru.softlogic.application.ErrorDumpProcessor;
import ru.softlogic.application.JammInformer;
import ru.softlogic.application.KkmErrorListener;
import ru.softlogic.application.NetworkInterfaceObserver;
import ru.softlogic.application.NetworkObserver;
import ru.softlogic.application.NetworkStatisticHandler;
import ru.softlogic.application.OpenFilesWatcher;
import ru.softlogic.application.PppWatcher;
import ru.softlogic.application.PrinterInfoListener;
import ru.softlogic.application.PrinterStatusObserver;
import ru.softlogic.application.QueueAgent;
import ru.softlogic.application.Rebooter;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.application.SimplePayoutManager;
import ru.softlogic.application.SystemUpdateListener;
import ru.softlogic.application.UncaughtExceptionListener;
import ru.softlogic.application.UpdateChecker;
import ru.softlogic.application.UssdChecker;
import ru.softlogic.application.VpnObserver;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.application.collection.MoneyCollectionObserver4Connector;
import ru.softlogic.application.disk.DiskObserver;
import ru.softlogic.application.kkm.RefsKkmControl;
import ru.softlogic.application.statistic.adv.AdvStatisticEnviromentListener;
import ru.softlogic.application.statistic.adv.AdvStatisticStore;
import ru.softlogic.application.statistic.adv.AdvStatisticThread;
import ru.softlogic.application.system.PcInfoCollector;
import ru.softlogic.cards.v2.module.CloseDaySchedule;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.BaseCashManager;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.command.CommandStore;
import ru.softlogic.date.DateStore;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.cashin.CashInFactory;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticStore;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.hopper.BaseHopper;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.HopperFactory;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.hardware.device.hopper.IHopper;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.hardware.device.present.Dispenser;
import ru.softlogic.hardware.device.present.DispenserNetworkOptions;
import ru.softlogic.hardware.device.present.DispenserOptions;
import ru.softlogic.hardware.device.present.Factory;
import ru.softlogic.hardware.device.present.StatusListener;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterFactory;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmListener;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.PrinterQueueFactory;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerFactory;
import ru.softlogic.hardware.device.scanner.BarcodeScannerOptions;
import ru.softlogic.hardware.device.scanner.BarcodeScannerType;
import ru.softlogic.hardware.device.scanner.BaseBarcodeScanner;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboard;
import ru.softlogic.hdw.dev.keyboard.VoidExtKeyboard;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.module.DynamicTimeoutManager;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.TimeoutManager;
import ru.softlogic.module.card.CardModuleConfigurator;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.proxy.CardModuleEventsProxy;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.InputModuleFactory;
import ru.softlogic.module.input.admin.AdminInputModule;
import ru.softlogic.module.input.admin.log.ViewAppender;
import ru.softlogic.module.input.hopper.CoinHopperInputModule;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.srv.api.adv.BannerObserver;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.modem.Operator;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.connector.AppStateWatcher;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorFactory;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.queue.DiskErrorListener;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.statistic.PromoStatisticStore;
import ru.softlogic.system.util.AppTimeMarker;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.EventNotifier;
import ru.softlogic.system.util.EventNotifierImpl;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.hwd.SerialExtractorApi;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.update.postproc.Decompressor;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateHandler;
import ru.softlogic.update.updater.UpdateSystem;

public class HtmlTerminalApplication
implements Application {
    private Logger log = Logger.getLogger((String)"start");
    private Printer printer;
    private PrinterQueue printerQueue;
    private Thread printerQueueThread;
    private PrinterStatusObserver printerStatusObserver;
    private Validator cashAcceptor;
    private Thread cashAcceptorThread;
    private CashBox cashAcceptorBox;
    private CashAcceptorStatusObserver cashAcceptorObserver;
    private Thread cashAcceptorObserverThread;
    private Validator coinAcceptor;
    private Thread coinAcceptorThread;
    private CashBox coinAcceptorBox;
    private CashBox flowDownCoinBox;
    private WatchDog watchDog;
    private NetworkObserver netObserver;
    private Thread netObserverThread;
    private JammInformer jammInformer;
    private UssdChecker ussdChecker;
    private UssdChecker4Connector ussdChecker2;
    private List<Thread> threads;
    private HtmlConnectorApplicationContext context;
    private ServerInterface serverInterface;
    private ClientInterface clientInterface;
    private Queue queue;
    private QueueAgent queueAgent;
    private BannerUpdater bannerUpdater;
    private ProcessExecutor executor;
    private List<ru.softlogic.srv.api.event.Event> updateEvents;
    private ScheduledExecutorService scheduler;
    private Scheduler cronScheduler;

    public HtmlTerminalApplication() {
        this.log.setAdditivity(false);
        this.threads = new LinkedList<Thread>();
        this.updateEvents = new LinkedList<ru.softlogic.srv.api.event.Event>();
    }

    public void start() {
        UncaughtExceptionListener exceptionListener = new UncaughtExceptionListener();
        Thread.setDefaultUncaughtExceptionHandler(exceptionListener);
        B.logLocale = AppDefaults.getInstance().getLogLocale();
        this.log.info((Object)("Log locale: " + B.logLocale));
        this.log.info((Object)("System locale: " + Locale.getDefault()));
        this.log.info((Object)B.log((String)"split"));
        Decompressor.process((File)new File(PathUtils.getAppHome()));
        this.log.info((Object)B.log((String)"split"));
        try {
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0430\u0445");
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.log.info((Object)("max window bounds: " + ge.getMaximumWindowBounds()));
            this.log.info((Object)("default screen device: " + ge.getDefaultScreenDevice().getIDstring()));
            GraphicsDevice[] gs = ge.getScreenDevices();
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u043e\u0432: " + gs.length));
            for (int j = 0; j < gs.length; ++j) {
                this.log.info((Object)("  \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0435 " + j));
                GraphicsDevice gd = gs[j];
                this.log.info((Object)("    id: " + gd.getIDstring()));
                this.log.info((Object)("    memory available, Mb: " + gd.getAvailableAcceleratedMemory() / 1024 / 1024));
                this.log.info((Object)("    bounds: " + gd.getDefaultConfiguration().getBounds()));
                DisplayMode dm = gd.getDisplayMode();
                if (dm != null) {
                    this.log.info((Object)"  Current display mode");
                    this.log.info((Object)("    depth: " + dm.getBitDepth()));
                    this.log.info((Object)("    refresh rate: " + dm.getRefreshRate()));
                    continue;
                }
                this.log.info((Object)"Not avaliable");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.log.info((Object)B.log((String)"split"));
        String hddSerial = null;
        try {
            hddSerial = SerialExtractorApi.getInstance().getHddSerial();
            this.log.info((Object)("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 HDD: " + hddSerial));
            this.log.info((Object)("\u041c\u043e\u0434\u0435\u043b\u044c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 : " + SerialExtractorApi.getInstance().getProcessorName()));
        }
        catch (Throwable gs) {
            // empty catch block
        }
        this.log.info((Object)"--- \u0424\u043b\u0430\u0433\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ----------------------------");
        int reboot = 0;
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_neterror")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0432\u0438\u044f \u0441\u0432\u044f\u0437\u0438");
            reboot |= 1;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_cmdreboot")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u043f\u043e \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            reboot |= 2;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_sftupdate")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u041f\u041e");
            reboot |= 4;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_servmenu")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
            reboot |= 8;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_sftupdate_exec")) {
            this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u041f\u041e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
            reboot |= 0x10;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_rpc")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0441\u043b\u0443\u0436\u0431\u044b RPC");
            reboot |= 0x20;
        }
        if (DaemonUtil.checkAndDeleteExitFlag((String)"_flag_schedule")) {
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0431\u044b\u043b\u0430 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
            reboot |= 0x40;
        }
        this.log.info((Object)"--- \u0424\u043b\u0430\u0433\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b ------------------");
        this.scheduler = Executors.newScheduledThreadPool(1);
        try {
            PresentConfiguration pc;
            DeviceConfiguration<SerialPort> hopperCfg;
            try {
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/cash-in/"));
                FileUtil.checkDir((String)(PathUtils.getAppHome() + "/data/network/"));
            }
            catch (Exception j) {
                // empty catch block
            }
            long begin = System.currentTimeMillis();
            Configuration conf = Configuration.getInstance();
            ConnectorConfiguration conn = conf.getDefaultConnectorConfiguration();
            if (conn != null) {
                Properties p = new Properties();
                try {
                    String httpsPort;
                    String httpPort;
                    boolean needUpdate = false;
                    p.load(new FileInputStream(PathUtils.getAppHome() + File.separator + "resources" + File.separator + "update.properties"));
                    this.log.info((Object)"\u0424\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d");
                    String host = p.getProperty("server.host");
                    if (host != null && !host.isEmpty() && !host.equals(conn.getParams().get("server"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("server") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + host));
                        conn.getParams().put("server", host);
                        needUpdate = true;
                    }
                    if ((httpPort = p.getProperty("server.http-port")) != null && !httpPort.isEmpty() && !httpPort.equals(conn.getParams().get("http-port"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 http-\u043f\u043e\u0440\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("http-port") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + httpPort));
                        conn.getParams().put("http-port", httpPort);
                        needUpdate = true;
                    }
                    if ((httpsPort = p.getProperty("server.https-port")) != null && !httpsPort.isEmpty() && !httpsPort.equals(conn.getParams().get("port"))) {
                        this.log.info((Object)("\u041c\u0435\u043d\u044f\u044e \u0441\u0442\u0430\u0440\u044b\u0439 https-\u043f\u043e\u0440\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + (String)conn.getParams().get("port") + " \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 " + httpsPort));
                        conn.getParams().put("port", httpsPort);
                        needUpdate = true;
                    }
                    if (needUpdate) {
                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                        try {
                            conf.updateConfiguration();
                            this.log.info((Object)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                        }
                        catch (ConfigurationException ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", (Throwable)ex);
                        }
                    } else {
                        this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                    }
                }
                catch (IOException needUpdate) {
                    // empty catch block
                }
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            this.executor = new ProcessExecutor();
            OsApi.getInstance().setExecutor(this.executor);
            SequenceManager.getInstance().createManager(conf.getApplicationDir() + File.separator + "sequence");
            Locale loc = conf.getLocale();
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043b\u043e\u043a\u0430\u043b\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + loc));
            Locale.setDefault(loc);
            this.log.info((Object)"*** \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0442\u043e\u0447\u043a\u0435 *******************************");
            try {
                this.log.info((Object)("\u0414\u0438\u043b\u0435\u0440: " + ReferenceManager.getInstance().getDealer()));
                this.log.info((Object)("\u0422\u043e\u0447\u043a\u0430: " + ReferenceManager.getInstance().getPoint()));
            }
            catch (ReferenceException needUpdate) {
                // empty catch block
            }
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ******************");
            CommandStore commandStore = new CommandStore(conf.getApplicationDir() + "/data/commands.obj");
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 ******************");
            PromoStatisticStore.getInstance((String)(conf.getApplicationDir() + "/data/promo.obj"));
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440 **********************************");
            ConnectorConfiguration connectorConfiguration = conf.getDefaultConnectorConfiguration();
            if (connectorConfiguration == null) {
                throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
            }
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
            this.queue = new Queue(conf.getApplicationDir() + "/data/queue.obj", (DiskErrorListener)new AppDiskErrorListener(null));
            this.log.info((Object)"Send system info");
            SystemInfo pcInfo = PcInfoCollector.getPcInfo();
            if (pcInfo != null) {
                pcInfo.setSkinVersion("Telepay HTML");
                SerialNumbersStore store = ConfigurationSN.getInstance().getStore();
                if (store.getNumbers() != null) {
                    if (store.getSerial(SerialNumbersStore.Type.FIRST_MONITOR) != null) {
                        pcInfo.setDisplay1Serial(store.getSerial(SerialNumbersStore.Type.FIRST_MONITOR));
                    }
                    if (store.getSerial(SerialNumbersStore.Type.SECOND_MONITOR) != null) {
                        pcInfo.setDisplay2Serial(store.getSerial(SerialNumbersStore.Type.SECOND_MONITOR));
                    }
                    if (store.getSerial(SerialNumbersStore.Type.TERMINAL) != null) {
                        pcInfo.setInvNumber(store.getSerial(SerialNumbersStore.Type.TERMINAL));
                    }
                }
            }
            this.queue.setSystemInfo(pcInfo);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0435\u0440\u0432\u0435\u0440-\u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            ProxyConfiguration proxy = new ProxyConfiguration();
            proxy.setUseProxy(conf.isUseProxy());
            proxy.setProxyHost(conf.getProxyHost());
            proxy.setProxyPort(conf.getProxyPort());
            proxy.setAuthProxy(conf.isAuthProxy());
            proxy.setProxyUser(conf.getProxyUser());
            proxy.setProxyPassword(conf.getProxyPassword());
            this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b proxy=" + proxy));
            this.serverInterface = ConnectorFactory.createConnector((ConnectorType)connectorConfiguration.getType(), (ConnectorConfiguration)connectorConfiguration, (ProxyConfiguration)proxy, (AppStateWatcher)new AppStateWatcherImpl());
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043b\u0438\u0435\u043d\u0442-\u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            this.clientInterface = new ClientInterface(this.serverInterface, this.queue, conf.isCashEmulator());
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0442\u0441\u044b\u043b\u044c\u0449\u0438\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u043e\u0432");
            this.queueAgent = new QueueAgent(this.queue, commandStore, this.serverInterface);
            if (SystemProp.isSkipSendPackets()) {
                this.log.info((Object)"\u041e\u0442\u0441\u044b\u043b\u043a\u0430 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
            } else {
                Thread queueAgentThread = new Thread((Runnable)this.queueAgent, "QueueAgentThread");
                this.threads.add(queueAgentThread);
            }
            SystemUpdateListener sul = new SystemUpdateListener(this.clientInterface);
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)sul);
            UpdateHandler uh = new UpdateHandler((StateListener)sul);
            this.threads.add(new Thread((Runnable)uh, "Updater"));
            UpdateSystem.setUpdateHandler((UpdateHandler)uh);
            if (SystemProp.isSkipUpdate()) {
                this.log.info((Object)"Update system disabled");
            } else {
                UpdateChecker uc = new UpdateChecker(uh);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)uc);
                this.scheduler.scheduleAtFixedRate(uc, 60L, 120L, TimeUnit.SECONDS);
            }
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)new VpnObserver());
            if (AppDefaults.getInstance().getBooleanProperty("Module.ecard.sender.enable", false)) {
                ECardSender s = new ECardSender();
                Integer timeout = AppDefaults.getInstance().getIntegerValue("Module.ecard.sender.timeout", 1440);
                this.scheduler.scheduleAtFixedRate(s, 5L, timeout.intValue(), TimeUnit.MINUTES);
            }
            if (OpenFilesWatcher.isSupported()) {
                this.scheduler.scheduleAtFixedRate(new OpenFilesWatcher(), 1L, 1L, TimeUnit.MINUTES);
            }
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0437\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a\u0430 \u0431\u0430\u043d\u043d\u0435\u0440\u043e\u0432");
            this.bannerUpdater = new BannerUpdater(this.clientInterface);
            this.threads.add(new Thread((Runnable)this.bannerUpdater, "BannerUpdater"));
            this.serverInterface.addBannerObserver((BannerObserver)this.bannerUpdater);
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)this.bannerUpdater);
            BDPNUpdater bdpnUpdater = new BDPNUpdater(this.clientInterface);
            this.threads.add(new Thread((Runnable)bdpnUpdater, "BDPNUpdater"));
            this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)bdpnUpdater);
            NetworkStatisticHandler nsh = new NetworkStatisticHandler(this.clientInterface);
            this.serverInterface.addNetObserver((NetObserver)nsh);
            this.threads.add(new Thread((Runnable)nsh, "NetworkStatisticHandler"));
            EventNotifier.init(new EventNotifierImpl(this.clientInterface, this.log), new AppTimeMarker());
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043f\u0435\u0447\u0430\u0442\u0438 *****************************");
            this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440");
            DeviceClass printerClass = conf.getPrinterClass();
            if (printerClass == null) {
                throw new ApplicationException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
            }
            switch (printerClass) {
                case IppPrinter: {
                    this.printer = PrinterFactory.createIppPrinter((String)conf.getIppPrinterName(), (boolean)true, (IppPrinterOptions)conf.getIppPrinterOptions(), (String)AppDefaults.getInstance().getProperty("printer.ipp.render"));
                    break;
                }
                case PosPrinter: {
                    DeviceConfiguration<Port> prnCfg = conf.getPosPrinterConfiguration();
                    if (prnCfg == null) {
                        throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                    }
                    this.printer = PrinterFactory.createPosPrinterInstance((DeviceType)prnCfg.getDeviceType(), (Port)prnCfg.getPort(), (PosPrinterOptions)conf.getPosPrinterOptions());
                    if (this.printer == null) {
                        throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0442\u0435\u0440 " + prnCfg.getDeviceType() + " \u0434\u043b\u044f " + prnCfg.getPort().getName());
                    }
                    this.log.info((Object)"Pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                    break;
                }
                case FiscalPrinter: {
                    DeviceConfiguration<SerialPort> frCfg = conf.getFiscalPrinterConfiguration();
                    if (frCfg == null) {
                        throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                    }
                    this.printer = PrinterFactory.createFiscalPrinterInstance((DeviceType)frCfg.getDeviceType(), (Port)frCfg.getPort(), (boolean)conf.isFiscalPrinterMode(), (KkmOptions)conf.getKkmOptions(), (KkmControl)new RefsKkmControl());
                    if (this.printer == null) {
                        throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0442\u0435\u0440 " + frCfg.getDeviceType() + " \u0434\u043b\u044f " + frCfg.getPort().getName());
                    }
                    if (this.printer instanceof Kkm) {
                        ((Kkm)this.printer).addKkmListener((KkmListener)new KkmErrorListener(this.clientInterface));
                        this.log.info((Object)"\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                        break;
                    }
                    this.log.info((Object)"\u041f\u043e\u0441-\u043f\u0440\u0438\u043d\u0442\u0435\u043d \u043d\u0430 \u0431\u0430\u0437\u0435 \u043a\u043a\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                    break;
                }
            }
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0435\u0447\u0430\u0442\u0438");
            this.printerQueue = PrinterQueueFactory.createPrinterQueue((Printer)this.printer, (String)conf.getPrintHandler());
            this.log.info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432, \u0440\u0435\u0430\u043a\u0446\u0438\u044f \u043d\u0430 \u0434\u0430\u0442\u0447\u0438\u043a \u0441\u043a\u043e\u0440\u043e\u0433\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043b\u0435\u043d\u0442\u044b: " + conf.isUsePaperNearEndSensor()));
            this.printerStatusObserver = new PrinterStatusObserver(this.clientInterface, conf.isUsePaperNearEndSensor());
            this.log.info((Object)"\u041f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u044f\u044e \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
            this.printerQueue.addObserver((ru.softlogic.hardware.device.print.status.PrinterStatusObserver)this.printerStatusObserver);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u0435\u0447\u0430\u0442\u0438");
            this.printerQueueThread = new Thread((Runnable)this.printerQueue, "PrinterQueueThread");
            this.threads.add(this.printerQueueThread);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
            this.printerQueue.addInfoListener((ru.softlogic.hardware.device.print.queue.PrinterInfoListener)new PrinterInfoListener(this.clientInterface));
            this.log.info((Object)"\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0430. \u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ****************");
            CommandLauncher commandLauncher = new CommandLauncher(commandStore, this.clientInterface, this.printerQueue, this.executor, conf.getModemConfiguration() == null ? null : conf.getModemConfiguration().getPort());
            this.threads.add(new Thread((Runnable)commandLauncher, "CommandLauncher"));
            this.threads.add(new Thread((Runnable)new TimerThread(), "TimerThread"));
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043f\u0440\u0438\u0435\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 ******************");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u0443\u043f\u044e\u0440");
            this.cashAcceptorBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/cash-acceptor.obj", DeviceClass.CashAcceptor);
            this.coinAcceptorBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/coin-acceptor.obj", DeviceClass.CoinAcceptor);
            this.flowDownCoinBox = new CashBox(conf.getApplicationDir() + "/data/cash-in/coin-flowbox.obj", DeviceClass.CoinAcceptor);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a");
            DeviceConfiguration<SerialPort> cashAccCfg = conf.getCashAcceptorConfiguration();
            if (cashAccCfg == null) {
                throw new ApplicationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            }
            this.cashAcceptor = CashInFactory.createInstance((DeviceType)cashAccCfg.getDeviceType(), (SerialPort)cashAccCfg.getPort());
            if (this.cashAcceptor == null) {
                throw new ApplicationException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a " + cashAccCfg.getDeviceType());
            }
            CashDeviceManager.getInstance().setDefaultCashValidator(this.cashAcceptor);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            this.cashAcceptorThread = new Thread((Runnable)this.cashAcceptor, "CashAcceptorThread");
            this.threads.add(this.cashAcceptorThread);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439");
            MoneyCollectionHandler cashCollectionHandler = new MoneyCollectionHandler(this.cashAcceptorBox);
            MoneyCollectionHandler coinCollectionHandler = new MoneyCollectionHandler(this.coinAcceptorBox);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0437\u0430 \u0432\u044b\u0434\u0435\u0440\u0433\u0438\u0432\u0430\u043d\u0438\u0435\u043c \u043a\u0430\u0441\u0441\u0435\u0442\u044b");
            MoneyCollectionObserver4Connector moneyCollectionObserver = new MoneyCollectionObserver4Connector(cashCollectionHandler, coinCollectionHandler);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)moneyCollectionObserver);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0435\u0440\u0430 \u043f\u043e \u0437\u0430\u0436\u0435\u0432\u044b\u0432\u0430\u043d\u0438\u044e");
            this.jammInformer = new JammInformer(this.clientInterface);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)this.jammInformer);
            this.log.info((Object)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            StatisticStore statisticStore = new StatisticStore(conf.getApplicationDir() + "/data/cash-in/cash-acceptor-stat.obj", DeviceClass.CashAcceptor);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            final CashAcceptorStatisticObserver statisticObserver = new CashAcceptorStatisticObserver(statisticStore);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
            this.cashAcceptor.addStatisticObserver((StatisticListener)statisticObserver);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            Thread statisticThread = new Thread((Runnable)new CashAcceptorStatisticThread(statisticStore, this.clientInterface), "CashAcceptorStatisticThread");
            this.threads.add(statisticThread);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            AdvStatisticStore ass = new AdvStatisticStore(conf.getApplicationDir() + "/data/adv-stat.obj");
            AppEnvironment.getInstance().addListener((AppEnvironmentListener)new AdvStatisticEnviromentListener(ass));
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
            Thread advStatisticThread = new Thread((Runnable)new AdvStatisticThread(ass, this.clientInterface), "AdvStatisticThread");
            this.threads.add(advStatisticThread);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.setDefaultInstance((CashManager)new BaseCashManager(this.cashAcceptorBox, this.coinAcceptorBox, new BaseCashManager.PermitListener(){

                @Override
                public void onPermit() {
                    statisticObserver.notify(Event.ProgramReject);
                }
            }));
            this.log.info((Object)"\u041c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430");
            this.cashAcceptorObserver = new CashAcceptorStatusObserver(this.clientInterface, this.cashAcceptor);
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0439 \u043f\u043e\u0442\u043e\u043a");
            this.cashAcceptorObserverThread = new Thread((Runnable)this.cashAcceptorObserver, "CashAcceptorObserverThread");
            this.threads.add(this.cashAcceptorObserverThread);
            this.log.info((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439");
            CashAcceptorIdentificationListener acceptorSnListener = new CashAcceptorIdentificationListener(this.clientInterface, this.cashAcceptor);
            this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
            this.cashAcceptor.addStatusObserver((ValidatorStatusListener)acceptorSnListener);
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043a \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.cashAcceptor);
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u043a \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
            CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.cashAcceptorObserver);
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a");
            this.log.info((Object)"\u0423\u0447\u0435\u0442 \u043a\u0443\u043f\u044e\u0440:");
            this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439");
            DeviceConfiguration<SerialPort> coinAccCfg = conf.getCoinAcceptorConfiguration();
            if (coinAccCfg != null) {
                this.createLoggerWithViewAppender("coin", "coin", "cashinview");
                this.coinAcceptor = CashInFactory.createInstance((DeviceType)coinAccCfg.getDeviceType(), (SerialPort)coinAccCfg.getPort());
                if (this.coinAcceptor != null) {
                    this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                    this.coinAcceptorThread = new Thread((Runnable)this.coinAcceptor, "CoinAcceptorThread");
                    this.threads.add(this.coinAcceptorThread);
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0437\u0430 \u0432\u044b\u0434\u0435\u0440\u0433\u0438\u0432\u0430\u043d\u0438\u0435\u043c \u043a\u0430\u0441\u0441\u0435\u0442\u044b");
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)moneyCollectionObserver);
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
                    CoinAcceptorStatusObserver caso = new CoinAcceptorStatusObserver(this.clientInterface);
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0435\u0433\u043e \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)caso);
                    this.log.info((Object)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f:");
                    this.log.info((Object)"  \u0421\u043e\u0437\u0434\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439");
                    CashAcceptorIdentificationListener coinAcceptorSnListener = new CashAcceptorIdentificationListener(this.clientInterface, this.coinAcceptor);
                    this.log.info((Object)"  \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u043a \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0443");
                    this.coinAcceptor.addStatusObserver((ValidatorStatusListener)coinAcceptorSnListener);
                    CashManager.getDefaultInstance().addCashDevice((ManagedCashAcceptor)this.coinAcceptor);
                    CashDeviceManager.getInstance().setDefaultCoinValidator(this.coinAcceptor);
                } else {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043d\u0438\u043a\u0430");
                }
            } else {
                this.log.info((Object)"\u041c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442");
            }
            this.log.info((Object)"\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u0440\u0438\u0435\u043c\u0430 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0442\u0440\u0435\u0434\u0441\u0442\u0432 \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430 \u0441\u0435\u0442\u0438 *******************");
            this.netObserver = new NetworkObserver((reboot & 1) > 0);
            this.netObserverThread = new Thread((Runnable)this.netObserver, "NetObserverThread");
            this.threads.add(this.netObserverThread);
            this.serverInterface.addNetObserver((NetObserver)this.netObserver);
            DeviceConfiguration<SerialPort> wdogCfg = conf.getWatchDogConfiguration();
            if (wdogCfg != null) {
                this.log.info((Object)("\u0422\u0438\u043f \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + wdogCfg.getDeviceType()));
                this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + conf.getWatchDogSettings()));
                this.watchDog = WatchDogFactory.createInstance((DeviceType)wdogCfg.getDeviceType(), (SerialPort)wdogCfg.getPort(), (WatchDogSettings)conf.getWatchDogSettings());
            } else {
                this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430. \u041f\u0440\u043e\u0431\u0443\u044e \u043d\u0430\u0439\u0442\u0438 \u0442\u0430\u0439\u043c\u0435\u0440\u044b \u043d\u0430 \u0448\u0438\u043d\u0435 USB");
                this.watchDog = WatchDogFactory.createInstance();
            }
            if (this.watchDog != null) {
                this.clientInterface.send(this.watchDog.getInfo());
                this.log.info((Object)("\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440 \u043d\u0430\u0439\u0434\u0435\u043d: " + this.watchDog.getInfo()));
                this.log.info((Object)"\u041f\u043e\u0434\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0441\u044c \u043d\u0430 \u043f\u0440\u043e\u0441\u043b\u0443\u0448\u043a\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
                this.netObserver.setWatchDog(this.watchDog);
            } else {
                this.log.error((Object)"\u0421\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440 \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
            }
            DeviceInfoSender dis = new DeviceInfoSender(this.clientInterface);
            BarcodeScannerType bst = conf.getBarcodeScannerType();
            if (bst == BarcodeScannerType.Serial) {
                BaseBarcodeScanner bbs;
                DeviceConfiguration<SerialPort> sp = conf.getBarcodeScannerConfiguration();
                if (sp != null && (bbs = BarcodeScannerFactory.createSerialScanner((DeviceType)sp.getDeviceType(), (SerialPort)sp.getPort(), (BarcodeScannerOptions)new BarcodeScannerOptions(), (DeviceInfoListener)dis)) != null) {
                    this.threads.add(new Thread((Runnable)bbs, "BarcodeScanner"));
                    BarcodeScanner.setScanner((BarcodeScanner)bbs);
                }
            } else if (bst == BarcodeScannerType.Keyboard) {
                BarcodeScanner.setScanner((BarcodeScanner)BarcodeScannerFactory.createKeyboardScanner((BarcodeScannerOptions)new BarcodeScannerOptions(), (DeviceInfoListener)dis));
            }
            if (BarcodeScanner.getScanner() == null) {
                BarcodeScanner.setScanner((BarcodeScanner)BarcodeScannerFactory.createScannerStub(null));
            }
            if ((hopperCfg = conf.getCoinHopperConfiguration()) != null) {
                this.log.info((Object)("\u0422\u0438\u043f \u0445\u043e\u043f\u043f\u0435\u0440\u0430: " + hopperCfg.getDeviceType()));
                BaseHopper baseHopper = HopperFactory.createInstance((DeviceType)hopperCfg.getDeviceType(), (SerialPort)hopperCfg.getPort(), (CashBox)this.coinAcceptorBox, (CashBox)this.flowDownCoinBox, (PayoutManager)new SimplePayoutManager(), (DeviceInfoListener)new DeviceInfoSender(this.clientInterface), (HopperStateListener)new AppHopperStateListener(this.clientInterface));
                if (baseHopper != null) {
                    this.threads.add(new Thread((Runnable)baseHopper, "HopperThread"));
                    this.log.info((Object)"\u0425\u043e\u043f\u043f\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                    Hopper.setDefaultHopper((IHopper)baseHopper);
                } else {
                    this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0445\u043e\u043f\u043f\u0435\u0440");
                }
            }
            if ((pc = conf.getPresentConfiguration()) != null) {
                this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432");
                this.log.info((Object)("\u0422\u0438\u043f: " + pc.getType() + ", \u0434\u0440\u0430\u0439\u0432\u0435\u0440: " + pc.getDriver()));
                if ("NetworkModule".equalsIgnoreCase(pc.getType())) {
                    Dispenser dispenser = Factory.createNetwork((String)pc.getDriver(), (DispenserOptions)pc.getOptions(), (DispenserNetworkOptions)pc.getNetworkOptions(), (StatusListener)new DispenserStatusListener(this.clientInterface), (DeviceInfoListener)dis);
                    Dispenser.setInstance((Dispenser)dispenser);
                    if (dispenser != null) {
                        this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u0441\u043e\u0437\u0434\u0430\u043d.");
                        this.threads.add(new Thread((Runnable)dispenser, "PresentDispencer"));
                    }
                }
            } else {
                this.log.info((Object)"\u041c\u043e\u0434\u0443\u043b\u044c \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            try {
                CardModuleConfigurator cmc = null;
                cmc = new CardModuleConfigurator(new File(PathUtils.getAppHome()), this.log);
                cmc.start(new DeviceInfoHandlingSender(this.clientInterface), new DeviceInfoHandlingSender(this.clientInterface), new CardEmergencyEventListener(this.clientInterface));
                this.log.info((Object)("\u041c\u043e\u0434\u0443\u043b\u044c \u043f\u043e \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u043c\u0438 \u043a\u0430\u0440\u0442\u0430\u043c\u0438: " + cmc.getManager()));
                this.threads.addAll(cmc.getThreads());
                CardModuleStore.getInstance().setManager(cmc.getManager());
                CardModuleStore.getInstance().setCardReaderOnly(cmc.isCardReaderOnly());
                Runnable closeDayTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CardModuleStore.getInstance().openSession(new CardModuleEventsProxy()).closeBusinessDay();
                        }
                        catch (IllegalStateException ex) {
                            HtmlTerminalApplication.this.log.info((Object)"day not closed");
                        }
                    }
                };
                CloseDaySchedule closeDaySchedule = cmc.getManager().getCloseDaySchedule();
                if (closeDaySchedule != null) {
                    for (CloseDaySchedule.Day d : CloseDaySchedule.Day.values()) {
                        CloseDaySchedule.Time time = closeDaySchedule.getTime(d);
                        if (time == null) continue;
                        this.cronScheduler.schedule("" + time.getMinute() + " " + time.getHour() + " * * " + d.toString(), closeDayTask);
                        this.log.info((Object)("Scheduled closeday task at: " + time.getHour() + ":" + time.getMinute() + " " + d.toString()));
                    }
                    this.cronScheduler.start();
                    this.log.info((Object)"Closeday scheduler thread started");
                } else {
                    this.log.info((Object)"Schedule of closeday tasks is not available");
                }
            }
            catch (Throwable e) {
                this.log.info((Object)("BankCard module is not available, " + e.getMessage()));
            }
            if (ExtKeyboard.getInstance() == null) {
                ExtKeyboard.setInstance((ExtKeyboard)new VoidExtKeyboard());
            }
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f ppp-\u0441\u043e\u0434\u0438\u043d\u0435\u043d\u0438\u044f: " + conf.isPppUse()));
            if (conf.isPppUse()) {
                this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                this.threads.add(new Thread((Runnable)new PppWatcher(conf.getPppName()), "PppWatcher"));
            } else {
                this.log.info((Object)"\u041e\u043f\u043e\u0432\u0435\u0449\u0430\u044e \u0441\u0435\u0440\u0432\u0435\u0440 \u043e\u0431 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
                this.clientInterface.sendModemState(new ModemState(null, 0, new Operator(1, ""), null, null, null));
            }
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0438 \u0443\u0440\u043e\u0432\u043d\u044f \u0441\u0438\u0433\u043d\u0430\u043b\u0430: " + conf.isUssdCheck()));
            if (conf.getModemConfiguration() != null && conf.getModemConfiguration().getPort() != null) {
                this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043c\u043e\u0434\u0435\u043c\u0435 \u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
                this.createLoggerWithViewAppender("modem", "add/modem", "modemview");
                this.ussdChecker = new UssdChecker(this.clientInterface, new DateStore(conf.getApplicationDir() + "/data/ussd.obj"), conf.getUssdRequest(), conf.getModemConfiguration().getPort(), conf.isUssdCheck());
                this.threads.add(new Thread((Runnable)this.ussdChecker, "ModemBalanceChecker"));
                this.ussdChecker2 = new UssdChecker4Connector(conf.getModemConfiguration().getPort());
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432:");
            this.threads.add(new Thread((Runnable)new NetworkInterfaceObserver(this.clientInterface), "NetworkInterfaceChecker"));
            this.log.info((Object)"************* \u0417\u0430\u043f\u0443\u0441\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f *************");
            this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f");
            BaseFacadeEngine stateFacade = new BaseFacadeEngine(this.queue, this.cashAcceptorBox, this.coinAcceptorBox, this.clientInterface);
            StateFacade.setEngine(stateFacade);
            this.cashAcceptor.addStatusObserver(stateFacade.getCashAcceptorListener());
            this.printerQueue.addObserver(stateFacade.getPrinterListener());
            this.serverInterface.addRemoteStatusObserver(stateFacade.getNetworkObserver());
            if (conf.getRendering() != null) {
                GuiOptions.setRendering((Rendering)conf.getRendering());
            }
            TimeoutManager.setInstance(new DynamicTimeoutManager());
            this.log.info((Object)"************* \u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ********************");
            Keeper kp = Session.getInstance().getCurrentKeeper();
            if (kp != null && !kp.getSum().isEmpty()) {
                Pack pack = Session.getInstance().getPack();
                this.log.info((Object)("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u0438\u0437\u043b\u0438\u0448\u0435\u043a " + kp));
                PackUtility.printPack("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", Session.getInstance().getPack());
                if (Session.getInstance().isPaymentAddedToQueue() && (pack == null || pack.getPaybackType() == 1 || pack.getPaybackType() == 2)) {
                    this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043f\u043e\u043c\u0435\u0449\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043d\u0435 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436");
                } else if (Session.getInstance().isPaymentAddedToQueue() && pack != null && pack.getPaybackType() != 0) {
                    this.log.info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043f\u043e\u043c\u0435\u0449\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439, \u043d\u043e \u043e\u0441\u0442\u0430\u043b\u0430\u0441\u044c \u0441\u0434\u0430\u0447\u0430. \u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0430 \u0441\u0434\u0430\u0447\u0443");
                    PaymentHelper.sendFaultPayment(this.clientInterface, false);
                } else {
                    this.log.info((Object)"\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436");
                    PaymentHelper.sendFaultPayment(this.clientInterface, true);
                }
                Session.getInstance().setCurrentKeeper(null);
            }
            this.log.info((Object)"*** \u0421\u043e\u0437\u0434\u0430\u044e \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440  ******************************");
            this.context = new HtmlConnectorApplicationContext(CashManager.getDefaultInstance(), this.printerQueue, this.clientInterface, this.jammInformer, this.watchDog, this.scheduler, this.ussdChecker2);
            this.context.addModuleTyteListener(commandLauncher);
            this.context.addModuleTyteListener(SafeReboot.getInstance());
            moneyCollectionObserver.setContext(this.context);
            cashCollectionHandler.setApplicationContext(this.context);
            coinCollectionHandler.setApplicationContext(this.context);
            this.context.setCollectionHandlers(cashCollectionHandler, coinCollectionHandler);
            moneyCollectionObserver.setConnector(this.context.getConnector());
            ProblemNotifier.setDefaultNotifier((ProblemNotifier)new SimpleProblemNotifier(this.context));
            InputModuleFactory.init(this.context);
            this.log.info((Object)"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u044e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
            InputModule sp = InputModuleFactory.getModule(ProviderType.AdminProvider);
            if (sp != null && sp instanceof AdminInputModule) {
                AdminInputModule ap = (AdminInputModule)sp;
                ap.setCollectionHandlers(cashCollectionHandler, coinCollectionHandler);
                this.cashAcceptor.addStatusObserver((ValidatorStatusListener)ap);
                this.cashAcceptor.addStatusObserver((ValidatorStatusListener)this.context);
                this.printerQueue.addObserver((ru.softlogic.hardware.device.print.status.PrinterStatusObserver)ap);
                this.printerQueue.addObserver((ru.softlogic.hardware.device.print.status.PrinterStatusObserver)this.context);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)ap);
                this.serverInterface.addRemoteStatusObserver((RemoteStatusObserver)this.context);
                this.serverInterface.addNetObserver((NetObserver)ap);
                this.serverInterface.addNetObserver((NetObserver)this.context);
            }
            if (Hopper.getDefaultHopper() != null && (sp = InputModuleFactory.getModule(ProviderType.CoinHopperProvider)) != null && sp instanceof CoinHopperInputModule) {
                CoinHopperInputModule chim = (CoinHopperInputModule)sp;
                chim.setCoinBox(this.coinAcceptorBox);
            }
            int startTime = (int)((System.currentTimeMillis() - begin) / 1000L);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            String res = (int)dim.getWidth() + "x" + (int)dim.getHeight();
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + startTime + " c"));
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u0438: ");
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e                   : " + DaemonVersion.version));
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f Java                 : " + SystemProp.getJavaVersion()));
            this.log.info((Object)("  \u0412\u0435\u0440\u0441\u0438\u044f OS                   : " + SystemProp.getOSName() + " " + SystemProp.getOSVersion() + " " + SystemProp.getOSArch()));
            this.log.info((Object)("  \u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f         : " + conf.getApplicationDir()));
            this.log.info((Object)("  \u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u044d\u043a\u0440\u0430\u043d\u0430           : " + res));
            this.threads.add(new Thread((Runnable)new DiskObserver(this.clientInterface), "DiskObserver"));
            this.threads.add(new Thread((Runnable)new Rebooter(stateFacade.getDisplayStateLIstener()), "Rebooter"));
            this.threads.add(new Thread((Runnable)new ErrorDumpProcessor(this.clientInterface), "ErrorDumpProcessor"));
            this.log.info((Object)"*** \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a\u0438 ***********************************");
            for (Thread t : this.threads) {
                this.log.info((Object)("\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e: " + t.getName()));
                t.start();
            }
            this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            try {
                this.context.start();
                if ((reboot & 0x40) == 0) {
                    this.clientInterface.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.Start, "cause=" + AppB.get("start." + Integer.toHexString(reboot)) + ", app.st=" + startTime));
                }
                for (ru.softlogic.srv.api.event.Event event : this.updateEvents) {
                    this.clientInterface.sendEvent(event);
                }
                Object obj = DaemonUtil.readObject((String)"_update_exception", (boolean)true);
                if (obj != null && obj instanceof Exception) {
                    Exception ex = (Exception)obj;
                    this.clientInterface.sendEvent(new ru.softlogic.srv.api.event.Event(EventType.UpdateFault, ex.getMessage()));
                }
                this.log.info((Object)"************* \u0417\u0430\u043f\u0443\u0441\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e *************");
                try {
                    FederalNumberValidator.getInstance();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f", ex);
                this.stop();
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
            System.exit(1);
        }
    }

    public void stop() {
        if (this.threads != null) {
            for (Thread t : this.threads) {
                this.log.info((Object)("\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e: " + t.getName()));
                t.interrupt();
            }
            for (Thread t : this.threads) {
                try {
                    this.log.info((Object)("\u041e\u0436\u0438\u0434\u0430\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f: " + t.getName()));
                    t.join();
                    this.log.info((Object)("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d: " + t.getName()));
                }
                catch (Exception ex) {
                    this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0442\u043e\u043a\u0430 " + t.getName() + ", " + ex.getMessage()));
                }
            }
        }
        this.log.info((Object)"\u041e\u0441\u0442\u0430\u043d\u043e\u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        if (this.context != null) {
            this.context.stop();
        }
    }

    public void closeFiles() {
        this.cashAcceptorBox.close();
        this.coinAcceptorBox.close();
    }

    private Logger createLoggerWithViewAppender(String name, String path, String appenderName, Level level) {
        Logger itemLogger = Logger.getLogger((String)name);
        itemLogger.setAdditivity(false);
        itemLogger.setLevel(level);
        DailyRollingFileAppender drfa = new DailyRollingFileAppender();
        drfa.setEncoding("UTF-8");
        drfa.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        drfa.setFile(PathUtils.getPath((String)("/log/" + path + ".log")));
        drfa.setDatePattern("'.'yyyy-MM-dd");
        drfa.activateOptions();
        itemLogger.addAppender((Appender)drfa);
        ViewAppender va = new ViewAppender();
        va.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %5p [%t] %m%n"));
        va.setName(appenderName);
        itemLogger.addAppender((Appender)va);
        return itemLogger;
    }

    private Logger createLoggerWithViewAppender(String name, String path, String appenderName) {
        return this.createLoggerWithViewAppender(name, path, appenderName, Level.INFO);
    }
}

