/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.html;

import i18n.B;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.CommissionRender;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.html.HtmlU;
import ru.softlogic.app.html.connector.InterfaceNotifier;
import ru.softlogic.app.html.connector.KioskdListener;
import ru.softlogic.app.html.connector.card.ConnectorListener;
import ru.softlogic.app.html.connector.card.HTMLCardPaymentModule;
import ru.softlogic.app.html.connector.model.BeginResult;
import ru.softlogic.app.html.connector.model.BrowserInfo;
import ru.softlogic.app.html.connector.model.Connector;
import ru.softlogic.app.html.connector.model.ConnectorState;
import ru.softlogic.app.html.connector.model.PaymentData;
import ru.softlogic.app.html.connector.model.Payments;
import ru.softlogic.app.html.connector.model.ReferencesAdapter;
import ru.softlogic.app.html.connector.utils.ConnectorStateController;
import ru.softlogic.app.html.connector.utils.UssdChecker4Connector;
import ru.softlogic.app.html.connector.websocket.WebSocketConnectListener;
import ru.softlogic.app.html.connector.websocket.WebSocketServer;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.app.task.TaskExecutor;
import ru.softlogic.application.JammInformer;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.application.collection.MoneyCollectionInitiator;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.acceptor.cbc.HtmlCbcModule;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.screen.content.ContentScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.screen.shell.Shell;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui.utils.SmsSuccessVerifier;
import ru.softlogic.gui.utils.VSTemplateProcessor;
import ru.softlogic.gui.utils.menu.GroupByMenuItemVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.LastReportsReqest;
import ru.softlogic.hardware.device.print.kkm.ReportByDate;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.ReportRequest;
import ru.softlogic.hardware.device.print.queue.ReportResultListener;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.device.print.status.PrinterStatusObserver;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.field.text.SimpleFormatter;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.ModuleStore;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.module.input.admin.AdminListener;
import ru.softlogic.module.input.admin.CashBoxModel;
import ru.softlogic.module.input.admin.LogListener4Connector;
import ru.softlogic.module.input.admin.log.ViewAppender;
import ru.softlogic.module.input.advanced.ConnectorAdapter;
import ru.softlogic.module.input.advanced.PrinterAdapter;
import ru.softlogic.module.input.mobile.FederalNumberValidator;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.VerifyType;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.sequence.Sequence;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionType;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.CashBackCardInterface;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.api.verify.VerifyResultType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.MenuItemStub;
import ru.softlogic.srv.connector.ws.stub.MenuStub;
import ru.softlogic.srv.connector.ws.stub.PointOptionsStub;
import ru.softlogic.srv.connector.ws.stub.ReferencesStub;
import ru.softlogic.srv.connector.ws.stub.ServiceTypeStub;
import ru.softlogic.system.util.CbcUtil;
import ru.softlogic.system.util.CheckCollectorPwdHelper;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.PinCodeGenerator;
import ru.softlogic.system.util.UsersUtil;
import ru.softlogic.system.util.fraud.FraudQueue;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.update.updater.AutoUpdateControl;
import ru.softlogic.update.updater.FileUpdateStore;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.UpdateSystem;

public class HtmlConnectorApplicationContext
implements ApplicationContext,
NetObserver,
RemoteStatusObserver,
PrinterStatusObserver,
ValidatorStatusListener {
    private Logger log;
    private Logger logGui;
    private PrinterQueue printerQueue;
    private ClientInterface clientInterface;
    private WatchDog watchDog;
    private WebSocketServer wss;
    private LocalConnector connector;
    private InterfaceNotifier notifier;
    private KioskdListener listener;
    private Payments payments;
    private TerminalState currentState;
    private Commission backupcommission1;
    private Commission backupcommission2;
    private MenuItem menuItem;
    private Sum sumPurchase;
    private Sum smsCost;
    private Keeper currentKeeper;
    private Set<CashUnit> cashUnits;
    private Set<CashUnit> coinUnits;
    private CashManager cashManager;
    private HtmlCbcModule cbcModule;
    private MoneyCollectionHandler cashCollectionHandler;
    private MoneyCollectionHandler coinCollectionHandler;
    private ServerUser menuUser;
    private ServiceMenuConnector smc;
    private ValidatorStatus validatorStatus;
    private Integer remoteStatus;
    private PrinterStatus printerStatus;
    private Date lastConnect;
    private Integer errCount;
    private LogListener4Connector logListener;
    private Sum sumRequired;
    private boolean enableCashManager;
    private UssdChecker4Connector ussdChecker;
    private int currentModule;
    private ServerUser collectorUser;
    private boolean setPersonalComm;
    private Set<ModuleTypeListener> moduleTypeListeners;

    HtmlConnectorApplicationContext(CashManager cashManager, PrinterQueue printerQueue, ClientInterface clientInterface, JammInformer jammInformer, WatchDog watchDog, ScheduledExecutorService scheduler, UssdChecker4Connector ussdChecker) {
        if (cashManager == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 CashManager");
        }
        if (printerQueue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PrinterQueue");
        }
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ServerConnector");
        }
        if (jammInformer == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 JammInformer");
        }
        this.logGui = Logger.getLogger((String)"gui");
        this.logGui.setAdditivity(false);
        this.log = Logger.getLogger((String)"pay");
        this.log.setAdditivity(false);
        this.logGui.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f");
        this.watchDog = watchDog;
        this.cashManager = cashManager;
        this.printerQueue = printerQueue;
        this.clientInterface = clientInterface;
        this.cbcModule = new HtmlCbcModule((CashBackCardInterface)clientInterface);
        cashManager.addCashDevice((ManagedCashAcceptor)this.cbcModule);
        this.logGui.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f WebSoketServer");
        this.wss = WebSocketServer.getInstance();
        this.notifier = new InterfaceNotifier(this.wss);
        this.connector = new LocalConnector();
        this.listener = new KioskdListener(this.connector);
        this.wss.addMessageListener(this.listener);
        this.smc = new ServiceMenuConnector();
        this.ussdChecker = ussdChecker;
        if (ussdChecker != null) {
            this.ussdChecker.setLog(this.log);
        }
        this.moduleTypeListeners = new HashSet<ModuleTypeListener>();
        BarcodeScanner.getScanner().addListener((BarcodeScannerListener)new LocalBarcodeScannerListener());
    }

    public void start() {
        if (this.wss != null) {
            this.logGui.info((Object)"\u0421\u0442\u0430\u0440\u0442\u0443\u0435\u043c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            this.wss.start(8000);
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043c\u043e\u0434\u0443\u043b\u044c: 1");
            this.currentModule = 1;
            this.notifyModuleTypeListeners(1);
        }
    }

    public void stop() {
        if (this.wss != null) {
            this.logGui.info((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440");
            this.wss.stop();
        }
    }

    public void update(boolean netError) {
        if (!netError) {
            this.errCount = 0;
            this.lastConnect = new Date();
        } else if (this.errCount == null) {
            this.errCount = 1;
        } else {
            Integer n = this.errCount;
            Integer n2 = this.errCount = Integer.valueOf(this.errCount + 1);
        }
    }

    public void update(int remoteStatus) {
        if (this.remoteStatus == null || this.remoteStatus != remoteStatus) {
            this.remoteStatus = remoteStatus;
        }
    }

    public void update(DeviceClass deviceClass, PrinterStatus status) {
        if (!status.equals((Object)this.printerStatus)) {
            this.printerStatus = status;
        }
    }

    public void update(ValidatorStatus status) {
        if (!status.equals((Object)this.validatorStatus)) {
            this.validatorStatus = status;
        }
    }

    public void errorEvent(String comment) {
    }

    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setModule(Module module) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ModuleStore getModuleStore() {
        return null;
    }

    @Override
    public void toMainMenu(int targetId) {
        this.toMainMenu();
    }

    @Override
    public void toMainMenuGroup(int label) {
        this.toMainMenu();
    }

    @Override
    public void toMainMenu(Intent intent) {
        this.toMainMenu();
    }

    public boolean isCanRedirect() {
        return false;
    }

    @Override
    public void toMainMenu() {
    }

    @Override
    public ClientInterface getServerConnector() {
        return this.clientInterface;
    }

    @Override
    public PrinterQueue getPrinterQueue() {
        return this.printerQueue;
    }

    @Override
    public FraudQueue getFraudQueue() {
        return null;
    }

    @Override
    public Shell getShell() {
        return null;
    }

    @Override
    public WatchDog getWatchDog() {
        return this.watchDog;
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        return null;
    }

    public void showScreen(ContentScreen screen) {
    }

    public void showWait(WaitScreen waitScreen) {
    }

    public void showDialog(DialogInterface dialogScreen) {
    }

    public void setCollectionHandlers(MoneyCollectionHandler cashCollectionHandler, MoneyCollectionHandler coinCollectionHandler) {
        this.cashCollectionHandler = cashCollectionHandler;
        this.coinCollectionHandler = coinCollectionHandler;
    }

    public void addModuleTyteListener(ModuleTypeListener listener) {
        this.moduleTypeListeners.add(listener);
    }

    private void notifyModuleTypeListeners(int moduleType) {
        for (ModuleTypeListener mtl : this.moduleTypeListeners) {
            mtl.onChange(moduleType);
        }
    }

    private class LocalExitIntent
    implements Intent {
        private final int errorCode;
        private final String method;
        ConnectorStateController csController;

        public LocalExitIntent(int errorCode, String method, ConnectorStateController csController) {
            this.errorCode = errorCode;
            this.method = method;
            this.csController = csController;
        }

        @Override
        public void process() {
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443: " + this.errorCode));
            try {
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(this.errorCode, this.method);
                this.csController.go2NewState(ConnectorState.load);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
            }
        }

        @Override
        public int getType() {
            return 2;
        }
    }

    public class NetworkConnectorUpdater
    implements Runnable {
        private int confirm;

        public int getConfirm() {
            return this.confirm;
        }

        public void setConfirm(int confirm) {
            this.confirm = confirm;
        }

        @Override
        public void run() {
            try {
                Point point = ReferenceManager.getInstance().getPoint();
                UpdateOptions uo = ReferenceManager.getInstance().getUpdateOptions();
                if (point == null || uo == null) {
                    throw new Exception("point not found");
                }
                if (uo.getUpdateUrl() == null || uo.getUpdateUrl().isEmpty()) {
                    throw new Exception("update url is empty ");
                }
                UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(this.updateUrl(uo.getUpdateUrl()), uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout")), (UpdateControl)new LocalGuiUpdateControl(), new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"), (StateListener)new LocalUpdateStateListener());
                if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
                    throw new Exception("update request reject");
                }
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f", (Throwable)ex);
            }
        }

        private String updateUrl(String url) {
            String version = "v5";
            String v = SystemProp.getUpdateVersion();
            if (v != null && !v.isEmpty()) {
                version = v;
            }
            if (OsDetector.current() == 1) {
                return url + "/" + version + "/linux/";
            }
            return url + "/" + version + "/windows/";
        }

        private class LocalUpdateStateListener
        implements StateListener {
            private LocalUpdateStateListener() {
            }

            public void onStart() {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041d\u0430\u0447\u0430\u043b\u043e \u043e\u0431\u043d\u043e\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("start", null);
            }

            public void onSkip() {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("skip", null);
            }

            public void onConfirm(UpdateSize updateSize) {
                try {
                    HtmlConnectorApplicationContext.this.log.debug((Object)("\u0421\u043e\u0433\u043b\u0430\u0441\u0438\u0435 \u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: " + updateSize));
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("\u0441onfirm", new JSONObject().put("updatesize", (Object)updateSize));
                }
                catch (Exception ex) {
                    HtmlConnectorApplicationContext.this.log.error((Object)ex);
                }
            }

            public void onProgress(String fileName, int total, int progress) {
                try {
                    HtmlConnectorApplicationContext.this.log.debug((Object)("\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: fileName <" + fileName + "> total <" + total + "> progress <" + progress + ">"));
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("progress", new JSONObject().put("filename", (Object)fileName).put("total", total).put("progress", progress));
                }
                catch (Exception ex) {
                    HtmlConnectorApplicationContext.this.log.error((Object)ex);
                }
            }

            public void onSuccess(UpdateMetric updateMetric) {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("success", null);
            }

            public void onCancel() {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u043d\u043e");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("cancel", null);
            }

            public void onLocalError(Exception ex, UpdateMetric updateMetric) {
                try {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439", (Throwable)ex);
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("localerror", new JSONObject().put("message", (Object)ex.getMessage()).put("updatemetric", (Object)new JSONObject((Object)updateMetric)));
                }
                catch (Exception e) {
                    HtmlConnectorApplicationContext.this.log.error((Object)e);
                }
            }

            public void onGlobalError(Exception ex) {
                try {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439", (Throwable)ex);
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("globalerror", new JSONObject().put("message", (Object)ex.getMessage()));
                }
                catch (Exception e) {
                    HtmlConnectorApplicationContext.this.log.error((Object)e);
                }
            }
        }

        private class LocalGuiUpdateControl
        implements UpdateControl {
            private LocalGuiUpdateControl() {
            }

            public boolean confirmUpdate(int size) {
                try {
                    HtmlConnectorApplicationContext.this.log.info((Object)("Update size=" + size + ", needs to confirm"));
                    NetworkConnectorUpdater.this.confirm = 0;
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("showconfirmupdate", new JSONObject().put("size", size));
                    for (int time = 0; NetworkConnectorUpdater.this.confirm == 0 && time < 10000; time += 100) {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    return NetworkConnectorUpdater.this.confirm == 1;
                }
                catch (Exception ex) {
                    HtmlConnectorApplicationContext.this.log.error((Object)ex);
                    return false;
                }
            }

            public boolean confirmRetry(int errorCount, Exception ex) {
                return errorCount < 5;
            }

            public boolean confirmRestart() {
                return true;
            }
        }
    }

    public class LocalConnectorUpdater {
        public void checkUpdate(File file) throws Exception {
            UpdateRequest ur = new UpdateRequest((UpdateStore)new FileUpdateStore(file), (UpdateControl)new AutoUpdateControl(1), new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"), (StateListener)new LocalUpdateStateListener());
            if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
                throw new Exception("update request reject");
            }
        }

        private class LocalUpdateStateListener
        implements StateListener {
            private LocalUpdateStateListener() {
            }

            public void onStart() {
            }

            public void onSkip() {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043e\u0431\u043d\u043e\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("skip", null);
            }

            public void onConfirm(UpdateSize updateSize) {
            }

            public void onProgress(String fileName, int total, int progress) {
            }

            public void onSuccess(UpdateMetric updateMetric) {
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                HtmlConnectorApplicationContext.this.notifier.onUpdate("success", null);
            }

            public void onCancel() {
            }

            public void onLocalError(Exception ex, UpdateMetric updateMetric) {
                try {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439", (Throwable)ex);
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("localerror", new JSONObject().put("message", (Object)ex.getMessage()).put("updatemetric", (Object)new JSONObject((Object)updateMetric)));
                }
                catch (Exception e) {
                    HtmlConnectorApplicationContext.this.log.error((Object)e);
                }
            }

            public void onGlobalError(Exception ex) {
                try {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439", (Throwable)ex);
                    HtmlConnectorApplicationContext.this.notifier.onUpdate("globalerror", new JSONObject().put("message", (Object)ex.getMessage()));
                }
                catch (Exception e) {
                    HtmlConnectorApplicationContext.this.log.error((Object)e);
                }
            }
        }
    }

    private class ServiceMenuConnector
    implements AdminListener {
        private boolean busy = false;
        private NetworkConnectorUpdater ncu = new NetworkConnectorUpdater();

        public ServiceMenuConnector() {
            Appender appender = Logger.getLogger((String)"net").getAppender("netview");
            HtmlConnectorApplicationContext.this.logListener = new LogListener4Connector(500, 200);
            if (appender instanceof ViewAppender) {
                ViewAppender app = (ViewAppender)appender;
                app.addListener(HtmlConnectorApplicationContext.this.logListener);
            }
        }

        public void validUser(String login, String password) throws Exception {
            HtmlConnectorApplicationContext.this.menuUser = UsersUtil.authenticationByMD5(login, password);
            if (HtmlConnectorApplicationContext.this.menuUser == null || HtmlConnectorApplicationContext.this.menuUser.getAccessList() == null || HtmlConnectorApplicationContext.this.menuUser.getAccessList().isEmpty()) {
                throw new Exception("Authorisation Error");
            }
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041f\u0440\u0430\u0432\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f: " + HtmlConnectorApplicationContext.this.menuUser.getAccessList()));
        }

        public void visibleKKMPanel(String login, String password) {
            try {
                boolean visible = UsersUtil.canShowTab(UsersUtil.authenticationByMD5(login, password), "kkm") && (HtmlConnectorApplicationContext.this.getPrinterQueue().getPrinterType() == PrinterType.Kkm || HtmlConnectorApplicationContext.this.getPrinterQueue().getPrinterType() == PrinterType.KkmOnline);
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438 KKM = " + visible));
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("visiblekkm", new JSONObject().put("visible", visible));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)ex);
            }
        }

        public void onTestPay() {
            try {
                if (HtmlConnectorApplicationContext.this.printerQueue == null || HtmlConnectorApplicationContext.this.printerQueue.getPrinterType() != PrinterType.Kkm && HtmlConnectorApplicationContext.this.printerQueue.getPrinterType() != PrinterType.KkmOnline) {
                    throw new Exception(B.get((String)"listener.printer.kkm.error"));
                }
                Operation operation = new Operation();
                operation.setFeHash(PaymentHelper.getFeHash());
                operation.setCheckNumber(9999);
                operation.setCommission(new Commission(0, "5%", CommissionType.Direct, 5.0, new Sum(0)));
                operation.setIdOperation(123456);
                Keeper keeper = new Keeper();
                keeper.addCash(new CashUnit(0, new Sum(0.01), 3));
                operation.setKeeper(keeper);
                Service service = new Service();
                service.setId(0);
                service.setName(B.get((String)"listener.printer.doc.service"));
                service.setPrintName(B.get((String)"listener.printer.doc.service"));
                service.setPrintText(B.get((String)"listener.printer.doc.text"));
                service.setProvider(new Dealer(B.get((String)"listener.printer.doc.agent"), B.get((String)"listener.printer.doc.agent.inn"), B.get((String)"listener.printer.doc.agent.address"), B.get((String)"listener.printer.doc.agent.support"), B.get((String)"listener.printer.doc.agent.support-work-time")));
                operation.setService(service);
                operation.setSumResult(new SumResult(new Sum(0.01), new Sum(0.0), new Sum(0.01), new Sum(0.0), new Sum(0.0), new Sum(0), null, null));
                operation.getForm().put("id1", B.get((String)"listener.printer.doc.number"));
                operation.getTitles().put("id1", B.get((String)"listener.printer.doc.number.title"));
                operation.getViews().put("id1", B.get((String)"listener.printer.doc.number.view"));
                operation.setDealer(new Dealer(B.get((String)"listener.printer.doc.agent"), B.get((String)"listener.printer.doc.agent.inn"), B.get((String)"listener.printer.doc.agent.address"), B.get((String)"listener.printer.doc.agent.support"), B.get((String)"listener.printer.doc.agent.support-work-time")));
                operation.setPoint(new Point(1, B.get((String)"listener.printer.doc.point"), B.get((String)"listener.printer.doc.point.address")));
                HtmlConnectorApplicationContext.this.printerQueue.print(operation);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)ex.getMessage(), (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        public void onLogs() {
            try {
                JSONObject o = new JSONObject();
                JSONArray logs = new JSONArray(HtmlConnectorApplicationContext.this.logListener.getLogs());
                o.put("logs", (Object)logs);
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("logs", o);
            }
            catch (JSONException ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043b\u043e\u0433\u043e\u0432", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, "Error requesting logs: " + ex.getMessage());
            }
        }

        public void onModemInfo() {
            try {
                if (HtmlConnectorApplicationContext.this.ussdChecker != null) {
                    JSONObject o = HtmlConnectorApplicationContext.this.ussdChecker.call();
                    HtmlConnectorApplicationContext.this.notifier.onServiceMenu("modeminfo", o);
                    return;
                }
                throw new Exception("The modem configuration is not set");
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043c\u043e\u0434\u0435\u043c\u0435", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, "An error occurred while requesting information about the modem: " + ex.getMessage());
                return;
            }
        }

        public void getCash(CashBox cashBox, CashBox coinBox) {
            try {
                JSONObject row;
                int i;
                CashBoxModel cbm1 = new CashBoxModel(CashFactory.getDefaultInstance().getCashUnits(), cashBox.getKeeper(), new String[]{B.get((String)"AdminPanel.cashPanel.table.nominal"), B.get((String)"AdminPanel.cashPanel.table.count"), B.get((String)"AdminPanel.cashPanel.table.sum"), B.get((String)"AdminPanel.cashPanel.table.total")});
                CashBoxModel cbm2 = new CashBoxModel(CashFactory.getDefaultInstance().getCoinUnits(), coinBox.getKeeper(), new String[]{B.get((String)"AdminPanel.cashPanel.table.nominal"), B.get((String)"AdminPanel.cashPanel.table.count"), B.get((String)"AdminPanel.cashPanel.table.sum"), B.get((String)"AdminPanel.cashPanel.table.total")});
                JSONObject result = new JSONObject();
                JSONArray casharr = new JSONArray();
                JSONArray coinarr = new JSONArray();
                for (i = 0; i < cbm1.getRowCount(); ++i) {
                    row = new JSONObject();
                    row.put("col1", cbm1.getValueAt(i, 0));
                    row.put("col2", cbm1.getValueAt(i, 1));
                    row.put("col3", cbm1.getValueAt(i, 2));
                    row.put("col4", cbm1.getValueAt(i, 3));
                    casharr.put((Object)row);
                }
                for (i = 0; i < cbm2.getRowCount(); ++i) {
                    row = new JSONObject();
                    row.put("col1", cbm2.getValueAt(i, 0));
                    row.put("col2", cbm2.getValueAt(i, 1));
                    row.put("col3", cbm2.getValueAt(i, 2));
                    row.put("col4", cbm2.getValueAt(i, 3));
                    coinarr.put((Object)row);
                }
                result.put("cash", (Object)casharr);
                result.put("coin", (Object)coinarr);
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("getcash", result);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, "An error occurred while obtaining information about cash");
            }
        }

        public void getStatus() {
            JSONObject o = new JSONObject();
            try {
                String validatorState = null;
                validatorState = HtmlConnectorApplicationContext.this.validatorStatus == null ? "-" : (HtmlConnectorApplicationContext.this.validatorStatus.isError() ? B.get((String)"ServiceMenu.status.error") : B.get((String)"ServiceMenu.status.ok"));
                o.put("validatorstatus", (Object)validatorState);
                String printerState = null;
                printerState = HtmlConnectorApplicationContext.this.printerStatus == null ? "-" : (!HtmlConnectorApplicationContext.this.printerStatus.isWork() ? B.get((String)"ServiceMenu.status.error") : B.get((String)"ServiceMenu.status.ok"));
                o.put("printerstatus", (Object)printerState);
                String remoteState = null;
                remoteState = HtmlConnectorApplicationContext.this.remoteStatus == null ? "-" : ((HtmlConnectorApplicationContext.this.remoteStatus & 1) != 0 ? B.get((String)"ServiceMenu.status.lock") : B.get((String)"ServiceMenu.status.ok"));
                o.put("remotestatus", (Object)remoteState);
                String diskSpace = "" + (int)(new File(PathUtils.getAppHome()).getUsableSpace() / 0x100000L);
                o.put("diskspace", (Object)diskSpace);
                String conn = null;
                String lastconn = null;
                if (HtmlConnectorApplicationContext.this.errCount == null) {
                    conn = "-";
                    lastconn = "-";
                } else if (HtmlConnectorApplicationContext.this.errCount == 0) {
                    conn = B.get((String)"ServiceMenu.status.ok");
                    lastconn = "" + (new Date().getTime() - HtmlConnectorApplicationContext.this.lastConnect.getTime()) / 60000L;
                } else {
                    conn = MessageFormat.format(B.get((String)"ServiceMenu.status.net-error"), HtmlConnectorApplicationContext.this.errCount);
                    lastconn = HtmlConnectorApplicationContext.this.lastConnect != null ? "" + (new Date().getTime() - HtmlConnectorApplicationContext.this.lastConnect.getTime()) / 60000L : "-";
                }
                o.put("connect", (Object)conn);
                o.put("lastconnect", (Object)lastconn);
                String queue = "";
                Operation[] ops = HtmlConnectorApplicationContext.this.clientInterface.getQueue().getOperations();
                GroupOperation[] gops = HtmlConnectorApplicationContext.this.clientInterface.getQueue().getGroupOperations();
                queue = "" + ((ops == null ? 0 : ops.length) + (gops == null ? 0 : gops.length));
                o.put("queue", (Object)queue);
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("status", o);
            }
            catch (JSONException ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, "Error requesting status: " + ex.getMessage());
            }
        }

        @Override
        public void onCashMoneyCollection() {
            if (HtmlConnectorApplicationContext.this.cashCollectionHandler != null) {
                this.incass(HtmlConnectorApplicationContext.this.cashCollectionHandler.getBox());
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0434\u0438\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u044f \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            }
        }

        @Override
        public void onCoinMoneyCollection() {
            if (HtmlConnectorApplicationContext.this.coinCollectionHandler != null) {
                this.incass(HtmlConnectorApplicationContext.this.coinCollectionHandler.getBox());
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0434\u0438\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u044f \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
            }
        }

        private synchronized void incass(CashBox box) {
            if (!this.busy) {
                UserAction.getInstance().update();
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044e, \u0438\u043d\u0438\u0446\u0438\u0430\u0442\u043e\u0440: " + (Object)((Object)MoneyCollectionInitiator.CashInPerson)));
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0418\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u0443\u0435\u043c " + box));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.MoneyCollection, "" + (Object)((Object)MoneyCollectionInitiator.CashInPerson) + "," + box.getDeviceClass()));
                Keeper keeper = box.collect();
                if (keeper != null) {
                    int id = 0;
                    try {
                        Sequence seq = SequenceManager.getInstance().getSequence("collection-id");
                        id = seq.next();
                    }
                    catch (Exception ex) {
                        HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: ", (Throwable)ex);
                    }
                    MoneyCollection mc = new MoneyCollection(id, keeper, box.getDeviceClass(), keeper.getCreated(), HtmlConnectorApplicationContext.this.menuUser);
                    HtmlConnectorApplicationContext.this.printerQueue.print(mc);
                    HtmlConnectorApplicationContext.this.clientInterface.sendMoneyCollection(mc);
                }
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0438\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
                this.busy = false;
            } else {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f");
            }
        }

        @Override
        public void onRebootTerminal() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u043c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
            SafeReboot.getInstance().reboot();
        }

        @Override
        public void onPowerOffTerminal() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
            SafeReboot.getInstance().poweroff();
        }

        @Override
        public void onRestartSoftware() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0436\u0443 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a \u041f\u041e");
            DaemonUtil.createExitFlag((String)"_flag_servmenu");
            System.exit(0);
        }

        @Override
        public void onMinimizeSoftware() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onCloseSoftware() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u043e\u043b\u043d\u044b\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432 \u041f\u041e");
            System.exit(15);
        }

        @Override
        public void onTestPrinter() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0422\u0435\u0441\u0442\u0438\u0440\u0443\u044e \u043f\u0440\u0438\u043d\u0442\u0435\u0440");
            MoneyCollection mc = new MoneyCollection(-1, new Keeper(), DeviceClass.CashAcceptor, null, HtmlConnectorApplicationContext.this.menuUser);
            HtmlConnectorApplicationContext.this.printerQueue.print(mc);
        }

        @Override
        public void onTestNetwork() {
            try {
                Date ob = HtmlConnectorApplicationContext.this.clientInterface.ping();
                String text = B.get((String)"ServiceMenu.network-test.result", null);
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("testnetwork", new JSONObject().put("test", (Object)text));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0441\u0432\u044f\u0437\u0438", (Throwable)ex);
            }
        }

        @Override
        public void onStartConfig() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440.");
            System.exit(16);
        }

        @Override
        public void onCheckDealerBalance() {
            try {
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("checkdealerbalance", new JSONObject().put("balance", HtmlConnectorApplicationContext.this.clientInterface.getBalance(HtmlConnectorApplicationContext.this.menuUser.getId())));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430", (Throwable)ex);
            }
        }

        @Override
        public void onExitConfigurator() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onNetworkUpdate() {
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0441\u0435\u0442\u0435\u0432\u044b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u0437 \u043c\u0435\u043d\u044e");
                ExecutorService service = Executors.newSingleThreadExecutor();
                service.execute(this.ncu);
                service.shutdown();
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f", (Throwable)ex);
            }
        }

        @Override
        public void onLocalUpdate() {
        }

        private void localupdate(String filename) {
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u0437 \u043c\u0435\u043d\u044e");
                if (!new File(filename).exists()) {
                    throw new Exception("File " + filename + " not found");
                }
                new LocalConnectorUpdater().checkUpdate(new File(filename));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f", (Throwable)ex);
            }
        }

        @Override
        public void onReportX() {
            try {
                HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new ReportRequest(KkmOperation.FormReportX));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        @Override
        public void onReportZ() {
            try {
                HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new ReportRequest(KkmOperation.FormReportZ));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        @Override
        public void onReportZService() {
            try {
                HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new ReportRequest(KkmOperation.FormReportZService));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        @Override
        public void onReportZMem() {
            try {
                HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new ReportRequest(KkmOperation.FormReportZMem));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        @Override
        public void onRequestMoneyCollections() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            try {
                MoneyCollection[] mcs = HtmlConnectorApplicationContext.this.clientInterface.getCollections();
                JSONArray mas = new JSONArray();
                if (mcs != null && mcs.length != 0) {
                    for (MoneyCollection mc : mcs) {
                        JSONObject o = new JSONObject();
                        o.put("id", mc.getId());
                        o.put("date", (Object)new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(mc.getDate()));
                        o.put("sum", mc.getKeeper().getSum().getSum());
                        mas.put((Object)o);
                    }
                }
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u043b\u044f\u044e \u043e\u0442\u0432\u0435\u0442");
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("requestmoneycollections", new JSONObject().put("mmc", (Object)mas));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430", (Throwable)ex);
            }
        }

        public void onPrintMoneyCollections(int n) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 id= " + n));
            try {
                MoneyCollection[] mcs = HtmlConnectorApplicationContext.this.clientInterface.getCollections();
                if (mcs != null && mcs.length != 0) {
                    for (MoneyCollection mc : mcs) {
                        if (mc.getId() != n) continue;
                        this.onPrintMoneyCollections(mc);
                        break;
                    }
                }
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u043b\u044f\u044e \u043e\u0442\u0432\u0435\u0442");
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438", (Throwable)ex);
            }
        }

        @Override
        public void onPrintMoneyCollections(MoneyCollection mc) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0434\u0443\u0431\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + mc));
            HtmlConnectorApplicationContext.this.printerQueue.print(mc);
        }

        @Override
        public void onConnect() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onRefreshNetworkInfo() {
        }

        @Override
        public void onReportByRange(Date start, Date end, boolean detailed) {
        }

        public void onReportByRange(Date start, Date end, boolean detailed, String passwd) {
            try {
                if (HtmlConnectorApplicationContext.this.getPrinterQueue().getPrinterType() != PrinterType.Kkm && HtmlConnectorApplicationContext.this.getPrinterQueue().getPrinterType() != PrinterType.KkmOnline) {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043d\u0435 KKM");
                    throw new Exception("Printer is not KKM");
                }
                HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443: \u0441 " + start + " \u043f\u043e " + end));
                ReportResult reportResult = HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new ReportByDate(start, end, detailed, passwd));
                HtmlConnectorApplicationContext.this.notifier.onServiceMenu("reportbyrange", new JSONObject().put("report", (Object)MessageFormat.format(B.get((String)"ServiceMenu.report.result"), reportResult.getMessage(), reportResult.getResult())));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, MessageFormat.format(B.get((String)"ServiceMenu.report.failure", (Locale)Locale.ENGLISH), ex));
            }
        }

        @Override
        public void onCashManagerControl(boolean enable) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onCalibrate() {
            try {
                String cPath = null;
                if (new File(PathUtils.getAppHome() + "/bin/calib").exists()) {
                    cPath = PathUtils.getAppHome() + "/bin/calib";
                } else if (new File(SystemProp.getUserHome() + "/bin/calib").exists()) {
                    cPath = SystemProp.getUserHome() + "/bin/calib";
                } else if (new File(SystemProp.getUserHome() + "/xic").exists()) {
                    cPath = SystemProp.getUserHome() + "/xic";
                }
                if (cPath == null) {
                    throw new Exception(B.get((String)"Provider.admin.nocalib", (Locale)Locale.ENGLISH));
                }
                Runtime.getRuntime().exec(cPath);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }

        @Override
        public void onOpenControlPanel() {
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u043f\u0430\u043d\u0435\u043b\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
                Runtime.getRuntime().exec("control panel");
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)ex);
            }
        }

        @Override
        public void onFillCoinHopper() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onTestFiscalClient() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void confirm(boolean flag) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u0432\u0435\u0442 \u0441\u043e\u0433\u043b\u0430\u0441\u0438\u044f \u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435: " + flag));
            if (flag) {
                this.ncu.setConfirm(1);
            } else {
                this.ncu.setConfirm(2);
            }
        }

        @Override
        public void onStartGSM() {
        }

        @Override
        public void onPrintCoffeeFullness() {
        }

        @Override
        public void onUpdateCoffeeFullness() {
        }

        @Override
        public void onUnloadPayments() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void onMakeCoffeeDrink() {
        }

        @Override
        public void onSwitchCoffeeMode() {
        }

        @Override
        public void onFlowDownCoinMoneyCollection() {
        }

        @Override
        public void onDispenserMoneyCollection() {
        }

        @Override
        public void onCoinMoneyCollectionNominal() {
        }

        @Override
        public void onStartCMSetup() {
        }

        @Override
        public void onReportZCopy(int copyCount) {
            try {
                HtmlConnectorApplicationContext.this.getPrinterQueue().reportAndWait(new LastReportsReqest(copyCount));
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
            }
        }
    }

    private class LocalBarcodeScannerListener
    implements BarcodeScannerListener {
        private LocalBarcodeScannerListener() {
        }

        public void onData(String data) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u043e\u0442 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445\u043a\u043e\u0434\u0430: " + data));
            HtmlConnectorApplicationContext.this.notifier.onBarcodeScanner(data);
        }
    }

    private class LocalConnector
    implements Connector,
    WebSocketConnectListener {
        ConnectorStateController csController;
        private HTMLCardPaymentModule cm;

        public LocalConnector() {
            this.csController = new ConnectorStateController(HtmlConnectorApplicationContext.this.notifier, HtmlConnectorApplicationContext.this.connector, HtmlConnectorApplicationContext.this.clientInterface, HtmlConnectorApplicationContext.this.log);
            try {
                this.cm = new HTMLCardPaymentModule(HtmlConnectorApplicationContext.this.log, HtmlConnectorApplicationContext.this.notifier);
            }
            catch (Throwable e) {
                HtmlConnectorApplicationContext.this.log.warn((Object)("Can't create card module: " + e));
            }
        }

        @Override
        public void onLoad(BrowserInfo browserInfo) {
            ConnectorState constate = this.csController.getPrevios();
            try {
                this.csController.go2NewState(ConnectorState.load);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                if (constate == ConnectorState.load) {
                    HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                    HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
                    HtmlConnectorApplicationContext.this.log.debug((Object)"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432 \u043c\u0435\u0442\u043e\u0434\u0430 <load>");
                }
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
                HtmlConnectorApplicationContext.this.log.debug((Object)"\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0435\u0441\u0441\u0438\u044f \u043d\u0430\u0447\u0430\u0442\u0430 \u0440\u0430\u043d\u0435\u0435. \u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u043c \u043e\u0442\u043c\u0435\u043d\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0435\u0441\u0441\u0438\u0438");
                int result = this.onCancel(0);
                if (result != 0) {
                    this.onCancel(1);
                }
                return;
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041d\u043e\u0432\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 web-\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u043c: " + browserInfo));
            this.onState();
        }

        @Override
        public void onBegin(String language, int idService) {
            try {
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.begin);
                HtmlConnectorApplicationContext.this.log.info((Object)">======================================================");
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u043e\u043f\u043b\u0430\u0442\u0430, id-service=" + idService));
                this.clearSession();
                MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(idService);
                MenuUtils.processMenu((MenuVisitor)mv);
                HtmlConnectorApplicationContext.this.menuItem = mv.getMenuItem();
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e: " + HtmlConnectorApplicationContext.this.menuItem));
                if (HtmlConnectorApplicationContext.this.menuItem == null) {
                    HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "html,begin,id-servide=" + idService + " - not found"));
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c \u043e\u0448\u0438\u0431\u043a\u0443: 1");
                    HtmlConnectorApplicationContext.this.notifier.onBegin(new BeginResult(1, 0));
                    this.csController.go2NewState(ConnectorState.cancel);
                    this.csController.go2NewState(ConnectorState.load);
                    return;
                }
                HtmlConnectorApplicationContext.this.notifier.onBegin(new BeginResult(0, HtmlConnectorApplicationContext.this.menuItem.getService().getId()));
                Pack p = new Pack();
                p.setService(HtmlConnectorApplicationContext.this.menuItem.getService());
                p.setCommission(HtmlConnectorApplicationContext.this.menuItem.getCommission());
                Session.getInstance().setCorrectPack(p);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
            }
        }

        @Override
        public void onReinit(int idService) {
            try {
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.reinit);
                HtmlConnectorApplicationContext.this.log.info((Object)">======================================================");
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u0440\u0435\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f\u043e\u043f\u043b\u0430\u0442\u0430, id-service=" + idService));
                HtmlConnectorApplicationContext.this.menuItem = null;
                HtmlConnectorApplicationContext.this.payments = null;
                HtmlConnectorApplicationContext.this.sumPurchase = null;
                HtmlConnectorApplicationContext.this.cashUnits = null;
                HtmlConnectorApplicationContext.this.coinUnits = null;
                HtmlConnectorApplicationContext.this.smsCost = null;
                Keeper enable = null;
                if (HtmlConnectorApplicationContext.this.enableCashManager) {
                    enable = HtmlConnectorApplicationContext.this.cashManager.disable();
                }
                if (enable != null && enable.getSum() != null && !enable.getSum().isEmpty()) {
                    HtmlConnectorApplicationContext.this.currentKeeper = enable;
                }
                Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                HtmlConnectorApplicationContext.this.enableCashManager = false;
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430:" + HtmlConnectorApplicationContext.this.currentKeeper));
                MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(idService);
                MenuUtils.processMenu((MenuVisitor)mv);
                HtmlConnectorApplicationContext.this.menuItem = mv.getMenuItem();
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e: " + HtmlConnectorApplicationContext.this.menuItem));
                if (HtmlConnectorApplicationContext.this.menuItem == null) {
                    HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "html,reinit,id-servide=" + idService + " - not found"));
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c \u043e\u0448\u0438\u0431\u043a\u0443: 1");
                    HtmlConnectorApplicationContext.this.notifier.onReinit(new BeginResult(1, 0));
                    this.csController.go2NewState(ConnectorState.cancel);
                    this.csController.go2NewState(ConnectorState.load);
                } else {
                    HtmlConnectorApplicationContext.this.notifier.onReinit(new BeginResult(0, HtmlConnectorApplicationContext.this.menuItem.getService().getId()));
                }
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
            }
        }

        @Override
        public void onPayment(Payments payments) {
            Commission personal;
            try {
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.payment);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
                return;
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041d\u0430\u0447\u0430\u043b\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + payments));
            HtmlConnectorApplicationContext.this.payments = payments;
            if (payments.getIdService() != HtmlConnectorApplicationContext.this.menuItem.getService().getId()) {
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0443\u043d\u043a\u0442\u0430 \u043c\u0435\u043d\u044e. \u041f\u043e\u0434\u043c\u0435\u043d\u044f\u044e \u0441\u0435\u0440\u0432\u0438\u0441. \u041d\u043e\u0432\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441: " + payments.getIdService()));
                MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(payments.getIdService());
                MenuUtils.processMenu((MenuVisitor)mv);
                if (mv.getMenuItem() == null) {
                    HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "html,begin,id-servide=" + payments.getIdService() + " - not found"));
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443: 1");
                    HtmlConnectorApplicationContext.this.notifier.onlyResultCode(1, "payment");
                    this.csController.rollback(ConnectorState.begin);
                    return;
                }
                if (mv.getMenuItem().getService().getChildServices() != null && mv.getMenuItem().getService().getChildServices().contains(payments.getIdService())) {
                    Service currentService = new Service(mv.getMenuItem().getService());
                    MenuItem newMenuItem = new MenuItem(mv.getMenuItem());
                    currentService.setId(payments.getIdService());
                    newMenuItem.setService(currentService);
                    HtmlConnectorApplicationContext.this.menuItem = newMenuItem;
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041f\u043e\u0434\u043c\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u0430. \u041d\u043e\u0432\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441: " + HtmlConnectorApplicationContext.this.menuItem.getService().getId()));
                }
            }
            HtmlConnectorApplicationContext.this.setPersonalComm = false;
            this.menuItemBackUp();
            if ("single".equals(payments.getDistributionType()) && (personal = ProviderHelper.getPersonalCommission(StoreHelper.convertObj(HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getData()), HtmlConnectorApplicationContext.this.menuItem.getService().getId(), HtmlConnectorApplicationContext.this.menuItem.getService().getServiceTypeId())) != null) {
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0443\u044e \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044e: " + personal));
                HtmlConnectorApplicationContext.this.setPersonalComm = true;
                HtmlConnectorApplicationContext.this.menuItem.setCommission(personal);
                HtmlConnectorApplicationContext.this.menuItem.getService().setCommission(personal);
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u043d\u043a\u0442\u0443 \u043c\u0435\u043d\u044e: " + HtmlConnectorApplicationContext.this.menuItem.getCommission()));
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443: " + HtmlConnectorApplicationContext.this.menuItem.getService().getCommission()));
            this.processSumPurchase(payments.getSum());
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0424\u043b\u0430\u0433\u0438 \u0441\u0445\u0435\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 =  " + HtmlConnectorApplicationContext.this.menuItem.getService().getPaymentSchemaFlags()));
            boolean canCard = true;
            if (HtmlConnectorApplicationContext.this.currentKeeper != null && !HtmlConnectorApplicationContext.this.currentKeeper.getSum().isEmpty()) {
                canCard = false;
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u044b \u043a\u0430\u0440\u0442\u043e\u0439: " + canCard));
            if (this.cm != null && canCard && (HtmlConnectorApplicationContext.this.menuItem.getService().getPaymentSchemaFlags() & 4) > 0) {
                boolean isCahs = (HtmlConnectorApplicationContext.this.menuItem.getService().getPaymentSchemaFlags() & 1) > 0;
                boolean isCbc = (HtmlConnectorApplicationContext.this.menuItem.getService().getPaymentSchemaFlags() & 2) > 0;
                boolean isInit = this.cm.isInit();
                boolean isReady = this.cm.isReady();
                boolean isCardReaderOnly = this.cm.isCardReaderOnly();
                HtmlConnectorApplicationContext.this.log.info((Object)("CM init: " + isInit + ", ready: " + isReady + ", card reader only: " + isCardReaderOnly));
                if (isInit && isReady && !isCardReaderOnly) {
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041a\u0430\u0440\u0442\u043e\u0447\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c \u0433\u043e\u0442\u043e\u0432 \u043a \u043e\u043f\u043b\u0430\u0442\u0435");
                    HtmlConnectorApplicationContext.this.notifier.onPayment(isCahs || isCbc, HtmlConnectorApplicationContext.this.sumPurchase == null || HtmlConnectorApplicationContext.this.sumPurchase.isEmpty());
                    return;
                }
            }
            HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u0435\u0440\u0435\u0445\u043e\u0436\u0443 \u043a \u044d\u043a\u0440\u0430\u043d\u0443 \u043e\u043f\u043b\u0430\u0442\u044b");
            this.processSumRequire();
            this.onContinuePayment();
        }

        private void processSumPurchase(Sum sumPurch) {
            Sum minSum = HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum();
            HtmlConnectorApplicationContext.this.sumPurchase = sumPurch;
            HtmlConnectorApplicationContext.this.log.info((Object)("*  SumPurchase =" + (HtmlConnectorApplicationContext.this.sumPurchase == null ? "<\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430>" : HtmlConnectorApplicationContext.this.sumPurchase.toString()) + ", minimal=" + (minSum == null || minSum.isEmpty() ? "<\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430>" : minSum.toString())));
            if (minSum != null && !HtmlConnectorApplicationContext.this.sumPurchase.isEmpty() && HtmlConnectorApplicationContext.this.sumPurchase.compareTo(minSum) < 0) {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0418\u0441\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0443\u043c\u043c\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                HtmlConnectorApplicationContext.this.sumPurchase = minSum;
                HtmlConnectorApplicationContext.this.log.info((Object)("*  SumPurchase =" + (HtmlConnectorApplicationContext.this.sumPurchase == null ? "<\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430>" : HtmlConnectorApplicationContext.this.sumPurchase.toString()) + ", minimal=" + (minSum == null || minSum.isEmpty() ? "<\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430>" : minSum.toString())));
            }
        }

        private void processSumRequire() {
            Sum minSum = HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum();
            HtmlConnectorApplicationContext.this.sumRequired = null;
            List<Sum> packSums = this.getPackSums(HtmlConnectorApplicationContext.this.payments.getPayments());
            if (HtmlConnectorApplicationContext.this.menuItem.getService().isGroupPaymentDividedCommission() && packSums != null && (HtmlConnectorApplicationContext.this.sumPurchase == null || HtmlConnectorApplicationContext.this.sumPurchase.isEmpty())) {
                HtmlConnectorApplicationContext.this.sumRequired = CommissionCalculator.calculate(packSums, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)HtmlConnectorApplicationContext.this.menuItem.getService().getCommission(), (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), null);
            } else if (HtmlConnectorApplicationContext.this.menuItem.getService().isGroupPaymentDividedCommission() && HtmlConnectorApplicationContext.this.menuItem.getService().getDivideSum() != null && !HtmlConnectorApplicationContext.this.menuItem.getService().getDivideSum().isEmpty() && (HtmlConnectorApplicationContext.this.sumPurchase == null || HtmlConnectorApplicationContext.this.sumPurchase.isEmpty())) {
                HtmlConnectorApplicationContext.this.sumRequired = CommissionCalculator.calculate((Sum)minSum, (Sum)HtmlConnectorApplicationContext.this.menuItem.getService().getDivideSum(), (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)HtmlConnectorApplicationContext.this.menuItem.getService().getCommission(), (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), null);
            } else if (HtmlConnectorApplicationContext.this.sumPurchase != null && !HtmlConnectorApplicationContext.this.sumPurchase.isEmpty()) {
                HtmlConnectorApplicationContext.this.sumRequired = CommissionCalculator.calculate((Sum)HtmlConnectorApplicationContext.this.sumPurchase, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)HtmlConnectorApplicationContext.this.menuItem.getService().getCommission(), (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), null);
            }
            if (HtmlConnectorApplicationContext.this.sumRequired == null && minSum != null && !minSum.isEmpty()) {
                HtmlConnectorApplicationContext.this.sumRequired = CommissionCalculator.calculate((Sum)minSum, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)HtmlConnectorApplicationContext.this.menuItem.getService().getCommission(), (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), null);
            }
            if (HtmlConnectorApplicationContext.this.sumRequired != null) {
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u0443\u043c\u043c\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430\u044f \u043a \u0432\u043d\u0435\u0441\u0435\u043d\u0438\u044e: " + HtmlConnectorApplicationContext.this.sumRequired));
            }
        }

        @Override
        public void onContinuePayment() {
            if (!ConnectorState.payment.equals((Object)this.csController.getPrevios())) {
                HtmlConnectorApplicationContext.this.notifier.onError(4, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u043e\u0434\u0430 ContinuePayment \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f");
                return;
            }
            Date now = new Date();
            HtmlConnectorApplicationContext.this.cashUnits = PaymentHelper.getAllowedUnits(HtmlConnectorApplicationContext.this.menuItem, 3, now);
            HtmlConnectorApplicationContext.this.coinUnits = PaymentHelper.getAllowedUnits(HtmlConnectorApplicationContext.this.menuItem, 4, now);
            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "payment");
            HtmlConnectorApplicationContext.this.notifier.onSumRequired(HtmlConnectorApplicationContext.this.sumRequired == null ? "0" : HtmlConnectorApplicationContext.this.sumRequired.toString());
            if (HtmlConnectorApplicationContext.this.currentKeeper == null) {
                HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
            }
            Session.getInstance().setCorrectPack(this.createPaymentsPack());
            Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0412\u043b\u043a\u043b\u044e\u0447\u0430\u0435\u043c \u043f\u0440\u0438\u0435\u043c \u043a\u0443\u043f\u044e\u0440. \u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430: " + HtmlConnectorApplicationContext.this.currentKeeper));
            HtmlConnectorApplicationContext.this.cashManager.enable(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService().getMaxSum(), HtmlConnectorApplicationContext.this.cashUnits, HtmlConnectorApplicationContext.this.coinUnits, (KeeperObserver)new ContextKeeperListener(), 65535, false);
            HtmlConnectorApplicationContext.this.enableCashManager = true;
        }

        @Override
        public void onCheckDispenser() {
            HtmlConnectorApplicationContext.this.log.info((Object)"* \u0420\u0430\u0431\u043e\u0442\u0430 \u0441 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u043e\u043c \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e false");
            HtmlConnectorApplicationContext.this.notifier.onDispenserAvailable(false);
        }

        @Override
        public void onCardPayment(Sum sumPurch) {
            if (sumPurch != null && !sumPurch.isEmpty()) {
                HtmlConnectorApplicationContext.this.sumPurchase = sumPurch;
            }
            if (HtmlConnectorApplicationContext.this.sumPurchase == null || HtmlConnectorApplicationContext.this.sumPurchase.isEmpty()) {
                this.menuItemRevert();
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443: 6");
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(6, "cardpayment");
                this.csController.rollback(ConnectorState.begin);
                return;
            }
            Session.getInstance().setCorrectPack(this.createPaymentsPack());
            this.cm.setNewCardPaymentHtmlGL();
            try {
                this.cm.setPoint(ModuleHelper.getPoint());
                this.cm.openSession();
                if (this.cm.isNeedReverse()) {
                    this.menuItemRevert();
                    this.cm.setIntent(new LocalExitIntent(5, "cardpayment", this.csController));
                    this.cm.cancelSession(false);
                    return;
                }
            }
            catch (Exception e) {
                HtmlConnectorApplicationContext.this.log.error((Object)e, (Throwable)e);
                this.cm.setCm(null);
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0438: " + HtmlConnectorApplicationContext.this.sumPurchase));
            if (this.cm.getCm() == null) {
                this.menuItemRevert();
                this.cm.setIntent(new LocalExitIntent(7, "cardpayment", this.csController));
                this.cm.cancelSession(true);
                return;
            }
            this.beginBankOperation();
        }

        private void beginBankOperation() {
            HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u0443\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e");
            Pack pack = Session.getInstance().getCorrectPack();
            this.cm.setSumOutcome(HtmlConnectorApplicationContext.this.sumPurchase);
            Sum sumIncome = CommissionCalculator.calculate((Sum)HtmlConnectorApplicationContext.this.sumPurchase, (Commission)pack.getCommission(), (Commission)pack.getService().getCommission(), (Date)new Date(), (String)"BANKCARD", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
            this.cm.setSumIncome(sumIncome);
            HtmlConnectorApplicationContext.this.log.info((Object)("*  Sum income: " + sumIncome));
            this.cm.setInvokeOperation(true);
            this.cm.purchase(this.cm.createFinanceOperation(), HtmlConnectorApplicationContext.this.clientInterface, new LocalConnectorListener(), HtmlConnectorApplicationContext.this.menuItem.getService());
            HtmlConnectorApplicationContext.this.log.info((Object)"Done");
        }

        private Pack createPaymentsPack() {
            Pack p = new Pack();
            p.setService(HtmlConnectorApplicationContext.this.menuItem.getService());
            p.setCommission(HtmlConnectorApplicationContext.this.menuItem.getCommission());
            LinkedList<Payment> ps = new LinkedList<Payment>();
            for (PaymentData pd : HtmlConnectorApplicationContext.this.payments.getPayments()) {
                Payment pmt = new Payment();
                pmt.setData(StoreHelper.convertObj(pd.getData()));
                ps.add(pmt);
            }
            p.setPayments(ps);
            return p;
        }

        private int processCardPayment(boolean cancel) {
            int checkNumber = HtmlConnectorApplicationContext.this.printerQueue.getCheckNumber();
            if (HtmlConnectorApplicationContext.this.currentKeeper == null) {
                HtmlConnectorApplicationContext.this.currentKeeper = Session.getInstance().getCorrectPack().getKeeper();
            }
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (HtmlConnectorApplicationContext.this.currentKeeper.getCashSum().isEmpty() && lp != null) {
                    checkNumber = lp.getCheckNumber();
                }
            }
            int idOperation = new HtmlHelper().getIdOperation();
            HtmlConnectorApplicationContext.this.log.info((Object)("*  id-operation=@@" + idOperation + " \u0447\u0435\u043a=##" + checkNumber));
            ServiceType st = null;
            Service srv = HtmlConnectorApplicationContext.this.menuItem.getService();
            if (srv != null) {
                GroupByMenuItemVisitor stv = new GroupByMenuItemVisitor(HtmlConnectorApplicationContext.this.menuItem);
                MenuUtils.processMenu((MenuVisitor)stv);
                st = stv.getServiceType();
            }
            if (HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum() != null && !HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum().isEmpty()) {
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum()));
            }
            Operation operation = this.createOperation(st, idOperation, checkNumber);
            operation.setPaymentTool(Session.getInstance().getCorrectPack().getPaymentTool());
            Operation eroroperation = new Operation(operation);
            if (!cancel && srv != null) {
                SumResult sr = Session.getInstance().getCorrectPack().getSumResult();
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0424\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + sr));
                HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                operation.setSumResult(sr);
                int flags = operation.getFlags();
                if (sr.getCommService() != null) {
                    flags |= 4;
                }
                operation.setFlags(flags);
            } else {
                CbcUtil.cancelOperation(operation);
            }
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u0440\u043e\u0432\u043e\u0436\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438");
                ProcessingResult result = HtmlConnectorApplicationContext.this.clientInterface.process(operation);
                Session.getInstance().setLastPayment(operation);
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result));
                if (result.getType() == ProcessingResultType.Ok) {
                    if (result.getDataItems() != null) {
                        for (DataItem di : result.getDataItems()) {
                            operation.getForm().put(di.getKey(), di.getValue());
                            operation.getViews().put(di.getKey(), di.getValue());
                            if (operation.getTitles().get(di.getKey()) == null) {
                                operation.getTitles().put(di.getKey(), di.getKey());
                            }
                            operation.getInputElements().put(di.getKey(), new InputElement(di.getKey(), (String)operation.getTitles().get(di.getKey()), di.getValue(), di.getValue(), 0));
                        }
                    }
                } else {
                    throw new Exception("\u041d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0441\u0442\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043d\u0435 ok");
                }
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044e");
                HtmlConnectorApplicationContext.this.printerQueue.print(operation);
                HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f", (Throwable)ex);
                CbcUtil.cancelOperation(eroroperation);
                try {
                    HtmlConnectorApplicationContext.this.clientInterface.process(eroroperation);
                    Session.getInstance().setLastPayment(operation);
                    HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HtmlConnectorApplicationContext.this.printerQueue.print(eroroperation);
                this.menuItemRevert();
                if (!cancel) {
                    HtmlConnectorApplicationContext.this.notifier.onProcess(4, null);
                }
                return 4;
            }
            HtmlConnectorApplicationContext.this.log.info((Object)"<======================================================");
            this.menuItemRevert();
            if (!cancel) {
                HtmlConnectorApplicationContext.this.notifier.onProcess(0, null);
            }
            return 0;
        }

        @Override
        public void onFinish(boolean saveChange, Integer distribute) {
            try {
                int result;
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.finish);
                if (saveChange && distribute != null) {
                    if (!this.canPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), new Sum(distribute.intValue()), HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission())) {
                        HtmlConnectorApplicationContext.this.log.error((Object)("*  \u0421\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 = " + new Sum(distribute.intValue()) + ". \u0421\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430. \u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b [ " + HtmlConnectorApplicationContext.this.sumRequired + " , " + new Sum(Math.min(HtmlConnectorApplicationContext.this.menuItem.getService().getMaxSum().getBasicSum(), HtmlConnectorApplicationContext.this.cashManager.current().getSum().getBasicSum())) + " ]"));
                        this.csController.rollback(buf);
                        HtmlConnectorApplicationContext.this.notifier.onProcess(6, HtmlConnectorApplicationContext.this.cashManager.current().getSum());
                        return;
                    }
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 = " + new Sum(distribute.intValue()) + ". \u0421\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430."));
                    HtmlConnectorApplicationContext.this.payments.getPayments().get(0).setSum(new Sum(distribute.intValue()));
                    HtmlConnectorApplicationContext.this.sumPurchase = new Sum(distribute.intValue());
                }
                if ((result = this.processPayment(false, saveChange)) != 5) {
                    this.csController.go2NewState(ConnectorState.load);
                }
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
            }
        }

        @Override
        public int onCancel(int code) {
            try {
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.cancel);
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c: " + code));
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430: " + HtmlConnectorApplicationContext.this.currentKeeper));
                if (HtmlConnectorApplicationContext.this.enableCashManager) {
                    HtmlConnectorApplicationContext.this.currentKeeper = HtmlConnectorApplicationContext.this.cashManager.current();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                }
                if (code == 0) {
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0414\u0438\u0430\u043b\u043e\u0433\u0430 \u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0435\u0449\u0435 \u043d\u0435 \u0431\u044b\u043b\u043e");
                    if (HtmlConnectorApplicationContext.this.currentKeeper == null || HtmlConnectorApplicationContext.this.currentKeeper.getSum().isEmpty()) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u043d\u0430\u043b\u0438\u0446\u0438\u0435 \u0432\u043d\u0435\u0441\u0435\u043d\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                        Keeper keeper = HtmlConnectorApplicationContext.this.currentKeeper;
                        if (HtmlConnectorApplicationContext.this.enableCashManager) {
                            keeper = HtmlConnectorApplicationContext.this.cashManager.disable();
                            HtmlConnectorApplicationContext.this.enableCashManager = false;
                        }
                        if (keeper == null || keeper.getSum().isEmpty()) {
                            HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041a\u043e\u0448\u0435\u043b\u0435\u043a \u043f\u0443\u0441\u0442. \u0417\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u043c \u0441\u0435\u0441\u0441\u0438\u044e");
                            this.csController.rollback(ConnectorState.load);
                            HtmlConnectorApplicationContext.this.log.info((Object)"<======================================================");
                            this.menuItemRevert();
                            HtmlConnectorApplicationContext.this.notifier.onCancel(code, 0);
                            return 0;
                        }
                        HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041a\u043e\u0448\u0435\u043b\u0435\u043a \u043d\u0435\u043f\u0443\u0441\u0442. \u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0441\u0435\u0441\u0441\u0438\u044e");
                        HtmlConnectorApplicationContext.this.currentKeeper = keeper;
                        Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                        HtmlConnectorApplicationContext.this.cashManager.enable(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService().getMaxSum(), HtmlConnectorApplicationContext.this.cashUnits, HtmlConnectorApplicationContext.this.coinUnits, (KeeperObserver)new ContextKeeperListener(), 65535, false);
                        HtmlConnectorApplicationContext.this.enableCashManager = true;
                        if (HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum() != null && !HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum().isEmpty() && !this.canPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission())) {
                            HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e CANCEL_SUM_NOT_ENOUGH");
                            this.csController.rollback(ConnectorState.payment);
                            HtmlConnectorApplicationContext.this.notifier.onCancel(code, 2);
                            return 2;
                        }
                        HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u0430 \u0434\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b \u0441\u0435\u0440\u0432\u0438\u0441\u0430. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e CANCEL_SUM_ENOUGH");
                        this.csController.rollback(ConnectorState.payment);
                        HtmlConnectorApplicationContext.this.notifier.onCancel(code, 3);
                        return 3;
                    }
                    if (HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum() != null && !HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum().isEmpty() && !this.canPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission())) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e CANCEL_SUM_NOT_ENOUGH");
                        this.csController.rollback(ConnectorState.payment);
                        HtmlConnectorApplicationContext.this.notifier.onCancel(code, 2);
                        return 2;
                    }
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u0430 \u0434\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b \u0441\u0435\u0440\u0432\u0438\u0441\u0430. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e CANCEL_SUM_ENOUGH");
                    this.csController.rollback(ConnectorState.payment);
                    HtmlConnectorApplicationContext.this.notifier.onCancel(code, 3);
                    return 3;
                }
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0414\u0438\u0430\u043b\u043e\u0433 \u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0431\u044b\u043b. \u041e\u043d \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u043e\u0442\u043c\u0435\u043d\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                if (HtmlConnectorApplicationContext.this.enableCashManager) {
                    HtmlConnectorApplicationContext.this.currentKeeper = HtmlConnectorApplicationContext.this.cashManager.disable();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                    HtmlConnectorApplicationContext.this.enableCashManager = false;
                }
                if (HtmlConnectorApplicationContext.this.currentKeeper == null) {
                    HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                }
                if (HtmlConnectorApplicationContext.this.currentKeeper.getSum().isEmpty()) {
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430: " + HtmlConnectorApplicationContext.this.currentKeeper.getCashSum().getSum()));
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041a\u043e\u0448\u0435\u043b\u0435\u043a \u043f\u0443\u0441\u0442. \u041a\u0430\u0440\u0442\u0430 \u0441\u0434\u0430\u0447\u0438 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0434\u0430\u043d\u0430. \u0417\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u043c \u0441\u0435\u0441\u0441\u0438\u044e");
                    HtmlConnectorApplicationContext.this.notifier.onCancel(code, 0);
                    this.csController.go2NewState(ConnectorState.load);
                    HtmlConnectorApplicationContext.this.log.info((Object)"<======================================================");
                    this.menuItemRevert();
                    return 0;
                }
                int result = this.processPayment(true, false);
                HtmlConnectorApplicationContext.this.notifier.onCancel(code, result);
                this.csController.go2NewState(ConnectorState.load);
                return result;
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
                return 4369;
            }
        }

        @Override
        public void onCbcActivate(String pincode) {
            try {
                ConnectorState buf = this.csController.getPrevios();
                this.csController.go2NewState(ConnectorState.cbcactivate);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
                return;
            }
            HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447    \u0438");
            ActivationResult ar = HtmlConnectorApplicationContext.this.cbcModule.activate(pincode, new Sum(0));
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + ar));
            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(ar.getError().getCode(), "cbcActivate");
        }

        @Override
        public void onStackOut(int Password, int Cash, int Coin, int Report, int Menu) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0411\u044b\u043b\u0430 \u0432\u044b\u0434\u0435\u0440\u043d\u0443\u0442\u0430 \u043a\u0430\u0441\u0441\u0435\u0442\u0430. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435: Password = " + Password + ", Cash = " + Cash + ", Coin = " + Coin + ", Report = " + Report + ", Menu = " + Menu));
            HtmlConnectorApplicationContext.this.collectorUser = null;
            HtmlConnectorApplicationContext.this.notifier.onStackOut(Password, Cash, Coin, Report, Menu);
        }

        @Override
        public void onCollectorPassword(String password) {
            HtmlConnectorApplicationContext.this.collectorUser = CheckCollectorPwdHelper.getServerUser(password);
            if (HtmlConnectorApplicationContext.this.collectorUser != null || CheckCollectorPwdHelper.checkPwdPoint(password)) {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430 \u0432\u0435\u0440\u043d\u044b\u0439");
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "collectorpassword");
            } else {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439");
                HtmlConnectorApplicationContext.this.notifier.onError(43690, B.get((String)"Collection.password.fail", (Locale)Locale.ENGLISH));
            }
        }

        @Override
        public void onStackOutCompletion(int Step) {
            ReportResultListener RRL = new ReportResultListener(){

                public void onResult(ReportResult result) {
                    if (!result.isError()) {
                        HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "stackoutcompletion");
                    } else {
                        HtmlConnectorApplicationContext.this.notifier.onError(34952, MessageFormat.format(B.get((String)"Collection.report.result", (Locale)Locale.ENGLISH), result.getMessage(), result.getResult()));
                    }
                }

                public void onFailure(Exception ex) {
                    HtmlConnectorApplicationContext.this.notifier.onError(34952, MessageFormat.format(B.get((String)"Collection.report.failure", (Locale)Locale.ENGLISH), ex));
                }

                public void onUnsupport() {
                    HtmlConnectorApplicationContext.this.notifier.onError(34952, B.get((String)"Collection.report.unsupport", (Locale)Locale.ENGLISH));
                }
            };
            if (Step == 0) {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                HtmlConnectorApplicationContext.this.cashCollectionHandler.onMoneyCollection();
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "stackoutcompletion");
            } else if (Step == 1) {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                HtmlConnectorApplicationContext.this.coinCollectionHandler.onMoneyCollection();
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "stackoutcompletion");
            } else if (Step == 2) {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0435\u0447\u0430\u0442\u0438 \u043e\u0442\u0447\u0435\u0442\u0430");
                HtmlConnectorApplicationContext.this.getPrinterQueue().report(new ReportRequest(KkmOperation.FormReportZMem, RRL));
            } else if (Step == 3) {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0428\u0430\u0433 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438");
                HtmlConnectorApplicationContext.this.getPrinterQueue().report(new ReportRequest(KkmOperation.FormReportZ, RRL));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReferences(int version) {
            block15: {
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438");
                Object fw = null;
                try {
                    JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{ReferencesAdapter.class});
                    Marshaller m = c.createMarshaller();
                    StringWriter sw = new StringWriter();
                    ReferencesAdapter rs = this.convert(ReferenceManager.getInstance());
                    if (rs != null) {
                        m.marshal((Object)rs, (Writer)sw);
                        String refs = sw.toString().replace("<referencesAdapter>", "").replace("</referencesAdapter>", "");
                        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(PathUtils.getAppHome() + "/refs.xml"), "UTF-8"));){
                            out.write(refs);
                        }
                        long curentversion = ReferenceManager.getInstance().getVersion();
                        HtmlConnectorApplicationContext.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432: " + curentversion));
                        if (version == 0) {
                            HtmlConnectorApplicationContext.this.log.info((Object)"\u0411\u044b\u043b\u0430 \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432");
                            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(1, "refs");
                        } else if (curentversion == 0L) {
                            HtmlConnectorApplicationContext.this.log.info((Object)"\u041d\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
                            HtmlConnectorApplicationContext.this.notifier.onError(2, "No references for sending");
                        } else if (curentversion == (long)version) {
                            HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430");
                            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "refs");
                        } else {
                            HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435\u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430");
                            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(1, "refs");
                        }
                        break block15;
                    }
                    HtmlConnectorApplicationContext.this.log.info((Object)"\u041d\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
                    HtmlConnectorApplicationContext.this.notifier.onError(2, "No references for sending");
                }
                catch (Throwable ex) {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432", ex);
                    HtmlConnectorApplicationContext.this.notifier.onError(2, "Error send references: " + ex.getMessage());
                }
            }
        }

        @Override
        public void onDemandRequest(Payments payments) {
            try {
                this.csController.go2NewState(ConnectorState.demand);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430." + ex.getMessage()));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onError(4369, ex.getMessage());
            }
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)"Send demand request");
                int val = SequenceManager.getValueQuietly((String)"question");
                StringBuilder sb = new StringBuilder();
                List<InputElement> data = payments.getPayments().get(0).getData();
                Collections.sort(data, new Comparator<InputElement>(){

                    @Override
                    public int compare(InputElement o1, InputElement o2) {
                        return o1.getKey().compareToIgnoreCase(o2.getKey());
                    }
                });
                HtmlConnectorApplicationContext.this.log.info((Object)("Sending data: " + data));
                for (InputElement ie : data) {
                    sb.append(ie.getKey()).append("=").append(ie.getValue()).append(";");
                }
                HtmlConnectorApplicationContext.this.clientInterface.putDemand(new Demand(val, (short)payments.getIdService(), sb.toString()));
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "demandrequest");
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"Error sending demand request", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(39321, "Error sending demand request");
            }
            this.csController.rollback(ConnectorState.load);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTextInfo(String fname) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 textinfo \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430 " + fname));
            BufferedWriter out = null;
            try {
                if (!new File(PathUtils.getAppHome(), "resources/" + fname).exists()) {
                    throw new Exception("Template with name " + fname + " is not found");
                }
                String result = new VSTemplateProcessor(PathUtils.getAppHome()).process("resources/" + fname);
                if (result == null) {
                    throw new Exception("Text is not return");
                }
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("resources/_" + fname), "UTF-8"));
                out.write(result);
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "textinfo");
                IOUtils.closeQuietly((Writer)out);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.notifier.onError(21845, ex.getMessage());
                HtmlConnectorApplicationContext.this.log.error((Object)ex);
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }

        @Override
        public void onCommission(int idService, int simple, List<InputElement> elems) {
            block10: {
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 id= " + idService + " \u0442\u0438\u043f= " + (simple == 0 ? "simple" : "complex")));
                MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(idService);
                MenuUtils.processMenu((MenuVisitor)mv);
                MenuItem item = mv.getMenuItem();
                HtmlConnectorApplicationContext.this.log.info((Object)">> check item");
                if (item != null) {
                    HtmlConnectorApplicationContext.this.log.info((Object)">> fill data");
                    Map data = null;
                    data = elems != null ? StoreHelper.convertObj(elems) : (HtmlConnectorApplicationContext.this.payments != null && !HtmlConnectorApplicationContext.this.payments.getPayments().isEmpty() ? StoreHelper.convertObj(HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getData()) : new HashMap());
                    HtmlConnectorApplicationContext.this.log.info((Object)(">> data=" + data));
                    HtmlConnectorApplicationContext.this.log.info((Object)(">> item.Service=" + item.getService()));
                    HtmlConnectorApplicationContext.this.log.info((Object)(">> item.Service.ServiceTypeId=" + (item.getService() != null ? item.getService().getServiceTypeId() : "null2")));
                    Commission comm = ProviderHelper.getPersonalCommission(data, item.getService().getId(), item.getService().getServiceTypeId());
                    HtmlConnectorApplicationContext.this.log.info((Object)(">> comm=" + comm));
                    if (comm == null) {
                        HashMap<String, InputElement> ies = new HashMap<String, InputElement>();
                        InputElement id1 = this.searchIe(elems, "id1");
                        if (id1 != null) {
                            ies.put("id1", id1);
                        }
                        CommissionRender render = CommissionRender.getInstance();
                        comm = render.processCommission(item.getCommission(), item.getService(), ies, Locale.getDefault(), false, new Date(), null, "CASH");
                    }
                    try {
                        if (comm.isSimple()) {
                            if (simple != 0) {
                                HtmlConnectorApplicationContext.this.notifier.onCommission(ru.softlogic.app.html.connector.utils.CommissionRender.generate(ru.softlogic.app.html.connector.utils.CommissionRender.COMMON, comm));
                            } else {
                                HtmlConnectorApplicationContext.this.notifier.onCommission(ru.softlogic.app.html.connector.utils.CommissionRender.generate(ru.softlogic.app.html.connector.utils.CommissionRender.SIMPLE, comm));
                            }
                            break block10;
                        }
                        if (simple != 0) {
                            HtmlConnectorApplicationContext.this.notifier.onCommission(ru.softlogic.app.html.connector.utils.CommissionRender.generate(ru.softlogic.app.html.connector.utils.CommissionRender.COMMON, comm));
                            break block10;
                        }
                        HtmlConnectorApplicationContext.this.notifier.onError(2, "Invalid commission request");
                    }
                    catch (Exception ex) {
                        HtmlConnectorApplicationContext.this.notifier.onError(21845, ex.getMessage());
                        HtmlConnectorApplicationContext.this.log.error((Object)ex);
                    }
                } else {
                    HtmlConnectorApplicationContext.this.notifier.onError(1, "Service not found");
                }
            }
        }

        private InputElement searchIe(List<InputElement> ies, String key) {
            for (InputElement ie : ies) {
                if (!key.equals(ie.getKey())) continue;
                return ie;
            }
            return null;
        }

        @Override
        public void onCommissionCalc(int idService, int sum, List<InputElement> elems, boolean inverse) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 id= " + idService + ", \u0441\u0443\u043c\u043c\u0430 " + sum));
            MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(idService);
            MenuUtils.processMenu((MenuVisitor)mv);
            MenuItem item = mv.getMenuItem();
            if (item != null) {
                SumResult res;
                HashMap<String, Object> data = elems != null ? StoreHelper.convertObj(elems) : new HashMap<String, Object>();
                Service s = item.getService();
                Pack pack = Session.getInstance().getPack();
                Commission comm = ProviderHelper.getPersonalCommission(data, s.getId(), s.getServiceTypeId());
                if (comm == null) {
                    comm = item.getCommission();
                }
                if (inverse) {
                    Sum in = CommissionCalculator.calculate((Sum)new Sum(sum), (Commission)comm, (Commission)s.getMinComm(), (Commission)s.getCommission(), (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee());
                    Keeper keeper = new Keeper();
                    keeper.addCashBackCard(new CashBackCard(0, in));
                    res = CommissionCalculator.calculate((Sum)in, (Keeper)keeper, (Commission)comm, (Commission)s.getMinComm(), (Commission)s.getCommission(), (Sum)new Sum(sum), (Sum)s.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)item.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee(), (Sum)HtmlConnectorApplicationContext.this.smsCost);
                } else {
                    Keeper keeper = new Keeper();
                    keeper.addCashBackCard(new CashBackCard(0, new Sum(sum)));
                    res = CommissionCalculator.calculate((Sum)new Sum(sum), (Keeper)keeper, (Commission)comm, (Commission)s.getMinComm(), (Commission)s.getCommission(), null, (Sum)s.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)item.isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee(), (Sum)HtmlConnectorApplicationContext.this.smsCost);
                }
                HtmlConnectorApplicationContext.this.notifier.onCommissionCalc(res);
            } else {
                HtmlConnectorApplicationContext.this.notifier.onError(1, "Service not found");
            }
        }

        @Override
        public void onPing() {
            try {
                HtmlConnectorApplicationContext.this.log.debug((Object)"ping");
                this.csController.go2NewState(ConnectorState.ping);
            }
            catch (ConnectorStateController.WrongMethodInvocation ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 ping", (Throwable)ex);
            }
        }

        @Override
        public void onLog(int level, String message) {
            Level l = Level.DEBUG;
            if (level == 0) {
                l = Level.ERROR;
            } else if (level == 1) {
                l = Level.INFO;
            }
            HtmlConnectorApplicationContext.this.logGui.log((Priority)l, (Object)message);
        }

        public ConnectorState getConnectorState() {
            return this.csController.getPrevios();
        }

        @Override
        public void onOnline(int idService, Map<String, String> data) {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u0440\u043e\u0432\u043e\u0434\u0438\u043c \u043e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443");
            MenuByServiceIdVisitor mv = new MenuByServiceIdVisitor(idService);
            MenuUtils.processMenu((MenuVisitor)mv);
            MenuItem item = mv.getMenuItem();
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e: " + item));
            if (item == null) {
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.SoftwareFault, "html,begin,id-servide=" + idService + " - not found"));
                HtmlConnectorApplicationContext.this.log.info((Object)"\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c \u043e\u0448\u0438\u0431\u043a\u0443: 1");
                HtmlConnectorApplicationContext.this.notifier.onError(1, "Service not found");
            } else {
                VerifyResult vresult = null;
                if (item.getService().getVerifyType() == VerifyType.Verify || item.getService().getVerifyType() == VerifyType.HalfOnline) {
                    try {
                        vresult = HtmlConnectorApplicationContext.this.clientInterface.verify(item.getService(), HtmlU.convert(data));
                    }
                    catch (Exception ex) {
                        HtmlConnectorApplicationContext.this.log.error((Object)("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u043d\u043b\u0430\u0439\u043d-\u0437\u0430\u043f\u0440\u043e\u0441\u0435" + ex.getMessage()));
                    }
                    if (item.getService().getVerifyType() == VerifyType.HalfOnline) {
                        if (vresult == null) {
                            vresult = new VerifyResult(VerifyResultType.Ok);
                        } else if (vresult.getResultType() != VerifyResultType.NotFound && vresult.getResultType() != VerifyResultType.ProviderPermit) {
                            vresult = new VerifyResult(VerifyResultType.Ok, vresult.getSumPurchase(), vresult.getTitle(), vresult.getDataItems(), vresult.getScreenType());
                        }
                    }
                    if (vresult == null) {
                        HtmlConnectorApplicationContext.this.log.error((Object)"\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443: 17476");
                        HtmlConnectorApplicationContext.this.notifier.onError(17476, "Failed when online request");
                    } else {
                        HtmlConnectorApplicationContext.this.log.info((Object)("\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + vresult.getResultType()));
                        HtmlConnectorApplicationContext.this.notifier.onOnline(idService, vresult);
                    }
                    HtmlConnectorApplicationContext.this.log.info((Object)"\u041e\u043d\u043b\u0430\u0439\u043d \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                } else {
                    HtmlConnectorApplicationContext.this.notifier.onOnline(idService, new VerifyResult(VerifyResultType.Ok));
                }
            }
        }

        @Override
        public void onState() {
            HtmlConnectorApplicationContext.this.currentState = StateFacade.getState();
            if (HtmlConnectorApplicationContext.this.currentState != null) {
                HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430: " + HtmlConnectorApplicationContext.this.currentState));
                HtmlConnectorApplicationContext.this.notifier.onState(HtmlConnectorApplicationContext.this.currentState.getErrorCode(), HtmlConnectorApplicationContext.this.currentState.getWarningMask(), this.csController.getPrevios().toString());
            } else {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
            }
        }

        @Override
        public void onSendEvent(String events, String message) {
            try {
                String event = events.toLowerCase();
                EventType ev = null;
                if ("start".equals(event)) {
                    ev = EventType.Start;
                } else if ("softwarefault".equals(event)) {
                    ev = EventType.SoftwareFault;
                } else if ("numberfault".equals(event)) {
                    ev = EventType.NumberFault;
                } else if ("servicemenulogin".equals(event)) {
                    ev = EventType.ServiceMenuLogin;
                } else if ("kkmevent".equals(event)) {
                    ev = EventType.KkmEvent;
                } else if ("referenceevent".equals(event)) {
                    ev = EventType.ReferenceEvent;
                } else if ("moneycollection".equals(event)) {
                    ev = EventType.MoneyCollection;
                } else if ("voidmoneycollection".equals(event)) {
                    ev = EventType.VoidMoneyCollection;
                } else if ("updatefault".equals(event)) {
                    ev = EventType.UpdateFault;
                } else if ("promotercontrol".equals(event)) {
                    ev = EventType.PromoterControl;
                } else if ("searchservice".equals(event)) {
                    ev = EventType.SearchService;
                } else if ("jamm".equals(event)) {
                    ev = EventType.Jamm;
                } else if ("calibrationfault".equals(event)) {
                    ev = EventType.CalibrationFault;
                } else if ("update".equals(event)) {
                    ev = EventType.Update;
                } else if ("warning".equals(event)) {
                    ev = EventType.Warning;
                }
                if (ev == null) {
                    throw new Exception("Event not found");
                }
                HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u0441\u044b\u043b\u0430\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440: event - " + event + " message - " + message));
                HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(ev, message));
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "sendevent");
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u0421\u0431\u043e\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f: " + ex.getMessage()));
                HtmlConnectorApplicationContext.this.notifier.onlyResultCode(1, "sendevent");
            }
        }

        @Override
        public void onServiceMenu(String login, String password, String button, Map<String, String> params) {
            block32: {
                try {
                    HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044e");
                    HtmlConnectorApplicationContext.this.smc.validUser(login, password);
                    if ("cashmoneycollection".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u044f \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                        HtmlConnectorApplicationContext.this.smc.onCashMoneyCollection();
                        break block32;
                    }
                    if ("coinmoneycollection".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u044f \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                        HtmlConnectorApplicationContext.this.smc.onCoinMoneyCollection();
                        break block32;
                    }
                    if ("rebootterminal".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
                        HtmlConnectorApplicationContext.this.smc.onRebootTerminal();
                        break block32;
                    }
                    if ("poweroffterminal".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
                        HtmlConnectorApplicationContext.this.smc.onPowerOffTerminal();
                        break block32;
                    }
                    if ("restartsoftware".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043e\u0444\u0442\u0430");
                        HtmlConnectorApplicationContext.this.smc.onRestartSoftware();
                        break block32;
                    }
                    if ("closesoftware".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0441\u043e\u0444\u0442\u0430");
                        HtmlConnectorApplicationContext.this.smc.onCloseSoftware();
                        break block32;
                    }
                    if ("testprinter".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0442\u0435\u0441\u0442 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                        HtmlConnectorApplicationContext.this.smc.onTestPrinter();
                        break block32;
                    }
                    if ("testnetwork".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.debug((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0442\u0435\u0441\u0442 \u0441\u0435\u0442\u0438");
                        HtmlConnectorApplicationContext.this.smc.onTestNetwork();
                        break block32;
                    }
                    if ("networkupdate".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.debug((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e \u0441\u0435\u0442\u0438");
                        HtmlConnectorApplicationContext.this.smc.onNetworkUpdate();
                        break block32;
                    }
                    if ("localupdate".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.debug((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435");
                        HtmlConnectorApplicationContext.this.smc.localupdate(params.get("param1"));
                        break block32;
                    }
                    if ("checkdealerbalance".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0431\u0430\u043b\u0430\u043d\u0441 \u0434\u0438\u043b\u0435\u0440\u0430");
                        HtmlConnectorApplicationContext.this.smc.onCheckDealerBalance();
                        break block32;
                    }
                    if ("startconfig".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0437\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440\u0430");
                        HtmlConnectorApplicationContext.this.smc.onStartConfig();
                        break block32;
                    }
                    if ("requestmoneycollections".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                        HtmlConnectorApplicationContext.this.smc.onRequestMoneyCollections();
                        break block32;
                    }
                    if ("printmoneycollections".equals(button)) {
                        int n = Integer.parseInt(params.get("param1"));
                        HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0430\u0446\u0438\u0438 \u2116" + n));
                        HtmlConnectorApplicationContext.this.smc.onPrintMoneyCollections(n);
                        break block32;
                    }
                    if ("status".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441");
                        HtmlConnectorApplicationContext.this.smc.getStatus();
                        break block32;
                    }
                    if ("xreport".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d X-\u043e\u0442\u0447\u0435\u0442");
                        HtmlConnectorApplicationContext.this.smc.onReportX();
                        break block32;
                    }
                    if ("zreport".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d Z-\u043e\u0442\u0447\u0435\u0442");
                        HtmlConnectorApplicationContext.this.smc.onReportZ();
                        break block32;
                    }
                    if ("zreportservice".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 Z-\u043e\u0442\u0447\u0435\u0442");
                        HtmlConnectorApplicationContext.this.smc.onReportZService();
                        break block32;
                    }
                    if ("zreportmem".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d Z-\u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
                        HtmlConnectorApplicationContext.this.smc.onReportZMem();
                        break block32;
                    }
                    if ("reportbyrange".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434");
                        Date start = new SimpleDateFormat("dd.MM.yyyy").parse(params.get("param1"));
                        Date stop = new SimpleDateFormat("dd.MM.yyyy").parse(params.get("param2"));
                        boolean d = Boolean.parseBoolean(params.get("param3"));
                        HtmlConnectorApplicationContext.this.smc.onReportByRange(start, stop, d, params.get("param4"));
                        break block32;
                    }
                    if ("validuser".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
                        HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, button);
                        HtmlConnectorApplicationContext.this.clientInterface.sendEvent(new Event(EventType.ServiceMenuLogin, "login=" + HtmlConnectorApplicationContext.this.menuUser.getLogin() + ",fio=" + HtmlConnectorApplicationContext.this.menuUser.getFio()));
                        break block32;
                    }
                    if ("calibrate".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0412\u044b\u0437\u0432\u0430\u0442\u044c \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u0449\u0438\u043a");
                        HtmlConnectorApplicationContext.this.smc.onCalibrate();
                        break block32;
                    }
                    if ("getos".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0442\u0438\u043f\u0430 \u041e\u0421");
                        JSONObject result = new JSONObject();
                        result.put("os", (int)OsDetector.current());
                        HtmlConnectorApplicationContext.this.notifier.onServiceMenu("getos", result);
                        break block32;
                    }
                    if ("logs".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u044b \u043b\u043e\u0433\u0438");
                        HtmlConnectorApplicationContext.this.smc.onLogs();
                        break block32;
                    }
                    if ("opencontrolpanel".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u043f\u0430\u043d\u0435\u043b\u0438 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
                        HtmlConnectorApplicationContext.this.smc.onOpenControlPanel();
                        break block32;
                    }
                    if ("getcash".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0432 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0435");
                        HtmlConnectorApplicationContext.this.smc.getCash(HtmlConnectorApplicationContext.this.cashCollectionHandler.getBox(), HtmlConnectorApplicationContext.this.coinCollectionHandler.getBox());
                        break block32;
                    }
                    if ("testpay".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0439 \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
                        HtmlConnectorApplicationContext.this.smc.onTestPay();
                        break block32;
                    }
                    if ("confirm".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u0438\u044f");
                        HtmlConnectorApplicationContext.this.smc.confirm(Boolean.parseBoolean(params.get("param1")));
                        break block32;
                    }
                    if ("visiblekkm".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0432\u043a\u043b\u0430\u0434\u043a\u0438 KKM");
                        HtmlConnectorApplicationContext.this.smc.visibleKKMPanel(login, password);
                        break block32;
                    }
                    if ("modeminfo".equals(button)) {
                        HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043c\u043e\u0434\u0435\u043c\u0435");
                        HtmlConnectorApplicationContext.this.smc.onModemInfo();
                        break block32;
                    }
                    throw new Exception("The requested function is not available in the service menu");
                }
                catch (Exception ex) {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e", (Throwable)ex);
                    HtmlConnectorApplicationContext.this.notifier.onError(30583, ex.getMessage());
                }
            }
        }

        @Override
        public void onCheckCopy(long idOperation, String pin) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a\u043e\u043f\u0438\u0438 \u0447\u0435\u043a\u0430: oper=" + idOperation + ",pin=" + pin));
            try {
                Operation op = HtmlConnectorApplicationContext.this.clientInterface.checkCopy(idOperation, pin);
                HtmlConnectorApplicationContext.this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + op));
                if (op == null) {
                    HtmlConnectorApplicationContext.this.log.error((Object)"\u0412\u0435\u0440\u043d\u0443\u043b\u0441\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u043e\u0442\u0432\u0435\u0442");
                    HtmlConnectorApplicationContext.this.notifier.onError(26214, "Error printing a check copy");
                } else {
                    this.fixOperation(op);
                    HtmlConnectorApplicationContext.this.log.info((Object)("Views=" + op.getViews() + ", titles=" + op.getTitles() + ", form=" + op.getForm() + ", point=" + op.getPoint() + ", dealer=" + op.getDealer()));
                    HtmlConnectorApplicationContext.this.printerQueue.print(op);
                    HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "checkcopy");
                }
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u043a\u043e\u043f\u0438\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(26214, "Error printing a check copy: " + ex.getMessage());
            }
        }

        @Override
        public void onPrintCustom(String templateName, Map<String, Object> data) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u043c \u043f\u0435\u0447\u0430\u0442\u044c. \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: " + templateName));
            new PrinterAdapter(HtmlConnectorApplicationContext.this.getPrinterQueue()).printCustom(templateName, data);
            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "printcustom");
        }

        @Override
        public void onOnlineRequest(RequestData data) {
            try {
                HtmlConnectorApplicationContext.this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441: " + data));
                Response<Data> response = new ConnectorAdapter(HtmlConnectorApplicationContext.this.clientInterface).request(data);
                HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u043e\u043d\u043b\u0430\u0439\u043d \u0437\u0430\u043f\u0440\u043e\u0441: " + response));
                HtmlConnectorApplicationContext.this.notifier.onOnlineRequest(response);
            }
            catch (Exception ex) {
                HtmlConnectorApplicationContext.this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435: " + ex.getMessage()), (Throwable)ex);
                HtmlConnectorApplicationContext.this.notifier.onError(39321, ex.getMessage());
            }
        }

        @Override
        public void onSetModule(int module) {
            HtmlConnectorApplicationContext.this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043c\u043e\u0434\u0443\u043b\u044c: " + module));
            HtmlConnectorApplicationContext.this.currentModule = module;
            HtmlConnectorApplicationContext.this.notifyModuleTypeListeners(module);
            HtmlConnectorApplicationContext.this.notifier.onlyResultCode(0, "setmodule");
        }

        @Override
        public void onUnknownMethod() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u043c\u0435\u0442\u043e\u0434\u043e\u043c");
            HtmlConnectorApplicationContext.this.notifier.onError(8738, "Failure to work with the method");
        }

        @Override
        public void connected() {
            HtmlConnectorApplicationContext.this.log.info((Object)"Browser connect");
        }

        @Override
        public void disconnected() {
            HtmlConnectorApplicationContext.this.log.info((Object)"Browser disconnect");
        }

        private List<Sum> getPackSums(List<PaymentData> payments) {
            if (payments == null || payments.size() < 2) {
                return null;
            }
            LinkedList<Sum> sums = new LinkedList<Sum>();
            for (PaymentData pd : payments) {
                if (pd.getSum() == null || pd.getSum().isEmpty()) continue;
                sums.add(pd.getSum());
            }
            if (sums.isEmpty()) {
                return null;
            }
            return sums;
        }

        private void menuItemBackUp() {
            if (HtmlConnectorApplicationContext.this.menuItem != null) {
                HtmlConnectorApplicationContext.this.backupcommission1 = HtmlConnectorApplicationContext.this.menuItem.getCommission();
                HtmlConnectorApplicationContext.this.backupcommission2 = HtmlConnectorApplicationContext.this.menuItem.getService().getCommission();
            }
        }

        private void menuItemRevert() {
            if (HtmlConnectorApplicationContext.this.setPersonalComm) {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0411\u044b\u043b\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0430 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f, \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c \u043e\u0431\u044b\u0447\u043d\u0443\u044e");
                HtmlConnectorApplicationContext.this.menuItem.setCommission(HtmlConnectorApplicationContext.this.backupcommission1);
                HtmlConnectorApplicationContext.this.menuItem.getService().setCommission(HtmlConnectorApplicationContext.this.backupcommission2);
            } else {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0430\u0441\u044c, \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043c\u0435\u043d\u044f\u044e");
            }
            HtmlConnectorApplicationContext.this.smsCost = null;
        }

        private void fixOperation(Operation op) throws ReferenceException {
            if (op == null) {
                return;
            }
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(op.getService().getId());
            MenuUtils.processMenu((MenuVisitor)mbsiv);
            if (mbsiv.getMenuItem() != null) {
                HtmlConnectorApplicationContext.this.log.info((Object)mbsiv.getMenuItem());
                GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(mbsiv.getMenuItem());
                MenuUtils.processMenu((MenuVisitor)gbmiv);
                op.setServiceType(gbmiv.getServiceType());
            } else {
                HtmlConnectorApplicationContext.this.log.error((Object)("Menu item by service id " + op.getService().getId() + " not found"));
            }
            if (op.getPoint() == null) {
                op.setPoint(ReferenceManager.getInstance().getPoint());
            }
            op.setCopy(true);
            if (op.getService() != null) {
                if (op.getService().getProviderType() == ProviderType.Mobile) {
                    SimpleFormatter formatter = new SimpleFormatter("8(***)***-****");
                    op.getTitles().put("id1", B.get((String)"Provider.mobile.phone.number"));
                    op.getViews().put("id1", formatter.format((String)op.getForm().get("id1")));
                    InputElement id1 = (InputElement)op.getInputElements().get("id1");
                    if (id1 != null) {
                        id1.setKeyTitle(B.get((String)"Provider.mobile.phone.number"));
                        id1.setValueTitle(formatter.format((String)op.getForm().get("id1")));
                    }
                } else {
                    if (op.getViews().get("id1") == null) {
                        op.getViews().put("id1", op.getForm().get("id1"));
                    }
                    if (op.getTitles().get("id1") == null) {
                        op.getTitles().put("id1", "");
                    }
                    if (op.getTitles().get("id2") == null) {
                        op.getTitles().put("id2", "");
                    }
                    if (op.getViews().get("id2") == null && op.getForm().get("id2") != null) {
                        op.getViews().put("id2", op.getForm().get("id2"));
                    }
                }
            }
        }

        private void clearSession() {
            HtmlConnectorApplicationContext.this.menuItem = null;
            HtmlConnectorApplicationContext.this.payments = null;
            HtmlConnectorApplicationContext.this.sumPurchase = null;
            HtmlConnectorApplicationContext.this.currentKeeper = null;
            HtmlConnectorApplicationContext.this.smsCost = null;
            Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            HtmlConnectorApplicationContext.this.cashUnits = null;
            HtmlConnectorApplicationContext.this.coinUnits = null;
            HtmlConnectorApplicationContext.this.enableCashManager = false;
        }

        private Operation createOperation(ServiceType st, int idOperation, int checkNumber) {
            Operation operation = new Operation();
            operation.setFeHash(PaymentHelper.getFeHash());
            operation.setService(HtmlConnectorApplicationContext.this.menuItem.getService());
            operation.setCommission(HtmlConnectorApplicationContext.this.menuItem.getCommission());
            operation.setIdOperation(idOperation);
            operation.setCheckNumber(checkNumber);
            operation.setServiceType(st);
            operation.setDate(new Date());
            operation.setDealer(ModuleHelper.getDealer());
            operation.setPoint(ModuleHelper.getPoint());
            operation.setPaymentSystem(ModuleHelper.getPaymentSystem());
            operation.setKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            if (HtmlConnectorApplicationContext.this.payments != null && HtmlConnectorApplicationContext.this.payments.getPayments() != null && !HtmlConnectorApplicationContext.this.payments.getPayments().isEmpty()) {
                for (InputElement id : HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getData()) {
                    operation.getForm().put(id.getKey(), id.getValue());
                    operation.getViews().put(id.getKey(), id.getValueTitle());
                    operation.getTitles().put(id.getKey(), id.getKeyTitle());
                    operation.getInputElements().put(id.getKey(), id);
                }
            }
            int flags = 0;
            if ((StateFacade.getState().getWarningMask() & 1) > 0) {
                flags |= 1;
            }
            if (HtmlConnectorApplicationContext.this.menuItem.getService().isFiscalService()) {
                flags |= 0x20;
            }
            if (HtmlConnectorApplicationContext.this.menuItem.getService().getProcessingType() == ProcessingType.Online || HtmlConnectorApplicationContext.this.menuItem.getService().getProcessingType() == ProcessingType.HalfOnline) {
                flags |= 0x10;
            }
            operation.setFlags(flags);
            return operation;
        }

        private int processPayment(boolean cancel, boolean saveChange) {
            Operation operation;
            if (cancel) {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041e\u0442\u043c\u0435\u043d\u0438\u043b\u0438 \u043f\u043b\u0430\u0442\u0435\u0436");
            } else {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438 \u043e\u043f\u043b\u0430\u0442\u0443");
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0417\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u043c \u043f\u0440\u0438\u0435\u043c \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0441\u0434\u0430\u0447\u0438: " + (saveChange ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e")));
                if (HtmlConnectorApplicationContext.this.enableCashManager) {
                    HtmlConnectorApplicationContext.this.currentKeeper = HtmlConnectorApplicationContext.this.cashManager.disable();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                    HtmlConnectorApplicationContext.this.enableCashManager = false;
                }
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430:  " + HtmlConnectorApplicationContext.this.currentKeeper + " \u0441\u0443\u043c\u043c\u0430 = " + HtmlConnectorApplicationContext.this.currentKeeper.getSum().getSum()));
            if (HtmlConnectorApplicationContext.this.currentKeeper == null) {
                HtmlConnectorApplicationContext.this.log.error((Object)"*  \u041f\u0443\u0441\u0442\u043e\u0439 \u043f\u043b\u0430\u0442\u0435\u0436. \u0412\u043e\u0437\u0440\u0430\u0449\u0430\u0435\u043c PAYMENT_ERROR.");
                this.csController.rollback(ConnectorState.load);
                this.menuItemRevert();
                if (!cancel) {
                    HtmlConnectorApplicationContext.this.notifier.onProcess(4, null);
                }
                return 4;
            }
            int checkNumber = HtmlConnectorApplicationContext.this.printerQueue.getCheckNumber();
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (HtmlConnectorApplicationContext.this.currentKeeper.getCashSum().isEmpty() && lp != null) {
                    checkNumber = lp.getCheckNumber();
                }
            }
            int idOperation = new HtmlHelper().getIdOperation();
            HtmlConnectorApplicationContext.this.log.info((Object)("*  id-operation=@@" + idOperation + " \u0447\u0435\u043a=##" + checkNumber));
            ServiceType st = null;
            if (HtmlConnectorApplicationContext.this.menuItem.getService() != null) {
                GroupByMenuItemVisitor stv = new GroupByMenuItemVisitor(HtmlConnectorApplicationContext.this.menuItem);
                MenuUtils.processMenu((MenuVisitor)stv);
                st = stv.getServiceType();
            }
            Service srv = HtmlConnectorApplicationContext.this.menuItem.getService();
            SumResult sumResult = this.resultPay(HtmlConnectorApplicationContext.this.currentKeeper, srv, HtmlConnectorApplicationContext.this.menuItem.getCommission(), srv.getMinSum(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
            this.subSmsCommission(sumResult);
            Sum divSum = srv.getDivideSum();
            Sum os = HtmlConnectorApplicationContext.this.sumPurchase;
            boolean emptyPayments = HtmlConnectorApplicationContext.this.payments == null || HtmlConnectorApplicationContext.this.payments.getPayments() == null || HtmlConnectorApplicationContext.this.payments.getPayments().isEmpty();
            boolean packNotCalculated = true;
            if (!(os != null && !os.isEmpty() || divSum == null || divSum.isEmpty() || emptyPayments || HtmlConnectorApplicationContext.this.payments.getPayments().size() != 1 || cancel)) {
                if (srv.isGroupPaymentDividedCommission()) {
                    PaymentData firstPayment = null;
                    List<SumResult> calculateList = this.calculateList(HtmlConnectorApplicationContext.this.currentKeeper, srv, HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
                    for (SumResult sr : calculateList) {
                        this.subSmsCommission(sr);
                        if (firstPayment == null) {
                            PaymentData payment = HtmlConnectorApplicationContext.this.payments.getPayments().get(0);
                            payment.setSum(sr.getOut());
                            payment.setSum\u0421omm(sr.getCommission());
                            firstPayment = payment;
                            continue;
                        }
                        PaymentData p = new PaymentData();
                        p.setData(firstPayment.getData());
                        p.setSum(sr.getOut());
                        p.setSum\u0421omm(sr.getCommission());
                        HtmlConnectorApplicationContext.this.payments.getPayments().add(p);
                    }
                    packNotCalculated = false;
                } else {
                    Sum totalInput = new Sum(sumResult.getOut());
                    HtmlConnectorApplicationContext.this.log.info((Object)("\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + totalInput + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0441\u0443\u043c\u043c\u044b: " + divSum));
                    int count = totalInput.getBasicSum() / divSum.getBasicSum();
                    if (!totalInput.divRest(divSum).isEmpty()) {
                        ++count;
                    }
                    --count;
                    PaymentData payment = HtmlConnectorApplicationContext.this.payments.getPayments().get(0);
                    payment.setSum(divSum);
                    for (int i = 0; i < count; ++i) {
                        PaymentData payment1 = new PaymentData();
                        payment1.setData(payment.getData());
                        payment1.setSum(divSum);
                        HtmlConnectorApplicationContext.this.payments.getPayments().add(payment1);
                    }
                    HtmlConnectorApplicationContext.this.payments.setDistributionType("consistent");
                }
            }
            if (HtmlConnectorApplicationContext.this.payments == null || HtmlConnectorApplicationContext.this.payments.getPayments() == null || HtmlConnectorApplicationContext.this.payments.getPayments().isEmpty()) {
                operation = this.createOperation(st, idOperation, checkNumber);
                CbcUtil.cancelOperation(operation);
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u0412\u044b\u0434\u0430\u0435\u043c \u043a\u0430\u0440\u0442\u0443 \u0441\u0434\u0430\u0447\u0438");
                try {
                    HtmlConnectorApplicationContext.this.clientInterface.process(operation);
                    Session.getInstance().setLastPayment(operation);
                    HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                }
                catch (Exception count) {
                    // empty catch block
                }
                HtmlConnectorApplicationContext.this.printerQueue.print(operation);
                this.menuItemRevert();
                if (!cancel) {
                    HtmlConnectorApplicationContext.this.notifier.onProcess(4, null);
                }
                return 4;
            }
            if (HtmlConnectorApplicationContext.this.payments.getPayments().size() == 1) {
                if (HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum() != null && !HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum().isEmpty()) {
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum()));
                }
                operation = this.createOperation(st, idOperation, checkNumber);
                Operation eroroperation = new Operation(operation);
                if (!cancel) {
                    SumResult sr = CommissionCalculator.calculate((Sum)HtmlConnectorApplicationContext.this.currentKeeper.getSum(), (Keeper)HtmlConnectorApplicationContext.this.currentKeeper, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)srv.getMinComm(), (Commission)srv.getCommission(), (Sum)HtmlConnectorApplicationContext.this.sumPurchase, (Sum)srv.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee(), (Sum)HtmlConnectorApplicationContext.this.smsCost);
                    this.subSmsCommission(sr);
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0424\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + sr));
                    HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                    if (!saveChange) {
                        if (sr.getChange() != null && !sr.getChange().isEmpty()) {
                            operation.setPinCode(PinCodeGenerator.generate());
                            operation.setPinCodeNominal(sr.getChange());
                        }
                    } else if (sr.getChange() != null && !sr.getChange().isEmpty()) {
                        HtmlConnectorApplicationContext.this.currentKeeper.addPayback(sr.getChange());
                    }
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                    operation.setSumResult(sr);
                    if (sr.getCommService() != null) {
                        operation.setFlags(operation.getFlags() | 4);
                    }
                } else {
                    CbcUtil.cancelOperation(operation);
                }
                try {
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u0440\u043e\u0432\u043e\u0436\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438");
                    ProcessingResult result = HtmlConnectorApplicationContext.this.clientInterface.process(operation);
                    Session.getInstance().setLastPayment(operation);
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result));
                    if (result.getType() == ProcessingResultType.Ok) {
                        if (result.getDataItems() != null) {
                            for (DataItem di : result.getDataItems()) {
                                operation.getForm().put(di.getKey(), di.getValue());
                                operation.getViews().put(di.getKey(), di.getValue());
                                if (operation.getTitles().get(di.getKey()) == null) {
                                    operation.getTitles().put(di.getKey(), di.getKey());
                                }
                                operation.getInputElements().put(di.getKey(), new InputElement(di.getKey(), (String)operation.getTitles().get(di.getKey()), di.getValue(), di.getValue(), 0));
                            }
                        }
                        HtmlConnectorApplicationContext.this.log.info((Object)"*\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044e");
                        HtmlConnectorApplicationContext.this.printerQueue.print(operation);
                        if (!cancel && saveChange && !HtmlConnectorApplicationContext.this.currentKeeper.getSum().isEmpty()) {
                            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c \u0441\u0434\u0430\u0447\u0443  \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435: " + HtmlConnectorApplicationContext.this.currentKeeper.getSum()));
                            this.menuItemRevert();
                            HtmlConnectorApplicationContext.this.notifier.onProcess(5, HtmlConnectorApplicationContext.this.currentKeeper.getSum());
                            return 5;
                        }
                    } else {
                        throw new Exception("Failed to perform the operation. The result is not ok");
                    }
                    HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                    Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                }
                catch (Exception ex) {
                    HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f", (Throwable)ex);
                    CbcUtil.cancelOperation(eroroperation);
                    try {
                        HtmlConnectorApplicationContext.this.clientInterface.process(eroroperation);
                        Session.getInstance().setLastPayment(operation);
                        HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                        Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                    HtmlConnectorApplicationContext.this.printerQueue.print(eroroperation);
                    this.menuItemRevert();
                    if (!cancel) {
                        HtmlConnectorApplicationContext.this.notifier.onProcess(4, null);
                    }
                    return 4;
                }
            }
            Date date = new Date();
            GroupOperation go = new GroupOperation();
            int id = SequenceManager.getValueQuietly((String)"operation-id");
            int doc = new Random().nextInt(32000);
            if (AppDefaults.getInstance().getBooleanProperty("Module.processing.change.old-check", false)) {
                Operation lp = Session.getInstance().getLastPayment();
                if (HtmlConnectorApplicationContext.this.currentKeeper.getCashSum().isEmpty() && lp != null) {
                    doc = lp.getCheckNumber();
                }
            }
            go.setFeHash(PaymentHelper.getFeHash());
            go.setService(HtmlConnectorApplicationContext.this.menuItem.getService());
            go.setCommission(HtmlConnectorApplicationContext.this.menuItem.getCommission());
            go.setIdOperation(id);
            go.setCheckNumber(doc);
            go.setSingleCheck(true);
            go.setKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            go.setDate(date);
            go.setSumResult(sumResult);
            if (!cancel) {
                if (HtmlConnectorApplicationContext.this.menuItem.getService().isGroupPaymentDividedCommission()) {
                    if (packNotCalculated) {
                        HtmlConnectorApplicationContext.this.log.debug((Object)("*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0431\u0435\u0437 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f: " + sumResult));
                        List srList = CommissionCalculator.calculatePackForList((Sum)HtmlConnectorApplicationContext.this.currentKeeper.getSum(), (Keeper)HtmlConnectorApplicationContext.this.currentKeeper, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), (Commission)srv.getMinComm(), (Commission)srv.getCommission(), this.getPackSums(HtmlConnectorApplicationContext.this.payments.getPayments()), (Sum)(srv.getDivideSum() == null || srv.getDivideSum().isEmpty() ? srv.getMaxSum() : srv.getDivideSum()), null, null, (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (Sum)HtmlConnectorApplicationContext.this.smsCost);
                        for (int i = 0; i < srList.size(); ++i) {
                            this.subSmsCommission((SumResult)srList.get(i));
                            HtmlConnectorApplicationContext.this.payments.getPayments().get(i).setSum(((SumResult)srList.get(i)).getOut());
                            HtmlConnectorApplicationContext.this.payments.getPayments().get(i).setSum\u0421omm(((SumResult)srList.get(i)).getCommission());
                        }
                    }
                } else {
                    Sum sumPays = null;
                    if ("default".equals(HtmlConnectorApplicationContext.this.payments.getDistributionType()) && !HtmlConnectorApplicationContext.this.payments.getSum().isEmpty()) {
                        sumPays = HtmlConnectorApplicationContext.this.payments.getSum();
                    }
                    HtmlConnectorApplicationContext.this.log.debug((Object)("*  \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0431\u0435\u0437 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f: " + sumResult));
                    Sum sum = new Sum(sumResult.getOut());
                    if ("uniform".equals(HtmlConnectorApplicationContext.this.payments.getDistributionType())) {
                        Sum lSum = new Sum(sum.getBasicSum() / HtmlConnectorApplicationContext.this.payments.getPayments().size());
                        for (PaymentData p : HtmlConnectorApplicationContext.this.payments.getPayments()) {
                            p.setSum(lSum);
                            sum = sum.sub(lSum);
                        }
                        if (!sum.isEmpty()) {
                            HtmlConnectorApplicationContext.this.payments.getPayments().get(0).setSum(HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum().add(sum));
                        }
                    } else {
                        for (PaymentData paymentData : HtmlConnectorApplicationContext.this.payments.getPayments()) {
                            if (paymentData.getSum() == null || paymentData.getSum().isEmpty()) continue;
                            if (sum.isEmpty()) break;
                            if (sum.compareTo(paymentData.getSum()) > 0) {
                                sum = sum.sub(paymentData.getSum());
                                continue;
                            }
                            paymentData.setSum(sum);
                            sum = new Sum();
                        }
                        if (sumResult.getChange() == null) {
                            sumResult.setChange(new Sum());
                        }
                        if (!sum.isEmpty()) {
                            if ("default".equals(HtmlConnectorApplicationContext.this.payments.getDistributionType())) {
                                sumResult.setChange(sumResult.getChange().add(sum));
                            } else {
                                HtmlConnectorApplicationContext.this.payments.getPayments().get(0).setSum(HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getSum().add(sum));
                            }
                        }
                        LinkedList<PaymentData> newPayments = new LinkedList<PaymentData>();
                        for (PaymentData p : HtmlConnectorApplicationContext.this.payments.getPayments()) {
                            if (p.getSum() == null || p.getSum().isEmpty()) continue;
                            newPayments.add(p);
                        }
                        HtmlConnectorApplicationContext.this.payments.setPayments(newPayments);
                    }
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0424\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + sumResult));
                }
                LinkedList<ChildOperation> opers = new LinkedList<ChildOperation>();
                boolean commInChild = false;
                for (PaymentData paymentData : HtmlConnectorApplicationContext.this.payments.getPayments()) {
                    Service service = new Service(HtmlConnectorApplicationContext.this.menuItem.getService());
                    for (InputElement ie : paymentData.getData()) {
                        if (!"name".equals(ie.getKey()) || ie.getValueTitle() == null || ie.getValueTitle().trim().isEmpty()) continue;
                        service.setPrintName(ie.getValueTitle());
                        break;
                    }
                    ChildOperation cho = new ChildOperation(service, paymentData.getSum(), paymentData.getSum\u0421omm(), null, null);
                    for (InputElement ie : paymentData.getData()) {
                        if (ie.getKey().startsWith("#")) continue;
                        cho.getForm().put(ie.getKey(), ie.getValue());
                        cho.getViews().put(ie.getKey(), ie.getValueTitle());
                        cho.getTitles().put(ie.getKey(), ie.getKeyTitle());
                        cho.getInputElements().put(ie.getKey(), ie);
                    }
                    opers.add(cho);
                    if (paymentData.getSum\u0421omm() == null || paymentData.getSum\u0421omm().isEmpty()) continue;
                    commInChild = true;
                }
                go.setChildOperations(opers);
                go.getForm().putAll(((ChildOperation)opers.get(0)).getForm());
                go.getViews().putAll(((ChildOperation)opers.get(0)).getViews());
                go.getTitles().putAll(((ChildOperation)opers.get(0)).getTitles());
                go.getInputElements().putAll(((ChildOperation)opers.get(0)).getInputElements());
                if (commInChild) {
                    go.getSumResult().setCommission(new Sum());
                }
                HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
                if (!saveChange) {
                    if (go.getSumResult().getChange() != null && !go.getSumResult().getChange().isEmpty()) {
                        go.setPinCode(PinCodeGenerator.generate());
                        go.setPinCodeNominal(go.getSumResult().getChange());
                    }
                } else if (go.getSumResult().getChange() != null && !go.getSumResult().getChange().isEmpty()) {
                    HtmlConnectorApplicationContext.this.currentKeeper.addPayback(go.getSumResult().getChange());
                }
                Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            } else {
                CbcUtil.cancelOperation((Operation)go);
            }
            go.setDealer(ModuleHelper.getDealer());
            go.setServiceType(st);
            HtmlConnectorApplicationContext.this.log.info((Object)("Multi operation pack " + go));
            HtmlConnectorApplicationContext.this.clientInterface.sendGroupOperation(go);
            Session.getInstance().setLastPayment((Operation)go);
            HtmlConnectorApplicationContext.this.printerQueue.print((Operation)go);
            if (!cancel && saveChange && !HtmlConnectorApplicationContext.this.currentKeeper.getSum().isEmpty()) {
                this.menuItemRevert();
                HtmlConnectorApplicationContext.this.notifier.onProcess(5, HtmlConnectorApplicationContext.this.currentKeeper.getSum());
                return 5;
            }
            HtmlConnectorApplicationContext.this.currentKeeper = new Keeper();
            Session.getInstance().setCurrentKeeper(HtmlConnectorApplicationContext.this.currentKeeper);
            HtmlConnectorApplicationContext.this.log.info((Object)"<======================================================");
            this.menuItemRevert();
            if (!cancel) {
                HtmlConnectorApplicationContext.this.notifier.onProcess(0, null);
            }
            return 0;
        }

        private void subSmsCommission(SumResult sumResult) {
            Sum commService = sumResult.getCommService();
            if (commService != null) {
                Sum commission = sumResult.getCommission();
                sumResult.setCommission(commission.sub(commService));
            }
        }

        @Override
        public void onCanDistribute(int sum) {
            Sum distribute = new Sum(sum);
            boolean canPay = this.canPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), distribute, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
            SumResult sr = this.resultPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), distribute, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
            if (sr != null) {
                HtmlConnectorApplicationContext.this.notifier.onCanDistribute(canPay, HtmlConnectorApplicationContext.this.currentKeeper.getSum().getBasicSum(), sr.getOut().getBasicSum(), sr.getCommission().getBasicSum(), sr.getChange().getBasicSum());
            } else {
                HtmlConnectorApplicationContext.this.log.error((Object)"SumResult is null.");
            }
        }

        @Override
        public void getMobileProvider(String number) {
            Integer serviceId = FederalNumberValidator.getInstance().getProvider(number);
            HtmlConnectorApplicationContext.this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c: " + serviceId));
            HtmlConnectorApplicationContext.this.notifier.onMobileService(serviceId);
        }

        private boolean canPay(Keeper keeper, Service service, Commission commission, Sum min, Sum operationSum, boolean ignoreMMC) {
            if (keeper == null) {
                return false;
            }
            SumResult sr = this.resultPay(keeper, service, commission, min, operationSum, ignoreMMC);
            return !sr.getOut().isEmpty() && sr.getOut().compareTo(min) >= 0;
        }

        private SumResult resultPay(Keeper keeper, Service service, Commission commission, Sum min, Sum operationSum, boolean ignoreMMC) {
            if (keeper == null) {
                return null;
            }
            if (service.isGroupPaymentDividedCommission() && (operationSum == null || operationSum.isEmpty())) {
                Sum divSum = service.getDivideSum() == null || service.getDivideSum().isEmpty() ? service.getMaxSum() : service.getDivideSum();
                return CommissionCalculator.calculatePack((Sum)keeper.getSum(), (Keeper)keeper, (Commission)commission, (Commission)service.getMinComm(), (Commission)service.getCommission(), this.getPackSums(HtmlConnectorApplicationContext.this.payments.getPayments()), (Sum)divSum, (Sum)service.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)ignoreMMC, (Sum)HtmlConnectorApplicationContext.this.smsCost);
            }
            return CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)commission, (Commission)service.getMinComm(), (Commission)service.getCommission(), (Sum)operationSum, (Sum)service.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee(), (Sum)HtmlConnectorApplicationContext.this.smsCost);
        }

        private List<SumResult> calculateList(Keeper keeper, Service service, Commission commission, Sum operationSum, boolean ignoreMMC) {
            if (service.isGroupPaymentDividedCommission() && (operationSum == null || operationSum.isEmpty())) {
                Sum divSum = service.getDivideSum() == null || service.getDivideSum().isEmpty() ? service.getMaxSum() : service.getDivideSum();
                return CommissionCalculator.calculatePackForList((Sum)keeper.getSum(), (Keeper)keeper, (Commission)commission, (Commission)service.getMinComm(), (Commission)service.getCommission(), this.getPackSums(HtmlConnectorApplicationContext.this.payments.getPayments()), (Sum)divSum, (Sum)service.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)ignoreMMC, (Sum)HtmlConnectorApplicationContext.this.smsCost);
            }
            return Collections.singletonList(CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)commission, (Commission)service.getMinComm(), (Commission)service.getCommission(), (Sum)operationSum, (Sum)service.getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission(), (FeeSum)Session.getInstance().getPack().getProviderFee(), (Sum)HtmlConnectorApplicationContext.this.smsCost));
        }

        private ReferencesAdapter convert(ReferenceManager refs) {
            if (refs == null) {
                return null;
            }
            ReferencesStub rs = new ReferencesStub();
            rs.setVersion(refs.getVersion());
            rs.setDealer(refs.getDealer());
            rs.setPoint(refs.getPoint());
            rs.setServiceOptions(refs.getServiceOptions());
            rs.setMenuItemStates(refs.getMenuItemStates());
            rs.setBanners(refs.getBanners());
            rs.setCheckAdvs(refs.getCheckAdvs());
            rs.setAuth(refs.getAuth());
            rs.setUpdateOptions(refs.getUpdateOptions());
            rs.setBank(refs.getBank());
            rs.setPaymentSystem(refs.getPaymentSystem());
            rs.setServerAddresses(refs.getServerAddresses());
            rs.setSecretMenuUsers(refs.getServerUsers());
            rs.setPersonalNumbers(refs.getPersonalNumbers());
            if (refs.getPointOptions() != null) {
                PointOptionsStub pos = new PointOptionsStub(refs.getPointOptions());
                rs.setPointOptions(pos);
            }
            if (refs.getMenu() != null) {
                MenuStub menuStub = new MenuStub();
                menuStub.setIclass(refs.getMenu().getIclass());
                menuStub.setIface(refs.getMenu().getIface());
                if (refs.getMenu().getTypes() != null) {
                    ServiceTypeStub[] st = new ServiceTypeStub[refs.getMenu().getTypes().length];
                    int i = 0;
                    for (ServiceType sts : refs.getMenu().getTypes()) {
                        st[i] = new ServiceTypeStub();
                        this.loadChildTypes(sts, st[i]);
                        ++i;
                    }
                    menuStub.setTypes(st);
                }
                rs.setMenuItems(menuStub);
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("refs=" + rs));
            return new ReferencesAdapter(rs);
        }

        public void loadChildTypes(ServiceType from, ServiceTypeStub to) {
            to.setId(from.getId());
            to.setImage(from.getImage());
            to.setLangs(from.getLangs());
            to.setName(from.getName());
            to.setInvitation(from.getInvitation());
            to.setSortOrder(from.getSortOrder());
            to.setHotkeyPosition(from.getHotkeyPosition());
            to.setScreenType(from.getScreenType());
            to.setDesc(from.getDesc());
            to.setBlocked(from.getBlocked());
            MenuItemStub[] mItems = new MenuItemStub[]{};
            if (from.getMenuItems() != null) {
                mItems = new MenuItemStub[from.getMenuItems().length];
                for (int j = 0; j < mItems.length; ++j) {
                    mItems[j] = new MenuItemStub();
                    mItems[j].setIdMenuItem(from.getMenuItems()[j].getIdMenuItem());
                    mItems[j].setCommission(from.getMenuItems()[j].getCommission());
                    mItems[j].setHotKey(from.getMenuItems()[j].isHotKey());
                    mItems[j].setVerify(from.getMenuItems()[j].isVerify());
                    mItems[j].setSpecialButton(from.getMenuItems()[j].isSpecialButton());
                    mItems[j].setSortOrder(from.getMenuItems()[j].getSortOrder());
                    mItems[j].setService(from.getMenuItems()[j].getService());
                    mItems[j].setHotkeyPosition(from.getMenuItems()[j].getHotkeyPosition());
                    mItems[j].setFlags(from.getMenuItems()[j].getFlags());
                }
            }
            to.setMenuItems(mItems);
            ServiceTypeStub[] st = new ServiceTypeStub[]{};
            if (from.getTypes() != null && from.getTypes().length > 0) {
                st = new ServiceTypeStub[from.getTypes().length];
                int i = 0;
                for (ServiceType sts : from.getTypes()) {
                    st[i] = new ServiceTypeStub();
                    this.loadChildTypes(sts, st[i]);
                    ++i;
                }
            }
            to.setTypes(st);
        }

        @Override
        public void onSmsNotificationInfo() {
            HtmlConnectorApplicationContext.this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u0441\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0438");
            boolean enabled = false;
            boolean selected = false;
            if (!ConnectorState.payment.equals((Object)this.csController.getPrevios())) {
                HtmlConnectorApplicationContext.this.notifier.onError(4, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0438\u0437 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
                return;
            }
            Point point = ModuleHelper.getPoint();
            if (HtmlConnectorApplicationContext.this.payments != null && HtmlConnectorApplicationContext.this.menuItem != null && HtmlConnectorApplicationContext.this.menuItem.getService() != null) {
                List<InputElement> data = HtmlConnectorApplicationContext.this.payments.getPayments().get(0).getData();
                enabled = SmsSuccessVerifier.isEnabled((Service)HtmlConnectorApplicationContext.this.menuItem.getService(), (Point)point, data);
                selected = SmsSuccessVerifier.isSelected((Service)HtmlConnectorApplicationContext.this.menuItem.getService(), (Point)point, (Commission)HtmlConnectorApplicationContext.this.menuItem.getCommission(), data);
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e: " + enabled));
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e: " + selected));
            Sum cost = null;
            if (enabled) {
                cost = SmsSuccessVerifier.getSmsCost((Point)point);
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u044f: " + cost));
            if (enabled && selected) {
                HtmlConnectorApplicationContext.this.smsCost = cost;
            } else {
                HtmlConnectorApplicationContext.this.smsCost = null;
            }
            HtmlConnectorApplicationContext.this.notifier.onSmsNotificationInfo(enabled, selected, cost);
        }

        @Override
        public void onSmsNotificationSwitch(boolean selected) {
            if (!ConnectorState.payment.equals((Object)this.csController.getPrevios()) && !ConnectorState.cbcactivate.equals((Object)this.csController.getPrevios())) {
                HtmlConnectorApplicationContext.this.notifier.onError(4, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0438\u0437 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
                return;
            }
            if (selected) {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u043a\u043b\u044e\u0447\u0438\u043b \u0441\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435");
                HtmlConnectorApplicationContext.this.smsCost = SmsSuccessVerifier.getSmsCost((Point)ModuleHelper.getPoint());
                HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u044f: " + HtmlConnectorApplicationContext.this.smsCost));
            } else {
                HtmlConnectorApplicationContext.this.log.info((Object)"*  \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u043b \u0441\u043c\u0441 \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435");
                HtmlConnectorApplicationContext.this.smsCost = null;
            }
            this.updateSums();
        }

        @Override
        public void onSetSumPurchase(Sum sumPurchase) {
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0417\u0430\u043f\u0440\u043e\u0441 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0443\u043c\u043c\u044b \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f, sumPurchase=" + sumPurchase));
            if (!ConnectorState.payment.equals((Object)this.csController.getPrevios())) {
                HtmlConnectorApplicationContext.this.notifier.onError(4, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u0441\u0443\u043c\u043c\u0443 \u0438\u0437 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
                return;
            }
            this.processSumPurchase(sumPurchase);
            this.processSumRequire();
            this.updateSums();
        }

        private void updateSums() {
            SumResult currentSumResult = this.resultPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
            if (currentSumResult == null) {
                currentSumResult = new SumResult();
            }
            HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0441\u0443\u043c\u043c\u044b: " + currentSumResult));
            Sum minSum = HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum();
            if (minSum == null) {
                minSum = new Sum(0);
            }
            Keeper k = Session.getInstance().getCurrentKeeper();
            boolean canPay = this.canPay(k, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), minSum, HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
            int commService = currentSumResult.getCommService() == null ? 0 : currentSumResult.getCommService().getBasicSum();
            HtmlConnectorApplicationContext.this.notifier.onChangeSum(canPay, k == null ? new Sum().toString() : k.getSum().toString(), currentSumResult.getOut().toString(), currentSumResult.getCommission().toString(), currentSumResult.getChange().toString(), k == null ? new Sum().getBasicSum() : k.getSum().getBasicSum(), currentSumResult.getOut().getBasicSum(), currentSumResult.getCommission().getBasicSum(), currentSumResult.getChange().getBasicSum(), commService);
        }

        public class ContextKeeperListener
        implements KeeperObserver {
            public void update(Keeper keeper, Sum sum) {
                int commService;
                Sum minSum;
                Session.getInstance().setCurrentKeeper(keeper);
                SumResult currentSumResult = LocalConnector.this.resultPay(HtmlConnectorApplicationContext.this.currentKeeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum(), HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
                if (!keeper.getSum().isEmpty()) {
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u041d\u043e\u0432\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430: " + keeper));
                    HtmlConnectorApplicationContext.this.log.info((Object)("*  \u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u0441\u0443\u043c\u043c\u044b: " + currentSumResult));
                }
                if ((minSum = HtmlConnectorApplicationContext.this.menuItem.getService().getMinSum()) == null) {
                    minSum = new Sum(0);
                }
                boolean canPay = LocalConnector.this.canPay(keeper, HtmlConnectorApplicationContext.this.menuItem.getService(), HtmlConnectorApplicationContext.this.menuItem.getCommission(), minSum, HtmlConnectorApplicationContext.this.sumPurchase, HtmlConnectorApplicationContext.this.menuItem.isIgnoreMinMaxCommission());
                int n = commService = currentSumResult.getCommService() == null ? 0 : currentSumResult.getCommService().getBasicSum();
                if (currentSumResult != null) {
                    HtmlConnectorApplicationContext.this.notifier.onChangeSum(canPay, keeper.getSum().toString(), currentSumResult.getOut().toString(), currentSumResult.getCommission().toString(), currentSumResult.getChange().toString(), keeper.getSum().getBasicSum(), currentSumResult.getOut().getBasicSum(), currentSumResult.getCommission().getBasicSum(), currentSumResult.getChange().getBasicSum(), commService);
                } else {
                    HtmlConnectorApplicationContext.this.log.error((Object)"CurrentSumResult is null.");
                }
            }

            public void notifyNoMoreNeed() {
            }
        }

        public class ContextTerminalStateListener {
            public ContextTerminalStateListener() {
                ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
                service.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (HtmlConnectorApplicationContext.this.currentModule == 0 || HtmlConnectorApplicationContext.this.currentModule == 1) {
                            if (HtmlConnectorApplicationContext.this.currentState == null) {
                                HtmlConnectorApplicationContext.this.currentState = StateFacade.getState();
                            }
                            if (!HtmlConnectorApplicationContext.this.currentState.equals((Object)StateFacade.getState())) {
                                HtmlConnectorApplicationContext.this.log.info((Object)("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u043e\u0441\u044c : " + HtmlConnectorApplicationContext.this.currentState));
                                LocalConnector.this.onState();
                            }
                        }
                    }
                }, 0L, 10L, TimeUnit.SECONDS);
            }
        }

        private class HtmlHelper {
            private HtmlHelper() {
            }

            public int getIdOperation() {
                int id = 0;
                try {
                    Sequence seq = SequenceManager.getInstance().getSequence("operation-id");
                    id = seq.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return id % 16000;
            }
        }

        private class LocalConnectorListener
        implements ConnectorListener {
            private LocalConnectorListener() {
            }

            @Override
            public int onCancel(int code) {
                return LocalConnector.this.onCancel(code);
            }

            @Override
            public void menuItemRevert() {
                LocalConnector.this.menuItemRevert();
            }

            @Override
            public int processCardPayment(boolean cancel) {
                return LocalConnector.this.processCardPayment(cancel);
            }
        }
    }
}

