/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.diagnostic;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class SimpleProblemNotifier
extends ProblemNotifier {
    private final ApplicationContext context;
    private final Logger log;
    private final Set<Integer> problems;

    public SimpleProblemNotifier(ApplicationContext context) {
        this.context = context;
        this.problems = new HashSet<Integer>();
        this.log = Logger.getLogger((String)"pay");
    }

    public void onError(final Exception ex) {
        this.log.error((Object)"Error was detected", (Throwable)ex);
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, ex.getMessage(), 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                SimpleProblemNotifier.this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, ex.getMessage()));
                SimpleProblemNotifier.this.context.toMainMenu();
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    public void onProblem(String message) {
        this.log.info((Object)("Problem detected: " + message));
        this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, message));
    }

    public void onProblemOnce(String message) {
        if (message != null && !this.problems.contains(message.hashCode())) {
            this.log.info((Object)("Problem detected: " + message));
            this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, message));
            this.problems.add(message.hashCode());
        }
    }

    public void onRequestRestart(String cause) {
        this.log.error((Object)("Software fault, needs restart. Cause: " + cause));
        this.onProblemOnce("Reboot requested: " + cause);
        SafeReboot.getInstance().restart("_flag_sffault");
    }
}

