/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.context.handler;

import java.util.HashMap;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.gui.utils.menu.MenuByBarcodeVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.reference.menu.MenuItem;

public class BarcodeListener
implements ModuleTypeListener {
    private static final long serialVersionUID = -866213032806229932L;
    private final transient BarcodeScanner sc = BarcodeScanner.getScanner();
    private volatile transient int module;

    public BarcodeListener() {
        this.sc.addListener((BarcodeScannerListener)new LocalBarcodeListener());
    }

    @Override
    public void onChange(int moduleType) {
        this.module = moduleType;
    }

    private class LocalBarcodeListener
    implements BarcodeScannerListener {
        private LocalBarcodeListener() {
        }

        public void onData(String data) {
            if (data == null || BarcodeListener.this.module != 1) {
                return;
            }
            data = data.trim();
            MenuByBarcodeVisitor bv = new MenuByBarcodeVisitor(data);
            MenuUtils.processMenu((MenuVisitor)bv);
            if (!bv.getItems().isEmpty()) {
                MenuItem menuItem = (MenuItem)bv.getItems().get(0);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("barcode", data);
                AppEnvironment.getInstance().open(menuItem, map);
            }
        }
    }
}

